package com.renderx.xepx.x4u.ct.charsetspanel;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.*;

import org.w3c.dom.*;

import javax.swing.event.*;
import java.util.*;

public class DomToJTreeCharsetsAdapter implements javax.swing.tree.TreeModel
{
    public static String[] FONT_NODES = {"options", "charsets", "charset", "character-mapping", "code-ranges", "codepage"};

    Document document;
    
    CharsetsPanel parentCharsetsPanel;

    OptTreeNode root = null;

    public DomToJTreeCharsetsAdapter(CharsetsPanel _parentCharsetsPanel, Document document, Element elem)
    {
	parentCharsetsPanel = _parentCharsetsPanel;
	root = new OptTreeNode(elem);
	this.document = document;
    }

    // Basic TreeModel operations
    public Object getRoot()
    {
	return this.root;
    }

    public boolean isLeaf(Object aNode)
    {
	OptTreeNode node = (OptTreeNode) aNode;
	if (node.childCount() > 0)
	    return false;
	return true;
    }

    public int getChildCount(Object parent)
    {
	OptTreeNode node = (OptTreeNode) parent;
	return node.childCount();
    }

    public Object getChild(Object parent, int index)
    {
	OptTreeNode node = (OptTreeNode) parent;
	return node.child(index);
    }

    public int getIndexOfChild(Object parent, Object child)
    {
	OptTreeNode node = (OptTreeNode) parent;
	return node.index((OptTreeNode) child);
    }

    public void valueForPathChanged(TreePath path, Object newValue)
    {
	Element currentNode = ((OptTreeNode) (path.getLastPathComponent())).body;
	String val = newValue.toString();
	if (currentNode.getNodeName().equalsIgnoreCase("font-group"))
	    currentNode.setAttribute("label", val);
	else if (currentNode.getNodeName().equalsIgnoreCase("font-family"))
	    currentNode.setAttribute("name", val);
	else if (currentNode.getNodeName().equalsIgnoreCase("font"))
	{
	    StringTokenizer st = new StringTokenizer(val, " ");
	    int ind = 1;
	    String attValue = st.nextToken();
	    while (st.hasMoreTokens())
	    {
		attValue = st.nextToken();
		boolean del = (attValue.equals("-"));
		String attName = "";
		if (ind == 1)
		    attName = "weight";
		else if (ind == 2)
		    attName = "style";
		else if (ind == 3)
		    attName = "variant";
		if (del)
		    currentNode.removeAttribute(attName);
		else
		    currentNode.setAttribute(attName, attValue);
		ind++;
	    }
	}
	fireTreeNodesChanged(new TreeModelEvent(currentNode, path));
    }

    public void insertInCurrentNode(TreeModelEvent treeEvent, String cmd)
    {
	TreePath path = treeEvent.getTreePath();
	OptTreeNode node = (OptTreeNode) path.getLastPathComponent();
	if (node.body == null)
	    return;
	Node newNode;
	Node currentNode = node.body;

	if (cmd.equalsIgnoreCase(CharsetsPanel.NEW_COMMANDS[0])) // code-ranges
	{ 
	    NodeList codeRangesList = currentNode.getChildNodes();	    
	    if(isNodeListConsistNode(codeRangesList, "code-ranges"))
	    {
		JOptionPane.showMessageDialog(new JFrame(), "Can't add second <code-ranges> section", 
			"Notify", JOptionPane.OK_OPTION);
		return;
	    }
	    newNode = this.document.createElement("code-ranges");
	    parentCharsetsPanel.codeRangeButton.setEnabled(false);
	    
	} else if (cmd.equalsIgnoreCase(CharsetsPanel.NEW_COMMANDS[1])) // character-mapping
	{ 
	    NodeList characterMappingList = currentNode.getChildNodes();
	    if(isNodeListConsistNode(characterMappingList, "character-mapping"))
	    {
		JOptionPane.showMessageDialog(new JFrame(), "Can't add second <character-mapping> section", 
			"Notify", JOptionPane.OK_OPTION);
		return;
	    }
	    newNode = this.document.createElement("character-mapping");
	    parentCharsetsPanel.characterMappingButton.setEnabled(false);
	} else if (cmd.equalsIgnoreCase(CharsetsPanel.NEW_COMMANDS[3])) // codepage
	{
	    NodeList characterMappingList = currentNode.getChildNodes();
	    if(isNodeListConsistNode(characterMappingList, "codepage"))
	    {
		JOptionPane.showMessageDialog(new JFrame(), "Can't add second <codepage> section", 
			"Notify", JOptionPane.OK_OPTION);
		return;
	    }
	    newNode = this.document.createElement("codepage");
	    ((Element) newNode).setAttribute("codepage-name", "new-codepage");
	    ((Element) newNode).setAttribute("ibm-name", "T1V10501");
	    ((Element) newNode).setAttribute("forcelatin", "true");
	    parentCharsetsPanel.codepageButton.setEnabled(false);
	} else //if (cmd.equalsIgnoreCase(CharsetsPanel.NEW_COMMANDS[2])) // charset
	{
	    newNode = this.document.createElement("charset");
	    if (currentNode.getNodeName().equalsIgnoreCase("charsets"))
	    {
		((Element) newNode).setAttribute("name", "New Charset");
	    }
	}
	node.body.appendChild(newNode);
	int i = node.index(new OptTreeNode(newNode));
	int[] ind = { i };
	Object[] ch = { new OptTreeNode(newNode) };
	fireTreeNodesInserted(new TreeModelEvent(this, path, ind, ch));
    }

    public static boolean isButtonAvalible(TreeSelectionEvent treeEvent, String nodeName)
    {
	boolean result = false;
	
  	TreePath currentTreePath = treeEvent.getNewLeadSelectionPath();
  	 	
	OptTreeNode node = (OptTreeNode) currentTreePath.getLastPathComponent();

	Node currentNode = node.body;

	NodeList subEllementList = currentNode.getChildNodes();

	if( ! isNodeListConsistNode(subEllementList, nodeName))
	{
	    result = true;
	}
  	
	return result;
    }
    
    public static boolean isNodeListConsistNode(NodeList codeRangesList, String nodeName)
    {
	boolean result = false;
	
	for(int i=0; i<codeRangesList.getLength(); i++)
	{
	    if(codeRangesList.item(i).getNodeName().equals(nodeName))
	    {
		result = true;
	    }
	}
	
	return result;
    }

    public void removeCurrentNode(TreeModelEvent e)
    {// TreePath path) {
	TreePath path = e.getTreePath();
	OptTreeNode node = (OptTreeNode) path.getLastPathComponent();
	if (node.body == null)
	    return;
	OptTreeNode root = (OptTreeNode) path.getParentPath()
		.getLastPathComponent();
	int[] ind = { root.index(node) };// new int[node.childCount()];
	Object[] ch = { node };// new Object[node.childCount()];
	fireTreeNodesRemoved(new TreeModelEvent(this, path.getParentPath(),
		ind, ch));
	Node parent = node.body.getParentNode();
	parent.removeChild(node.body);
	return;
    }

    private Vector listenerList = new Vector();

    public void addTreeModelListener(TreeModelListener listener)
    {
	if (listener != null && !listenerList.contains(listener))
	{
	    listenerList.addElement(listener);
	}
    }

    public void removeTreeModelListener(TreeModelListener listener)
    {
	if (listener != null)
	{
	    listenerList.removeElement(listener);
	}
    }

    public void fireTreeNodesChanged(TreeModelEvent e)
    {
	Enumeration listeners = listenerList.elements();
	while (listeners.hasMoreElements())
	{
	    TreeModelListener listener = (TreeModelListener) listeners
		    .nextElement();
	    listener.treeNodesChanged(e);
	}
    }

    public void fireTreeNodesInserted(TreeModelEvent e)
    {
	Enumeration listeners = listenerList.elements();
	while (listeners.hasMoreElements())
	{
	    TreeModelListener listener = (TreeModelListener) listeners
		    .nextElement();
	    listener.treeNodesInserted(e);
	}
    }

    public void fireTreeNodesRemoved(TreeModelEvent e)
    {
	Enumeration listeners = listenerList.elements();
	while (listeners.hasMoreElements())
	{
	    TreeModelListener listener = (TreeModelListener) listeners
		    .nextElement();
	    listener.treeNodesRemoved(e);
	}
    }

    public void fireTreeStructureChanged(TreeModelEvent e)
    {
	Enumeration listeners = listenerList.elements();
	while (listeners.hasMoreElements())
	{
	    TreeModelListener listener = (TreeModelListener) listeners
		    .nextElement();
	    listener.treeStructureChanged(e);
	}
    }

    boolean treeElement(String elementName)
    {
	for (int i = 0; i < FONT_NODES.length; i++)
	{
	    if (elementName.equals(FONT_NODES[i]))
		return true;
	}
	return false;
    }

    public class OptTreeNode
    {
	public Element body;

	OptTreeNode(Document doc)
	{
	    this((Element) doc.getElementsByTagName("options").item(0));
	}

	OptTreeNode(Element body)
	{
	    this.body = body;
	}

	OptTreeNode(Node body)
	{
	    this.body = (Element) body;
	}

	OptTreeNode(String name)
	{
	    this.body = (Element) document.getElementsByTagName(name).item(0);
	}

	public String toString()
	{
	    if (body == null)
	    {
		return "Error: Not found <charsets> element in xep.xml";
	    }
	    String tag = body.getTagName();
	    if (tag.equalsIgnoreCase("options"))
		return "Options";
	    else if (tag.equalsIgnoreCase("charsets"))
		return "Charsets";
	    else if (tag.equalsIgnoreCase("charset"))
		return body.getAttribute("name");
	    else if (tag.equalsIgnoreCase("codepage"))
		return "codepage";
	    else if (tag.equalsIgnoreCase("code-ranges"))
		return "code-ranges";
	    else if (tag.equalsIgnoreCase("character-mapping"))
		return "character-mapping";
	    return body.getNodeValue();
	}

	public String getFontDetail(Node node)
	{
	    NamedNodeMap attribs = node.getAttributes();
	    String res = "- ";
	    if (attribs.getNamedItem("weight") == null)
		res += "- ";
	    else
		res += attribs.getNamedItem("weight").getNodeValue() + " ";
	    if (attribs.getNamedItem("style") == null)
		res += "- ";
	    else
		res += attribs.getNamedItem("style").getNodeValue() + " ";
	    if (attribs.getNamedItem("variant") == null)
		res += "- ";
	    else
		res += attribs.getNamedItem("variant").getNodeValue();
	    return res.trim();
	}

	public int childCount()
	{
	    int count = 0;
	    
	    if(body == null)
	    {
		return 0;		
	    }
	    
	    for (int i = 0; i < body.getChildNodes().getLength(); i++)
	    {
		org.w3c.dom.Node node = body.getChildNodes().item(i);
		if (node.getNodeType() == Node.ELEMENT_NODE
			&& treeElement(node.getNodeName()))
		{
		    ++count;
		}
	    }
	    return count;
	}

	/**
         * 
         * @param searchIndex
         *                int
         * @return FontTreeNode
         */
	public OptTreeNode child(int searchIndex)
	{
	    // Note: JTree index is zero-based.
	    org.w3c.dom.Node node = body.getChildNodes().item(searchIndex);
	    int elementNodeIndex = 0;
	    for (int i = 0; i < body.getChildNodes().getLength(); i++)
	    {
		node = body.getChildNodes().item(i);
		if (node.getNodeType() == Node.ELEMENT_NODE
			&& treeElement(node.getNodeName())
			&& elementNodeIndex++ == searchIndex)
		{
		    break;
		}
	    }
	    return new OptTreeNode(node);
	} // child

	public int index(OptTreeNode child)
	{
	    int count = childCount();
	    for (int i = 0; i < count; i++)
	    {
		OptTreeNode n = this.child(i);
		if (child.body == n.body)
		    return i;
	    }
	    return -1; // Should never get here.
	}

	/**
         * @return the body
         */
	public Element getBody()
	{
	    return body;
	}
    }
    
} // DomToTreeModelAdapter

