/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.spi.RegisterableService;
import javax.imageio.spi.ServiceRegistry;
import org.freehep.util.Service;
import org.freehep.util.export.ExportFileType;

public class ExportFileTypeRegistry {
    private static ExportFileTypeRegistry registry;
    private static ClassLoader loader;
    private ServiceRegistry service = new ServiceRegistry(categories.iterator());
    private List extraTypes = new ArrayList();
    private static final Collection categories;

    private ExportFileTypeRegistry() {
    }

    public static synchronized ExportFileTypeRegistry getDefaultInstance(ClassLoader loader) {
        if (loader != null && loader != ExportFileTypeRegistry.loader) {
            if (ExportFileTypeRegistry.loader != null) {
                throw new RuntimeException(ExportFileTypeRegistry.class.getName() + ": Different classloader was already used in getDefaultInstance");
            }
            ExportFileTypeRegistry.loader = loader;
        }
        if (registry == null) {
            registry = new ExportFileTypeRegistry();
            ExportFileTypeRegistry.addApplicationClasspathExportFileTypes(registry);
        }
        return registry;
    }

    public List get() {
        return this.get(null);
    }

    public List get(String format) {
        ArrayList export = new ArrayList();
        this.addExportFileTypeToList(export, format, this.service.getServiceProviders(ExportFileType.class, true));
        this.addExportFileTypeToList(export, format, this.extraTypes.iterator());
        return export;
    }

    public void add(ExportFileType exportFileType) {
        this.extraTypes.add(exportFileType);
    }

    private void addExportFileTypeToList(List list, String format, Iterator iterator) {
        block0: while (iterator.hasNext()) {
            ExportFileType type = (ExportFileType)iterator.next();
            if (format == null) {
                if (list.contains(type)) continue;
                list.add(type);
                continue;
            }
            String[] ext = type.getExtensions();
            for (int i = 0; i < ext.length; ++i) {
                if (!ext[i].equalsIgnoreCase(format)) continue;
                if (list.contains(type)) continue block0;
                list.add(type);
                continue block0;
            }
        }
    }

    private static void addApplicationClasspathExportFileTypes(ExportFileTypeRegistry registry) {
        ClassLoader classLoader = loader != null ? loader : Thread.currentThread().getContextClassLoader();
        Iterator iterator = categories.iterator();
        while (iterator.hasNext()) {
            Class category = (Class)iterator.next();
            Iterator providers = Service.providers(category, classLoader).iterator();
            Object previous = null;
            while (providers.hasNext()) {
                Object current = providers.next();
                registry.service.registerServiceProvider(current);
                if (previous != null) {
                    registry.service.setOrdering(category, previous, current);
                }
                previous = current;
            }
        }
    }

    static {
        categories = new ArrayList(2);
        categories.add(ExportFileType.class);
        categories.add(RegisterableService.class);
    }
}

