/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre;

import com.renderx.xep.pre.Attr;
import java.io.PrintStream;

public class Token {
    public int type = 0;
    public Attr value = null;
    public static final int INVALID_TYPE = 0;
    public static final int END_OF_DATA = 1;
    public static final int LEFT_PARENTHESIS = 2;
    public static final int RIGHT_PARENTHESIS = 4;
    public static final int COMMA = 8;
    public static final int PLUS = 16;
    public static final int MINUS = 32;
    public static final int ASTERISK = 64;
    public static final int SLASH = 128;
    public static final int DIVIDE = 256;
    public static final int MODULO = 512;
    public static final int UNARY_PLUS = 1024;
    public static final int UNARY_MINUS = 2048;
    public static final int FUNCTOR = 4096;
    public static final int EXPRESSION = 8192;

    public Token() {
    }

    public Token(int n) {
        this.type = n;
    }

    public Token(int n, Attr attr) {
        this.type = n;
        this.value = attr;
    }

    public String getTypeName() {
        switch (this.type) {
            case 0: {
                return "<INVALID TYPE>";
            }
            case 1: {
                return "END OF DATA";
            }
            case 4096: {
                return "FUNCTOR";
            }
            case 2: {
                return "LEFT PARENTHESIS";
            }
            case 4: {
                return "RIGHT PARENTHESIS";
            }
            case 8: {
                return "COMMA";
            }
            case 16: {
                return "PLUS";
            }
            case 32: {
                return "MINUS";
            }
            case 64: {
                return "ASTERISK";
            }
            case 128: {
                return "SLASH";
            }
            case 256: {
                return "DIVIDE";
            }
            case 512: {
                return "MODULO";
            }
            case 1024: {
                return "UNARY PLUS";
            }
            case 2048: {
                return "UNARY MINUS";
            }
            case 8192: {
                return this.value.getTypeName();
            }
        }
        return "<BAD EXPRESSION TYPE>";
    }

    public void Dump(PrintStream printStream) {
        this.Dump(printStream, "");
    }

    public void Dump(PrintStream printStream, String string) {
        printStream.print(string + this.getTypeName());
        if (this.type == 8192 || this.type == 4096) {
            printStream.print(": " + this.value.toString());
        }
        printStream.println();
    }
}

