/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre;

import com.renderx.sax.InputSource;
import com.renderx.sax.SAXStorage;
import com.renderx.sax.Serializer;
import com.renderx.sax.XMLPlayer;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.Base32;
import com.renderx.util.Base64OutputStream;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.Session;
import com.renderx.xep.pre.AttributeParser;
import com.renderx.xep.pre.Elem;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class FOPreprocessor
implements ContentHandler {
    public static final String GHOST_MARKER_PREFIX = "[ghost]";
    private final ContentHandler parent;
    private ContentHandler handler = null;
    private final ErrorHandler errorHandler;
    private int skip = 0;
    private int treeDepth = 0;
    private final StringBuffer pcdata = new StringBuffer();
    private int storeMarker = 0;
    private SAXStorage markerData = null;
    private final Hashtable markerTable = new Hashtable();
    private final Hashtable markerHistory = new Hashtable();
    private String markerClassName = null;
    private int storeImage = 0;
    private Serializer imageData = null;
    private StringWriter imageWriter = null;
    private Base64OutputStream imageFilter = null;
    private AttributesImpl imageAttributes = null;
    private int storeFV = 0;
    private Serializer FVData = null;
    private StringWriter FVWriter = null;
    private Base64OutputStream FVFilter = null;
    private AttributesImpl FVAttributes = null;
    private int storeRMR = 0;
    private Serializer RMRData = null;
    private StringWriter RMRWriter = null;
    private Base64OutputStream RMRFilter = null;
    private AttributesImpl RMRAttributes = null;
    private int storeLeader = 0;
    private StringBuffer leaderData = null;
    private AttributesImpl leaderAttributes = null;
    private boolean multiSwitch = false;
    private boolean emptyRowGroup = false;
    private boolean emptyPageIndex = false;
    private String refKey = null;
    private SAXStorage folio_prefix = null;
    private SAXStorage folio_suffix = null;
    private final boolean enable_folio;
    private TextOnlyStorage index_page_citation_list_separator = null;
    private TextOnlyStorage index_page_citation_range_separator = null;
    private static final Attributes emptyAttributes = new AttributesImpl();
    private static final Attributes ltrOverrideAttributes = new AttributesImpl();
    private static final short PREDEFINED_META_FIELD = 0;
    private static final short CUSTOM_META_FIELD = 1;
    private static final Hashtable metafields;
    private static boolean initialized;
    private final Hashtable folios = new Hashtable();

    private static final String generateId(int n) {
        return "[" + n + "]";
    }

    public static synchronized void init() throws InternalException {
        if (initialized) {
            return;
        }
        AttributeParser.init();
        Elem.init();
        initialized = true;
    }

    public FOPreprocessor(ContentHandler contentHandler, ErrorHandler errorHandler) {
        boolean bl = this.enable_folio = errorHandler instanceof Session && ((Session)errorHandler).config.ENABLE_FOLIO;
        if (this.enable_folio) {
            this.handler = this.parent = new SAXStorage();
            ((SAXStorage)this.parent).setContentHandler(new FolioProcessor(contentHandler));
        } else {
            this.handler = this.parent = contentHandler;
        }
        this.errorHandler = errorHandler;
    }

    private String makeQName(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf(58);
        if (n == -1) {
            return string;
        }
        return string2.substring(0, n + 1) + string;
    }

    private void flushText() throws SAXException {
        int n = this.pcdata.length();
        if (n > 0) {
            char[] cArray = new char[n];
            this.pcdata.getChars(0, n, cArray, 0);
            this.handler.characters(cArray, 0, n);
            this.pcdata.setLength(0);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        Elem.Descriptor descriptor;
        ++this.treeDepth;
        if (this.skip > 0) {
            ++this.skip;
            return;
        }
        if (this.storeLeader > 0) {
            ++this.storeLeader;
            return;
        }
        if (this.storeImage > 0) {
            ++this.storeImage;
            this.imageData.startElement(string, string2, string3, attributes);
            return;
        }
        if (this.storeFV > 0) {
            ++this.storeFV;
            this.FVData.startElement(string, string2, string3, attributes);
            return;
        }
        if (this.storeRMR > 0) {
            ++this.storeRMR;
            this.RMRData.startElement(string, string2, string3, attributes);
            return;
        }
        this.flushText();
        if (string == null || string.length() == 0) {
            this.errorHandler.warning("Invalid element in anonymous namespace: '" + string2 + "'; element skipped");
            this.skip = 1;
            return;
        }
        if (("page-number-citation-last".equals(string2) || "change-bar-begin".equals(string2) || "change-bar-end".equals(string2) || "bookmark".equals(string2)) && "http://www.w3.org/1999/XSL/Format".equals(string)) {
            string = "http://www.renderx.com/XSL/Extensions";
        }
        if ((descriptor = Elem.getDescriptor(string2)) == null || !string.equals(descriptor.nsuri)) {
            if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
                this.errorHandler.warning("Unknown XSL-FO element: '" + string2 + "'; element skipped");
            } else if ("http://www.renderx.com/XSL/Extensions".equals(string)) {
                this.errorHandler.warning("Invalid RenderX extension element: '" + string2 + "'; element skipped");
            }
            this.skip = 1;
            return;
        }
        if (this.enable_folio && (string4 = attributes.getValue("id")) != null) {
            this.folios.put(string4, new Object[]{this.folio_prefix, this.folio_suffix});
        }
        switch (descriptor.id) {
            case 55: {
                this.skip = 1;
                break;
            }
            case 53: {
                if (!this.multiSwitch) {
                    this.skip = 1;
                    break;
                }
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", "wrapper", this.makeQName("wrapper", string3), attributes);
                break;
            }
            case 52: 
            case 54: {
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", "wrapper", this.makeQName("wrapper", string3), attributes);
                break;
            }
            case 23: {
                string4 = attributes.getValue("character");
                if (string4 != null && string4.length() == 1) {
                    this.handler.startElement("http://www.w3.org/1999/XSL/Format", "inline", this.makeQName("inline", string3), attributes);
                    this.handler.characters(string4.toCharArray(), 0, string4.length());
                    this.handler.endElement("http://www.w3.org/1999/XSL/Format", "inline", this.makeQName("inline", string3));
                }
                this.skip = 1;
                break;
            }
            case 51: {
                String string5 = attributes.getValue("retrieve-class-name");
                if (string5 == null) {
                    this.skip = 1;
                    break;
                }
                Integer n = (Integer)this.markerTable.get(string5);
                if (n == null) {
                    n = new Integer(0);
                }
                this.markerTable.put(string5, new Integer(n + 1));
                String string6 = FOPreprocessor.generateId(n) + string5;
                AttributesImpl attributesImpl = new AttributesImpl(attributes);
                attributesImpl.setValue(attributes.getIndex("retrieve-class-name"), string6);
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", string2, string3, attributesImpl);
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
                this.skip = 1;
                break;
            }
            case 50: {
                if (this.storeMarker > 0) {
                    this.skip = 1;
                    break;
                }
                this.markerClassName = attributes.getValue("marker-class-name");
                if (this.markerClassName == null) {
                    this.skip = 1;
                    break;
                }
                this.storeMarker = 1;
                this.markerData = new SAXStorage();
                this.handler = this.markerData;
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", "wrapper", this.makeQName("wrapper", string3), attributes);
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", string2, string3, attributes);
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", "block", this.makeQName("block", string3), emptyAttributes);
                Enumeration enumeration = this.markerHistory.keys();
                while (enumeration.hasMoreElements()) {
                    String string7 = (String)enumeration.nextElement();
                    SAXStorage sAXStorage = (SAXStorage)this.markerHistory.get(string7);
                    this.proliferateMarker(string7, this.makeQName("marker", string3), sAXStorage, true);
                }
                break;
            }
            case 204: {
                this.folio_prefix = new SAXStorage();
                this.handler = this.folio_prefix;
                break;
            }
            case 205: {
                this.folio_suffix = new SAXStorage();
                this.handler = this.folio_suffix;
                break;
            }
            case 108: {
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", "inline", this.makeQName("inline", string3), attributes);
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", string2, string3, emptyAttributes);
                this.refKey = attributes.getValue("ref-key");
                break;
            }
            case 30: {
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", "bidi-override", this.makeQName("bidi-override", string3), ltrOverrideAttributes);
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", "inline", this.makeQName("inline", string3), attributes);
                if (this.folio_prefix != null) {
                    this.folio_prefix.setContentHandler(this.handler);
                    this.folio_prefix.play();
                    this.folio_prefix.setContentHandler(null);
                }
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", string2, string3, emptyAttributes);
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
                if (this.folio_suffix != null) {
                    this.folio_suffix.setContentHandler(this.handler);
                    this.folio_suffix.play();
                    this.folio_suffix.setContentHandler(null);
                }
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", "inline", this.makeQName("inline", string3));
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", "bidi-override", this.makeQName("bidi-override", string3));
                this.skip = 1;
                break;
            }
            case 31: 
            case 201: {
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", "bidi-override", this.makeQName("bidi-override", string3), ltrOverrideAttributes);
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", "inline", this.makeQName("inline", string3), attributes);
                String string8 = attributes.getValue("ref-id");
                if (string8 == null) {
                    this.handler.startElement("http://www.w3.org/1999/XSL/Format", string2, string3, emptyAttributes);
                } else {
                    AttributesImpl attributesImpl = new AttributesImpl();
                    attributesImpl.addAttribute("", "ref-id", "ref-id", "CDATA", string8);
                    this.handler.startElement("http://www.w3.org/1999/XSL/Format", string2, string3, attributesImpl);
                }
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", "inline", this.makeQName("inline", string3));
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", "bidi-override", this.makeQName("bidi-override", string3));
                this.skip = 1;
                break;
            }
            case 29: {
                this.leaderData = new StringBuffer();
                this.leaderAttributes = new AttributesImpl(attributes);
                this.storeLeader = 1;
                break;
            }
            case 26: {
                this.imageWriter = new StringWriter();
                this.imageFilter = new Base64OutputStream(this.imageWriter);
                try {
                    this.imageData = new Serializer(this.imageFilter);
                }
                catch (IOException iOException) {
                    throw new InternalException("Internal error: cannot create a serializer for an embedded image: " + iOException.toString());
                }
                this.imageAttributes = new AttributesImpl(attributes);
                this.storeImage = 1;
                this.imageData.startDocument();
                break;
            }
            case 125: {
                if (attributes.getValue("value") != null) {
                    this.handler.startElement("http://www.w3.org/1999/XSL/Format", string2, string3, attributes);
                    this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
                    this.skip = 1;
                    break;
                }
                this.FVWriter = new StringWriter();
                this.FVFilter = new Base64OutputStream(this.FVWriter, false);
                try {
                    this.FVData = new Serializer(this.FVFilter);
                    this.FVData.setEmitDeclaration(false);
                }
                catch (IOException iOException) {
                    throw new InternalException("Internal error: cannot create a serializer for the content of an rx:flash-var: " + iOException.toString());
                }
                this.FVAttributes = new AttributesImpl(attributes);
                this.storeFV = 1;
                this.FVData.startDocument();
                break;
            }
            case 126: {
                if (attributes.getValue("src") != null) {
                    this.handler.startElement("http://www.w3.org/1999/XSL/Format", string2, string3, attributes);
                    this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
                    this.skip = 1;
                    break;
                }
                this.RMRWriter = new StringWriter();
                this.RMRFilter = new Base64OutputStream(this.RMRWriter, false);
                try {
                    this.RMRData = new Serializer(this.RMRFilter);
                }
                catch (IOException iOException) {
                    throw new InternalException("Internal error: cannot create a serializer for the content of an rx:rich-media-resource: " + iOException.toString());
                }
                this.RMRAttributes = new AttributesImpl(attributes);
                this.storeRMR = 1;
                this.RMRData.startDocument();
                break;
            }
            case 105: {
                String string9 = "";
                String string10 = attributes.getValue("name");
                int n = metafields.containsKey(string10.toUpperCase()) ? (int)((Short)metafields.get(string10.toUpperCase())).shortValue() : 1;
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        string9 = "__custom_field__";
                        string10 = Base32.encode(string10.getBytes());
                        break;
                    }
                    default: {
                        throw new InternalException("Internal error: undefined type of meta-info field: " + string10);
                    }
                }
                AttributesImpl attributesImpl = new AttributesImpl();
                attributesImpl.addAttribute("", "name", "name", "CDATA", string9 + string10);
                attributesImpl.addAttribute("", "value", "value", "CDATA", attributes.getValue("value"));
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", string2, string3, attributesImpl);
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
                this.skip = 1;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: 
            case 35: 
            case 107: 
            case 109: 
            case 111: 
            case 112: 
            case 122: 
            case 206: 
            case 207: {
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", string2, string3, attributes);
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
                this.skip = 1;
                break;
            }
            case 110: 
            case 210: {
                if (this.index_page_citation_list_separator != null || this.index_page_citation_range_separator != null) {
                    int n;
                    AttributesImpl attributesImpl = null;
                    attributesImpl = new AttributesImpl(attributes);
                    if (this.index_page_citation_list_separator != null) {
                        n = attributes.getIndex("list-separator");
                        if (n < 0) {
                            attributesImpl.addAttribute("", "list-separator", "list-separator", "CDATA", "" + this.index_page_citation_list_separator);
                        } else {
                            attributesImpl.setAttribute(n, "", "list-separator", "list-separator", "CDATA", "" + this.index_page_citation_list_separator);
                        }
                    }
                    if (this.index_page_citation_range_separator != null) {
                        n = attributes.getIndex("range-separator");
                        if (n < 0) {
                            attributesImpl.addAttribute("", "range-separator", "range-separator", "CDATA", "" + this.index_page_citation_range_separator);
                        } else {
                            attributesImpl.setAttribute(n, "", "range-separator", "range-separator", "CDATA", "" + this.index_page_citation_range_separator);
                        }
                    }
                    this.handler.startElement("http://www.w3.org/1999/XSL/Format", string2, string3, attributesImpl);
                } else {
                    this.handler.startElement("http://www.w3.org/1999/XSL/Format", string2, string3, attributes);
                }
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
                this.skip = 1;
                break;
            }
            case 16: {
                if (attributes.getValue("index-key") != null) {
                    AttributesImpl attributesImpl = null;
                    attributesImpl = new AttributesImpl(attributes);
                    int n = attributes.getIndex("http://www.renderx.com/XSL/Extensions", "key");
                    if (n < 0) {
                        attributesImpl.addAttribute("http://www.renderx.com/XSL/Extensions", "key", "rx:key", "CDATA", attributes.getValue("index-key"));
                    } else {
                        attributesImpl.setAttribute(n, "http://www.renderx.com/XSL/Extensions", "key", "rx:key", "CDATA", attributes.getValue("index-key"));
                    }
                    attributesImpl.removeAttribute(attributesImpl.getIndex("index-key"));
                    attributes = attributesImpl;
                }
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", string2, string3, attributes);
                break;
            }
            case 211: {
                this.index_page_citation_list_separator = new TextOnlyStorage();
                this.handler = this.index_page_citation_list_separator;
                break;
            }
            case 212: {
                this.index_page_citation_range_separator = new TextOnlyStorage();
                this.handler = this.index_page_citation_range_separator;
                break;
            }
            default: {
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", string2, string3, attributes);
            }
        }
        this.multiSwitch = descriptor.id == 52;
        this.emptyRowGroup = descriptor.id == 38 || descriptor.id == 36 || descriptor.id == 37;
        boolean bl = this.emptyPageIndex = descriptor.id == 108;
        if (this.storeMarker > 0 && descriptor.id != 50 && this.skip == 0 && this.storeLeader == 0 && this.storeImage == 0 && this.storeFV == 0 && this.storeRMR == 0) {
            ++this.storeMarker;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Elem.Descriptor descriptor;
        --this.treeDepth;
        if (this.skip > 0) {
            --this.skip;
            return;
        }
        if (this.storeLeader > 0) {
            --this.storeLeader;
            if (this.storeLeader == 0) {
                String string4 = this.leaderData.toString();
                if ("use-content".equals(this.leaderAttributes.getValue("leader-pattern"))) {
                    if (string4 == null) {
                        string4 = "";
                    }
                    this.leaderAttributes.addAttribute("", "leader-dot", "leader-dot", "CDATA", string4);
                }
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", string2, string3, this.leaderAttributes);
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
                this.leaderData = null;
                this.leaderAttributes = null;
            }
            return;
        }
        if (this.storeImage > 0) {
            --this.storeImage;
            if (this.storeImage == 0) {
                this.imageData.endDocument();
                try {
                    this.imageFilter.close();
                    this.imageWriter.close();
                }
                catch (IOException iOException) {
                    throw new InternalException(iOException.toString());
                }
                this.imageAttributes.addAttribute("", "src", "src", "CDATA", "data:image/svg+xml;base64," + this.imageWriter.toString());
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", "external-graphic", this.makeQName("external-graphic", string3), this.imageAttributes);
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", "external-graphic", this.makeQName("external-graphic", string3));
                this.imageData = null;
                this.imageFilter = null;
                this.imageWriter = null;
            } else {
                this.imageData.endElement(string, string2, string3);
            }
            return;
        }
        if (this.storeFV > 0) {
            --this.storeFV;
            if (this.storeFV == 0) {
                this.FVData.endDocument();
                try {
                    this.FVFilter.close();
                    this.FVWriter.close();
                }
                catch (IOException iOException) {
                    throw new InternalException(iOException.toString());
                }
                this.FVAttributes.addAttribute("", "flash-var-content", "flash-var-content", "CDATA", this.FVWriter.toString());
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", "flash-var", this.makeQName("flash-var", string3), this.FVAttributes);
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", "flash-var", this.makeQName("flash-var", string3));
                this.FVData = null;
                this.FVFilter = null;
                this.FVWriter = null;
            } else {
                this.FVData.endElement(string, string2, string3);
            }
            return;
        }
        if (this.storeRMR > 0) {
            --this.storeRMR;
            if (this.storeRMR == 0) {
                this.RMRData.endDocument();
                try {
                    this.RMRFilter.close();
                    this.RMRWriter.close();
                }
                catch (IOException iOException) {
                    throw new InternalException(iOException.toString());
                }
                String string5 = "data:application/octet-stream;base64," + this.RMRWriter.toString();
                this.RMRAttributes.addAttribute("", "rich-media-resource-content", "rich-media-resource-content", "CDATA", string5);
                this.handler.startElement("http://www.w3.org/1999/XSL/Format", "rich-media-resource", this.makeQName("rich-media-resource", string3), this.RMRAttributes);
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", "rich-media-resource", this.makeQName("rich-media-resource", string3));
                this.RMRData = null;
                this.RMRFilter = null;
                this.RMRWriter = null;
            } else {
                this.RMRData.endElement(string, string2, string3);
            }
            return;
        }
        this.flushText();
        if (this.storeMarker > 0) {
            --this.storeMarker;
            if (this.storeMarker == 0) {
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", "wrapper", this.makeQName("wrapper", string3));
                this.handler = this.parent;
                this.markerHistory.put(this.markerClassName, this.markerData);
                this.proliferateMarker(this.markerClassName, string3, this.markerData, false);
                this.markerData = null;
                this.markerClassName = null;
                return;
            }
        }
        if ((descriptor = Elem.getDescriptor(string2)) == null) {
            throw new InternalException("Nesting violation in preprocessor: encountered closing tag for element '" + string2 + "', namespace '" + string + "'");
        }
        switch (descriptor.id) {
            case 17: 
            case 18: 
            case 19: {
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", "block", this.makeQName("block", string3));
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
                break;
            }
            case 204: 
            case 205: {
                this.handler = this.parent;
                break;
            }
            case 108: {
                if (this.emptyPageIndex && this.refKey != null) {
                    AttributesImpl attributesImpl = new AttributesImpl();
                    attributesImpl.addAttribute("", "ref-key", "ref-key", "CDATA", this.refKey);
                    this.handler.startElement("http://www.w3.org/1999/XSL/Format", "index-item", this.makeQName("index-item", string3), attributesImpl);
                    this.handler.endElement("http://www.w3.org/1999/XSL/Format", "index-item", this.makeQName("index-item", string3));
                }
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", "inline", this.makeQName("inline", string3));
                break;
            }
            case 50: 
            case 52: 
            case 53: 
            case 54: {
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", "wrapper", this.makeQName("wrapper", string3));
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
                break;
            }
            case 16: {
                this.markerTable.clear();
                this.folio_suffix = null;
                this.folio_prefix = null;
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                if (this.emptyRowGroup) {
                    this.handler.startElement("http://www.w3.org/1999/XSL/Format", "table-row", this.makeQName("table-row", string3), emptyAttributes);
                    this.handler.startElement("http://www.w3.org/1999/XSL/Format", "table-cell", this.makeQName("table-cell", string3), emptyAttributes);
                    this.handler.startElement("http://www.w3.org/1999/XSL/Format", "block", this.makeQName("block", string3), emptyAttributes);
                    this.handler.endElement("http://www.w3.org/1999/XSL/Format", "block", this.makeQName("block", string3));
                    this.handler.endElement("http://www.w3.org/1999/XSL/Format", "table-cell", this.makeQName("table-cell", string3));
                    this.handler.endElement("http://www.w3.org/1999/XSL/Format", "table-row", this.makeQName("table-row", string3));
                    this.emptyRowGroup = false;
                }
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
                break;
            }
            case 211: {
                this.handler = this.parent;
                break;
            }
            case 212: {
                this.handler = this.parent;
                break;
            }
            case 209: {
                this.index_page_citation_list_separator = null;
                this.index_page_citation_range_separator = null;
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
                break;
            }
            default: {
                this.handler.endElement("http://www.w3.org/1999/XSL/Format", string2, string3);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.skip > 0) {
            return;
        }
        if (this.treeDepth == 0) {
            return;
        }
        if (this.storeLeader > 0) {
            this.leaderData.append(cArray, n, n2);
            return;
        }
        if (this.storeImage > 0) {
            this.imageData.characters(cArray, n, n2);
            return;
        }
        if (this.storeFV > 0) {
            this.FVData.characters(cArray, n, n2);
            return;
        }
        if (this.storeRMR > 0) {
            this.RMRData.characters(cArray, n, n2);
            return;
        }
        this.pcdata.append(cArray, n, n2);
    }

    public void startDocument() throws SAXException {
        this.handler.startDocument();
        this.pcdata.setLength(0);
    }

    public void endDocument() throws SAXException {
        this.parent.endDocument();
        if (this.enable_folio) {
            ((SAXStorage)this.parent).play();
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.skip > 0) {
            return;
        }
        if (this.storeImage > 0) {
            this.imageData.processingInstruction(string, string2);
            return;
        }
        if (this.storeFV > 0) {
            this.FVData.processingInstruction(string, string2);
            return;
        }
        if (this.storeRMR > 0) {
            this.RMRData.processingInstruction(string, string2);
            return;
        }
        if (this.storeLeader > 0) {
            return;
        }
        this.flushText();
        this.handler.processingInstruction(string, string2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.skip > 0) {
            return;
        }
        if (this.storeLeader > 0) {
            this.leaderData.append(cArray, n, n2);
            return;
        }
        if (this.storeImage > 0) {
            this.imageData.ignorableWhitespace(cArray, n, n2);
            return;
        }
        if (this.storeFV > 0) {
            this.FVData.ignorableWhitespace(cArray, n, n2);
            return;
        }
        if (this.storeRMR > 0) {
            this.RMRData.ignorableWhitespace(cArray, n, n2);
            return;
        }
        this.flushText();
        this.handler.ignorableWhitespace(cArray, n, n2);
    }

    public void skippedEntity(String string) throws SAXException {
        if (this.skip > 0) {
            return;
        }
        if (this.storeImage > 0) {
            this.imageData.skippedEntity(string);
            return;
        }
        if (this.storeFV > 0) {
            this.FVData.skippedEntity(string);
            return;
        }
        if (this.storeRMR > 0) {
            this.RMRData.skippedEntity(string);
            return;
        }
        if (this.storeLeader > 0) {
            return;
        }
        this.flushText();
        this.handler.skippedEntity(string);
    }

    public void setDocumentLocator(Locator locator) {
        this.handler.setDocumentLocator(locator);
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.skip > 0) {
            return;
        }
        if (this.storeImage > 0) {
            this.imageData.startPrefixMapping(string, string2);
            return;
        }
        if (this.storeFV > 0) {
            this.FVData.startPrefixMapping(string, string2);
            return;
        }
        if (this.storeRMR > 0) {
            this.RMRData.startPrefixMapping(string, string2);
            return;
        }
        if (this.storeLeader > 0) {
            return;
        }
        this.flushText();
        if ("http://www.renderx.com/XSL/Extensions".equals(string2)) {
            string2 = "http://www.w3.org/1999/XSL/Format";
        }
        this.handler.startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (this.skip > 0) {
            return;
        }
        if (this.storeImage > 0) {
            this.imageData.endPrefixMapping(string);
            return;
        }
        if (this.storeFV > 0) {
            this.FVData.endPrefixMapping(string);
            return;
        }
        if (this.storeRMR > 0) {
            this.RMRData.endPrefixMapping(string);
            return;
        }
        if (this.storeLeader > 0) {
            return;
        }
        this.flushText();
        this.handler.endPrefixMapping(string);
    }

    private void proliferateMarker(String string, String string2, SAXStorage sAXStorage, boolean bl) throws SAXException {
        Integer n = (Integer)this.markerTable.get(string);
        if (n == null) {
            return;
        }
        int n2 = n;
        sAXStorage.setContentHandler(this.handler);
        String string3 = bl ? GHOST_MARKER_PREFIX : "";
        int n3 = 0;
        while (n3 < n) {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "marker-class-name", "marker-class-name", "CDATA", string3 + FOPreprocessor.generateId(n3) + string);
            this.handler.startElement("http://www.w3.org/1999/XSL/Format", "marker", string2, attributesImpl);
            sAXStorage.play();
            this.handler.endElement("http://www.w3.org/1999/XSL/Format", "marker", string2);
            ++n3;
        }
    }

    public static void main(String[] stringArray) {
        OutputStream outputStream = System.out;
        if (stringArray.length < 1) {
            System.err.println("call: java com.renderx.xep.pre.FOPreprocessor source_xml [target_xml]\n");
            System.exit(1);
        }
        try {
            FOPreprocessor.init();
            if (stringArray.length > 1) {
                outputStream = new FileOutputStream(stringArray[1]);
            }
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(new FOPreprocessor(new Serializer(outputStream), new DefaultErrorHandler()));
            xMLReader.parse(new InputSource(new FileInputStream(stringArray[0])));
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    static {
        ((AttributesImpl)ltrOverrideAttributes).addAttribute("", "unicode-bidi", "unicode-bidi", "CDATA", "embed");
        ((AttributesImpl)ltrOverrideAttributes).addAttribute("", "direction", "direction", "CDATA", "ltr");
        metafields = new Hashtable();
        metafields.put("AUTHOR", new Short(0));
        metafields.put("CREATOR", new Short(0));
        metafields.put("PRODUCER", new Short(0));
        metafields.put("PUBLISHER", new Short(0));
        metafields.put("KEYWORDS", new Short(0));
        metafields.put("SUBJECT", new Short(0));
        metafields.put("TITLE", new Short(0));
        initialized = false;
    }

    private class TextOnlyStorage
    implements ContentHandler {
        private String value = "";

        private TextOnlyStorage() {
        }

        public String toString() {
            return this.value;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.value = this.value + new String(cArray, n, n2);
        }

        public void skippedEntity(String string) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }
    }

    private class FolioProcessor
    implements ContentHandler {
        private ContentHandler h = null;

        public FolioProcessor(ContentHandler contentHandler) {
            this.h = contentHandler;
        }

        public void skippedEntity(String string) throws SAXException {
            this.h.skippedEntity(string);
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            this.h.processingInstruction(string, string2);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.h.ignorableWhitespace(cArray, n, n2);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.h.characters(cArray, n, n2);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (("page-number-citation".equals(string2) || "page-number-citation-last".equals(string2)) && "http://www.w3.org/1999/XSL/Format".equals(string)) {
                Object object;
                String string4 = attributes.getValue("ref-id");
                XMLPlayer xMLPlayer = null;
                SAXStorage sAXStorage = null;
                if (string4 != null && (object = FOPreprocessor.this.folios.get(string4)) != null) {
                    xMLPlayer = (SAXStorage)((Object[])object)[0];
                    sAXStorage = (SAXStorage)((Object[])object)[1];
                }
                if (xMLPlayer != null) {
                    xMLPlayer.setContentHandler(this.h);
                    ((SAXStorage)xMLPlayer).play();
                    xMLPlayer.setContentHandler(null);
                }
                this.h.startElement(string, string2, string3, attributes);
                this.h.endElement(string, string2, string3);
                if (sAXStorage != null) {
                    sAXStorage.setContentHandler(this.h);
                    sAXStorage.play();
                    sAXStorage.setContentHandler(null);
                }
            } else {
                this.h.startElement(string, string2, string3, attributes);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!"page-number-citation".equals(string2) && !"page-number-citation-last".equals(string2) || !"http://www.w3.org/1999/XSL/Format".equals(string)) {
                this.h.endElement(string, string2, string3);
            }
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            this.h.startPrefixMapping(string, string2);
        }

        public void endPrefixMapping(String string) throws SAXException {
            this.h.endPrefixMapping(string);
        }

        public void startDocument() throws SAXException {
            this.h.startDocument();
        }

        public void endDocument() throws SAXException {
            this.h.endDocument();
        }

        public void setDocumentLocator(Locator locator) {
            this.h.setDocumentLocator(locator);
        }
    }
}

