/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre;

import com.renderx.xep.lib.InternalException;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.ParserException;
import com.renderx.xep.pre.Token;
import java.io.IOException;
import java.io.InputStreamReader;

public class AttributeLexer {
    public static final String blanks = " \t\r\n";
    public static final String token_delimiters = " \t\r\n'\"()+,*/";
    public static final String single_chars = "-()+,*/";
    public static final String quotes = "'\"";
    public static final String digits = "0123456789";
    public static final String hexdigits = "0123456789ABCDEFabcdef";
    private char[] data = null;
    private int length = 0;
    private int cursor = 0;
    private boolean isShorthand = false;
    private boolean expectUnaryOp = true;

    public AttributeLexer() {
    }

    public AttributeLexer(boolean bl) {
        this.isShorthand = bl;
    }

    public AttributeLexer(String string, boolean bl) {
        this(bl);
        this.setSource(string);
    }

    public AttributeLexer(char[] cArray, boolean bl) {
        this(bl);
        this.setSource(cArray);
    }

    public void setSource(String string) {
        this.setSource(string.toCharArray());
    }

    public void setSource(char[] cArray) {
        this.setSource(cArray, 0, cArray.length);
    }

    public void setSource(char[] cArray, int n, int n2) {
        this.data = cArray;
        this.cursor = n;
        this.length = n + n2;
        this.expectUnaryOp = true;
    }

    private void skip_whitespace() {
        while (this.cursor < this.length) {
            if (blanks.indexOf(this.data[this.cursor]) == -1) break;
            ++this.cursor;
        }
    }

    public Token nextToken() throws ParserException {
        Token token = new Token();
        this.nextToken(token);
        return token;
    }

    public int nextToken(Token token) throws ParserException {
        this.skip_whitespace();
        token.value = null;
        if (this.cursor >= this.length) {
            token.type = 1;
            return 1;
        }
        if (single_chars.indexOf(this.data[this.cursor]) != -1) {
            switch (this.data[this.cursor++]) {
                case '(': {
                    token.type = 2;
                    break;
                }
                case ')': {
                    token.type = 4;
                    break;
                }
                case ',': {
                    token.type = 8;
                    break;
                }
                case '+': {
                    token.type = this.expectUnaryOp || this.isShorthand ? 1024 : 16;
                    break;
                }
                case '-': {
                    token.type = this.expectUnaryOp || this.isShorthand ? 2048 : 32;
                    break;
                }
                case '*': {
                    token.type = 64;
                    break;
                }
                case '/': {
                    token.type = 128;
                    break;
                }
                default: {
                    throw new InternalException("Lexer internal error: unhandled single-char token " + this.data[this.cursor - 1]);
                }
            }
            this.expectUnaryOp = token.type != 4;
            return token.type;
        }
        this.expectUnaryOp = false;
        token.type = 8192;
        if (quotes.indexOf(this.data[this.cursor]) != -1) {
            char c = this.data[this.cursor];
            int n = ++this.cursor;
            do {
                if (this.cursor != this.length) continue;
                throw new ParserException("Unterminated quoted string");
            } while (this.data[this.cursor++] != c);
            token.value = Attr.Word.create(new String(this.data, n, this.cursor - n - 1));
            return token.type;
        }
        int n = this.cursor;
        while (this.cursor < this.length) {
            if (token_delimiters.indexOf(this.data[this.cursor]) != -1) break;
            ++this.cursor;
        }
        if (this.data[n] == '#') {
            if (this.cursor - n == 7 && hexdigits.indexOf(this.data[n + 1]) != -1 && hexdigits.indexOf(this.data[n + 2]) != -1 && hexdigits.indexOf(this.data[n + 3]) != -1 && hexdigits.indexOf(this.data[n + 4]) != -1 && hexdigits.indexOf(this.data[n + 5]) != -1 && hexdigits.indexOf(this.data[n + 6]) != -1) {
                int n2 = Integer.parseInt(new String(this.data, n + 1, 2), 16);
                int n3 = Integer.parseInt(new String(this.data, n + 3, 2), 16);
                int n4 = Integer.parseInt(new String(this.data, n + 5, 2), 16);
                token.value = n2 == n3 && n3 == n4 ? Attr.Color.Grayscale.create((double)n3 / 255.0) : Attr.Color.RGB.create((double)n2 / 255.0, (double)n3 / 255.0, (double)n4 / 255.0);
                return token.type;
            }
            if (this.cursor - n == 4 && hexdigits.indexOf(this.data[n + 1]) != -1 && hexdigits.indexOf(this.data[n + 2]) != -1 && hexdigits.indexOf(this.data[n + 3]) != -1) {
                int n5 = Integer.parseInt(new String(this.data, n + 1, 1), 16) * 17;
                int n6 = Integer.parseInt(new String(this.data, n + 2, 1), 16) * 17;
                int n7 = Integer.parseInt(new String(this.data, n + 3, 1), 16) * 17;
                token.value = n5 == n6 && n6 == n7 ? Attr.Color.Grayscale.create((double)n6 / 255.0) : Attr.Color.RGB.create((double)n5 / 255.0, (double)n6 / 255.0, (double)n7 / 255.0);
                return token.type;
            }
        }
        if (digits.indexOf(this.data[n]) == -1 && (this.data[n] != '.' || n >= this.length - 1 || digits.indexOf(this.data[n + 1]) == -1)) {
            if (this.cursor - n == 3) {
                if (this.data[n] == 'd' && this.data[n + 1] == 'i' && this.data[n + 2] == 'v' && !this.isShorthand) {
                    this.expectUnaryOp = true;
                    token.type = 256;
                    return 256;
                }
                if (this.data[n] == 'm' && this.data[n + 1] == 'o' && this.data[n + 2] == 'd' && !this.isShorthand) {
                    this.expectUnaryOp = true;
                    token.type = 512;
                    return 512;
                }
                if (this.data[n] == 'u' && this.data[n + 1] == 'r' && this.data[n + 2] == 'l') {
                    int n8 = this.cursor;
                    this.skip_whitespace();
                    if (this.data[this.cursor++] != '(') {
                        this.cursor = n8;
                    } else {
                        this.skip_whitespace();
                        n = this.cursor;
                        int n9 = this.cursor;
                        Token token2 = new Token();
                        block22: while (true) {
                            switch (this.nextToken(token2)) {
                                case 1: {
                                    throw new ParserException("Unclosed bracket in an URI specifier");
                                }
                                case 4: {
                                    break block22;
                                }
                                default: {
                                    n9 = this.cursor;
                                    continue block22;
                                }
                            }
                            break;
                        }
                        if (quotes.indexOf(this.data[n]) != -1 && n9 > n + 1 && this.data[n] == this.data[n9 - 1]) {
                            ++n;
                            --n9;
                        }
                        token.value = Attr.Word.create("url(" + new String(this.data, n, n9 - n) + ")");
                        return token.type;
                    }
                }
            }
            token.value = Attr.Word.create(new String(this.data, n, this.cursor - n));
            this.skip_whitespace();
            if (this.cursor < this.length && this.data[this.cursor] == '(') {
                ++this.cursor;
                this.expectUnaryOp = true;
                token.type = 4096;
            }
            return token.type;
        }
        int n10 = n;
        boolean bl = false;
        double d = 1.0;
        double d2 = 0.0;
        int n11 = 0;
        while (n10 < this.cursor) {
            if (digits.indexOf(this.data[n10]) != -1) {
                int n12 = this.data[n10] - 48;
                if (bl) {
                    d2 += (d /= 10.0) * (double)n12;
                } else {
                    n11 = (int)((double)n11 * 10.0);
                    d2 = n11 += n12;
                }
            } else {
                if (this.data[n10] != '.' || bl) break;
                bl = true;
            }
            ++n10;
        }
        switch (this.cursor - n10) {
            case 0: {
                if (bl) {
                    token.value = Attr.Ratio.create(d2);
                    return token.type;
                }
                token.value = Attr.Count.create(n11);
                return token.type;
            }
            case 1: {
                if (this.data[n10] != '%') break;
                token.value = Attr.Percentage.create(d2);
                return token.type;
            }
            case 2: {
                if (this.data[n10] == 'e' && this.data[n10 + 1] == 'm') {
                    token.value = Attr.EMLength.create(d2);
                    return token.type;
                }
                if (this.data[n10] == 'p' && this.data[n10 + 1] == 't') {
                    token.value = Attr.Length.create((int)Math.round(d2 * 1000.0));
                    return token.type;
                }
                if (this.data[n10] == 'i' && this.data[n10 + 1] == 'n') {
                    token.value = Attr.Length.create((int)Math.round(d2 * 72.0 * 1000.0));
                    return token.type;
                }
                if (this.data[n10] == 'p' && this.data[n10 + 1] == 'c') {
                    token.value = Attr.Length.create((int)Math.round(d2 * 12.0 * 1000.0));
                    return token.type;
                }
                if (this.data[n10] == 'p' && this.data[n10 + 1] == 'x') {
                    token.value = Attr.Length.create((int)Math.round(d2 * 0.6 * 1000.0));
                    return token.type;
                }
                if (this.data[n10] == 'c' && this.data[n10 + 1] == 'm') {
                    token.value = Attr.Length.create((int)Math.round(d2 * 28.346456692913385 * 1000.0));
                    return token.type;
                }
                if (this.data[n10] != 'm' || this.data[n10 + 1] != 'm') break;
                token.value = Attr.Length.create((int)Math.round(d2 * 2.834645669291339 * 1000.0));
                return token.type;
            }
            case 3: {
                if (this.data[n10] == 'd' && this.data[n10 + 1] == 'e' && this.data[n10 + 2] == 'g') {
                    token.value = Attr.Angle.create(d2);
                    return token.type;
                }
                if (this.data[n10] == 'r' && this.data[n10 + 1] == 'a' && this.data[n10 + 2] == 'd') {
                    token.value = Attr.Angle.create(d2 * 180.0 / 3.14159265);
                    return token.type;
                }
            }
            case 4: {
                if (this.data[n10] != 'g' || this.data[n10 + 1] != 'r' || this.data[n10 + 2] != 'a' || this.data[n10 + 3] != 'd') break;
                token.value = Attr.Angle.create(d2 * 0.9);
                return token.type;
            }
        }
        throw new ParserException("Incorrect structure of a numeric token: " + new String(this.data, n, this.cursor - n));
    }

    public static void main(String[] stringArray) {
        char[] cArray = new char[8192];
        int n = 0;
        AttributeLexer attributeLexer = new AttributeLexer();
        Token token = new Token();
        while (true) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                n = inputStreamReader.read(cArray);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                System.exit(1);
            }
            if (n < 0) {
                System.exit(0);
            }
            attributeLexer.setSource(cArray, 0, n);
            try {
                do {
                    attributeLexer.nextToken(token);
                    token.Dump(System.out);
                } while (token.type != 1);
            }
            catch (ParserException parserException) {
                System.err.println(parserException.toString());
            }
            catch (InternalException internalException) {
                System.err.println(internalException.toString());
            }
            System.out.println();
        }
    }
}

