/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.cmp;

import com.renderx.util.Array;
import com.renderx.util.Matrix;
import com.renderx.xep.cmp.Flow;
import com.renderx.xep.cmp.Item;
import com.renderx.xep.cmp.Xattr;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.Session;
import com.renderx.xep.pre.AttList;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.Attributed;
import java.util.Enumeration;

public class TableContext
extends Xattr {
    private static final short CELLS_ONLY = 0;
    private static final short HAS_ROWS = 1;
    public static final short HEADER = 0;
    public static final short BODY = 1;
    public static final short FOOTER = 2;
    public int table_width;
    final Session session;
    private Array cols = new Array();
    private Array rows = new Array();
    private Array rowgroups = new Array();
    private Matrix cells = new Matrix();
    private int irgr = 0;
    private int irow = -1;
    private int icol = 0;
    private short mode = (short)-1;
    private int max_row_length = 1;
    private boolean new_row_started = true;
    private boolean ends_row = false;
    private int gap;
    private boolean auto;
    private boolean width_auto;

    TableContext(Attributed attributed, Session session) {
        super(attributed);
        this.session = session;
        this.table_width = Attr.dim_range(attributed, Attn.$inline_progression_dimension_minimum, Attn.$inline_progression_dimension_optimum, Attn.$inline_progression_dimension_maximum, 0);
        boolean bl = this.width_auto = this.table_width == Integer.MIN_VALUE;
        if (this.width_auto) {
            this.auto = true;
            this.table_width = 0;
        } else {
            this.auto = attributed.get(Attn.$table_layout) == Attr.auto;
        }
        this.gap = attributed.get(Attn.$border_separation_inline_progression_direction).length();
    }

    void column(Attributed attributed) {
        Column column = new Column(attributed);
        this.cols.put(column.number - 1, column);
        if (column.number > this.max_row_length) {
            this.max_row_length = column.number;
        }
    }

    void startRowgroup(short s, Attributed attributed, Flow flow, Flow flow2) {
        this.irow = this.cells.length();
        this.rowgroups.put(this.irgr, new Rowgroup(attributed, flow, flow2, this.irow, s));
        this.mode = 0;
    }

    void endRowgroup(short s) {
        if (this.mode == 0) {
            this.newRow();
        }
        ((Rowgroup)this.rowgroups.get((int)this.irgr)).bounds[1] = this.cells.length();
        ++this.irgr;
    }

    private void newRow() {
        if (!this.new_row_started) {
            int n;
            Array array = (Array)this.cells.get(this.irow);
            int n2 = n = array == null ? 0 : array.length();
            if (n > this.max_row_length) {
                this.max_row_length = n;
            }
            ++this.irow;
            this.new_row_started = true;
        }
    }

    void startRow(Attributed attributed) {
        this.mode = 1;
        Row row = new Row(attributed);
        this.rows.put(this.irow, row);
        this.new_row_started = false;
    }

    void endRow() {
        this.newRow();
    }

    void startCell(Attributed attributed, Item.Frame frame, Item.Frame frame2, Flow flow, Flow flow2, Flow flow3) {
        if (this.mode == 1 && (attributed.get(Attn.$ends_row).bool() || attributed.get(Attn.$starts_row).bool())) {
            this.session.warning("(starts|ends)-row inside a row");
        }
        if (attributed.get(Attn.$starts_row).bool()) {
            this.newRow();
        }
        if (attributed.get(Attn.$ends_row).bool()) {
            this.ends_row = true;
        }
        this.new_row_started = false;
        this.icol = attributed.get(Attn.$column_number).count() - 1;
        if (this.cells.get(this.irow, this.icol) != null) {
            this.session.error("table cells overlap, skipping a cell");
            return;
        }
        Cell cell = new Cell(attributed, this.irow, this.icol);
        cell.outer = frame;
        cell.inner = frame2;
        cell.flow_prolog = flow;
        cell.flow_body = flow2;
        cell.flow_epilog = flow3;
        int n = this.irow + cell.n_rows_spanned;
        int n2 = this.icol + cell.n_columns_spanned;
        if (this.cells.get(n - 1, n2 - 1) != null) {
            this.session.error("table cells overlap, skipping a cell");
            return;
        }
        int n3 = this.irow;
        while (n3 != n) {
            int n4 = this.icol;
            while (n4 != n2) {
                if (this.cells.get(n3, n4) != null) {
                    this.session.warning("table cells overlap");
                }
                this.cells.put(n3, n4, cell);
                ++n4;
            }
            ++n3;
        }
        cell.width_min = frame2.get(Attn.$inline_progression_dimension_minimum).length_or_ratio(0);
        cell.width_max = frame2.get(Attn.$inline_progression_dimension_maximum).length_or_ratio(Integer.MAX_VALUE);
        cell.extrawidth = frame2.get(Attn.$border_start_width_length).length_or_ratio(0) + frame2.get(Attn.$border_end_width_length).length_or_ratio(0) + frame2.get(Attn.$padding_start_length).length_or_ratio(0) + frame2.get(Attn.$padding_end_length).length_or_ratio(0) + this.gap;
        frame2.a.remove(Attn.$inline_progression_dimension_minimum);
        frame2.a.remove(Attn.$inline_progression_dimension_optimum);
        frame2.a.remove(Attn.$inline_progression_dimension_maximum);
    }

    void endCell() {
        if (this.ends_row) {
            this.newRow();
            this.ends_row = false;
        }
    }

    private void fix() {
        int n = 0;
        while (n != this.cells.length()) {
            if (this.rows.get(n) == null) {
                this.rows.put(n, new Row());
            }
            ++n;
        }
        int n2 = 0;
        while (n2 != this.max_row_length) {
            if (this.cols.get(n2) == null) {
                this.cols.put(n2, new Column());
            }
            ++n2;
        }
        n = 0;
        while (n != this.cells.length()) {
            Array array = (Array)this.cells.get(n);
            if (array == null) {
                array = new Array(this.max_row_length);
                this.cells.put(n, array);
            }
            n2 = 0;
            while (n2 != this.max_row_length) {
                if (array.get(n2) == null) {
                    array.put(n2, new Cell());
                }
                ++n2;
            }
            ++n;
        }
    }

    public void pin(int n, boolean bl) {
        if (bl || n != this.table_width) {
            if (this.auto) {
                int n2 = 0;
                while (n2 != this.cols.length()) {
                    Column column = (Column)this.cols.get(n2);
                    if (column.auto) {
                        column.width_fixed = 0;
                        column.width_proportional = column.vol;
                    }
                    ++n2;
                }
                while (true) {
                    this.fit(n);
                    boolean bl2 = false;
                    int n3 = 0;
                    while (n3 != this.cols.length()) {
                        Column column = (Column)this.cols.get(n3);
                        if (column.auto) {
                            if (column.width < column.width_min) {
                                column.width_fixed = column.width_min;
                                column.width_proportional = 0.0;
                                bl2 = true;
                            } else if (this.width_auto && column.width > column.width_max) {
                                column.width_fixed = column.width_max;
                                column.width_proportional = 0.0;
                                bl2 = true;
                            }
                        }
                        ++n3;
                    }
                    if (bl2) {
                        continue;
                    }
                    break;
                }
            } else {
                this.fit(n);
            }
        }
    }

    private void fit(int n) {
        Column column;
        int n2 = n;
        int n3 = 0;
        double d = 0.0;
        int n4 = 0;
        while (n4 != this.cols.length()) {
            Column column2 = (Column)this.cols.get(n4);
            if (column2.get(Attn.$column_width_fixed) instanceof Attr.Ratio) {
                column2.width_fixed = (int)Math.round((double)n * column2.get(Attn.$column_width_fixed).ratio());
            }
            n2 -= column2.width_fixed;
            n3 += column2.width_fixed;
            d += column2.width_proportional;
            ++n4;
        }
        if (this.width_auto) {
            this.table_width = d == 0.0 ? n3 : n;
        } else if (d == 0.0) {
            if (n3 > n) {
                this.table_width = n3;
            } else {
                int n5 = 0;
                while (n5 != this.cols.length()) {
                    column = (Column)this.cols.get(n5);
                    if (!column.auto && column.width_proportional == 0.0) {
                        column.width_proportional = 1.0;
                        d += 1.0;
                    }
                    ++n5;
                }
                this.table_width = d == 0.0 ? n3 : n;
            }
        } else {
            this.table_width = n;
        }
        int n6 = n2;
        column = null;
        int n7 = 0;
        while (n7 != this.cols.length()) {
            Column column3 = (Column)this.cols.get(n7);
            column3.width = column3.width_fixed;
            if (column3.width_proportional != 0.0) {
                int n8 = (int)Math.round((double)n2 * (column3.width_proportional / d));
                column3.width += n8;
                n6 -= n8;
                column = column3;
            }
            ++n7;
        }
        if (column != null) {
            column.width += n6;
        }
        int n9 = 0;
        while (n9 != this.rowgroups.length()) {
            Rowgroup rowgroup = (Rowgroup)this.rowgroups.get(n9);
            if (rowgroup != null) {
                int n10 = rowgroup.bounds[0];
                while (n10 != rowgroup.bounds[1]) {
                    Array array = (Array)this.cells.get(n10);
                    int n11 = 0;
                    while (n11 != array.length()) {
                        Cell cell = (Cell)array.get(n11);
                        if (cell.O[0] == n10 && cell.O[1] == n11) {
                            int n12;
                            int n13 = this.gap / 2;
                            int n14 = ((Column)this.cols.get((int)cell.O[1])).width - this.gap;
                            if (cell.O[1] != 0) {
                                n12 = 0;
                                while (n12 != cell.O[1]) {
                                    n13 += ((Column)this.cols.get((int)n12)).width;
                                    ++n12;
                                }
                            }
                            if (cell.n_columns_spanned != 1) {
                                n12 = cell.O[1] + 1;
                                while (n12 != cell.O[1] + cell.n_columns_spanned) {
                                    n14 += ((Column)this.cols.get((int)n12)).width;
                                    ++n12;
                                }
                            }
                            cell.outer.a.put(Attn.$start_indent, Attr.newLength(n13));
                            cell.outer.a.put(Attn.$inline_progression_dimension_optimum, Attr.newLength(n14));
                        }
                        ++n11;
                    }
                    ++n10;
                }
            }
            ++n9;
        }
    }

    private void measure() {
        if (this.auto) {
            int n;
            int n2 = 0;
            while (n2 != this.cells.length()) {
                Array array = (Array)this.cells.get(n2);
                int n3 = 0;
                while (n3 != array.length()) {
                    Cell cell = (Cell)array.get(n3);
                    if (cell.O[0] == n2 && cell.O[1] == n3) {
                        Xattr xattr;
                        n = 0;
                        int n4 = 0;
                        double d = 0.0;
                        int n5 = 0;
                        int n6 = 0;
                        Enumeration enumeration = cell.flow_body.elements();
                        while (enumeration.hasMoreElements()) {
                            Item item = (Item)enumeration.nextElement();
                            if (item.breaksPhrase()) {
                                if (n5 > n) {
                                    n = n5;
                                }
                                n5 = 0;
                            }
                            if (item.breaksLine()) {
                                if (n6 > n4) {
                                    n4 = n6;
                                }
                                n6 = 0;
                            }
                            if (item instanceof Item.Inline) {
                                xattr = (Item.Inline)item;
                                xattr.dimensions(0);
                                n5 += xattr.width;
                                n6 += xattr.width;
                                d += (double)(xattr.ascender - xattr.descender) * (double)xattr.width;
                            } else if (item instanceof Item.Frame) {
                                int n7 = item instanceof Item.Table ? ((Item.Table)item).context.table_width : Attr.length_range(item, Attn.$inline_progression_dimension_minimum, Attn.$inline_progression_dimension_optimum, Attn.$inline_progression_dimension_maximum, 0);
                                if (n < n7) {
                                    n = n7;
                                }
                                if (n4 < n7) {
                                    n4 = n7;
                                }
                            }
                            if (n5 > n) {
                                n = n5;
                            }
                            if (n6 <= n4) continue;
                            n4 = n6;
                        }
                        if (n < cell.width_min) {
                            n = cell.width_min;
                        }
                        if (n4 > cell.width_max) {
                            n4 = cell.width_max;
                        }
                        if (n4 < n) {
                            n4 = n;
                        }
                        n += cell.extrawidth;
                        n4 += cell.extrawidth;
                        d /= (double)(cell.n_rows_spanned * cell.n_columns_spanned);
                        n /= cell.n_columns_spanned;
                        n4 /= cell.n_columns_spanned;
                        int n8 = cell.O[1];
                        while (n8 <= cell.O[3]) {
                            xattr = (Column)this.cols.get(n8);
                            if (((Column)xattr).width_min < n) {
                                ((Column)xattr).width_min = n;
                            }
                            if (((Column)xattr).width_max < n4) {
                                ((Column)xattr).width_max = n4;
                            }
                            ((Column)xattr).vol += d;
                            ++n8;
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
            double d = 0.0;
            int n9 = 0;
            while (n9 != this.cols.length()) {
                d += ((Column)this.cols.get((int)n9)).vol;
                ++n9;
            }
            if (d != 0.0 && this.cols.length() != 0) {
                d /= (double)this.cols.length();
                n = 0;
                while (n != this.cols.length()) {
                    Column column = (Column)this.cols.get(n);
                    column.vol = Math.sqrt(column.vol / d);
                    ++n;
                }
            }
        }
    }

    void gen(Item.Table table, Flow flow) {
        int n = table.bno;
        this.fix();
        flow.append(Item.empty);
        Flow flow2 = new Flow();
        int n2 = 0;
        while (n2 != this.rowgroups.length()) {
            Flow flow3;
            Rowgroup rowgroup = (Rowgroup)this.rowgroups.get(n2);
            switch (rowgroup.part) {
                case 0: {
                    flow3 = table.header;
                    break;
                }
                case 2: {
                    flow3 = table.footer;
                    break;
                }
                case 1: {
                    flow3 = flow2;
                    break;
                }
                default: {
                    throw new InternalException("invalid table part: " + rowgroup.part);
                }
            }
            if (rowgroup.flow_prolog != null) {
                flow3.append(rowgroup.flow_prolog);
            }
            int n3 = rowgroup.bounds[0];
            while (n3 != rowgroup.bounds[1]) {
                int n4;
                Object object;
                Row row = (Row)this.rows.get(n3);
                boolean bl = row.keep_together;
                boolean bl2 = false;
                if (row.get(Attn.$break_before) != Attr.auto) {
                    flow3.append(new Item.Break(row, "before"));
                }
                flow3.append(Item.empty);
                Array array = (Array)this.cells.get(n3);
                int n5 = array.length() - 1;
                while (n5 != -1) {
                    Cell cell = (Cell)array.get(n5);
                    if (cell.O[0] == n3 && cell.O[1] == n5) {
                        flow3.append(new Item.Fork(cell.id("table-cell", n)));
                    }
                    if (cell.keep_together) {
                        bl = true;
                        if (cell.O[2] != n3) {
                            bl2 = true;
                        }
                    }
                    --n5;
                }
                if (!row.auto) {
                    flow3.append(new Item.Washer.Display(row.row_height));
                }
                if (!bl) {
                    flow3.append(Item.filled);
                }
                flow3.append(new Item.Jump("table-row-epilog:" + n + ":" + n3));
                if (row.get(Attn.$keep_with_previous_within_column) != Attr.auto || row.get(Attn.$keep_with_previous_within_page) != Attr.auto) {
                    flow3.append(new Item.Keep((Attributed)row));
                }
                int n6 = 0;
                while (n6 != array.length()) {
                    Cell cell = (Cell)array.get(n6);
                    if (cell.O[0] == n3 && cell.O[1] == n6) {
                        object = cell.id("table-cell", n);
                        flow3.append(new Item.Label((String)object)).append(cell.flow_prolog).append(cell.flow_body).append(Item.filled).append(new Item.Softsync((String)object)).append(new Item.Softsync((String)object)).append(cell.flow_epilog).append(new Item.Sync((String)object)).append(Item.eofl);
                        n4 = n3;
                        while (n4 != n3 + cell.n_rows_spanned) {
                            ((Row)this.rows.get((int)n4)).level.register(cell.inner);
                            ++n4;
                        }
                    }
                    ++n6;
                }
                if (row.get(Attn.$keep_with_next_within_column) != Attr.auto || row.get(Attn.$keep_with_next_within_page) != Attr.auto) {
                    flow3.append(new Item.Keep((Attributed)row));
                }
                flow3.append(new Item.Label("table-row-epilog:" + n + ":" + n3));
                int n7 = 0;
                while (n7 != array.length()) {
                    object = (Cell)array.get(n7);
                    if (((Cell)object).O[2] == n3 && ((Cell)object).O[3] == n7) {
                        flow3.append(new Item.Softsync(((Cell)object).id("table-cell", n)));
                    }
                    ++n7;
                }
                int n8 = 0;
                while (n8 != array.length()) {
                    Cell cell = (Cell)array.get(n8);
                    if (cell.O[2] == n3 && cell.O[3] == n8) {
                        flow3.append(new Item.Softsync(cell.id("table-cell", n)));
                    }
                    ++n8;
                }
                if (!bl2) {
                    flow3.append(Item.filled);
                }
                n4 = 0;
                while (n4 != array.length()) {
                    Cell cell = (Cell)array.get(n4);
                    if (cell.O[2] == n3 && cell.O[3] == n4) {
                        flow3.append(new Item.Sync(cell.id("table-cell", n)));
                    }
                    ++n4;
                }
                flow3.append(row.level);
                if (row.get(Attn.$break_after) != Attr.auto) {
                    flow3.append(new Item.Break(row, "after"));
                }
                ++n3;
            }
            if (rowgroup.flow_epilog != null) {
                flow3.append(rowgroup.flow_epilog);
            }
            ++n2;
        }
        if (table.get(Attn.$table_omit_header_at_break).bool()) {
            if (!table.get(Attn.$table_omit_initial_header).bool()) {
                flow.append(table.header);
            }
            table.header = new Flow();
        }
        flow.append(flow2);
        flow2 = null;
        if (table.get(Attn.$table_omit_footer_at_break).bool()) {
            flow.append(table.footer);
            table.footer = new Flow();
        }
        this.measure();
        this.pin(this.table_width, true);
    }

    private class Cell {
        int[] O = new int[4];
        int width_min;
        int width_max;
        int extrawidth;
        int n_columns_spanned = -1;
        int n_rows_spanned = -1;
        boolean keep_together = false;
        Item.Frame outer = null;
        Item.Frame inner = null;
        Flow flow_prolog = null;
        Flow flow_body = null;
        Flow flow_epilog = null;
        private String idtail;

        Cell() {
            this.O[3] = -1;
            this.O[2] = -1;
            this.O[1] = -1;
            this.O[0] = -1;
        }

        Cell(Attributed attributed, int n, int n2) {
            this.O[0] = n;
            this.O[1] = n2;
            this.idtail = ":" + this.O[0] + ":" + this.O[1];
            this.n_columns_spanned = attributed.get(Attn.$number_columns_spanned).count();
            this.n_rows_spanned = attributed.get(Attn.$number_rows_spanned).count();
            if (this.n_columns_spanned < 1) {
                this.n_columns_spanned = 1;
            }
            if (this.n_rows_spanned < 1) {
                this.n_rows_spanned = 1;
            }
            this.O[2] = this.O[0] + this.n_rows_spanned - 1;
            this.O[3] = this.O[1] + this.n_columns_spanned - 1;
            this.keep_together = attributed.get(Attn.$keep_together_within_page) != Attr.auto || attributed.get(Attn.$keep_together_within_column) != Attr.auto;
        }

        String id(String string, int n) {
            return string + ":" + n + this.idtail;
        }
    }

    private class Rowgroup
    extends Xattr {
        int[] bounds = new int[]{-1, -1};
        Flow flow_prolog;
        Flow flow_epilog;
        short part;

        Rowgroup(Attributed attributed, Flow flow, Flow flow2, int n, short s) {
            super(attributed);
            this.flow_prolog = flow;
            this.flow_epilog = flow2;
            this.bounds[0] = n;
            this.part = s;
        }
    }

    private class Row
    extends Xattr {
        public Item.Level level = new Item.Level();
        int row_height = 0;
        boolean auto;
        boolean keep_together = false;

        Row(Attributed attributed) {
            super(attributed);
            this.row_height = attributed.get(Attn.$block_progression_dimension_minimum).length_or_ratio(0);
            if (this.row_height == 0) {
                this.row_height = attributed.get(Attn.$block_progression_dimension_optimum).length_or_ratio(0);
            }
            this.auto = this.row_height == 0;
            this.keep_together = attributed.get(Attn.$keep_together_within_column) != Attr.auto || attributed.get(Attn.$keep_together_within_page) != Attr.auto;
        }

        Row() {
            super(AttList.empty);
        }
    }

    private class Column
    extends Xattr {
        int number;
        int width;
        int width_fixed;
        double width_proportional;
        boolean auto;
        int width_min;
        int width_max;
        double vol;

        private Column(Attributed attributed) {
            super(attributed);
            this.number = attributed.get(Attn.$column_number).count();
            this.auto = attributed.get(Attn.$column_width_proportional) == Attr.auto;
            this.width_proportional = this.auto ? 1.0 : attributed.get(Attn.$column_width_proportional).ratio();
            this.width_fixed = attributed.get(Attn.$column_width_fixed) instanceof Attr.Length ? (this.width_fixed = attributed.get(Attn.$column_width_fixed).length()) : 0;
        }

        Column() {
            this(AttList.empty);
        }
    }
}

