/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

import com.renderx.util.Base64InputStream;
import com.renderx.util.Base64OutputStream;
import com.renderx.util.URLDecodeInputStream;
import com.renderx.util.URLSpec;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;

public class DataURL
implements Serializable {
    private final boolean base64;
    private final String type;
    private final String data;
    private final int dataoffset;
    URLSpec baseURL = null;

    public DataURL(URLSpec uRLSpec, String string) throws MalformedURLException {
        this(string);
        if (uRLSpec != null) {
            this.baseURL = uRLSpec.getBase();
        }
    }

    public DataURL(String string) throws MalformedURLException {
        if (!"data:".equalsIgnoreCase(string.substring(0, 5))) {
            throw new MalformedURLException("Not a valid 'data' URL: " + string);
        }
        int n = string.indexOf(44);
        if (n == -1) {
            throw new MalformedURLException("Invalid structure of the 'data' URL: no comma found");
        }
        this.data = string;
        this.dataoffset = n + 1;
        String string2 = string.substring(5, n).trim();
        this.base64 = string2.endsWith(";base64");
        if (this.base64) {
            string2 = new String(string2.substring(0, string2.length() - 7).trim().getBytes());
        }
        this.type = string2.equals("") ? "text/plain;charset=US-ASCII" : (string2.indexOf(47) == -1 ? "text/plain;" + string2 : string2);
    }

    public InputStream openStream() throws IOException {
        StringReader stringReader = new StringReader(this.data);
        stringReader.skip(this.dataoffset);
        if (this.base64) {
            return new Base64InputStream(stringReader);
        }
        return new URLDecodeInputStream(stringReader);
    }

    public String getContentType() {
        return this.type;
    }

    public String toString() {
        return this.data;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 3) {
            System.err.println("Usage: {-urlencode | -base64 | -decode} <data URL file> <binary file>");
            System.exit(1);
        }
        if ("-base64".equals(stringArray[0])) {
            FileWriter fileWriter = new FileWriter(stringArray[1]);
            fileWriter.write("data:application/octet-stream;base64,");
            Base64OutputStream base64OutputStream = new Base64OutputStream(fileWriter);
            FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                base64OutputStream.write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            base64OutputStream.close();
            fileWriter.close();
        } else if ("-urlencode".equals(stringArray[0])) {
            char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
            FileWriter fileWriter = new FileWriter(stringArray[1]);
            fileWriter.write("data:application/octet-stream,");
            FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                int n2 = 0;
                while (n2 < n) {
                    byte by = byArray[n2];
                    if ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()".indexOf((char)by) != -1) {
                        fileWriter.write((char)by);
                    } else {
                        fileWriter.write(37);
                        fileWriter.write(cArray[by >> 4 & 0xF]);
                        fileWriter.write(cArray[by & 0xF]);
                    }
                    ++n2;
                }
            }
            ((InputStream)fileInputStream).close();
            fileWriter.close();
        } else {
            FileReader fileReader = new FileReader(stringArray[1]);
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[1024];
            int n = 0;
            while ((n = fileReader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
            DataURL dataURL = new DataURL(stringWriter.toString());
            System.out.println("Content-type: " + dataURL.getContentType());
            InputStream inputStream = dataURL.openStream();
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2]);
            byte[] byArray = new byte[1024];
            int n3 = 0;
            while ((n3 = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n3);
            }
            fileReader.close();
            stringWriter.close();
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
    }
}

