/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.smil;

import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.Media;
import com.renderx.graphics.ObjectRecordCoordinator;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.smil.ParseTerminationException;
import com.renderx.smil.ResourceSpooler;
import com.renderx.smil.SMILAttrValue;
import com.renderx.smil.SMILParseException;
import java.io.IOException;
import java.io.OutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SMIL
extends Media {
    final String SMIL10URI = "http://www.w3.org/TR/REC-smil";
    final String SMIL20URI = "http://www.w3.org/2001/SMIL20";

    public SMIL() {
        this.mimetype = "application/smil;";
    }

    public void parse() throws IOException, ImageFormatException {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            InputSource inputSource = new InputSource(this.openImageStream());
            xMLReader.setContentHandler(new SMILReader());
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new ImageFormatException("Invalid or unsupported SMIL:" + sAXException.toString());
        }
    }

    public void copyData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            InputSource inputSource = new InputSource(this.openImageStream());
            xMLReader.setContentHandler(new ResourceSpooler(outputStream, this.factory, this.source.getBase()));
            xMLReader.parse(inputSource);
        }
        catch (ParseTerminationException parseTerminationException) {
        }
        catch (SAXException sAXException) {
            throw new ImageFormatException("Invalid SMIL:" + sAXException.toString());
        }
        outputStream.flush();
    }

    class SMILReader
    extends DefaultHandler {
        private boolean isLayout = false;

        SMILReader() {
        }

        public void endDocument() throws SAXException {
            if (!this.isLayout) {
                throw new SMILParseException("SMIL media with no layout is not supported");
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!"http://www.w3.org/TR/REC-smil".equals(string) && !string.startsWith("http://www.w3.org/2001/SMIL20")) {
                throw new SAXException("Root element in a SMIL media " + SMIL.this.toDisplayString() + " is not in the SMIL 1.0 or 2.0 version namespaces");
            }
            AttributesImpl attributesImpl = new AttributesImpl(attributes);
            if (!this.isLayout && ("root-layout".equals(string2) || "topLayout".equals(string2))) {
                SMIL.this.width = this.parseLength(attributesImpl.getValue("width"));
                SMIL.this.height = this.parseLength(attributesImpl.getValue("height"));
                this.isLayout = true;
            }
        }

        private double parseLength(String string) throws SAXException {
            if (string == null) {
                throw new SMILParseException("Missing either 'height' or 'width' in layout of SMIL media" + SMIL.this.toDisplayString());
            }
            SMILAttrValue.Length length = new SMILAttrValue.Length(string);
            if (length.len == 0.0) {
                throw new SMILParseException("Zero-sized SMIL: either 'height' or 'width' in layout of SMIL media has value of '0'" + SMIL.this.toDisplayString());
            }
            if (length.base == 1) {
                throw new SMILParseException("Em units are not supported in dimensions of 'root-layout' or 'topLayout' elements");
            }
            if (length.base == 2) {
                throw new SMILParseException("Ex units are not supported in dimensions of 'root-layout' or 'topLayout' elements");
            }
            if (length.base == 3) {
                throw new SMILParseException("Percentages are not supported in dimensions of 'root-layout' or 'topLayout' elements");
            }
            return length.len;
        }
    }
}

