/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pslib;

import com.renderx.pslib.PSOutputStream;
import com.renderx.util.List;
import java.io.IOException;
import java.util.Enumeration;

public abstract class Function {
    int inputDimension;
    int outputDimension;

    Function(int n, int n2) {
        this.inputDimension = n;
        this.outputDimension = n2;
    }

    abstract String getFunctionType();

    void write(PSOutputStream pSOutputStream) throws IOException {
        pSOutputStream.print("<</FunctionType " + this.getFunctionType() + " ");
        pSOutputStream.print("/Domain [");
        int n = 0;
        while (n < this.inputDimension) {
            pSOutputStream.print("0 1");
            if (n < this.inputDimension - 1) {
                pSOutputStream.print(" ");
            }
            ++n;
        }
        pSOutputStream.print("] ");
        this.writeFunctionContent(pSOutputStream);
        pSOutputStream.print(">>");
    }

    abstract void writeFunctionContent(PSOutputStream var1) throws IOException;

    public static class FunctionType3
    extends Function {
        private List subfunctions = new List();
        private List bounds = new List();

        FunctionType3(int n) {
            super(1, n);
        }

        String getFunctionType() {
            return "3";
        }

        void addFunction(Function function) {
            this.subfunctions.append(function);
        }

        void addBound(double d) {
            this.bounds.append(new Double(d));
        }

        void writeFunctionContent(PSOutputStream pSOutputStream) throws IOException {
            pSOutputStream.print("/Functions [");
            Enumeration enumeration = this.subfunctions.elements();
            while (enumeration.hasMoreElements()) {
                pSOutputStream.println();
                ((Function)enumeration.nextElement()).write(pSOutputStream);
                if (!enumeration.hasMoreElements()) continue;
                pSOutputStream.print(" ");
            }
            pSOutputStream.println();
            pSOutputStream.print("] ");
            pSOutputStream.print("/Bounds [");
            Enumeration enumeration2 = this.bounds.elements();
            while (enumeration2.hasMoreElements()) {
                pSOutputStream.print("" + (Double)enumeration2.nextElement());
                if (!enumeration2.hasMoreElements()) continue;
                pSOutputStream.print(" ");
            }
            pSOutputStream.print("] ");
            pSOutputStream.print("/Encode [");
            int n = 0;
            while (n < this.subfunctions.length()) {
                pSOutputStream.print("0 1");
                if (n < this.subfunctions.length() - 1) {
                    pSOutputStream.print(" ");
                }
                ++n;
            }
            pSOutputStream.print("]");
        }
    }

    public static class FunctionType2
    extends Function {
        final double exponent;
        double[] C0;
        double[] C1;

        FunctionType2(int n, double d) {
            super(1, n);
            this.exponent = d;
        }

        String getFunctionType() {
            return "2";
        }

        void setC0(double[] dArray) {
            this.C0 = dArray;
        }

        void setC1(double[] dArray) {
            this.C1 = dArray;
        }

        void writeFunctionContent(PSOutputStream pSOutputStream) throws IOException {
            pSOutputStream.print("/C0 [");
            int n = 0;
            while (n < this.C0.length) {
                pSOutputStream.print("" + this.C0[n]);
                if (n < this.C0.length - 1) {
                    pSOutputStream.print(" ");
                }
                ++n;
            }
            pSOutputStream.print("] ");
            pSOutputStream.print("/C1 [");
            int n2 = 0;
            while (n2 < this.C1.length) {
                pSOutputStream.print("" + this.C1[n2]);
                if (n2 < this.C1.length - 1) {
                    pSOutputStream.print(" ");
                }
                ++n2;
            }
            pSOutputStream.print("] ");
            pSOutputStream.print("/N ");
            pSOutputStream.print("" + this.exponent);
        }
    }
}

