/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib.parser;

import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.parser.PDFArray;
import com.renderx.pdflib.parser.PDFDictionary;
import com.renderx.pdflib.parser.PDFElement;
import com.renderx.pdflib.parser.PDFInstance;
import com.renderx.pdflib.parser.PDFName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;

public class PDFStream
extends PDFDictionary {
    public long streamOffset = -1L;
    public long streamLength = -1L;
    PDFElement filters;
    byte[] array;
    public long stream_size;

    public PDFStream(PDFDictionary pDFDictionary) {
        this.dict = pDFDictionary.dict;
    }

    void write(PDFOutputStream pDFOutputStream, PDFInstance pDFInstance, int n) throws IOException {
        this.writeDict(pDFOutputStream, pDFInstance);
        pDFOutputStream.println("stream");
        pDFOutputStream.generateCurrentKey(n);
        long l = pDFOutputStream.size();
        pDFOutputStream.startCompressedStream();
        pDFOutputStream.print(this.array);
        pDFOutputStream.finishCompressedStream();
        this.stream_size = (long)pDFOutputStream.size() - l;
        pDFOutputStream.print("\nendstream");
    }

    String minFilter() throws IOException {
        if (this.filters == null) {
            return "";
        }
        if (this.filters instanceof PDFName) {
            String string = ((PDFName)this.filters).value;
            return this.uncompressTill(string);
        }
        if (this.filters instanceof PDFArray) {
            String string = "";
            int n = 0;
            while (n < ((PDFArray)this.filters).array.length()) {
                string = string + this.uncompressTill(((PDFName)((PDFArray)this.filters).array.get((int)n)).value);
                ++n;
            }
            return string;
        }
        throw new IOException("Broken filter for page");
    }

    String uncompressTill(String string) {
        if (string.equals("/FlateDecode")) {
            return "";
        }
        return string;
    }

    void decompress() throws IOException {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<decompress>");
        }
        if (this.filters == null) {
            if (PDFOutputStream.dump != null) {
                PDFOutputStream.dumpprintln("</decompress>");
            }
            return;
        }
        if (this.filters instanceof PDFName) {
            String string = ((PDFName)this.filters).value;
            this.decompress(string);
            if (PDFOutputStream.dump != null) {
                PDFOutputStream.dumpprintln("</decompress>");
            }
            return;
        }
        if (this.filters instanceof PDFArray) {
            String string = "";
            int n = 0;
            while (n < ((PDFArray)this.filters).array.length() && this.decompress(((PDFName)((PDFArray)this.filters).array.get((int)n)).value)) {
                ++n;
            }
            if (PDFOutputStream.dump != null) {
                PDFOutputStream.dumpprintln("</decompress>");
            }
        } else {
            throw new IOException("Broken filter for page");
        }
    }

    boolean decompress(String string) throws IOException {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<filter name=\"" + string + "\"/>");
        }
        if (string.equals("/FlateDecode")) {
            this.decompressFlate();
            return true;
        }
        if (string.equals("/ASCIIHEXDecode")) {
            this.decompressASCIIHEX();
            return true;
        }
        if (string.equals("/ASCII85Decode")) {
            this.decompressASCII85();
            return true;
        }
        if (string.equals("/RunLengthDecode")) {
            this.decompressRunLength();
            return true;
        }
        return string.equals("/LZWDecode");
    }

    void decompressFlate() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.array);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            while ((n = inflaterInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            Object var7_6 = null;
            this.array = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.array = byteArrayOutputStream.toByteArray();
            inflaterInputStream.close();
            byteArrayOutputStream.close();
            throw throwable;
        }
        inflaterInputStream.close();
        byteArrayOutputStream.close();
    }

    void decompressASCIIHEX() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = -1;
        int n2 = 0;
        while (n2 < this.array.length) {
            int n3 = this.hexval((char)this.array[n2]);
            if (n3 != -1) {
                if (n == -1) {
                    n = n3;
                } else {
                    byteArrayOutputStream.write((n << 4) + n3);
                    n = -1;
                }
            }
            ++n2;
        }
        this.array = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
    }

    private int hexval(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return c - 97 + 10;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return c - 65 + 10;
            }
        }
        return -1;
    }

    private int ascii85val(char c) {
        if (c < '!' || c > 'u') {
            return -1;
        }
        return c - 33;
    }

    void decompressASCII85() throws IOException {
        int n;
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        int[] nArray = new int[5];
        int n4 = 0;
        while (n4 < this.array.length) {
            if (this.array[n4] == 126) break;
            if (this.array[n4] == 122 && n3 == 0) {
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
            } else {
                int n5 = this.ascii85val((char)this.array[n4]);
                if (n5 != -1) {
                    nArray[n3] = n5;
                    if (++n3 == 5) {
                        n3 = 0;
                        n2 = 0;
                        n = 0;
                        while (n < 5) {
                            n2 = n2 * 85 + nArray[n];
                            ++n;
                        }
                        byteArrayOutputStream.write((byte)(n2 >> 24));
                        byteArrayOutputStream.write((byte)(n2 >> 16));
                        byteArrayOutputStream.write((byte)(n2 >> 8));
                        byteArrayOutputStream.write((byte)n2);
                    }
                }
            }
            ++n4;
        }
        if (n3 == 1) {
            throw new IOException("Illegal length in ASCII85Decode.");
        }
        n2 = n3;
        while (n2 < 5) {
            nArray[n2] = 84;
            ++n2;
        }
        n = 0;
        int n6 = 0;
        while (n6 < 5) {
            n = n * 85 + nArray[n6];
            ++n6;
        }
        if (n3 == 2) {
            byteArrayOutputStream.write((byte)(n >> 24));
        } else if (n3 == 3) {
            byteArrayOutputStream.write((byte)(n >> 24));
            byteArrayOutputStream.write((byte)(n >> 16));
        } else if (n3 == 4) {
            byteArrayOutputStream.write((byte)(n >> 24));
            byteArrayOutputStream.write((byte)(n >> 16));
            byteArrayOutputStream.write((byte)(n >> 8));
        }
        this.array = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
    }

    void decompressRunLength() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = -1;
        int n2 = 0;
        while (n2 < this.array.length) {
            if (n == -1) {
                int n3 = n = this.array[n2] < 0 ? 256 + this.array[n2] : this.array[n2];
                if (n == 128) {
                    break;
                }
            } else if (n > 128) {
                n = 257 - n;
                int n4 = 0;
                while (n4 <= n) {
                    byteArrayOutputStream.write(this.array[n2]);
                    ++n4;
                }
                n = -1;
            } else {
                byteArrayOutputStream.write(this.array[n2]);
                --n;
            }
            ++n2;
        }
        this.array = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length >= 2) {
            File file = new File(stringArray[0]);
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(new File(stringArray[1]));
            PDFStream pDFStream = new PDFStream(new PDFDictionary());
            pDFStream.array = new byte[(int)file.length()];
            fileInputStream.read(pDFStream.array);
            fileInputStream.close();
            if (stringArray.length == 2) {
                pDFStream.filters = new PDFName("/FlateDecode");
            } else {
                pDFStream.filters = new PDFArray();
                int n = 2;
                while (n < stringArray.length) {
                    ((PDFArray)pDFStream.filters).array.put(n - 2, new PDFName("/" + stringArray[n]));
                    ++n;
                }
            }
            pDFStream.decompress();
            fileOutputStream.write(pDFStream.array);
            fileOutputStream.close();
        } else {
            System.err.println("Usage: java com.renderx.pdflib.parser.PDFStream <'compressed stream' file> <'decompressed stream' file> (<filter1> (<filter2> (...)))");
        }
    }
}

