/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib.parser;

import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.parser.ParseUtils;
import com.renderx.pdflib.parser.Token;
import com.renderx.util.SeekableFileInputStream;
import com.renderx.util.SeekableInput;
import java.io.IOException;

public class Lexer {
    SeekableInput raf;
    char curchar;
    boolean needReadNext;

    Lexer(SeekableInput seekableInput) throws IOException {
        this.raf = seekableInput;
        this.needReadNext = true;
    }

    public void seek(long l) throws IOException {
        this.raf.seek(l);
    }

    Token nextToken() throws IOException {
        if (this.needReadNext) {
            this.read();
        }
        this.skipSpaces();
        while (this.curchar == '%') {
            this.skipComment();
            if (PDFOutputStream.dump == null) continue;
            PDFOutputStream.dumpprintln("<skipComment/>");
        }
        if (this.curchar == '/') {
            this.needReadNext = false;
            return this.readName();
        }
        if (this.curchar == '(') {
            this.needReadNext = true;
            return this.readString();
        }
        if (this.curchar == '[') {
            this.needReadNext = true;
            return new Token(6, null);
        }
        if (this.curchar == ']') {
            this.needReadNext = true;
            return new Token(7, null);
        }
        if (this.curchar == '>') {
            if (this.read() == '>') {
                this.needReadNext = true;
                return new Token(9, null);
            }
            throw new IOException("Broken pdf file. Dictionary is not closed.");
        }
        if (this.curchar == '<') {
            this.read();
            if (this.curchar == '<') {
                this.needReadNext = true;
                return new Token(8, null);
            }
            this.needReadNext = true;
            return this.readHEXString();
        }
        if (ParseUtils.isNumber(this.curchar)) {
            this.needReadNext = false;
            return this.readNumeric();
        }
        this.needReadNext = false;
        String string = this.readTillTerminal();
        if (string.equals("R")) {
            return new Token(5, null);
        }
        if (string.startsWith("stream")) {
            return new Token(12, null);
        }
        if (string.startsWith("startxref")) {
            return new Token(13, null);
        }
        if (string.startsWith("endobj")) {
            return new Token(11, null);
        }
        if (string.startsWith("true")) {
            return new Token(14, string);
        }
        if (string.startsWith("false")) {
            return new Token(14, string);
        }
        if (string.startsWith("null")) {
            return new Token(14, string);
        }
        if (string.startsWith("obj")) {
            return new Token(10, string);
        }
        throw new IOException("Broken pdf file. Wrong token '" + string + "'");
    }

    private Token readName() throws IOException {
        String string = "/";
        this.read();
        while (!ParseUtils.isSpace(this.curchar) && this.curchar != '/' && this.curchar != '[' && this.curchar != ']' && this.curchar != '(' && this.curchar != '<' && this.curchar != '>') {
            string = string + this.curchar;
            this.curchar = this.read();
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<readName value=\"" + string + "\"/>");
        }
        return new Token(1, string);
    }

    private String decodeString(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '\\') {
                stringBuffer.append(c);
            } else if (++n == string.length()) {
                stringBuffer.append(c);
            } else {
                c = string.charAt(n);
                switch (c) {
                    case 'n': {
                        stringBuffer.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuffer.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuffer.append('\t');
                        break;
                    }
                    case 'b': {
                        stringBuffer.append('\b');
                        break;
                    }
                    case 'f': {
                        stringBuffer.append('\f');
                        break;
                    }
                    case '(': 
                    case ')': 
                    case '\\': {
                        stringBuffer.append(c);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        int n2 = c - 48;
                        int n3 = 0;
                        while (n3 < 2 && n + 1 < string.length()) {
                            c = string.charAt(n + 1);
                            if (c < '0' || '7' < c) break;
                            n2 *= 8;
                            n2 += c - 48;
                            ++n3;
                            ++n;
                        }
                        stringBuffer.append((char)n2);
                        break;
                    }
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private Token readString() throws IOException {
        int n = 1;
        String string = "";
        this.read();
        int n2 = 122;
        if (this.curchar == '(') {
            ++n;
        }
        if (this.curchar == ')') {
            --n;
        }
        while (n > 0) {
            string = string + this.curchar;
            n2 = this.curchar == '\\' && n2 == 92 ? 122 : (int)this.curchar;
            this.read();
            if (this.curchar == '(' && n2 != 92) {
                ++n;
            }
            if (this.curchar != ')' || n2 == 92) continue;
            --n;
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<readString value=\"" + string + "\"/>");
        }
        return new Token(2, this.decodeString(string));
    }

    private int hexval(int n) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return n - 48;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return n - 97 + 10;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return n - 97 + 10;
            }
        }
        return -1;
    }

    public Token readHEXString() throws IOException {
        String string = "";
        while (this.curchar != '>') {
            if (!ParseUtils.isSpace(this.curchar)) {
                string = string + this.curchar;
            }
            this.read();
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<readHEXString value=\"" + string + "\"/>");
        }
        return new Token(3, string);
    }

    public void skipComment() throws IOException {
        this.read();
        while (this.curchar != '\n' && this.curchar != '\r') {
            this.read();
        }
        this.skipSpaces();
    }

    public void skipSpaces() throws IOException {
        if (ParseUtils.isSpace(this.curchar)) {
            while (ParseUtils.isSpace(this.read())) {
            }
        }
    }

    public void skipEndl() throws IOException {
        if (this.curchar == '\r') {
            this.read();
            if (this.curchar != '\n') {
                long l = this.raf.getFilePointer();
                this.raf.seek(l - 1L);
                this.curchar = (char)13;
            }
        }
    }

    public Token readNumeric() throws IOException {
        String string = "" + this.curchar;
        this.read();
        boolean bl = true;
        while (!ParseUtils.isTerminal(this.curchar)) {
            if (!ParseUtils.isDigit(this.curchar)) {
                bl = false;
            }
            string = string + this.curchar;
            this.read();
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<numeric value=\"" + string + "\"/>");
        }
        if (bl) {
            return new Token(4, string);
        }
        return new Token(14, string);
    }

    public String readTillTerminal() throws IOException {
        String string = "" + this.curchar;
        while (!ParseUtils.isTerminal(this.read())) {
            string = string + this.curchar;
        }
        this.skipEndl();
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<tillTerminal value=\"" + string + "\"/>");
        }
        return string;
    }

    char read() throws IOException {
        this.curchar = (char)this.raf.readUnsignedByte();
        return this.curchar;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static void main(String[] stringArray) throws Exception {
        Token token;
        block3: {
            Lexer lexer;
            block2: {
                lexer = new Lexer(new SeekableFileInputStream(stringArray[0]));
                if (!true) break block2;
                token = lexer.nextToken();
                if (token.type >= 11) break block3;
            }
            do {
                System.out.println(token);
                token = lexer.nextToken();
            } while (token.type < 11);
        }
        System.out.println(token);
    }
}

