/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.util.Hashtable;

abstract class Annot
extends PDFObject {
    static final short BORDER_SOLID = 0;
    static final short BORDER_DASHED = 1;
    static final short BORDER_BEVELED = 2;
    static final short BORDER_INSET = 3;
    static final short BORDER_UNDERLINED = 4;
    static final Hashtable border_styles = new Hashtable();
    static final short icon_file_graph = 0;
    static final short icon_file_paperclip = 1;
    static final short icon_file_pushpin = 2;
    static final short icon_file_tag = 3;
    static final short icon_text_comment = 4;
    static final short icon_text_insert = 5;
    static final short ICON_TEXT_NOTE = 6;
    static final short icon_text_paragraph = 7;
    static final short icon_text_newparagraph = 8;
    static final short icon_text_key = 9;
    static final short icon_text_help = 10;
    static final String[] icon_names;
    static final int flag_invisible = 1;
    static final int flag_hidden = 2;
    static final int flag_print = 4;
    static final int flag_nozoom = 8;
    static final int flag_norotate = 16;
    static final int flag_noview = 32;
    static final int flag_readonly = 64;
    static final int flag_locked = 128;
    static final int flag_togglenoview = 256;
    static final String[] border_style_names;
    int type;
    float[] rect = new float[4];
    int struct_parent;
    protected int annot_properties = 0;
    short border_style;
    float border_width;
    float border_red;
    float border_green;
    float border_blue;
    float border_dash1;
    float border_dash2;

    Annot(IndirectObject indirectObject, float f, float f2, float f3, float f4) {
        super(indirectObject);
        this.rect[0] = f;
        this.rect[1] = f2;
        this.rect[2] = f3;
        this.rect[3] = f4;
        this.struct_parent = -1;
    }

    abstract String getSubType();

    abstract void writeAnnotBody(PDFOutputStream var1);

    void writeStructParent(PDFOutputStream pDFOutputStream) {
        if (this.struct_parent != -1) {
            pDFOutputStream.println("/StructParent " + this.struct_parent);
        }
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.print("/Subtype/" + this.getSubType());
        this.write_border_style(pDFOutputStream);
        pDFOutputStream.print(" /Rect [" + PDFOutputStream.pdf_float(this.rect[0]) + " " + PDFOutputStream.pdf_float(this.rect[1]) + " " + PDFOutputStream.pdf_float(this.rect[2]) + " " + PDFOutputStream.pdf_float(this.rect[3]) + "]");
        if (this.annot_properties != 0) {
            pDFOutputStream.print(" /F " + this.annot_properties);
        }
        this.writeAnnotBody(pDFOutputStream);
        this.writeStructParent(pDFOutputStream);
    }

    void write_border_style(PDFOutputStream pDFOutputStream) {
        if (this.border_style == 0 && this.border_width == 1.0f && this.border_red == 0.0f && this.border_green == 0.0f && this.border_blue == 0.0f && this.border_dash1 == 3.0f && this.border_dash2 == 3.0f) {
            return;
        }
        if (!"Popup".equals(this.getSubType())) {
            pDFOutputStream.print("/Border[0 0 " + PDFOutputStream.pdf_float(this.border_width));
            if (this.border_width != 0.0f && this.border_style == 1) {
                pDFOutputStream.print("[" + PDFOutputStream.pdf_float(this.border_dash1));
                if (this.border_dash1 != this.border_dash2) {
                    pDFOutputStream.print(" " + PDFOutputStream.pdf_float(this.border_dash2));
                }
                pDFOutputStream.print("]");
            }
            pDFOutputStream.print("]");
        }
        if ("Link".equals(this.getSubType()) && this.border_width == 0.0f) {
            return;
        }
        if (!("Screen".equals(this.getSubType()) || "RichMedia".equals(this.getSubType()) || "Popup".equals(this.getSubType()))) {
            pDFOutputStream.print("/C [" + PDFOutputStream.pdf_float(this.border_red) + " " + PDFOutputStream.pdf_float(this.border_green) + " " + PDFOutputStream.pdf_float(this.border_blue) + "]");
        }
    }

    void setStructParent(int n) {
        this.struct_parent = n;
    }

    int getStructParent() {
        return this.struct_parent;
    }

    void setAnnotProperties(int n) {
        this.annot_properties |= n;
    }

    int getAnnotProperties() {
        return this.annot_properties;
    }

    void setColor(float[] fArray) {
        this.border_red = fArray[0];
        this.border_green = fArray[1];
        this.border_blue = fArray[2];
    }

    float[] getColor() {
        return new float[]{this.border_red, this.border_green, this.border_blue};
    }

    static {
        border_styles.put("SOLID", new Short(0));
        border_styles.put("DASHED", new Short(1));
        border_styles.put("OUTSET", new Short(2));
        border_styles.put("INSET", new Short(3));
        border_styles.put("UNDERLINED", new Short(4));
        icon_names = new String[]{"Graph", "Paperclip", "Pushpin", "Tag", "Comment", "Insert", "Note", "Paragraph", "NewParagraph", "Key", "Help"};
        border_style_names = new String[]{"S", "D", "B", "I", "U"};
    }
}

