/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.SpotColorFileFormatError;
import com.renderx.util.Hashtable;
import com.renderx.util.LineEnumerator;
import com.renderx.util.URLSpec;
import com.renderx.util.User;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;

public final class SpotColorList {
    public static final SpotColorList dflt = new SpotColorList();
    private final Hashtable exactName2CMYK = new Hashtable();
    private final Hashtable partialName2CMYK = new Hashtable();
    private static boolean initialized = false;

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        String string = null;
        try {
            string = User.getProperty("com.renderx.xep.SPOT_COLOR_TRANSLATION_TABLE");
            if (string != null) {
                dflt.readColorListNewFormat(new URLSpec(string).openStream());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("cannot parse " + string + ": " + exception.toString());
        }
        initialized = true;
    }

    public SpotColorList() {
    }

    public SpotColorList(InputStream inputStream) throws IOException, SpotColorFileFormatError {
        this();
        this.readColorList(inputStream);
    }

    public void readColorListNewFormat(InputStream inputStream) throws IOException, SpotColorFileFormatError {
        LineEnumerator lineEnumerator = new LineEnumerator(inputStream);
        int n = 0;
        while (lineEnumerator.hasMoreLines()) {
            String string = lineEnumerator.nextLine();
            ++n;
            int n2 = string.indexOf(" PC");
            if (n2 == -1) continue;
            String string2 = SpotColorList.normalizeColorName(string.substring(0, n2));
            String string3 = string.substring(n2 + 3);
            double[] dArray = new double[4];
            int n3 = 0;
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                while (stringTokenizer.hasMoreTokens() && n3 < dArray.length) {
                    int n4 = Integer.parseInt(stringTokenizer.nextToken().trim());
                    dArray[n3++] = (double)n4 / 100.0;
                }
            }
            catch (Exception exception) {
                throw new SpotColorFileFormatError("[Line " + n + "]: spot color '" + string2 + "' has an invalid CMYK equivalent");
            }
            this.partialName2CMYK.put(string2, dArray);
            if (!string2.startsWith("pantone ")) continue;
            this.partialName2CMYK.put(string2.substring(8), dArray);
        }
    }

    public void readColorList(InputStream inputStream) throws IOException, SpotColorFileFormatError {
        LineEnumerator lineEnumerator = new LineEnumerator(inputStream);
        int n = 0;
        while (lineEnumerator.hasMoreLines()) {
            StringTokenizer stringTokenizer;
            String string = lineEnumerator.nextLine();
            ++n;
            if (string.startsWith("#") || !(stringTokenizer = new StringTokenizer(string, ";")).hasMoreTokens()) continue;
            String string2 = SpotColorList.normalizeColorName(stringTokenizer.nextToken());
            double[] dArray = new double[4];
            int n2 = 0;
            try {
                while (stringTokenizer.hasMoreTokens() && n2 < dArray.length) {
                    int n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
                    dArray[n2++] = (double)n3 / 100.0;
                }
            }
            catch (Exception exception) {
                throw new SpotColorFileFormatError("[Line " + n + "]: spot color '" + string2 + "' has an invalid CMYK equivalent");
            }
            this.putColorName(string2, dArray, " *");
        }
    }

    public double[] getCMYK(String string) {
        double[] dArray = (double[])this.exactName2CMYK.get(string = SpotColorList.normalizeColorName(string));
        if (dArray != null) {
            return dArray;
        }
        int n = string.lastIndexOf(32);
        if (n == -1) {
            return null;
        }
        return (double[])this.partialName2CMYK.get(string.substring(0, n));
    }

    private static String normalizeColorName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken().toLowerCase());
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private void putColorName(String string, double[] dArray, String string2) {
        if (string.endsWith(string2)) {
            this.partialName2CMYK.put(string.substring(0, string.length() - string2.length()), dArray);
        } else {
            this.exactName2CMYK.put(string, dArray);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("Usage: com.renderx.graphics.SpotColorList list_file_name");
            System.exit(1);
        }
        SpotColorList.init();
        try {
            double[] dArray;
            String string;
            SpotColorList spotColorList = null;
            if (stringArray.length == 1) {
                spotColorList = new SpotColorList(new FileInputStream(stringArray[0]));
            }
            System.err.println();
            System.err.println("Instance SpotColor list:");
            System.err.println("--------------------");
            int n = 1;
            Enumeration enumeration = spotColorList.exactName2CMYK.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                dArray = spotColorList.getCMYK(string);
                System.err.println("[" + n + "] " + string + " = [" + dArray[0] + ", " + dArray[1] + ", " + dArray[2] + ", " + dArray[3] + "]");
                ++n;
            }
            enumeration = spotColorList.partialName2CMYK.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                dArray = spotColorList.getCMYK(string + " ABC");
                System.err.println("[" + n + "] " + string + " = [" + dArray[0] + ", " + dArray[1] + ", " + dArray[2] + ", " + dArray[3] + "]");
                ++n;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        System.exit(0);
    }
}

