/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.BitmapImage;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.ObjectRecordCoordinator;
import com.renderx.graphics.TIFFImage;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JPEGImage
extends BitmapImage {
    public JPEGImage() {
        this.mimetype = "image/jpeg";
    }

    /*
     * Unable to fully structure code
     */
    public void parse() throws IOException, ImageFormatException {
        this.compressionMethod = (short)3;
        this.bitsPerComponent = 8;
        this.usesBigEndian = false;
        this.canCopyData = true;
        this.canExpandData = false;
        var1_1 = this.openSeekableImageStream();
        try {
            try {
                var2_2 = false;
                var1_1.seek(2L);
                var3_4 = var1_1.readUnsignedByte();
                var4_5 = 0;
                ** GOTO lbl103
                {
                    var3_4 = var1_1.readUnsignedByte();
                    do {
                        if (var3_4 != 255) continue block16;
                        while (var3_4 == 255) {
                            var3_4 = var1_1.readUnsignedByte();
                        }
                        var5_6 = var1_1.readUnsignedShort() - 2;
                        if (var3_4 >= 192 && var3_4 <= 195) {
                            var1_1.skipBytes(1);
                            var6_7 = var1_1.readUnsignedShort();
                            var7_11 = var1_1.readUnsignedShort();
                            var8_12 = var1_1.readUnsignedByte();
                            if (this.pxWidth < var7_11) {
                                this.pxWidth = var7_11;
                            }
                            if (this.pxHeight < var6_7) {
                                this.pxHeight = var6_7;
                            }
                            if (var4_5 < var8_12) {
                                var4_5 = var8_12;
                            }
                            var1_1.skipBytes(var5_6 - 6);
                            continue;
                        }
                        if (var3_4 == 224) {
                            var6_8 = new byte[5];
                            var1_1.readFully(var6_8);
                            v0 = var7_11 = var6_8[0] != 74 || var6_8[1] != 70 || var6_8[2] != 73 || var6_8[3] != 70 || var6_8[4] != 0 ? 1 : 0;
                            if (var7_11 != 0) {
                                var1_1.skipBytes(var5_6 - 5);
                                continue;
                            }
                            var1_1.skipBytes(2);
                            var8_12 = var1_1.readUnsignedByte();
                            var9_14 = var1_1.readUnsignedShort();
                            var11_17 = var1_1.readUnsignedShort();
                            if (this.noResolution) {
                                switch (var8_12) {
                                    case 1: {
                                        this.horzResolution = var9_14;
                                        this.vertResolution = var11_17;
                                        this.noResolution = false;
                                        break;
                                    }
                                    case 2: {
                                        this.horzResolution = 2.54 * var9_14;
                                        this.vertResolution = 2.54 * var11_17;
                                        this.noResolution = false;
                                        break;
                                    }
                                    case 0: {
                                        var13_19 = Math.sqrt(var11_17 / var9_14);
                                        this.horzResolution /= var13_19;
                                        this.vertResolution *= var13_19;
                                        this.noResolution = false;
                                        break;
                                    }
                                    default: {
                                        throw new ImageFormatException("Invalid unit type (" + var8_12 + ") in JPEG image: " + this.toDisplayString(), this.mimetype);
                                    }
                                }
                            }
                            var1_1.skipBytes(var5_6 - 12);
                            continue;
                        }
                        if (var3_4 == 225) {
                            var6_9 = new byte[6];
                            var1_1.readFully(var6_9);
                            v1 = var7_11 = var6_9[0] == 69 && var6_9[1] == 120 && var6_9[2] == 105 && var6_9[3] == 102 && var6_9[4] == 0 && var6_9[5] == 0 ? 1 : 0;
                            if (var7_11 != 0 && this.noResolution) {
                                var8_13 = var1_1.getFilePointer();
                                try {
                                    var10_15 = new TIFFImage(var8_13, true);
                                    var11_18 = this.openSeekableImageStream();
                                    var10_15.parse(var11_18);
                                    this.horzResolution = var10_15.horzResolution;
                                    this.vertResolution = var10_15.vertResolution;
                                    this.noResolution = false;
                                }
                                catch (Exception var10_16) {
                                    throw new ImageFormatException("Error parsing EXIF data in JPEG image '" + this.toDisplayString() + "': " + var10_16.getMessage(), this.mimetype);
                                }
                            }
                            var1_1.skipBytes(var5_6 - 6);
                            continue;
                        }
                        if (var3_4 == 238) {
                            if (var5_6 >= 5) {
                                var5_6 -= 5;
                                var6_10 = new byte[5];
                                var1_1.readFully(var6_10);
                                v2 = var2_2 = var6_10[0] == 65 && var6_10[1] == 100 && var6_10[2] == 111 && var6_10[3] == 98 && var6_10[4] == 101;
                            }
                            if (var5_6 <= 0) continue;
                            var1_1.skipBytes(var5_6);
                            continue;
                        }
                        var1_1.skipBytes(var5_6);
lbl103:
                        // 8 sources

                    } while (var3_4 != 218);
                }
                switch (var4_5) {
                    case 1: {
                        this.colorSpace = (short)4;
                        ** break;
                    }
                    case 3: {
                        this.colorSpace = 1;
                        ** break;
                    }
                    case 4: {
                        this.colorSpace = (short)(var2_2 != false ? 3 : 2);
                        ** break;
                    }
                    default: {
                        throw new ImageFormatException("Invalid number of color components (" + var4_5 + ") in JPEG image " + this.toDisplayString(), this.mimetype);
                    }
                }
            }
            catch (EOFException var2_3) {
                throw new ImageFormatException("Premature end of file or corrupt data in JPEG image " + this.toDisplayString(), this.mimetype);
            }
lbl118:
            // 3 sources

            var16_20 = null;
        }
        catch (Throwable var15_22) {
            var16_21 = null;
            var1_1.close();
            throw var15_22;
        }
        var1_1.close();
        this.setDimensions();
    }

    public void copyData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        InputStream inputStream = this.openImageStream();
        try {
            int n;
            byte[] byArray = new byte[objectRecordCoordinator != null ? objectRecordCoordinator.getRecordLength() : 8192];
            while ((n = inputStream.read(byArray)) != -1) {
                if (objectRecordCoordinator != null) {
                    objectRecordCoordinator.beginRecord(outputStream, n);
                }
                outputStream.write(byArray, 0, n);
                if (objectRecordCoordinator == null) continue;
                objectRecordCoordinator.endRecord(outputStream, n);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public void expandData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws ImageFormatException {
        throw new ImageFormatException("JPEG image '" + this.toDisplayString() + "' cannot be expanded: not yet implemented");
    }
}

