/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts;

import com.renderx.fonts.FontFileFormatError;
import com.renderx.fonts.Metric;
import com.renderx.fonts.StandardAdobeEncoding;
import com.renderx.fonts.TTMetric;
import com.renderx.util.Array;
import com.renderx.util.SeekableFileInputStream;
import com.renderx.util.SeekableInput;
import com.renderx.util.SeekableInputOffsetFilter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;

public class CFFMetric
extends Metric {
    public String registry = "";
    public String ordering = "";
    public int supplement = 0;
    public int CIDCount = 8720;
    public int CIDFontType = 0;
    public String fdFontName = "";
    public int paintType = 0;
    public long charstringsOffset = 0L;
    public int charstringType = 2;
    public long charstringsLength = 0L;
    public boolean isPredefinedEncoding = true;
    public long encodingOffset = 0L;
    public boolean isPredefinedCharset = true;
    public long charsetOffset = 0L;
    public final int charsetFormat;
    public long charsetLength = 0L;
    public int fontNumber = 0;
    public long privateDictOffset = 0L;
    public long privateDictLength = 0L;
    public long fdArrayOffset = 0L;
    public long fdSelectOffset = 0L;
    public long localSubrsOffset = -1L;
    public final Array globalSubrs;
    private Array glyphNames;
    private Array glyphCIDs;
    private final Array names;
    private final Array topDicts;
    private final Array strings;
    private final boolean nameExists;
    static final int MAX_OPERANDS = 100;
    public static String[] DEFAULT_STRINGS = new String[]{".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "endash", "dagger", "daggerdbl", "periodcentered", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "questiondown", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "emdash", "AE", "ordfeminine", "Lslash", "Oslash", "OE", "ordmasculine", "ae", "dotlessi", "lslash", "oslash", "oe", "germandbls", "onesuperior", "logicalnot", "mu", "trademark", "Eth", "onehalf", "plusminus", "Thorn", "onequarter", "divide", "brokenbar", "degree", "thorn", "threequarters", "twosuperior", "registered", "minus", "eth", "multiply", "threesuperior", "copyright", "Aacute", "Acircumflex", "Adieresis", "Agrave", "Aring", "Atilde", "Ccedilla", "Eacute", "Ecircumflex", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Ntilde", "Oacute", "Ocircumflex", "Odieresis", "Ograve", "Otilde", "Scaron", "Uacute", "Ucircumflex", "Udieresis", "Ugrave", "Yacute", "Ydieresis", "Zcaron", "aacute", "acircumflex", "adieresis", "agrave", "aring", "atilde", "ccedilla", "eacute", "ecircumflex", "edieresis", "egrave", "iacute", "icircumflex", "idieresis", "igrave", "ntilde", "oacute", "ocircumflex", "odieresis", "ograve", "otilde", "scaron", "uacute", "ucircumflex", "udieresis", "ugrave", "yacute", "ydieresis", "zcaron", "exclamsmall", "Hungarumlautsmall", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "isuperior", "lsuperior", "msuperior", "nsuperior", "osuperior", "rsuperior", "ssuperior", "tsuperior", "ff", "ffi", "ffl", "parenleftinferior", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "exclamdownsmall", "centoldstyle", "Lslashsmall", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "Dotaccentsmall", "Macronsmall", "figuredash", "hypheninferior", "Ogoneksmall", "Ringsmall", "Cedillasmall", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "zerosuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Roman", "Semibold"};
    static final short hVersion = 0;
    static final short hNotice = 1;
    static final short hFullName = 2;
    static final short hFamilyName = 3;
    static final short hWeight = 4;
    static final short hFontBBox = 5;
    static final short pStdHW = 10;
    static final short pStdVW = 11;
    static final short hCharset = 15;
    static final short hEncoding = 16;
    static final short hCharStrings = 17;
    static final short hPrivate = 18;
    static final short hSubrs = 19;
    static final short hIsFixedPitch = -1;
    static final short hItalicAngle = -2;
    static final short hUnderlinePosition = -3;
    static final short hUnderlineThickness = -4;
    static final short hPaintType = -5;
    static final short hCharstringType = -6;
    static final short hROS = -30;
    static final short hCIDFontVersion = -31;
    static final short hCIDFontRevision = -32;
    static final short hCIDFontType = -33;
    static final short hCIDCount = -34;
    static final short hFDArray = -36;
    static final short hFDSelect = -37;
    static final short hFontName = -38;
    private static int MAX_COMPOSE_GLYPHS_LENGTH = 12;

    public void dump(PrintStream printStream) {
        super.dump(printStream);
        printStream.println("\nCFF-specific font data:");
    }

    public CFFMetric(SeekableInput seekableInput, String string) throws IOException, FontFileFormatError {
        int n;
        int n2;
        float[] fArray;
        int n3;
        this.isCFF = true;
        boolean bl = this.nameExists = string != null;
        if (this.nameExists) {
            this.fontName = string;
        }
        seekableInput.skipBytes(2);
        int n4 = seekableInput.readUnsignedByte();
        seekableInput.seek(n4);
        this.names = this.readINDEXData(seekableInput);
        this.topDicts = this.readINDEXData(seekableInput);
        this.strings = this.readINDEXData(seekableInput);
        this.globalSubrs = this.readINDEXData(seekableInput);
        if (this.names.length() == 0) {
            throw new FontFileFormatError("Invalid CFF font data: font name table is empty");
        }
        if (this.names.length() > 1) {
            throw new FontFileFormatError("Unsupported CFF font: the font contains more than one subfont");
        }
        if (this.nameExists) {
            boolean bl2 = false;
            this.fontNumber = 0;
            while (this.fontNumber < this.names.length()) {
                if (string.equals(new String((byte[])this.names.get(this.fontNumber)))) {
                    bl2 = true;
                    break;
                }
                ++this.fontNumber;
            }
            if (!bl2) {
                throw new FontFileFormatError("CFF font data doesn't contain supplied font name");
            }
        } else {
            this.fontNumber = 0;
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])this.topDicts.get(this.fontNumber)));
        this.isCIDFont = false;
        this.isFixedPitch = false;
        this.italicAngle = 0.0f;
        this.underlinePosition = -100.0f;
        this.underlineThickness = 50.0f;
        this.fontBBox = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        block32: while (dataInputStream.available() > 0) {
            float[] fArray2 = new float[100];
            n3 = 0;
            while (n3 < fArray2.length) {
                fArray2[n3] = -1.0f;
                ++n3;
            }
            fArray = new float[2];
            n2 = 0;
            while (this.readOperand(dataInputStream, fArray) > 0 && fArray[1] == 0.0f) {
                fArray2[n2] = fArray[0];
                ++n2;
            }
            if (fArray[1] == -1.0f) continue;
            n = (int)fArray[0];
            switch (n) {
                case 2: {
                    this.fullName = this.getString(fArray2[0], this.strings);
                    break;
                }
                case 3: {
                    this.family = this.getString(fArray2[0], this.strings);
                    break;
                }
                case 0: {
                    this.version = this.getString(fArray2[0], this.strings);
                    break;
                }
                case 1: {
                    this.notice = this.getString(fArray2[0], this.strings);
                    break;
                }
                case 4: {
                    this.weight = this.getString(fArray2[0], this.strings);
                    break;
                }
                case 5: {
                    this.fontBBox[0] = fArray2[0];
                    this.fontBBox[1] = fArray2[1];
                    this.fontBBox[2] = fArray2[2];
                    this.fontBBox[3] = fArray2[3];
                    break;
                }
                case -30: {
                    this.registry = this.getString(fArray2[0], this.strings);
                    this.ordering = this.getString(fArray2[1], this.strings);
                    this.supplement = (int)fArray2[2];
                    this.isCIDFont = true;
                    this.isPredefinedEncoding = false;
                    this.isPredefinedCharset = false;
                    break;
                }
                case -33: {
                    this.CIDFontType = (int)fArray2[0];
                    if (this.CIDFontType != 0) {
                        throw new FontFileFormatError("Unsupported CFF CID font type: " + this.CIDFontType);
                    }
                }
                case 16: {
                    this.encodingOffset = (int)fArray2[0];
                    if (this.encodingOffset <= 1L) break;
                    this.isPredefinedEncoding = false;
                    break;
                }
                case -6: {
                    this.charstringType = (int)fArray2[0];
                    if (this.charstringType >= 1 || this.charstringType <= 2) continue block32;
                    throw new FontFileFormatError("Unsupported type of CFF Charstring encoding: " + this.charstringType);
                }
                case 15: {
                    this.charsetOffset = (int)fArray2[0];
                    if (this.charsetOffset <= 2L) break;
                    this.isPredefinedCharset = false;
                    break;
                }
                case 18: {
                    this.privateDictLength = (int)fArray2[0];
                    this.privateDictOffset = (int)fArray2[1];
                    break;
                }
                case 17: {
                    this.charstringsOffset = (int)fArray2[0];
                    break;
                }
                case -2: {
                    this.italicAngle = fArray2[0];
                    break;
                }
                case -3: {
                    this.underlinePosition = fArray2[0];
                    break;
                }
                case -4: {
                    this.underlineThickness = fArray2[0];
                    break;
                }
                case -1: {
                    this.isFixedPitch = fArray2[0] != 0.0f;
                    break;
                }
                case -5: {
                    this.paintType = (int)fArray2[0];
                    break;
                }
                case -34: {
                    this.CIDCount = (int)fArray2[0];
                    break;
                }
                case -38: {
                    this.fdFontName = this.getString(fArray2[0], this.strings);
                    break;
                }
                case -36: {
                    this.fdArrayOffset = (int)fArray2[0];
                    break;
                }
                case -37: {
                    this.fdSelectOffset = (int)fArray2[0];
                }
            }
        }
        seekableInput.seek(this.charstringsOffset);
        this.charstringsLength = this.getINDEXLength(seekableInput);
        this.glyphNames = new Array();
        this.glyphCIDs = new Array();
        seekableInput.seek(this.charstringsOffset);
        this.numGlyphs = this.readINDEXElementsCount(seekableInput);
        if (this.isPredefinedCharset) {
            this.charsetFormat = 0;
            throw new FontFileFormatError("Support for OpenType/CFF fonts with predefined charset not implemented yet");
        }
        seekableInput.seek(this.charsetOffset);
        this.charsetFormat = seekableInput.readUnsignedByte();
        ++this.charsetLength;
        this.glyphNames.put(0, ".notdef");
        this.glyphCIDs.put(0, new Integer(0));
        int n5 = 1;
        switch (this.charsetFormat) {
            case 0: {
                n3 = 0;
                while (n3 < this.numGlyphs - 1) {
                    int n6 = seekableInput.readUnsignedShort();
                    this.addGlyphSelector(n5 + n3, n6);
                    ++n3;
                }
                n5 += this.numGlyphs - 1;
                this.charsetLength += (long)((this.numGlyphs - 1) * 2);
                break;
            }
            case 1: 
            case 2: {
                while (n5 < this.numGlyphs) {
                    int n7 = seekableInput.readUnsignedShort();
                    this.charsetLength += 2L;
                    n2 = this.charsetFormat == 1 ? seekableInput.readUnsignedByte() : seekableInput.readUnsignedShort();
                    this.charsetLength += this.charsetFormat == 1 ? 1L : 2L;
                    n = 0;
                    while (n <= n2) {
                        this.addGlyphSelector(n5 + n, n7 + n);
                        ++n;
                    }
                    n5 += n2 + 1;
                }
                break;
            }
            default: {
                throw new FontFileFormatError("Invalid CFF font data: Charset encoding type is incorrect");
            }
        }
        seekableInput.seek(this.privateDictOffset);
        if (!this.isCIDFont) {
            byte[] byArray = new byte[(int)this.privateDictLength];
            seekableInput.readFully(byArray);
            DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray));
            while (dataInputStream2.available() > 0) {
                fArray = new float[100];
                n2 = 0;
                while (n2 < fArray.length) {
                    fArray[n2] = -1.0f;
                    ++n2;
                }
                float[] fArray3 = new float[2];
                int n8 = 0;
                while (this.readOperand(dataInputStream2, fArray3) > 0 && fArray3[1] == 0.0f) {
                    fArray[n8] = fArray3[0];
                    ++n8;
                }
                if (fArray3[1] == -1.0f) continue;
                int n9 = (int)fArray3[0];
                switch (n9) {
                    case 19: {
                        this.localSubrsOffset = (int)fArray[0];
                    }
                }
            }
        }
        if (this.isCIDFont) {
            if (this.charsetOffset == 0L) {
                throw new FontFileFormatError("Invalid CFF font data: Charsets data are missing");
            }
            if (this.fdArrayOffset == 0L) {
                throw new FontFileFormatError("Invalid CFF font data: FD Array operator is missing");
            }
        }
    }

    long readBytes(SeekableInput seekableInput, int n) throws IOException {
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            l = 256L * l;
            l += (long)seekableInput.readUnsignedByte();
            ++n2;
        }
        return l;
    }

    int readOperand(DataInputStream dataInputStream, float[] fArray) throws IOException {
        int n = 0;
        int n2 = dataInputStream.readUnsignedByte();
        ++n;
        if (n2 >= 32 && n2 <= 246) {
            fArray[0] = n2 - 139;
            fArray[1] = 0.0f;
        } else if (n2 >= 247 && n2 <= 250) {
            fArray[0] = (n2 - 247) * 256 + dataInputStream.readUnsignedByte() + 108;
            fArray[1] = 0.0f;
            ++n;
        } else if (n2 >= 251 && n2 <= 254) {
            fArray[0] = -(n2 - 251) * 256 - dataInputStream.readUnsignedByte() - 108;
            fArray[1] = 0.0f;
            ++n;
        } else if (n2 == 28) {
            fArray[0] = dataInputStream.readUnsignedByte() * 256 + dataInputStream.readUnsignedByte();
            fArray[1] = 0.0f;
            n += 2;
        } else if (n2 == 29) {
            fArray[0] = dataInputStream.readUnsignedByte() * 256 * 256 * 256 + dataInputStream.readUnsignedByte() * 256 * 256 + dataInputStream.readUnsignedByte() * 256 + dataInputStream.readUnsignedByte();
            fArray[1] = 0.0f;
            n += 4;
        } else if (n2 == 30) {
            String string = "";
            while (true) {
                int n3 = dataInputStream.readUnsignedByte();
                byte by = (byte)(n3 >> 4);
                byte by2 = (byte)(n3 & 0xF);
                ++n;
                if (by == 15) break;
                string = string + this.parseRealValue(by);
                if (by2 == 15) break;
                string = string + this.parseRealValue(by2);
            }
            fArray[0] = new Float(string).floatValue();
            fArray[1] = 0.0f;
        } else if (n2 >= 0 && n2 <= 21) {
            if (n2 == 12) {
                fArray[0] = -dataInputStream.readUnsignedByte();
                fArray[1] = 1.0f;
                ++n;
            } else {
                fArray[0] = n2;
                fArray[1] = 1.0f;
            }
        } else {
            fArray[0] = 0.0f;
            fArray[1] = -1.0f;
        }
        return n;
    }

    String parseRealValue(byte by) throws IOException {
        if (by < 10) {
            return "" + by;
        }
        switch (by) {
            case 10: {
                return ".";
            }
            case 11: {
                return "E";
            }
            case 12: {
                return "E-";
            }
            case 14: {
                return "-";
            }
        }
        throw new IOException("Invalid CFF font data");
    }

    int calculateBiasNumber(int n) {
        if (this.charstringType == 1) {
            return 0;
        }
        if (n < 1240) {
            return 107;
        }
        if (n < 33900) {
            return 1131;
        }
        return 32768;
    }

    public int readINDEXElementsCount(SeekableInput seekableInput) throws IOException, FontFileFormatError {
        return seekableInput.readUnsignedShort();
    }

    public int readINDEXOffsetElementSize(SeekableInput seekableInput) throws IOException, FontFileFormatError {
        int n = seekableInput.readUnsignedByte();
        if (n < 1 && n > 4) {
            throw new FontFileFormatError("Invalid CFF font data: offset element size is " + n + "; it is out of range 1-4");
        }
        return n;
    }

    public long readINDEXOffset(SeekableInput seekableInput, int n) throws IOException, FontFileFormatError {
        return this.readBytes(seekableInput, n);
    }

    public Array readINDEXData(SeekableInput seekableInput) throws IOException, FontFileFormatError {
        Array array = new Array();
        int n = this.readINDEXElementsCount(seekableInput);
        if (n == 0) {
            return array;
        }
        int n2 = this.readINDEXOffsetElementSize(seekableInput);
        long[] lArray = new long[n + 1];
        long[] lArray2 = new long[n];
        lArray[0] = this.readINDEXOffset(seekableInput, n2);
        int n3 = 0;
        while (n3 < n) {
            lArray[n3 + 1] = this.readINDEXOffset(seekableInput, n2);
            lArray2[n3] = lArray[n3 + 1] - lArray[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            byte[] byArray = new byte[(int)lArray2[n4]];
            seekableInput.readFully(byArray);
            array.put(n4, byArray);
            ++n4;
        }
        return array;
    }

    public long getINDEXLength(SeekableInput seekableInput) throws IOException, FontFileFormatError {
        int n = this.readINDEXElementsCount(seekableInput);
        if (n == 0) {
            return 2L;
        }
        int n2 = this.readINDEXOffsetElementSize(seekableInput);
        seekableInput.skipBytes(n * n2);
        long l = this.readINDEXOffset(seekableInput, n2);
        return (long)(3 + (n + 1) * n2) + (l - 1L);
    }

    String getString(float f, Array array) throws FontFileFormatError {
        if (f < (float)DEFAULT_STRINGS.length) {
            return DEFAULT_STRINGS[(int)f];
        }
        int n = (int)f - DEFAULT_STRINGS.length;
        if (n >= array.length()) {
            throw new FontFileFormatError("Error while parsing CFF metric: STRING INDEX out of boundary");
        }
        return new String((byte[])array.get(n));
    }

    private void addGlyphSelector(int n, int n2) throws FontFileFormatError {
        this.glyphCIDs.put(n, new Integer(n2));
        if (!this.isCIDFont) {
            this.glyphNames.put(n, this.getString(n2, this.strings));
        }
    }

    public int getGlyphCID(int n) throws FontFileFormatError {
        if (n >= this.numGlyphs) {
            throw new FontFileFormatError("Error in OpenType/CFF font: Glyph ID " + n + "exceeds max number of glyphs (" + this.numGlyphs + ")");
        }
        return (Integer)this.glyphCIDs.get(n);
    }

    public String getGlyphName(int n) throws FontFileFormatError {
        if (!this.isCIDFont) {
            return (String)this.glyphNames.get(n);
        }
        throw new FontFileFormatError("OpenType/CFF (CID) font has no glyph names");
    }

    public byte[] int2short(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public int[] composeGlyphs(byte[] byArray, Array array, Array array2) {
        if (!this.isCIDFont && byArray.length < MAX_COMPOSE_GLYPHS_LENGTH) {
            int[] nArray = new int[byArray.length];
            int n = 0;
            while (n < byArray.length) {
                nArray[n] = byArray[n] & 0xFF;
                ++n;
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int[] nArray2 = new int[2];
            boolean bl = false;
            while (n2 < nArray.length) {
                if (nArray[n2] >= 32 && nArray[n2] <= 246) {
                    bl = false;
                    ++n4;
                    nArray2[n3++] = nArray[n2++] - 139;
                } else if (nArray[n2] >= 247 && nArray[n2] <= 250) {
                    bl = false;
                    ++n4;
                    nArray2[n3++] = (nArray[n2++] - 247 << 8) + nArray[n2++] + 108;
                } else if (nArray[n2] >= 251 && nArray[n2] <= 254) {
                    bl = false;
                    ++n4;
                    nArray2[n3++] = (-(nArray[n2++] - 251) << 8) - nArray[n2++] - 108;
                } else if (nArray[n2] == 28) {
                    bl = false;
                    ++n4;
                    int n5 = n3++;
                    int n6 = ++n2;
                    int n7 = ++n2;
                    ++n2;
                    nArray2[n5] = (nArray[n6] << 8) + nArray[n7];
                } else if (nArray[n2] == 255) {
                    bl = false;
                    ++n4;
                    int n8 = n3++;
                    int n9 = ++n2;
                    int n10 = ++n2;
                    int n11 = ++n2;
                    int n12 = ++n2;
                    ++n2;
                    nArray2[n8] = (nArray[n9] << 24) + (nArray[n10] << 16) + (nArray[n11] << 8) + nArray[n12];
                } else if (nArray[n2] < 32) {
                    if (nArray[n2] == 12) {
                        bl = true;
                        n2 += 2;
                    } else {
                        switch (nArray[n2]) {
                            case 14: {
                                if (bl) {
                                    return null;
                                }
                                if (n4 <= 1) break;
                                String string = StandardAdobeEncoding.getGlyphName(nArray2[0]);
                                String string2 = StandardAdobeEncoding.getGlyphName(nArray2[1]);
                                return new int[]{this.glyphNames.indexOf(string), this.glyphNames.indexOf(string2)};
                            }
                            case 10: {
                                int n13 = this.calculateBiasNumber(array.length());
                                int n14 = nArray2[(n3 + 1) % 2];
                                byte[] byArray2 = (byte[])array.get(n14 + n13);
                                int n15 = 1;
                                n15 = n14 >= -107 && n14 <= 107 ? 1 : (n14 >= -1131 && n14 <= 1131 ? 2 : (n14 >= Short.MIN_VALUE && n14 >= Short.MAX_VALUE ? 3 : 5));
                                byte[] byArray3 = new byte[byArray.length - (n15 + 1) + byArray2.length];
                                System.arraycopy(byArray, 0, byArray3, 0, n2 - n15);
                                System.arraycopy(byArray2, 0, byArray3, n2 - n15, byArray2.length);
                                System.arraycopy(byArray, n2 + 1, byArray3, n2 - n15 + byArray2.length, byArray.length - (n2 + 1));
                                return this.composeGlyphs(byArray3, array, array2);
                            }
                            case 29: {
                                int n16 = this.calculateBiasNumber(array2.length());
                                int n17 = nArray2[(n3 + 1) % 2];
                                byte[] byArray4 = (byte[])array2.get(n17 + n16);
                                int n18 = 1;
                                n18 = n17 >= -107 && n17 <= 107 ? 1 : (n17 >= -1131 && n17 <= 1131 ? 2 : (n17 >= Short.MIN_VALUE && n17 >= Short.MAX_VALUE ? 3 : 5));
                                byte[] byArray5 = new byte[byArray.length - (n18 + 1) + byArray4.length];
                                System.arraycopy(byArray, 0, byArray5, 0, n2 - n18);
                                System.arraycopy(byArray4, 0, byArray5, n2 - n18, byArray4.length);
                                System.arraycopy(byArray, n2 + 1, byArray5, n2 - n18 + byArray4.length, byArray.length - (n2 + 1));
                                return this.composeGlyphs(byArray5, array, array2);
                            }
                            default: {
                                bl = true;
                            }
                        }
                        ++n2;
                    }
                }
                n3 %= 2;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws Exception {
        int n;
        TTMetric tTMetric;
        RandomAccessFile randomAccessFile;
        FileOutputStream fileOutputStream;
        block16: {
            if (stringArray.length == 1) {
                new CFFMetric(new SeekableFileInputStream(stringArray[0]), null).dump(System.out);
                return;
            }
            if (stringArray.length != 2) {
                System.err.println("Usage: java com.renderx.fonts.CFFMetric <(embed | subset)?> <OpenType/CFF font filename>");
                return;
            }
            if ("dump".equals(stringArray[0])) {
                fileOutputStream = null;
                randomAccessFile = null;
                try {
                    Object var9_12;
                    try {
                        fileOutputStream = new FileOutputStream(new File(stringArray[1] + ".dump"));
                        tTMetric = new TTMetric(new SeekableFileInputStream(stringArray[1]), 1);
                        randomAccessFile = new SeekableFileInputStream(stringArray[1]);
                        randomAccessFile.seek(tTMetric.cff_offset);
                        long l = tTMetric.cff_length;
                        byte[] byArray = new byte[16384];
                        while (l > 0L) {
                            n = l < (long)byArray.length ? (int)l : byArray.length;
                            l -= (long)n;
                            randomAccessFile.read(byArray, 0, n);
                            fileOutputStream.write(byArray, 0, n);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        var9_12 = null;
                        randomAccessFile.close();
                        fileOutputStream.close();
                        break block16;
                    }
                    var9_12 = null;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    randomAccessFile.close();
                    fileOutputStream.close();
                    throw throwable;
                }
                randomAccessFile.close();
                fileOutputStream.close();
            }
        }
        if (!"subset".equals(stringArray[0])) return;
        fileOutputStream = null;
        randomAccessFile = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(new File(stringArray[1] + ".subset"));
                tTMetric = new TTMetric(new SeekableFileInputStream(stringArray[1]), 1);
                CFFMetric cFFMetric = new CFFMetric(new SeekableInputOffsetFilter(new SeekableFileInputStream(stringArray[1]), tTMetric.cff_offset), null);
                randomAccessFile = new SeekableFileInputStream(stringArray[1]);
                randomAccessFile.seek(tTMetric.cff_offset);
                byte[] byArray = new byte[(int)cFFMetric.charstringsOffset];
                randomAccessFile.readFully(byArray);
                fileOutputStream.write(byArray);
                int n2 = cFFMetric.readINDEXElementsCount((SeekableInput)((Object)randomAccessFile));
                n = cFFMetric.readINDEXOffsetElementSize((SeekableInput)((Object)randomAccessFile));
                fileOutputStream.write(cFFMetric.int2short(n2));
                fileOutputStream.write(n);
                byArray = new byte[(n2 + 1) * n];
                randomAccessFile.readFully(byArray);
                fileOutputStream.write(byArray);
                byArray = new byte[(int)(cFFMetric.charstringsLength - (long)((n2 + 1) * n) - 1L - 2L)];
                randomAccessFile.readFully(byArray);
                int n3 = 0;
                while (true) {
                    if (n3 >= byArray.length) {
                        fileOutputStream.write(byArray);
                        byArray = new byte[(int)(tTMetric.cff_length - (cFFMetric.charstringsOffset + cFFMetric.charstringsLength))];
                        randomAccessFile.readFully(byArray);
                        fileOutputStream.write(byArray);
                        break;
                    }
                    byArray[n3] = 0;
                    ++n3;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Object var11_18 = null;
                randomAccessFile.close();
                fileOutputStream.close();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var11_19 = null;
                randomAccessFile.close();
                fileOutputStream.close();
                return;
            }
            Object var11_17 = null;
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            randomAccessFile.close();
            fileOutputStream.close();
            throw throwable;
        }
        randomAccessFile.close();
        fileOutputStream.close();
    }
}

