/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.AFP;

public class Point2D
implements Cloneable {
    public int x;
    public int y;

    public Point2D() {
    }

    public Point2D(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Point2D(double d, double d2) {
        this();
        this.setLocation(d, d2);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setLocation(double d, double d2) {
        this.x = (int)d;
        this.y = (int)d2;
    }

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public String toString() {
        return "Point2D.Float[" + this.x + ", " + this.y + "]";
    }

    public Point2D toAFPCoordinates() {
        return new Point2D(AFP.toAFPCoordinates(this.x), AFP.toAFPCoordinates(this.y));
    }

    public Point2D toAfpDimensions() {
        return new Point2D(AFP.toAfpDimensions(this.x), AFP.toAfpDimensions(this.y));
    }

    public void setLocation(Point2D point2D) {
        this.setLocation(point2D.getX(), point2D.getY());
    }

    public static int distanceSq(int n, int n2, int n3, int n4) {
        return (n -= n3) * n + (n2 -= n4) * n2;
    }

    public static int distance(int n, int n2, int n3, int n4) {
        return (int)Math.sqrt((n -= n3) * n + (n2 -= n4) * n2);
    }

    public int distanceSq(int n, int n2) {
        return (n -= this.getX()) * n + (n2 -= this.getY()) * n2;
    }

    public int distanceSq(Point2D point2D) {
        int n = point2D.getX() - this.getX();
        int n2 = point2D.getY() - this.getY();
        return n * n + n2 * n2;
    }

    public int distance(int n, int n2) {
        return (int)Math.sqrt((n -= this.getX()) * n + (n2 -= this.getY()) * n2);
    }

    public int distance(Point2D point2D) {
        int n = point2D.getX() - this.getX();
        int n2 = point2D.getY() - this.getY();
        return (int)Math.sqrt(n * n + n2 * n2);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Point2D) {
            Point2D point2D = (Point2D)object;
            return this.getX() == point2D.getX() && this.getY() == point2D.getY();
        }
        return super.equals(object);
    }

    public void swapXYMe() {
        int n = this.x;
        this.x = this.y;
        this.y = n;
    }

    public Point2D swapXY() {
        return new Point2D(this.y, this.x);
    }

    public boolean isZero() {
        return this.x == 0 && this.y == 0;
    }

    public boolean isZeroAny() {
        return this.x == 0 || this.y == 0;
    }
}

