/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.AFPException;
import com.renderx.afplib.AFPInternalException;
import com.renderx.afplib.CodePage259;
import com.renderx.afplib.ConfigManager;
import com.renderx.afplib.HighlightColorRegistry;
import com.renderx.afplib.Point2D;
import com.renderx.afplib.Tag;
import com.renderx.afplib.Util;
import com.renderx.afplib.XFont;
import com.renderx.afplib.XGraphic;
import com.renderx.afplib.XTextDecoderSingleton;
import com.renderx.afplib.XTextPiece;
import com.renderx.afplib.XYObject;
import com.renderx.graphics.BitmapImage;
import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.ObjectRecordCoordinator;
import com.renderx.graphics.TIFFImage;
import com.renderx.util.Base64InputStream;
import com.renderx.util.ErrorHandler;
import com.renderx.util.SeekableInput;
import com.renderx.xep.pre.Attr;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AFP {
    public static Point2D resolution = new Point2D(14400, 14400);
    public static final int MAX_IPD_DATA_SIZE = 32000;
    public static final int MAX_OCD_DATA_SIZE = 32000;
    static final int PAGE_UNIT_BASE_10INCHES = 0;
    static final int PAGE_UNIT_BASE_10CENTIMETERS = 1;
    public static int pageUnitBase = 0;
    public static final String LAST_MODCA_SF_NAME = "FFFF000000000000";
    public static final int OBJECT_CLASSIFICATION_IMAGE = 1;
    final int COLOR_SPACE_RGB = 1;
    final int COLOR_SPACE_CMYK = 4;
    final int COLOR_SPACE_HIGHLIGHT = 6;
    final int COLOR_SPACE_CIELAB = 8;
    final int COLOR_SPACE_STANDARD_OCA = 64;
    static final String RESOURCE_GROUP_NAME = "AFPRENDE";
    public static final short AFP_RGB_COLOR_DEPTH = 8;
    public static final short AFP_RGB_COLOR_MAX = 255;
    public static final short AFP_CMYK_COLOR_DEPTH = 8;
    public static final short AFP_CMYK_COLOR_MAX = 255;
    private static final short COLOR_OF_MEDIUM = -248;
    private static Object[] extendedColorToOCAColorIndexMap = new Object[]{new Object[]{Attr.Color.RGB.create(0.0, 0.0, 1.0), new Short(1)}, new Object[]{Attr.Color.RGB.create(1.0, 0.0, 0.0), new Short(2)}, new Object[]{Attr.Color.RGB.create(1.0, 0.0, 1.0), new Short(3)}, new Object[]{Attr.Color.RGB.create(0.0, 1.0, 0.0), new Short(4)}, new Object[]{Attr.Color.RGB.create(0.0, 1.0, 1.0), new Short(5)}, new Object[]{Attr.Color.RGB.create(1.0, 1.0, 0.0), new Short(6)}, new Object[]{Attr.Color.RGB.create(0.0, 0.0, 0.0), new Short(8)}, new Object[]{Attr.Color.Grayscale.create(0.0), new Short(8)}, new Object[]{Attr.Color.RGB.create(0.65, 0.1647, 0.1647), new Short(16)}, new Object[]{Attr.Color.Grayscale.create(0.5), new Short(16)}};
    public HighlightColorRegistry highlightColors;
    public XTextDecoderSingleton utf8TextDecoder;
    public static final int STRUCTURED_FIELD_ID_LEN = 3;
    public static final int CONTROL_SEQUENCE_ID_LEN = 1;
    public static final int OBJECT_TOKEN_LEN = 8;
    public static final Map STRUCTURED_FIELD = new HashMap();
    public static final Map STRUCTURED_FIELD_BYID = new HashMap();
    private static final short[] TRIPLETS;
    private static final int MAX_FQNAME_LENGTH = 125;
    public static final Map CONTROL_SEQUENCE;
    private static final Map MODCA_EMBEDDABLE_OBJECT_TYPE;
    public static short[][] compressionAlgorithmCodes;
    private boolean useZOSPrefix5A = true;
    private OutputStream afpOutputStream = null;
    private ByteBuffer buffer = null;
    boolean accumulatingMode = false;
    private String textCodePage = null;
    public ErrorHandler errorHandler = null;
    private short nImage = 0;
    private short nText = 0;
    private int currentRotation = 0;
    private Attr.Color currentColor = null;
    private int currentLetterSpacing = 0;
    private XFont currentPTOCATextStyle = null;
    private boolean activeSVI = false;
    private int currentWordSpacing = -1;
    private ConfigManager optionsManager;
    public PtocaBuffer ptoca = new PtocaBuffer();
    private int currentBaseLine = 0;
    public static final float JAVA2D_RESOLUTION = 72000.0f;
    private static Point2D millipointsToAFP;

    public boolean isPtocaLevelSupported(int n) {
        return n >= this.optionsManager.getPtocaLevels();
    }

    public boolean isGocaLevelSupported(int n) {
        return n >= this.optionsManager.getGocaLevels();
    }

    private static double colorDistance(Attr.Color color, Attr.Color color2) {
        if (color instanceof Attr.Color.RGB && color2 instanceof Attr.Color.RGB) {
            Attr.Color.RGB rGB = (Attr.Color.RGB)color;
            Attr.Color.RGB rGB2 = (Attr.Color.RGB)color2;
            double[] dArray = rGB.r_g_b();
            double[] dArray2 = rGB2.r_g_b();
            double d = dArray[0] - dArray2[0];
            double d2 = dArray[1] - dArray2[1];
            double d3 = dArray[2] - dArray2[2];
            return Math.sqrt(d * d + d2 * d2 + d3 * d3);
        }
        if (color instanceof Attr.Color.Grayscale && color2 instanceof Attr.Color.Grayscale) {
            Attr.Color.Grayscale grayscale = (Attr.Color.Grayscale)color;
            Attr.Color.Grayscale grayscale2 = (Attr.Color.Grayscale)color2;
            return grayscale.gray() - grayscale2.gray();
        }
        return 1.0E13;
    }

    public static short extendedColorToOCAColorIndex(Attr.Color color) {
        if (color == null) {
            return -248;
        }
        double d = AFP.colorDistance(Attr.Color.RGB.create(0.0, 0.0, 0.0), Attr.Color.RGB.create(1.0, 1.0, 1.0));
        Short s = null;
        for (int i = 0; i < extendedColorToOCAColorIndexMap.length; ++i) {
            Attr.Color color2 = (Attr.Color)((Object[])extendedColorToOCAColorIndexMap[i])[0];
            Short s2 = (Short)((Object[])extendedColorToOCAColorIndexMap[i])[1];
            double d2 = AFP.colorDistance(color, color2);
            if (d2 == 0.0) {
                return s2;
            }
            if (!(d2 < d)) continue;
            d = d2;
            s = s2;
        }
        return s != null ? (short)s : (short)-248;
    }

    private static final void MODCASF(String string, String string2, long l, int n) {
        MODCAStructeredField mODCAStructeredField = new MODCAStructeredField(string, string2, l, n);
        STRUCTURED_FIELD.put(string2, mODCAStructeredField);
        STRUCTURED_FIELD_BYID.put(new Long(l), mODCAStructeredField);
    }

    public static final MODCAStructeredField getModcaSF(String string) {
        MODCAStructeredField mODCAStructeredField = (MODCAStructeredField)STRUCTURED_FIELD.get(string);
        if (mODCAStructeredField == null) {
            Long l = new Long(Long.parseLong(string, 16));
            mODCAStructeredField = (MODCAStructeredField)STRUCTURED_FIELD_BYID.get(l);
        }
        if (mODCAStructeredField == null) {
            throw new AFPException("Unknown MOD:CA structured field " + string);
        }
        return mODCAStructeredField;
    }

    public static final boolean isValidModCATriplet(short s) {
        int n = TRIPLETS.length / 2;
        int n2 = -1;
        int n3 = TRIPLETS.length;
        while (n2 < n && n < n3) {
            if (TRIPLETS[n] == s) {
                return true;
            }
            if (s < TRIPLETS[n]) {
                n3 = n;
                n -= (n - n2) / 2;
                continue;
            }
            if (s <= TRIPLETS[n]) continue;
            n2 = n;
            n += (n3 - n) / 2;
        }
        return false;
    }

    private static void MODCA_EMBEDDABLE_OBJECT_TYPE(String string, boolean bl, short s, short s2, short s3, short s4) {
        MODCA_EMBEDDABLE_OBJECT_TYPE.put(string, new EmbeddableObjectType(string, bl, s, s2, s3, s4));
    }

    public static final EmbeddableObjectType getMoDcaEmbeddableObjectType(String string) {
        return (EmbeddableObjectType)MODCA_EMBEDDABLE_OBJECT_TYPE.get(string);
    }

    public static short getCompressionAlgorithmCode(BitmapImage bitmapImage) {
        for (int i = 0; i < compressionAlgorithmCodes.length; ++i) {
            if (compressionAlgorithmCodes[i][0] != bitmapImage.compressionMethod) continue;
            return compressionAlgorithmCodes[i][1];
        }
        return 0;
    }

    public AFP(OutputStream outputStream, ErrorHandler errorHandler, boolean bl, HighlightColorRegistry highlightColorRegistry, ConfigManager configManager) {
        this.afpOutputStream = outputStream;
        this.errorHandler = errorHandler;
        this.buffer = ByteBuffer.allocate(655360);
        this.useZOSPrefix5A = bl;
        this.textCodePage = "Cp500";
        this.accumulatingMode = false;
        this.highlightColors = highlightColorRegistry;
        this.optionsManager = configManager;
        resolution = new Point2D(configManager.getResolution(), configManager.getResolution());
        AFP.millipointsToAFP.x = Math.round(720000.0f / (float)AFP.resolution.x);
        AFP.millipointsToAFP.y = Math.round(720000.0f / (float)AFP.resolution.y);
    }

    public AFP(OutputStream outputStream, ErrorHandler errorHandler, HighlightColorRegistry highlightColorRegistry, ConfigManager configManager) {
        this(outputStream, errorHandler, true, highlightColorRegistry, configManager);
    }

    public void startAccumulation() throws IOException {
        if (!this.accumulatingMode) {
            this.flush();
            this.accumulatingMode = true;
        }
    }

    public void stopAccumulation() throws IOException {
        if (this.accumulatingMode) {
            this.accumulatingMode = false;
            this.flush();
        }
    }

    public void writeAccumulatedLength(int n) throws IOException {
        if (this.accumulatingMode) {
            Util.writeShortAbsolute(this.buffer, n, this.buffer.position() - 1);
            this.stopAccumulation();
        }
    }

    public final String genImageName(Image image) {
        this.nImage = (short)(this.nImage + 1);
        return Util.name08("I", String.valueOf(this.nImage));
    }

    public final short getImageId() {
        return this.nImage;
    }

    public final String genPTOCAName() {
        this.nText = (short)(this.nText + 1);
        return Util.name08("PT", String.valueOf(this.nText));
    }

    public void writeModcaSFNamed(String string, String string2) throws IOException, AFPInternalException {
        this.writeModcaSFNamed(string, string2, -1, false);
    }

    public final void writeModcaSFNamed(String string, String string2, int n) throws IOException, AFPInternalException {
        this.writeModcaSFNamed(string, string2, n, false);
    }

    public void writeModcaSFNamedHex(String string, String string2) throws IOException, AFPInternalException {
        this.writeModcaSFNamed(string, string2, -1, true);
    }

    public final void writeModcaSFNamedHex(String string, String string2, int n) throws IOException, AFPInternalException {
        this.writeModcaSFNamed(string, string2, n, true);
    }

    public void writeModcaSFNamed(String string, String string2, int n, boolean bl) throws IOException, AFPInternalException {
        MODCAStructeredField mODCAStructeredField = AFP.getModcaSF(string);
        if (this.useZOSPrefix5A) {
            Util.writeByte(this.buffer, 90);
        }
        Util.writeNBytes(this.buffer, n <= 0 ? (long)mODCAStructeredField.length : (long)n, 2);
        Util.writeNBytes(this.buffer, mODCAStructeredField.identifier, 3);
        Util.writeNBytes(this.buffer, 0L, 1);
        Util.writeNBytes(this.buffer, 0L, 2);
        if (string2 != null) {
            if (bl) {
                if (string2.length() > 16) {
                    string2 = string2.substring(0, 15);
                }
                this.writeHex(string2);
            } else {
                this.writeEBC(string2.substring(0, Math.min(8, string2.length())));
                if (string2.length() > 8) {
                    this.writeTriplet_0x02_FullyQualifiedName(1, string2);
                }
            }
        }
    }

    public void writeModcaSF(String string) throws IOException {
        this.writeModcaSF(string, -1);
    }

    public int writeModcaSF(String string, int n) throws IOException {
        MODCAStructeredField mODCAStructeredField = AFP.getModcaSF(string);
        if (this.useZOSPrefix5A) {
            Util.writeByte(this.buffer, 90);
        }
        int n2 = this.buffer.position();
        Util.writeNBytes(this.buffer, n <= 0 ? (long)mODCAStructeredField.length : (long)n, 2);
        Util.writeNBytes(this.buffer, mODCAStructeredField.identifier, 3);
        Util.writeNBytes(this.buffer, 0L, 1);
        Util.writeNBytes(this.buffer, 0L, 2);
        return n2;
    }

    public void writeModcaTripletHeader(int n, int n2) {
        this.writeModcaTripletHeader((short)n, (short)n2);
    }

    public void writeModcaTripletHeader(short s, short s2) {
        if (!AFP.isValidModCATriplet(s)) {
            throw new AFPException("Invalid MOD:CA triplet " + String.valueOf(s));
        }
        Util.writeByte(this.buffer, s2);
        Util.writeByte(this.buffer, s);
    }

    public void writePTOCACS(String string, int n) throws IOException, AFPInternalException {
        this.writePTOCACS(string, n, true);
    }

    public void writePTOCACS(String string, int n, boolean bl) throws IOException, AFPInternalException {
        Long l = (Long)CONTROL_SEQUENCE.get(string);
        long l2 = l;
        if (!bl) {
            this.ptoca.writeCSPrefix();
        } else {
            ++l2;
        }
        Util.writeByte(this.buffer, n);
        if (l != null) {
            Util.writeNBytes(this.buffer, l2, 1);
        } else {
            if (string.length() > 2) {
                string = string.substring(0, 1);
            }
            Util.writeHex(this.buffer, string);
        }
        this.flush();
    }

    public void writeIocaLSDF(int n, int n2) throws IOException {
        Util.writeByte(this.buffer, n);
        Util.writeByte(this.buffer, n2);
        this.flush();
    }

    public void writeIocaESDF(int n, int n2) throws IOException {
        Util.writeNBytes(this.buffer, n, 2);
        Util.writeNBytes(this.buffer, n2, 2);
        this.flush();
    }

    public void copyImageData(BitmapImage bitmapImage, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        bitmapImage.copyData(this.afpOutputStream, objectRecordCoordinator);
    }

    public void copyImageData(BitmapImage bitmapImage) throws IOException, ImageFormatException {
        bitmapImage.copyData(this.afpOutputStream);
    }

    public void expandImageData(BitmapImage bitmapImage, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        bitmapImage.expandData(this.afpOutputStream, objectRecordCoordinator);
    }

    public void expandImageData(BitmapImage bitmapImage) throws IOException, ImageFormatException {
        bitmapImage.expandData(this.afpOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeBitmapImage(BitmapImage bitmapImage, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        if (!bitmapImage.canCopyData && !bitmapImage.canExpandData) {
            this.errorHandler.error("cannot use neither raw nor expanded bitmap data in file '" + bitmapImage.toDisplayString() + "'.");
            return;
        }
        if (bitmapImage.canCopyData) {
            bitmapImage.copyData(this.afpOutputStream, objectRecordCoordinator);
        } else {
            SeekableInput seekableInput = bitmapImage.openSeekableImageStream();
            try {
                int n;
                Object object;
                if (bitmapImage instanceof TIFFImage) {
                    object = (TIFFImage)bitmapImage;
                    seekableInput.seek(((TIFFImage)object).offsetAdjustment);
                }
                object = new byte[objectRecordCoordinator.getRecordLength()];
                while ((n = seekableInput.read((byte[])object)) != -1) {
                    objectRecordCoordinator.beginRecord(this.afpOutputStream, n);
                    this.afpOutputStream.write((byte[])object, 0, n);
                    objectRecordCoordinator.endRecord(this.afpOutputStream, n);
                }
            }
            finally {
                seekableInput.close();
            }
        }
    }

    public final void writeNBytes(long l, int n) throws AFPInternalException, IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("writeNBytes: Negative numberOfBytes");
        }
        if (n > 8) {
            throw new IllegalArgumentException("writeNBytes: Cannot write more than 8 bytes in chunk");
        }
        if (n != 8 && l >> n * 8 != 0L) {
            throw new AFPInternalException("writeNBytes: overflow " + l);
        }
        Util.writeNBytes(this.buffer, l, n);
    }

    public final void writeByte(int n) throws AFPInternalException {
        if (n > 255) {
            throw new AFPInternalException("writeByte: overflow " + n);
        }
        Util.writeByte(this.buffer, n);
    }

    public final void writeFlagsInByte(boolean[] blArray) throws AFPInternalException {
        if (blArray.length > 8) {
            throw new AFPInternalException("writeFlags: to many flags");
        }
        if (blArray.length < 8) {
            throw new AFPInternalException("writeFlags: not enough flags");
        }
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            n += this.fromBooleanToByte(blArray[i]) << 7 - i;
        }
        Util.writeByte(this.buffer, n);
    }

    private int fromBooleanToByte(boolean bl) {
        return bl ? 1 : 0;
    }

    public final void writeFlagsInByte(String string) throws AFPInternalException {
        boolean[] blArray = new boolean[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '1') {
                blArray[i] = true;
                continue;
            }
            if (string.charAt(i) == '0') {
                blArray[i] = false;
                continue;
            }
            throw new AFPInternalException("Wrong binary value " + string);
        }
        this.writeFlagsInByte(blArray);
    }

    public final void writeShort(int n) throws AFPInternalException {
        if (n > 65535) {
            throw new AFPInternalException("writeShort: overflow " + n);
        }
        Util.writeShort(this.buffer, n);
    }

    private void writeShort(int n, int n2) throws AFPInternalException {
        this.writeShort(n);
        this.writeShort(n2);
    }

    public final void writeHex(String string) {
        Util.writeHex(this.buffer, string);
    }

    public final int rememberBufferPosition() {
        return this.buffer.position();
    }

    public final void setRememberBufferPosition(int n) {
        this.buffer.position(n);
    }

    public void writeText(String string) throws AFPException, UnsupportedEncodingException, AFPInternalException {
        byte[] byArray = string.getBytes(this.textCodePage);
        this.writeConvertedText(byArray);
    }

    public void writeConvertedText(byte[] byArray) {
        this.buffer.put(ByteBuffer.wrap(byArray));
    }

    public void writeTextCp259(String string) throws AFPInternalException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            Byte by = CodePage259.UTF16ToCP259(c);
            if (by == null) {
                throw new AFPException("Unicode symbol '" + c + "' (U+" + Integer.toHexString(c) + ") is not found in codepage 259.");
            }
            this.writeByte(by.byteValue());
        }
    }

    public void writeEBC(String string) {
        Util.writeEBC(this.buffer, string);
    }

    public int writeBytes(byte[] byArray, int n, int n2) {
        if (n < byArray.length) {
            if (n + n2 > byArray.length) {
                n2 = byArray.length - n;
            }
            this.buffer.put(byArray, n, n2);
            return n2;
        }
        return 0;
    }

    private final void transferBuffer() throws IOException {
        byte[] byArray = this.buffer.array();
        this.afpOutputStream.write(byArray, 0, this.buffer.position());
        this.buffer.clear();
    }

    public final void flush() throws IOException {
        if (!this.accumulatingMode) {
            this.transferBuffer();
        }
    }

    public final void rollback() {
        this.buffer.reset();
    }

    public void markBuffer() {
        this.buffer.mark();
    }

    public void drawHorizontalRule(Point2D point2D, Point2D point2D2) throws AFPInternalException, IOException {
        this.gotoXY(point2D);
        this.writePTOCACS("DIR", 7);
        this.writePoint2bytes(point2D2);
        this.writeByte(0);
    }

    public void drawVerticalRule(Point2D point2D, Point2D point2D2) throws AFPInternalException, IOException {
        this.gotoXY(point2D);
        this.writePTOCACS("DBR", 7);
        this.writePoint2bytes(point2D2);
        this.writeByte(0);
    }

    public void gotoXY(Point2D point2D) throws AFPInternalException, IOException {
        this.writePTOCACS("AMI", 4);
        this.writeShort(point2D.x);
        if (point2D.y != this.currentBaseLine) {
            this.writePTOCACS("AMB", 4);
            this.writeShort(point2D.y);
            this.currentBaseLine = point2D.y;
        }
    }

    public void setOrientation(XYObject xYObject) throws IOException, AFPInternalException {
        this.setOrientation(xYObject.rotation, false);
    }

    public void setOrientation(int n, boolean bl) throws IOException, AFPInternalException {
        if (!bl && n == this.currentRotation) {
            return;
        }
        this.currentRotation = n;
        this.writePTOCACS("STO", 6);
        this.writeRotationBytes(n);
    }

    public void writeRotationBytes(int n) throws IOException, AFPInternalException {
        switch (n) {
            case 0: {
                this.writeShort(0, 11520);
                break;
            }
            case 90: {
                this.writeShort(34560, 0);
                break;
            }
            case 180: {
                this.writeShort(23040, 34560);
                break;
            }
            case 270: {
                this.writeShort(11520, 23040);
                break;
            }
            default: {
                throw new IOException("Rotation of " + n + " is not supported!");
            }
        }
    }

    public void resetColor() {
        this.currentColor = null;
    }

    public void setColor(Attr.Color color) throws AFPInternalException {
        if (this.currentColor != null && color.equals(this.currentColor)) {
            return;
        }
        this.currentColor = color;
        try {
            if (this.isPtocaLevelSupported(1)) {
                this.writePTOCACS("STC", 5);
                short s = AFP.extendedColorToOCAColorIndex(color);
                this.writeShort(s);
                this.writeByte(1);
            }
            if (this.isPtocaLevelSupported(3)) {
                int n = this.getExtendedColorSequenceLength(color) + 3;
                this.writePTOCACS("SEC", n);
                this.writeByte(0);
                this.writeExtendedColorSequence(color);
            }
        }
        catch (IOException iOException) {
            this.errorHandler.exception("Can't set color", iOException);
        }
    }

    public int getExtendedColorSequenceLength(Attr.Color color) {
        if (color instanceof Attr.Color.RGB) {
            return 12;
        }
        if (color instanceof Attr.Color.CMYK) {
            return 13;
        }
        if (color instanceof Attr.Color.Grayscale) {
            return 12;
        }
        if (color instanceof Attr.Color.SpotColor) {
            return 12;
        }
        throw new AFPException("Color space is not supported for color " + color.toString());
    }

    public void writeExtendedColorSequence(Attr.Color color) throws AFPInternalException, AFPException {
        if (color instanceof Attr.Color.RGB) {
            Attr.Color.RGB rGB = (Attr.Color.RGB)color;
            this.writeByte(1);
            this.writeNBytes(0L, 4);
            this.writeByte(8);
            this.writeByte(8);
            this.writeByte(8);
            this.writeByte(0);
            double[] dArray = rGB.r_g_b();
            this.writeNBytes(Math.round(dArray[0] * 255.0), 1);
            this.writeNBytes(Math.round(dArray[1] * 255.0), 1);
            this.writeNBytes(Math.round(dArray[2] * 255.0), 1);
        } else if (color instanceof Attr.Color.CMYK) {
            Attr.Color.CMYK cMYK = (Attr.Color.CMYK)color;
            this.writeByte(4);
            this.writeNBytes(0L, 4);
            this.writeByte(8);
            this.writeByte(8);
            this.writeByte(8);
            this.writeByte(8);
            double[] dArray = cMYK.c_m_y_k();
            this.writeNBytes(Math.round(dArray[0] * 255.0), 1);
            this.writeNBytes(Math.round(dArray[1] * 255.0), 1);
            this.writeNBytes(Math.round(dArray[2] * 255.0), 1);
            this.writeNBytes(Math.round(dArray[3] * 255.0), 1);
        } else if (color instanceof Attr.Color.Grayscale) {
            Attr.Color.Grayscale grayscale = (Attr.Color.Grayscale)color;
            this.writeByte(1);
            this.writeNBytes(0L, 4);
            this.writeByte(8);
            this.writeByte(8);
            this.writeByte(8);
            this.writeByte(0);
            double d = grayscale.gray();
            double d2 = grayscale.gray();
            double d3 = grayscale.gray();
            this.writeNBytes(Math.round(d * 255.0), 1);
            this.writeNBytes(Math.round(d2 * 255.0), 1);
            this.writeNBytes(Math.round(d3 * 255.0), 1);
        } else if (color instanceof Attr.Color.SpotColor) {
            Attr.Color.SpotColor spotColor = (Attr.Color.SpotColor)color;
            int n = this.highlightColors.getColorIndex(spotColor.colorant);
            int n2 = this.getTintPercentage(spotColor.tint);
            this.writeByte(6);
            this.writeNBytes(0L, 4);
            this.writeByte(16);
            this.writeByte(8);
            this.writeByte(0);
            this.writeByte(0);
            this.writeNBytes(n, 2);
            this.writeByte(n2);
        } else {
            throw new AFPException("Color space is not supported for color " + color.toString());
        }
    }

    private int getTintPercentage(int n) {
        return n * 100 / 65535;
    }

    public void setLetterSpacingDelta(int n) throws AFPInternalException {
        int n2 = AFP.toAFPCoordinates(Math.abs(n));
        if (n < 0) {
            n2 = 0;
        }
        if (n2 != this.currentLetterSpacing) {
            this.currentLetterSpacing = n2;
            try {
                this.writePTOCACS("SIA", 5);
                this.writeShort(n2 & Short.MAX_VALUE);
                this.writeByte(0);
            }
            catch (IOException iOException) {
                this.errorHandler.exception("Can't set letter spacing", iOException);
            }
        }
    }

    public void setWordSpacing(XTextPiece xTextPiece, int n, int n2) {
        try {
            if (xTextPiece.letterSpacingDelta == 0 && xTextPiece.wordSpacing == 0) {
                if (this.activeSVI) {
                    this.activeSVI = false;
                    this.writePTOCACS("SVI", 4);
                    this.writeShort(Short.MAX_VALUE);
                    this.flush();
                }
            } else {
                float f = (float)n2 * (float)n * 0.02f;
                int n3 = 0;
                if (xTextPiece.letterSpacingDelta != 0) {
                    int n4;
                    int n5;
                    int n6 = 0;
                    for (n5 = 0; n5 < xTextPiece.value.length(); ++n5) {
                        if (xTextPiece.value.charAt(n5) != ' ') continue;
                        ++n6;
                    }
                    n5 = (xTextPiece.value.length() - n6 - 1) * xTextPiece.letterSpacingDelta;
                    int n7 = n6 * xTextPiece.wordSpacing;
                    int n8 = n4 = AFP.toAFPCoordinates(n7 + n5);
                    if (n6 != 0) {
                        n8 = n4 / n6;
                        n3 = (int)f + n8;
                    } else {
                        n3 = (int)f;
                    }
                } else {
                    n3 = (int)f + AFP.toAFPCoordinates(xTextPiece.wordSpacing);
                }
                this.activeSVI = true;
                this.writePTOCACS("SVI", 4);
                this.writeShort(n3 & Short.MAX_VALUE);
                this.flush();
            }
        }
        catch (Exception exception) {
            this.errorHandler.exception("Can't write PTOCA Set Variable Space Character Increment (SVI)", exception);
        }
    }

    public void resetWordSpacing() throws IOException, AFPInternalException {
        if (this.currentWordSpacing != -1) {
            this.currentWordSpacing = -1;
            this.writePTOCACS("SVI", 4);
            this.writeShort(65535);
            this.flush();
        }
    }

    public void setWordSpacing(int n) throws IOException, AFPInternalException {
        if (n < 0) {
            this.resetWordSpacing();
        } else if (n != this.currentWordSpacing) {
            this.currentWordSpacing = n;
            this.writePTOCACS("SVI", 4);
            this.writeShort(n & 0xFFFF);
            this.flush();
        }
    }

    public void resetTextStyle() {
        this.currentWordSpacing = -1;
        this.currentPTOCATextStyle = null;
    }

    public void setTextStyle(XFont xFont) throws IOException, AFPInternalException {
        if (this.currentPTOCATextStyle != null && xFont.equals(this.currentPTOCATextStyle)) {
            return;
        }
        this.currentPTOCATextStyle = xFont;
        this.writePTOCACS("SCFL", 3);
        this.writeByte(xFont.fontAFPLocalId & 0x7F);
    }

    public void writeTLE(Tag tag) throws IOException, AFPInternalException {
        this.writeModcaSF("TLE", tag.attributeName.length() + tag.attributeValue.length() + 8 + 8 + 10);
        this.writeModcaTripletHeader(2, tag.attributeName.length() + 4);
        this.writeByte(11);
        this.writeByte(0);
        this.writeText(tag.attributeName);
        this.writeModcaTripletHeader(54, tag.attributeValue.length() + 4);
        this.writeShort(0);
        this.writeText(tag.attributeValue);
        this.writeModcaTripletHeader(128, 10);
        this.writeNBytes(tag.tagID, 4);
        this.writeNBytes(1L, 4);
    }

    public void processTags(ArrayList arrayList) throws IOException, AFPInternalException {
        for (int i = 0; i < arrayList.size(); ++i) {
            Tag tag = (Tag)arrayList.get(i);
            this.writeTLE(tag);
        }
    }

    public void writeSF_BeginResourceGroup() throws IOException, AFPInternalException {
        this.writeModcaSFNamed("BRG", RESOURCE_GROUP_NAME);
        this.flush();
    }

    public void writeSF_EndResourceGroup() throws IOException, AFPInternalException {
        this.writeModcaSFNamed("ERG", RESOURCE_GROUP_NAME);
        this.flush();
    }

    public void writeContainerObject(XGraphic xGraphic) throws IOException, ImageFormatException, AFPInternalException {
        AFP aFP = this;
        BitmapImage bitmapImage = (BitmapImage)xGraphic.image;
        if (bitmapImage.canCopyData) {
            if (xGraphic.afpObjectToken == null) {
                xGraphic.afpObjectToken = this.genImageName(xGraphic.image);
            }
            EmbeddableObjectType embeddableObjectType = AFP.getMoDcaEmbeddableObjectType(xGraphic.mimeType);
            aFP.writeModcaSFNamed("BRS", xGraphic.afpObjectToken, 28);
            aFP.writeShort(0);
            aFP.writeModcaTripletHeader(33, 10);
            aFP.writeByte(252);
            aFP.writeNBytes(0L, 7);
            aFP.flush();
            aFP.writeModcaSFNamed("BOC", xGraphic.afpObjectToken, 40);
            this.writeTriplet_0x10_ObjectClassification(aFP, 1);
            embeddableObjectType.writeToAFP(aFP, 16);
            aFP.copyImageData(bitmapImage, new ObjectRecordCoordinator(){

                public int getRecordLength() {
                    return 32000;
                }

                public void beginRecord(OutputStream outputStream, int n) {
                    try {
                        AFP.this.writeModcaSF("OCD", 8 + n);
                        AFP.this.flush();
                    }
                    catch (IOException iOException) {
                        throw new AFPException(iOException);
                    }
                }

                public void endRecord(OutputStream outputStream, int n) {
                }
            });
            aFP.writeModcaSFNamed("EOC", xGraphic.afpObjectToken);
            aFP.flush();
            aFP.writeModcaSFNamed("ERS", xGraphic.afpObjectToken);
            aFP.flush();
        }
    }

    public void writeModcaObject(XGraphic xGraphic) throws IOException, ImageFormatException, AFPInternalException {
        AFP aFP = this;
        BitmapImage bitmapImage = (BitmapImage)xGraphic.image;
        if (bitmapImage.canCopyData) {
            if (xGraphic.afpObjectToken == null) {
                xGraphic.afpObjectToken = this.genImageName(xGraphic.image);
            }
            EmbeddableObjectType embeddableObjectType = AFP.getMoDcaEmbeddableObjectType(xGraphic.mimeType);
            this.writeModcaSFNamed("BRS", xGraphic.afpObjectToken, 28);
            aFP.writeShort(0);
            aFP.writeModcaTripletHeader(33, 10);
            aFP.writeByte(252);
            aFP.writeNBytes(0L, 7);
            aFP.flush();
            aFP.copyImageData(bitmapImage);
            aFP.writeModcaSFNamed("ERS", xGraphic.afpObjectToken);
            aFP.flush();
        }
    }

    public final void iobModca(XGraphic xGraphic) throws IOException, ImageFormatException, AFPInternalException {
        this.writeIncludeObject(xGraphic, null);
    }

    private void writeIncludeObject(XGraphic xGraphic, EmbeddableObjectType embeddableObjectType) throws IOException, AFPInternalException, ImageFormatException {
        short s = AFP.getMoDcaEmbeddableObjectType((String)xGraphic.mimeType).iobObjectType;
        this.writeSF_IOB(xGraphic.origin, s, xGraphic.afpObjectToken, embeddableObjectType != null);
        xGraphic.writeObjectAreaSize(this);
        if (embeddableObjectType != null) {
            this.writeTriplet_0x10_ObjectClassification(embeddableObjectType);
        }
    }

    public final void iobOther(XGraphic xGraphic) throws IOException, ImageFormatException, AFPInternalException {
        this.writeIncludeObject(xGraphic, AFP.getMoDcaEmbeddableObjectType(xGraphic.mimeType));
    }

    private void writeTriplet_0x10_ObjectClassification(EmbeddableObjectType embeddableObjectType) throws IOException, AFPInternalException {
        this.writeModcaTripletHeader(16, 24);
        this.writeByte(0);
        this.writeByte(16);
        this.writeShort(0);
        this.writeShort(43008);
        embeddableObjectType.writeToAFP(this, 16);
        this.flush();
    }

    void writeSF_IPO(Point2D point2D, String string) throws IOException, AFPInternalException {
        this.writeModcaSFNamed("IPO", string, 24);
        this.writePoint(point2D);
        this.writeShort(0);
        this.flush();
    }

    void writeSF_IPS(Point2D point2D, String string) throws IOException, AFPInternalException {
        this.writeModcaSFNamed("IPS", string);
        this.writePoint(point2D);
        this.flush();
    }

    public void writeSF_IOB(Point2D point2D, short s, String string, boolean bl) throws IOException, AFPInternalException {
        this.writeModcaSFNamed("IOB", string, bl ? 79 : 55);
        this.writeByte(0);
        this.writeByte(s);
        this.writePoint(point2D);
        this.writeRotationBytes(0);
        this.writeZeroPoint();
        this.writeByte(1);
        this.writeTriplet_0x4B_MeasurementUnits();
        this.writeTriplet_0x04_MappingOption(XGraphic.MO_SCALE_TO_FIT);
        this.flush();
    }

    public void writeTriplet_0x4B_MeasurementUnits() throws AFPInternalException {
        this.writeModcaTripletHeader(75, 8);
        this.writeMeasurementUnitBytes();
        this.writeResolutionBytes();
    }

    public void writeMeasurementUnitBytes() throws AFPInternalException {
        this.writeByte(0);
        this.writeByte(0);
    }

    public void writeResolutionBytes() throws AFPInternalException {
        this.writeShort(AFP.resolution.x, AFP.resolution.y);
    }

    public void writeTriplet_0x04_MappingOption(byte by) throws AFPInternalException {
        this.writeModcaTripletHeader(4, 3);
        this.writeByte(by);
    }

    private void writeTriplet_0x10_ObjectClassification(AFP aFP, int n) throws IOException, AFPInternalException {
        aFP.writeModcaTripletHeader(16, 24);
        aFP.writeByte(0);
        aFP.writeByte(n);
        aFP.writeShort(0);
        aFP.writeShort(56320);
        aFP.flush();
    }

    public void writeTriplet_0x4C_ObjectAreaSize(Point2D point2D) throws IOException, AFPInternalException {
        this.writeModcaTripletHeader(76, 9);
        this.writeByte(2);
        this.writePoint(point2D);
        this.flush();
    }

    public void writeTriplet_0x02_FullyQualifiedName(int n, String string) throws AFPInternalException {
        int n2 = Math.min(string.length(), 125);
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2);
        this.writeModcaTripletHeader(2, 4 + string2.length());
        this.writeByte(n);
        this.writeByte(0);
        this.writeEBC(string2);
        if (string3.length() > 0) {
            this.writeTriplet_0x02_FullyQualifiedName(n, string3);
        }
    }

    void writeTriplet_0x1F_FontDescriptorSpec(int n) throws AFPInternalException {
        this.writeModcaTripletHeader(31, 20);
        this.writeByte(0);
        this.writeByte(0);
        this.writeShort(n);
        this.writeShort(0);
        this.writeByte(0);
        this.writeNBytes(0L, 10);
        this.writeFlagsInByte("0110000");
    }

    void writeTriplet_0x5D_OutlineFont(int n) throws AFPInternalException {
        this.writeModcaTripletHeader(93, 4);
        this.writeShort(n);
    }

    void writeTriplet_0x24_ResourceLocalId(int n, int n2) throws AFPInternalException {
        this.writeModcaTripletHeader(36, 4);
        this.writeByte(n);
        this.writeByte(n2 & 0x7F);
    }

    public void writeZeroPoint() throws AFPInternalException {
        this.writePoint(new Point2D(0, 0));
    }

    public void writePoint(Point2D point2D) throws AFPInternalException {
        if (point2D.x < 0) {
            this.errorHandler.error("Don't handle negative numbers, x coord " + point2D.x + " changed to 0");
            this.writeNBytes(0L, 3);
        } else {
            this.writeNBytes(point2D.x, 3);
        }
        if (point2D.y < 0) {
            this.errorHandler.error("Don't handle negative numbers, y coord " + point2D.y + " changed to 0");
            this.writeNBytes(0L, 3);
        } else {
            this.writeNBytes(point2D.y, 3);
        }
    }

    public void writePoint2bytes(Point2D point2D) throws AFPInternalException {
        this.writeShort(point2D.x, point2D.y);
    }

    public void writeResolution(Point2D point2D) throws AFPInternalException {
        if (point2D != null) {
            this.writeShort(AFP.toAfpDimensions(point2D.x), AFP.toAfpDimensions(point2D.y));
        } else {
            this.writeResolutionBytes();
        }
    }

    public void writePageDescriptor(Point2D point2D) throws IOException, AFPInternalException {
        this.writeSF_PageDescriptor(point2D, resolution);
    }

    public void writeSF_PageDescriptor(Point2D point2D, Point2D point2D2) throws IOException, AFPInternalException {
        this.writeModcaSF("PGD", 23);
        this.writePageUnitBaseBytes();
        this.writeShort(point2D2.x, point2D2.y);
        this.writePoint(point2D);
        this.writeNBytes(0L, 3);
        this.flush();
    }

    public void writeUnitBase() throws AFPInternalException {
        this.writeByte(pageUnitBase);
    }

    public void writePageUnitBaseBytes() throws AFPInternalException {
        this.writeByte(pageUnitBase);
        this.writeByte(pageUnitBase);
    }

    public void writeHighlightColors() throws IOException {
        this.highlightColors.writeToAfp(this);
    }

    public static String convertBase64ToString(String string) {
        String string2 = null;
        try {
            if (string.startsWith("data:image/svg+xml;base64,")) {
                String string3 = string.substring("data:image/svg+xml;base64,".length());
                Base64InputStream base64InputStream = new Base64InputStream(string3);
                StringBuffer stringBuffer = new StringBuffer(string3.length());
                int n = -1;
                int n2 = 0;
                while ((n = base64InputStream.read()) >= 0) {
                    ++n2;
                    char c = (char)n;
                    stringBuffer.append(c);
                }
                string2 = stringBuffer.toString();
            }
            return string2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return string2;
        }
    }

    public static final int toAFPCoordinates(int n) {
        return Math.round((float)n / (float)AFP.millipointsToAFP.x);
    }

    public static final int toAfpDimensions(int n) {
        int n2 = pageUnitBase == 0 ? n * 10 : Math.round((float)n * 25.4f);
        return n2;
    }

    static {
        AFP.MODCASF("Begin Active Environment Group", "BAG", 13871305L, 16);
        AFP.MODCASF("Begin Bar Code Object", "BBC", 13871339L, 16);
        AFP.MODCASF("Begin Color Attribute Table", "BCA", 13871223L, 16);
        AFP.MODCASF("Bar Code Data", "BDA", 13889259L, 16);
        AFP.MODCASF("Bar Code Data Descriptor", "BDD", 13870827L, 16);
        AFP.MODCASF("Begin Document Environment Group", "BDG", 13871300L, 16);
        AFP.MODCASF("Begin Document Index", "BDI", 13871271L, 16);
        AFP.MODCASF("Begin Document", "BDT", 13871272L, 16);
        AFP.MODCASF("Begin Form Environment Group (0)", "BFG", 13871301L, 16);
        AFP.MODCASF("Begin Form Map", "BFM", 13871309L, 16);
        AFP.MODCASF("Begin Graphics Object", "BGR", 13871291L, 16);
        AFP.MODCASF("Begin IM Image (C)", "BIl", 13871227L, 16);
        AFP.MODCASF("Begin Image Object", "BIM", 13871355L, 16);
        AFP.MODCASF("Begin Medium Map", "BMM", 13871308L, 16);
        AFP.MODCASF("Begin Overlay", "BMO", 13871327L, 16);
        AFP.MODCASF("Begin Named Page Group", "BNG", 13871277L, 16);
        AFP.MODCASF("Begin Object Container", "BOC", 13871250L, 40);
        AFP.MODCASF("Begin Object Environment Group", "BOG", 13871303L, 16);
        AFP.MODCASF("Begin Page", "BPG", 13871279L, 16);
        AFP.MODCASF("Begin Page Segment", "BPS", 13871199L, 16);
        AFP.MODCASF("Begin Presentation Text Object", "BPT", 13871259L, 16);
        AFP.MODCASF("Begin Resource Group", "BRG", 13871302L, 16);
        AFP.MODCASF("Begin Resource", "BRS", 13871310L, 16);
        AFP.MODCASF("Begin Resource Environment Group", "BSG", 13871321L, 16);
        AFP.MODCASF("Color Attribute Table", "CAT", 13873271L, 16);
        AFP.MODCASF("Container Data Descriptor", "CDD", 13870738L, 16);
        AFP.MODCASF("Composed Text Control (0)", "CTC", 13871003L, 16);
        AFP.MODCASF("End Active Environment Group", "EAG", 13871561L, 16);
        AFP.MODCASF("End Bar Code Object", "EBC", 13871595L, 16);
        AFP.MODCASF("End Color Attribute Table", "ECA", 13871479L, 16);
        AFP.MODCASF("End Document Environment Group", "EDG", 13871556L, 16);
        AFP.MODCASF("End Document Index", "EDI", 13871527L, 16);
        AFP.MODCASF("End Document", "EDT", 13871528L, 16);
        AFP.MODCASF("End Form Environment Group (0)", "EFG", 13871557L, 16);
        AFP.MODCASF("End Form Map", "EFM", 13871565L, 16);
        AFP.MODCASF("End Graphics Object", "EGR", 13871547L, 16);
        AFP.MODCASF("End IM Image (C)", "EII", 13871483L, 16);
        AFP.MODCASF("End Image Object", "EIM", 13871611L, 8);
        AFP.MODCASF("End Medium Map", "EMM", 13871564L, 16);
        AFP.MODCASF("End Overlay", "EMO", 13871583L, 16);
        AFP.MODCASF("End Named Page Group", "ENG", 13871533L, 16);
        AFP.MODCASF("End Object Container", "EOC", 13871506L, 16);
        AFP.MODCASF("End Object Environment Group", "EOG", 13871559L, 16);
        AFP.MODCASF("End Page", "EPG", 13871535L, 16);
        AFP.MODCASF("End Page Segment", "EPS", 13871455L, 16);
        AFP.MODCASF("End Presentation Text Object", "EPT", 13871515L, 16);
        AFP.MODCASF("End Resource Group", "ERG", 13871558L, 16);
        AFP.MODCASF("End Resource", "ERS", 13871566L, 16);
        AFP.MODCASF("End Resource Environment Group", "ESG", 13871577L, 16);
        AFP.MODCASF("Form Environment Group Descriptor (0)", "FGD", 13870789L, 16);
        AFP.MODCASF("Graphics Data", "GAD", 13889211L, 16);
        AFP.MODCASF("Graphics Data Descriptor", "GDD", 13870779L, 16);
        AFP.MODCASF("IM Image Cell Position (C)", "ICP", 13872251L, 16);
        AFP.MODCASF("Image Data Descriptor", "IDD", 13870843L, 21);
        AFP.MODCASF("Index Element", "IEL", 13873831L, 16);
        AFP.MODCASF("Image Input Descriptor (C)", "IID", 13870715L, 16);
        AFP.MODCASF("Invoke Medium Map", "IMM", 13872076L, 16);
        AFP.MODCASF("Include Object", "IOB", 13873091L, 16);
        AFP.MODCASF("IM Image Output Control (C)", "IOC", 13870971L, 16);
        AFP.MODCASF("Image Picture Data", "IPD", 13889275L, 12);
        AFP.MODCASF("Include Page", "IPG", 13873071L, 16);
        AFP.MODCASF("Include Page Overlay", "IPO", 13873112L, 16);
        AFP.MODCASF("Include Page Segment", "IPS", 13872991L, 16);
        AFP.MODCASF("IM Image Raster Data (C)", "IRD", 13889147L, 16);
        AFP.MODCASF("Link Logical Element", "LLE", 13874320L, 16);
        AFP.MODCASF("Map Bar Code Object", "MBC", 13872107L, 16);
        AFP.MODCASF("Map Color Attribute Table", "MCA", 13871991L, 16);
        AFP.MODCASF("Medium Copy Count", "MCC", 13869704L, 14);
        AFP.MODCASF("Map Container Data", "MCD", 13872018L, 16);
        AFP.MODCASF("Map Coded Font", "MCF", 13872010L, 16);
        AFP.MODCASF("Map Coded Font Format-1 (C)", "MCF-1", 13873546L, 16);
        AFP.MODCASF("Medium Descriptor", "MDD", 13870728L, 20);
        AFP.MODCASF("Map Data Resource", "MDR", 13872067L, 16);
        AFP.MODCASF("Medium Finishing Control", "MFC", 13869192L, 16);
        AFP.MODCASF("Map Graphics Object", "MGO", 13872059L, 16);
        AFP.MODCASF("Map Image Object", "MIO", 13872123L, 13);
        AFP.MODCASF("Medium Modification Control", "MMC", 13870984L, 10);
        AFP.MODCASF("Map Medium Overlay", "MMO", 13873631L, 16);
        AFP.MODCASF("Map Media Type", "MMT", 13872008L, 16);
        AFP.MODCASF("Map Page", "MPG", 13872047L, 16);
        AFP.MODCASF("Map Page Overlay", "MPO", 13872088L, 16);
        AFP.MODCASF("Map Page Segment", "MPS", 13873503L, 16);
        AFP.MODCASF("Map Suppression", "MSU", 13872106L, 16);
        AFP.MODCASF("No Operation", "NOP", 0xD3EEEEL, 16);
        AFP.MODCASF("Object Area Descriptor", "OBD", 13870699L, 28);
        AFP.MODCASF("Object Area Position", "OBP", 13872235L, 32);
        AFP.MODCASF("Object Container Data", "OCD", 13889170L, 8);
        AFP.MODCASF("Presentation Fidelity Control", "PFC", 13873800L, 16);
        AFP.MODCASF("Page Descriptor", "PGD", 13870767L, 16);
        AFP.MODCASF("Page Position", "PGP", 13873583L, 17);
        AFP.MODCASF("Page Position Format-1 (C)", "PGP-1", 13872303L, 16);
        AFP.MODCASF("Page Modification Control", "PMC", 13871023L, 16);
        AFP.MODCASF("Preprocess Presentation Object", "PPO", 13872579L, 16);
        AFP.MODCASF("Presentation Text Data Descriptor", "PTD", 13873563L, 16);
        AFP.MODCASF("Presentation Text Descriptor Format-1 (C)", "PTD-1", 13870747L, 16);
        AFP.MODCASF("Presentation Text Data", "PTX", 13889179L, 16);
        AFP.MODCASF("Tag Logical Element", "TLE", 13869200L, 16);
        TRIPLETS = new short[]{1, 2, 4, 16, 24, 31, 32, 33, 34, 36, 37, 38, 45, 54, 67, 69, 70, 71, 75, 76, 77, 78, 80, 86, 87, 88, 89, 90, 93, 94, 94, 98, 101, 104, 108, 112, 113, 114, 116, 117, 120, 128, 129, 130, 131, 132, 133, 134, 135, 136, 139, 142};
        CONTROL_SEQUENCE = new HashMap();
        CONTROL_SEQUENCE.put("AMB", new Long(210L));
        CONTROL_SEQUENCE.put("AMI", new Long(198L));
        CONTROL_SEQUENCE.put("DBR", new Long(230L));
        CONTROL_SEQUENCE.put("DIR", new Long(228L));
        CONTROL_SEQUENCE.put("STO", new Long(246L));
        CONTROL_SEQUENCE.put("SVI", new Long(196L));
        CONTROL_SEQUENCE.put("SIA", new Long(194L));
        CONTROL_SEQUENCE.put("SEC", new Long(128L));
        CONTROL_SEQUENCE.put("STC", new Long(116L));
        CONTROL_SEQUENCE.put("SCFL", new Long(240L));
        CONTROL_SEQUENCE.put("TRN", new Long(218L));
        MODCA_EMBEDDABLE_OBJECT_TYPE = new HashMap();
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("modca/pseg", true, (short)0, (short)95, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("modca/ioca", true, (short)0, (short)251, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("application/vnd.ibm.modcap", true, (short)0, (short)251, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("modca/goca", true, (short)0, (short)187, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("modca/oly", true, (short)0, (short)0, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("image/gif", false, (short)22, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("gif", false, (short)22, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("image/tiff", false, (short)14, (short)146, (short)0, (short)1);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("tiff", false, (short)14, (short)146, (short)0, (short)1);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("image/pcx", false, (short)19, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("pcx", false, (short)19, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("image/jpeg", false, (short)23, (short)146, (short)131, (short)254);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("jpeg", false, (short)23, (short)146, (short)131, (short)254);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("image/png", false, (short)23, (short)146, (short)131, (short)254);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("application/pdf", false, (short)25, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("pdf", false, (short)25, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("PDF with Transparency", false, (short)49, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("PDF Resource Object", false, (short)26, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("application/postscript", false, (short)13, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("application/postscript", false, (short)13, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("image/eps", false, (short)48, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("DIB", false, (short)17, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("Color Mapping Table", false, (short)20, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("PCL Page Object", false, (short)34, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("Resident Color Profile", false, (short)46, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("IOCA FS45 Tile Resource", false, (short)47, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("TrueType/OpenType Font", false, (short)51, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("TrueType/OpenType Font Collection", false, (short)53, (short)146, (short)0, (short)0);
        AFP.MODCA_EMBEDDABLE_OBJECT_TYPE("Resource Access Table", false, (short)54, (short)146, (short)0, (short)0);
        compressionAlgorithmCodes = new short[][]{{-1, 1}, {0, 3}, {1, 6}, {-1, 8}, {-1, 10}, {-1, 11}, {8, 13}, {-1, 32}, {4, 128}, {5, 129}, {6, 130}, {3, 131}};
        millipointsToAFP = new Point2D(50, 50);
    }

    class PtocaBuffer {
        String name = null;
        final int PROJECTED_END_PTOCA_SEQUENCE_LENGTH = 64;
        final int MAX_BUFFER_LENGTH = 65471;

        PtocaBuffer() {
        }

        public void begin() throws IOException, AFPInternalException {
            if (!this.isInPtoca()) {
                this.name = this.beginPtocaObject();
            }
            AFP.this.buffer.mark();
        }

        public void end() throws IOException, AFPInternalException {
            if (this.isInPtoca()) {
                this.endPtocaObject();
                this.name = null;
            }
        }

        void beginAnother() throws IOException, AFPInternalException {
            this.end();
            this.begin();
        }

        public boolean isInPtoca() {
            return this.name != null;
        }

        String beginPtocaObject() throws IOException, AFPInternalException {
            String string = AFP.this.genPTOCAName();
            AFP.this.writeModcaSFNamed("BPT", string);
            AFP.this.flush();
            AFP.this.startAccumulation();
            AFP.this.writeModcaSF("PTX");
            this.writeCSPrefix();
            return string;
        }

        public void writeCSPrefix() throws AFPInternalException {
            AFP.this.writeShort(11219);
        }

        void endPtocaObject() throws AFPInternalException, IOException {
            AFP.this.setOrientation(0, true);
            AFP.this.writeShort(760);
            AFP.this.writeAccumulatedLength(1);
            if (this.name != null) {
                AFP.this.writeModcaSFNamed("EPT", this.name);
            } else {
                AFP.this.writeModcaSFNamedHex("EPT", AFP.LAST_MODCA_SF_NAME);
            }
            AFP.this.resetColor();
            AFP.this.resetTextStyle();
        }

        public final boolean checkBuffer() throws IOException, AFPInternalException {
            if (AFP.this.accumulatingMode) {
                if (AFP.this.buffer.position() < 65471) {
                    AFP.this.buffer.mark();
                } else {
                    try {
                        AFP.this.buffer.reset();
                    }
                    catch (InvalidMarkException invalidMarkException) {
                        AFP.this.buffer.rewind();
                    }
                    this.beginAnother();
                    return false;
                }
            }
            return true;
        }
    }

    static class EmbeddableObjectType {
        String mimeType;
        boolean isMoDcaResource;
        static final long objectTypeOIDPrefix = 434363245374210305L;
        short objectTypeOIDSuffix;
        short iobObjectType;
        short imageCompressionAlgorithmCode;
        short imageRecordingAlgorithmCode;

        public EmbeddableObjectType(String string, boolean bl, short s, short s2, short s3, short s4) {
            this.mimeType = string;
            this.isMoDcaResource = bl;
            this.objectTypeOIDSuffix = s;
            this.iobObjectType = s2;
            this.imageCompressionAlgorithmCode = s3;
            this.imageRecordingAlgorithmCode = s4;
        }

        public void writeToAFP(AFP aFP, int n) throws IOException, AFPInternalException {
            aFP.writeNBytes(434363245374210305L, 8);
            aFP.writeByte(this.objectTypeOIDSuffix);
            if (n > 9) {
                n -= 9;
                while (n > 0) {
                    aFP.writeByte(0);
                    --n;
                }
            }
        }

        public void writeToAFPShort(AFP aFP, int n) throws IOException, AFPInternalException {
            aFP.writeByte(this.objectTypeOIDSuffix);
            --n;
            while (n > 0) {
                aFP.writeByte(0);
                --n;
            }
        }

        public void writeImageEncoding(AFP aFP, BitmapImage bitmapImage) throws IOException, AFPInternalException {
            short s = this.imageCompressionAlgorithmCode;
            if (s == 0) {
                s = AFP.getCompressionAlgorithmCode(bitmapImage);
            }
            short s2 = this.imageRecordingAlgorithmCode;
            if (s != 0 && s2 != 0) {
                aFP.writeIocaLSDF(149, 2);
                aFP.writeByte(s);
                aFP.writeByte(s2);
            }
        }
    }

    private static class MODCAStructeredField {
        public final String name;
        public final String acronim;
        public final long identifier;
        public final int length;

        public MODCAStructeredField(String string, String string2, long l, int n) {
            this.name = string;
            this.acronim = string2;
            this.identifier = l;
            this.length = n;
        }
    }
}

