package com.renderx.xepx.x4u.ct.charsetspanel;

/**
 * @author: Roschupkin Alexander
 * @version 1.0
 */

import javax.swing.table.*;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Attr;

public class DomToTableRangeModel extends AbstractTableModel
{

    private static final long serialVersionUID = 5493264810504538767L;

    private String[] columnNames = { "From", "To" }; // for font aliase only
    Vector rowData; // vector of DOM-Elements
    int colCnt; // 1 for Languages-Table, 2 for Font-aliases
    Element root; // parent node for table elements (for add/remove action)
    String child; // Element name (languages, font-data or font-alias)
    boolean attrib; // fill rowData from attributes (for font-data) or from subchildren

    public DomToTableRangeModel(Element root, boolean attr)
    {
	if(root.getElementsByTagName("code-ranges").getLength() > 0)
	{
	    NodeList children = root.getElementsByTagName("code-ranges");
	    root = (Element)children.item(0); 
	}
	this.root = root;
	this.attrib = attr;
	if (root.getTagName().equalsIgnoreCase("code-ranges"))
	{
	    colCnt = 2;
	    child = "code-range";
	} else
	{
	    colCnt = 2;
	    child = (attrib) ? "charset" : "code-range";
	}
	rowData = new Vector();
	if (attrib)
	{
	    NodeList children = root.getElementsByTagName("code-range");
	    Element font_data;
	    if (children.getLength() == 0)
	    {
		font_data = root.getOwnerDocument().createElement("code-range");
		root.appendChild(font_data);
	    } else
	    {
		font_data = (Element) children.item(0);
		NamedNodeMap lst = font_data.getAttributes();
		for (int i = 0; i < lst.getLength(); i++)
		{
		    rowData.add(lst.item(i));
		}
	    }
	} else
	{
	    NodeList lst = root.getChildNodes(); // getElementsByTagName(child) gives all desendet - dont worked
	    if (lst != null)
	    {
		for (int i = 0; i < lst.getLength(); i++)
		{
		    if (lst.item(i).getNodeName().equals(child))
			rowData.add(lst.item(i));
		}
	    }
	}
    }

    public String getColumnName(int col)
    {
	if (colCnt == 1 || attrib)
	    return null;
	else
	    return columnNames[col].toString();
    }

    public int getRowCount()
    {
	return rowData.size();
    }

    public Class getColumnClass(int c)
    {
	return getValueAt(0, c).getClass();
    }

    public int getColumnCount()
    {
	return colCnt;
    }

    public Object getValueAt(int row, int col)
    {
	if (attrib)
	{
	    Attr t = (Attr) rowData.get(row);
	    return (col == 0) ? t.getNodeName() : t.getNodeValue();
	} else
	{
	    Element t = (Element) rowData.get(row);
	    if (col == 0)
	    {
		if(t.getAttributes().getNamedItem("from") == null)
		    return "";
		else
		    return t.getAttributes().getNamedItem("from").getNodeValue();
	    }
	    else
	    {
		if(t.getAttributes().getNamedItem("to") == null)
		    return "";
		else    
		    return t.getAttributes().getNamedItem("to").getNodeValue();
	    }
	}
    }

    public Object getNodeAt(int row)
    {
	if (attrib)
	    return (Attr) rowData.get(row);
	else
	    return (Element) rowData.get(row);
    }

    public boolean isCellEditable(int row, int col)
    {
	return true;
    }

    public void setValueAt(Object value, int row, int col)
    {
	if (attrib)
	{
	    Attr t = (Attr) rowData.get(row);
	    Element font_data = (Element) root.getElementsByTagName(
		    "code-range").item(0);
	    if (col == 0)
	    {
		rowData.remove(row);
		font_data.removeAttribute(t.getNodeName());
		font_data.setAttribute(value.toString(), t.getNodeValue());
		rowData.add(row, font_data.getAttributeNode(value.toString()));
	    } else
		font_data.setAttribute(t.getNodeName(), value.toString());
	} else
	{
	    Element t = (Element) rowData.get(row);
	    if (col == 0)
		t.setAttribute("from", value.toString());
	    else
		t.setAttribute("to", value.toString());
	}
	fireTableCellUpdated(row, col);
    }

    public void addRow(Element element)
    {
	if (attrib)
	{
	    NodeList ch = element.getElementsByTagName("code-range");
	    Element prnt; //= root.getOwnerDocument().createElement("font-data");
	    if (ch == null)
	    {
		prnt = root.getOwnerDocument().createElement("code-range");
		element.appendChild(prnt);
	    } else
		prnt = (Element) ch.item(0);

	    prnt.setAttribute("NEW", "VALUE");
	    Attr t = (Attr) prnt.getAttributes().getNamedItem("NEW");
	    rowData.add(t);
	} else
	    rowData.add(element);
	fireTableDataChanged();
    }

    public void deleteRow(int row)
    {
	rowData.remove(row);
	fireTableDataChanged();
    }

}
