package com.renderx.xepx.x4u.ct;

import javax.swing.tree.*;
import org.w3c.dom.*;
import javax.swing.event.*;
import java.util.*;

public class DomToJTreeAdapter implements javax.swing.tree.TreeModel
{
    public static String[] FONT_NODES = { "fonts", "font-family", "font-group",
	    "font", "charsets", "charset", /*"code-range", "character",*/ "options"};

    Document document;

    FontTreeNode root = null;

    // public DomToJTreeAdapter(FontTreeNode root) {super(null); this.root =
        // root;}
    public DomToJTreeAdapter(Document document, Element elem)
    {
	root = new FontTreeNode(elem);
	this.document = document;
    }

    // Basic TreeModel operations
    public Object getRoot()
    {
	return this.root;
    }

    public boolean isLeaf(Object aNode)
    {
	FontTreeNode node = (FontTreeNode) aNode;
	if (node.childCount() > 0)
	    return false;
	return true;
    }

    public int getChildCount(Object parent)
    {
	FontTreeNode node = (FontTreeNode) parent;
	return node.childCount();
    }

    public Object getChild(Object parent, int index)
    {
	FontTreeNode node = (FontTreeNode) parent;
	return node.child(index);
    }

    public int getIndexOfChild(Object parent, Object child)
    {
	FontTreeNode node = (FontTreeNode) parent;
	return node.index((FontTreeNode) child);
    }

    public void valueForPathChanged(TreePath path, Object newValue)
    {
	Element currentNode = ((FontTreeNode) (path.getLastPathComponent())).body;
	String val = newValue.toString();
	if (currentNode.getNodeName().equalsIgnoreCase("font-group"))
	    currentNode.setAttribute("label", val);
	else if (currentNode.getNodeName().equalsIgnoreCase("font-family"))
	    currentNode.setAttribute("name", val);
	else if (currentNode.getNodeName().equalsIgnoreCase("font"))
	{
	    StringTokenizer st = new StringTokenizer(val, " ");
	    int ind = 1;
	    String attValue = st.nextToken();
	    while (st.hasMoreTokens())
	    {
		attValue = st.nextToken();
		boolean del = (attValue.equals("-"));
		String attName = "";
		if (ind == 1)
		    attName = "weight";
		else if (ind == 2)
		    attName = "style";
		else if (ind == 3)
		    attName = "variant";
		if (del)
		    currentNode.removeAttribute(attName);
		else
		    currentNode.setAttribute(attName, attValue);
		ind++;
	    }
	}
	fireTreeNodesChanged(new TreeModelEvent(currentNode, path));
    }

    public void insertInCurrentNode(TreeModelEvent e, String cmd)
    {
	TreePath path = e.getTreePath();
	FontTreeNode node = (FontTreeNode) path.getLastPathComponent();
	if (node.body == null)
	    return;
	Node newNode;
	Node current = node.body;
	if (cmd.equalsIgnoreCase(FontsPanel.NEW_COMMANDS[0]))
	{ // group
	    newNode = this.document.createElement("font-group");
	    ((Element) newNode).setAttribute("label", "New Group");
	} else if (cmd.equalsIgnoreCase(FontsPanel.NEW_COMMANDS[1]))
	{ // family
	    newNode = this.document.createElement("font-family");
	    ((Element) newNode).setAttribute("name", "New Family");
	} else
	{
	    newNode = this.document.createElement("font");
	    if (current.getNodeName().equalsIgnoreCase("font"))
	    {
		path = path.getParentPath();
		node = (FontTreeNode) path.getLastPathComponent();
	    }
	}
	node.body.appendChild(newNode);
	int i = node.index(new FontTreeNode(newNode));
	int[] ind = { i };
	Object[] ch = { new FontTreeNode(newNode) };
	fireTreeNodesInserted(new TreeModelEvent(this, path, ind, ch));
    }

    public void removeCurrentNode(TreeModelEvent e)
    {// TreePath path) {
	TreePath path = e.getTreePath();
	FontTreeNode node = (FontTreeNode) path.getLastPathComponent();
	if (node.body == null)
	    return;
	FontTreeNode root = (FontTreeNode) path.getParentPath()
		.getLastPathComponent();
	int[] ind = { root.index(node) };// new int[node.childCount()];
	Object[] ch = { node };// new Object[node.childCount()];
	fireTreeNodesRemoved(new TreeModelEvent(this, path.getParentPath(),
		ind, ch));
	Node parent = node.body.getParentNode();
	parent.removeChild(node.body);
	return;
    }

    private Vector listenerList = new Vector();

    public void addTreeModelListener(TreeModelListener listener)
    {
	if (listener != null && !listenerList.contains(listener))
	{
	    listenerList.addElement(listener);
	}
    }

    public void removeTreeModelListener(TreeModelListener listener)
    {
	if (listener != null)
	{
	    listenerList.removeElement(listener);
	}
    }

    public void fireTreeNodesChanged(TreeModelEvent e)
    {
	Enumeration listeners = listenerList.elements();
	while (listeners.hasMoreElements())
	{
	    TreeModelListener listener = (TreeModelListener) listeners
		    .nextElement();
	    listener.treeNodesChanged(e);
	}
    }

    public void fireTreeNodesInserted(TreeModelEvent e)
    {
	Enumeration listeners = listenerList.elements();
	while (listeners.hasMoreElements())
	{
	    TreeModelListener listener = (TreeModelListener) listeners
		    .nextElement();
	    listener.treeNodesInserted(e);
	}
    }

    public void fireTreeNodesRemoved(TreeModelEvent e)
    {
	Enumeration listeners = listenerList.elements();
	while (listeners.hasMoreElements())
	{
	    TreeModelListener listener = (TreeModelListener) listeners
		    .nextElement();
	    listener.treeNodesRemoved(e);
	}
    }

    public void fireTreeStructureChanged(TreeModelEvent e)
    {
	Enumeration listeners = listenerList.elements();
	while (listeners.hasMoreElements())
	{
	    TreeModelListener listener = (TreeModelListener) listeners
		    .nextElement();
	    listener.treeStructureChanged(e);
	}
    }

    boolean treeElement(String elementName)
    {
	for (int i = 0; i < FONT_NODES.length; i++)
	{
	    if (elementName.equals(FONT_NODES[i]))
		return true;
	}
	return false;
    }

    public class FontTreeNode
    {
	public Element body;

	FontTreeNode(Document doc)
	{
	    this((Element) doc.getElementsByTagName("fonts").item(0));
	}

	FontTreeNode(Element body)
	{
	    this.body = body;
	}

	FontTreeNode(Node body)
	{
	    this.body = (Element) body;
	}

	FontTreeNode(String name)
	{
	    this.body = (Element) document.getElementsByTagName(name).item(0);
	}

	public String toString()
	{
	    String tag = body.getTagName();
	    if (tag.equalsIgnoreCase("fonts"))
		return "Fonts";
	    else if (tag.equalsIgnoreCase("font-group"))
		return body.getAttribute("label");
	    else if (tag.equalsIgnoreCase("font-family"))
		return body.getAttribute("name");
	    else if (tag.equalsIgnoreCase("font"))
		return getFontDetail(body);
	    return body.getNodeValue();
	}

	public String getFontDetail(Node node)
	{
	    NamedNodeMap attribs = node.getAttributes();
	    String res = "- ";
	    if (attribs.getNamedItem("weight") == null)
		res += "- ";
	    else
		res += attribs.getNamedItem("weight").getNodeValue() + " ";
	    if (attribs.getNamedItem("style") == null)
		res += "- ";
	    else
		res += attribs.getNamedItem("style").getNodeValue() + " ";
	    if (attribs.getNamedItem("variant") == null)
		res += "- ";
	    else
		res += attribs.getNamedItem("variant").getNodeValue();
	    return res.trim();
	}

	public int childCount()
	{
	    int count = 0;
	    for (int i = 0; i < body.getChildNodes().getLength(); i++)
	    {
		org.w3c.dom.Node node = body.getChildNodes().item(i);
		if (node.getNodeType() == Node.ELEMENT_NODE
			&& treeElement(node.getNodeName()))
		{
		    ++count;
		}
	    }
	    return count;
	}

	/**
         * 
         * @param searchIndex
         *                int
         * @return FontTreeNode
         */
	public FontTreeNode child(int searchIndex)
	{
	    // Note: JTree index is zero-based.
	    org.w3c.dom.Node node = body.getChildNodes().item(searchIndex);
	    int elementNodeIndex = 0;
	    for (int i = 0; i < body.getChildNodes().getLength(); i++)
	    {
		node = body.getChildNodes().item(i);
		if (node.getNodeType() == Node.ELEMENT_NODE
			&& treeElement(node.getNodeName())
			&& elementNodeIndex++ == searchIndex)
		{
		    break;
		}
	    }
	    return new FontTreeNode(node);
	} // child

	public int index(FontTreeNode child)
	{
	    int count = childCount();
	    for (int i = 0; i < count; i++)
	    {
		FontTreeNode n = this.child(i);
		if (child.body == n.body)
		    return i;
	    }
	    return -1; // Should never get here.
	}

	/**
         * @return the body
         */
	public Element getBody()
	{
	    return body;
	}
    }
    
} // DomToTreeModelAdapter

