package com.renderx.xepx.x4u.as;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class TimerListener implements ActionListener {
	private Settings settings;
	private UI ui;
	private Formatter formatter;

	TimerListener(Settings settings,Formatter formatter,UI ui){
		this.settings = settings;
		this.ui = ui;
		this.formatter = formatter;
	}

	public void actionPerformed(ActionEvent e){
		ui.logtab.update();
		int state = formatter.state();
		if(state != Formatter.FORMATTING){
			ui.timer.stop();
			ui.rootframe.start.setEnabled(true);
			if(state == Formatter.SUCCESSFUL)
			{
				ui.logtab.update("\nFormatting successful.");
				//JOptionPane.showMessageDialog(ui.rootframe, "Formatting successful.", "XEP Assistant", JOptionPane.OK_OPTION, new ImageIcon());
				if(settings.preview && new java.io.File(settings.result).exists()) {
					try {
						Process proc = Runtime.getRuntime().exec(
							new String[]{settings.viewer,settings.result});
					} catch(Exception ex) {
						JOptionPane.showMessageDialog(ui.rootframe, "Cannot launch external viewer '"+settings.viewer+"': "+ex.getMessage(), "Error", JOptionPane.OK_OPTION);
					}
				}
			}
			else if(state == Formatter.FAILURE)
				ui.logtab.update("\nFormatting failed.");
				//JOptionPane.showMessageDialog(ui.rootframe, "Formatting failed. See event log for details.", "XEP Assistant", JOptionPane.OK_OPTION);
			
		}
	}
}
