/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre.att;

import com.renderx.util.Hashtable;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.AttributeParser;
import com.renderx.xep.pre.ParserContext;
import com.renderx.xep.pre.ParserException;
import com.renderx.xep.pre.Token;
import com.renderx.xep.pre.att.AbsoluteSide;
import com.renderx.xep.pre.att.ColorSpec;
import java.util.Enumeration;
import java.util.Stack;

public class BorderSide
extends Attn {
    private AbsoluteSide widthComponent;
    private AbsoluteSide colorComponent;
    private AbsoluteSide styleComponent;
    private Hashtable widths = new Hashtable();
    private Hashtable styles = new Hashtable();

    public BorderSide(String string) throws ParserException {
        super(string);
        this.widthComponent = (AbsoluteSide)Attn.byName(string + "-width");
        this.colorComponent = (AbsoluteSide)Attn.byName(string + "-color");
        this.styleComponent = (AbsoluteSide)Attn.byName(string + "-style");
        this.widths.put("thin", new Boolean(true));
        this.widths.put("medium", new Boolean(true));
        this.widths.put("thick", new Boolean(true));
        this.styles.put("none", new Boolean(true));
        this.styles.put("hidden", new Boolean(true));
        this.styles.put("solid", new Boolean(true));
        this.styles.put("double", new Boolean(true));
        this.styles.put("dashed", new Boolean(true));
        this.styles.put("dotted", new Boolean(true));
        this.styles.put("inset", new Boolean(true));
        this.styles.put("outset", new Boolean(true));
        this.styles.put("groove", new Boolean(true));
        this.styles.put("ridge", new Boolean(true));
    }

    public void process(String string, ParserContext parserContext) throws ParserException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Stack stack = AttributeParser.parseShorthand(string);
        if (stack.size() > 3) {
            throw new ParserException("Too many tokens in shorthand: " + this.name + "=\"" + string + "\"");
        }
        Enumeration enumeration = stack.elements();
        while (enumeration.hasMoreElements()) {
            Token token = (Token)enumeration.nextElement();
            if (token.type != 8192) {
                throw new ParserException("Incorrect shorthand structure: " + this.name + "=\"" + string + "\"");
            }
            Attr attr = token.value;
            if (attr instanceof Attr.Color) {
                if (bl2) {
                    throw new ParserException("Duplicated color specification in shorthand: " + this.name + "=\"" + string + "\"");
                }
                bl2 = true;
                this.colorComponent.process(attr, parserContext);
                continue;
            }
            if (attr instanceof Attr.Length) {
                if (bl3) {
                    throw new ParserException("Duplicated width specification in shorthand: " + this.name + "=\"" + string + "\"");
                }
                bl3 = true;
                this.widthComponent.process(attr, parserContext);
                continue;
            }
            if (attr instanceof Attr.Word) {
                if (ColorSpec.predefinedColors.containsKey(attr.word())) {
                    if (bl2) {
                        throw new ParserException("Duplicated color specification in shorthand: " + this.name + "=\"" + string + "\"");
                    }
                    bl2 = true;
                    this.colorComponent.process(attr, parserContext);
                    continue;
                }
                if (this.styles.containsKey(attr.word())) {
                    if (bl) {
                        throw new ParserException("Duplicated color specification in shorthand: " + this.name + "=\"" + string + "\"");
                    }
                    bl = true;
                    this.styleComponent.process(attr, parserContext);
                    continue;
                }
                if (this.widths.containsKey(attr.word())) {
                    if (bl3) {
                        throw new ParserException("Duplicated color specification in shorthand: " + this.name + "=\"" + string + "\"");
                    }
                    bl3 = true;
                    this.widthComponent.process(attr, parserContext);
                    continue;
                }
                throw new ParserException("Unrecognized token " + attr.word() + " in shorthand: " + this.name + "=\"" + string + "\"");
            }
            throw new ParserException("Incorrect token type " + attr.getTypeName() + " in shorthand: " + this.name + "=\"" + string + "\"");
        }
    }
}

