/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

import com.renderx.sax.ConfigHandler;
import com.renderx.sax.ConfigHandlerAdapter;
import com.renderx.sax.InputSource;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.RoleMapConfigurationException;
import com.renderx.util.URLSpec;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class RoleMap {
    public static final Hashtable roleMapTable = new Hashtable();
    public static final Hashtable standardTypes = new Hashtable();
    public static final Hashtable XEPAliases = new Hashtable();
    private final ErrorHandler errHandler;

    public RoleMap(URLSpec uRLSpec, ErrorHandler errorHandler) throws RoleMapConfigurationException {
        this.errHandler = errorHandler;
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(new ConfigHandlerAdapter(new Config(), uRLSpec));
            URLSpec uRLSpec2 = uRLSpec;
            synchronized (uRLSpec2) {
                xMLReader.parse(new InputSource(uRLSpec));
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RoleMapConfigurationException("Cannot parse " + uRLSpec + ": " + exception.toString());
        }
    }

    public static final String makeXEPTagName(String string) {
        String string2 = new String();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string2 = string2 + string3.substring(0, 1).toUpperCase() + string3.substring(1);
        }
        return string2;
    }

    public void printError(String string) {
        if (this.errHandler == null) {
            return;
        }
        ErrorHandler errorHandler = this.errHandler;
        synchronized (errorHandler) {
            this.errHandler.error("role map config: " + string);
        }
    }

    private class Config
    implements ConfigHandler {
        private static final String NSURI = "http://www.renderx.com/XEP/config";

        private Config() {
        }

        public void startDocument(Hashtable hashtable) {
            hashtable.put("roll-up", "false");
            hashtable.put("standard", "false");
        }

        public void endDocument(Hashtable hashtable) {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes, Hashtable hashtable) {
            if (!"".equals(string) && !NSURI.equals(string)) {
                return;
            }
            String string4 = attributes.getValue("roll-up");
            String string5 = attributes.getValue("standard");
            if (string4 != null) {
                hashtable.put("roll-up", string4);
            }
            if (string5 != null) {
                hashtable.put("standard", string5);
            }
            if (string2.equals("structure-element")) {
                String string6;
                String string7 = this.getRequiredValue(string2, attributes, "name");
                if (string7 == null) {
                    return;
                }
                if ("true".equals(hashtable.get("standard"))) {
                    standardTypes.put(string7, string7);
                } else if ("false".equals(hashtable.get("roll-up")) && (string6 = this.getRequiredValue(string2, attributes, "role-mapping")) != null) {
                    roleMapTable.put(string7, string6);
                }
            } else if (string2.equals("structure-alias")) {
                String string8 = this.getRequiredValue(string2, attributes, "name");
                String string9 = this.getRequiredValue(string2, attributes, "value");
                if (string8 != null && string9 != null) {
                    XEPAliases.put(string8, string9);
                }
            }
        }

        public void endElement(String string, String string2, String string3, Hashtable hashtable) {
        }

        public void characters(char[] cArray, int n, int n2, Hashtable hashtable) {
        }

        public void processingInstruction(String string, String string2, Hashtable hashtable) {
        }

        private final String getRequiredValue(String string, Attributes attributes, String string2) {
            String string3 = attributes.getValue(string2);
            if (string3 == null) {
                RoleMap.this.printError("Mandatory attribute '" + string2 + "' is missing on element '" + string + "'; element skipped");
            }
            return string3;
        }
    }
}

