/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.svg.css;

import com.renderx.svg.css.CSSParseException;
import com.renderx.svg.css.Lexer;
import com.renderx.svg.css.RuleSet;
import com.renderx.svg.css.Selector;
import com.renderx.svg.css.Style;
import com.renderx.util.Array;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.ErrorHandler;
import com.renderx.util.URLSpec;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class StyleSheet {
    private Vector ruleTable = new Vector();
    private Vector styleTable = new Vector();
    ErrorHandler errorHandler = new DefaultErrorHandler();

    public StyleSheet(String string, ErrorHandler errorHandler) {
        if (errorHandler != null) {
            this.setErrorHandler(errorHandler);
        }
        this.parse(new Lexer(string));
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private void parse(Lexer lexer) {
        Object object;
        lexer.nextIgnoreSpaces();
        while (lexer.getType() == 28) {
            try {
                object = this.parseImport(lexer);
                if (((String)object).length() == 0) continue;
                this.parse(new Lexer(StyleSheet.load(new URLSpec((String)object).openStream())));
            }
            catch (CSSParseException cSSParseException) {
                this.errorForward(lexer, cSSParseException);
            }
            catch (Exception exception) {
                this.errorHandler.warning("CSS parser: " + exception.getMessage());
            }
        }
        while (lexer.getType() != 0) {
            try {
                object = new RuleSet(lexer, this.errorHandler);
                this.styleTable.addElement(((RuleSet)object).getStyleDeclaration());
                int n = 0;
                while (n < ((Array)object).length()) {
                    this.addRule((Selector)((Array)object).get(n));
                    ++n;
                }
            }
            catch (CSSParseException cSSParseException) {
                this.errorForward(lexer, cSSParseException);
            }
        }
    }

    private String parseImport(Lexer lexer) throws CSSParseException {
        StringBuffer stringBuffer = new StringBuffer();
        lexer.nextIgnoreSpaces();
        while (lexer.getType() != 8) {
            switch (lexer.getType()) {
                case 0: {
                    throw new CSSParseException("Unexpected end of style declaration");
                }
                case -1: {
                    throw new CSSParseException("Expected @import directive");
                }
            }
            stringBuffer.append(lexer.getStringValue());
            lexer.nextIgnoreSpaces();
        }
        lexer.nextIgnoreSpaces();
        return StyleSheet.parseURL(stringBuffer.toString());
    }

    protected static String parseURL(String string) {
        String string2 = string.trim();
        if ((string2.startsWith("url(") || string2.startsWith("URL(")) && string2.charAt(string2.length() - 1) == ')') {
            string2 = string2.substring(4, string2.length() - 1).trim();
        }
        if (string2.length() > 2 && (string2.charAt(0) == '\'' && string2.charAt(string2.length() - 1) == '\'' || string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"')) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return string2;
    }

    public int indexOfRule(Selector selector) {
        int n = 0;
        while (n < this.ruleTable.size()) {
            if (((Rule)this.ruleTable.elementAt((int)n))._selector.equals(selector)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void addRule(Selector selector) {
        int n = 0;
        while (n < this.ruleTable.size()) {
            Selector selector2 = ((Rule)this.ruleTable.elementAt((int)n))._selector;
            if (selector.equals(selector2)) {
                Rule rule = (Rule)this.ruleTable.elementAt(n);
                rule.put(rule.length(), new Integer(this.styleTable.size() - 1));
                this.ruleTable.setElementAt(rule, n);
                return;
            }
            if (selector.getSpecificity() < selector2.getSpecificity()) {
                Rule rule = new Rule(selector);
                rule.put(rule.length(), new Integer(this.styleTable.size() - 1));
                this.ruleTable.insertElementAt(rule, n);
                return;
            }
            ++n;
        }
        Rule rule = new Rule(selector);
        rule.put(rule.length(), new Integer(this.styleTable.size() - 1));
        this.ruleTable.addElement(rule);
    }

    public void addRule(Selector selector, Style style) {
        this.styleTable.addElement(style);
        this.addRule(selector);
    }

    public Selector getSelector(int n) {
        return ((Rule)this.ruleTable.elementAt((int)n))._selector;
    }

    public Style getStyle(int n) {
        Style style = new Style();
        Rule rule = (Rule)this.ruleTable.elementAt(n);
        int n2 = 0;
        while (n2 < rule.length()) {
            Style style2 = (Style)this.styleTable.elementAt((Integer)rule.get(n2));
            Enumeration enumeration = style2.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                style.put(k, style2.get(k));
            }
            ++n2;
        }
        return style;
    }

    public int size() {
        return this.ruleTable.size();
    }

    private void errorForward(Lexer lexer, CSSParseException cSSParseException) {
        int n = 0;
        while (true) {
            switch (lexer.getType()) {
                case 0: {
                    return;
                }
                case 2: {
                    --n;
                }
                case 8: {
                    if (n == 0) {
                        lexer.nextIgnoreSpaces();
                        return;
                    }
                }
                case -1: {
                    break;
                }
                case 1: {
                    ++n;
                }
            }
            lexer.nextIgnoreSpaces();
        }
    }

    public static String load(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n;
        while ((n = inputStream.read()) != -1) {
            if (n == 13 || n == 10) {
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 1) {
            System.err.println("call: java com.renderx.svg.css.StyleSheet file_CSS1_style\n");
            System.exit(1);
        }
        StyleSheet styleSheet = new StyleSheet(StyleSheet.load(new FileInputStream(stringArray[0])), null);
        int n = 0;
        while (n < styleSheet.size()) {
            System.out.println(styleSheet.getSelector((int)n).nodelist.toString() + " --> " + styleSheet.getStyle(n) + " spec=" + styleSheet.getSelector(n).getSpecificity());
            ++n;
        }
    }

    class Rule
    extends Array {
        Selector _selector;

        Rule(Selector selector) {
            this._selector = selector;
        }
    }
}

