/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.Annot;
import com.renderx.pdflib.AppearanceStream;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import java.util.Enumeration;

public abstract class AcroField
extends Annot {
    public static final short ACROFIELD_NONE = 0;
    public static final short ACROFIELD_TEXT = 1;
    public static final short ACROFIELD_RADIO = 2;
    public static final short ACROFIELD_CHECKBOX = 3;
    public static final short ACROFIELD_COMBOBOX = 4;
    public static final short ACROFIELD_LISTBOX = 5;
    public static final short ACROFIELD_RESET = 6;
    public static final short ACROFIELD_SUBMIT = 7;
    static final int READ_ONLY = 1;
    static final int REQUIRED = 2;
    static final int NO_EXPORT = 4;
    static final int MULTILINE = 4096;
    static final int PASSWORD = 8192;
    static final int NO_TOGGLE_TO_OFF = 16384;
    static final int RADIO = 32768;
    static final int PUSHBUTTON = 65536;
    static final int COMBO = 131072;
    static final int EDIT = 262144;
    static final int SORT = 524288;
    static final int FILE_SELECT = 0x100000;
    static final int MULTI_SELECT = 0x200000;
    static final int DO_NOT_SPELL_CHECK = 0x400000;
    static final int DO_NOT_SROLL = 0x800000;
    static final int SA_INCLUDE = 1;
    static final int SA_INCLUDE_NO_VALUE_FIELDS = 2;
    static final int SA_EXPORT_FORMAT = 4;
    static final int SA_GET_METHOD = 8;
    static final int SA_SUBMIT_COORDINATES = 16;
    static final int SA_XFDF = 32;
    static final int SA_INCLUDE_APPEND_SAVES = 64;
    static final int SA_INCLUDE_ANNOTATIONS = 128;
    static final int SA_SUBMIT_PDF = 256;
    static final int SA_CANONICAL_FORMAT = 512;
    static final int SA_EXCL_NON_USER_ANNOTS = 1024;
    static final int SA_EXCL_F_KEY = 2048;
    static final int SA_EMBED_FORM = 8192;
    static final short O_SUBMIT_FORMAT_FDF = 0;
    static final short O_SUBMIT_FORMAT_HTML = 1;
    static final short O_SUBMIT_FORMAT_XFDF = 2;
    static final short O_SUBMIT_FORMAT_PDF = 3;
    static final short O_SUBMIT_METHOD_POST = 0;
    static final short O_SUBMIT_METHOD_GET = 1;
    static final short JS_KEYSTROKE = 0;
    static final short JS_FORMAT = 1;
    static final short JS_VALIDATE = 2;
    static final short JS_CALCULATE = 3;
    static final short JS_BLUR = 4;
    static final short JS_FOCUS = 5;
    static final short JS_MOUSEDOWN = 6;
    static final short JS_MOUSEUP = 7;
    static final short JS_MOUSEENTER = 8;
    static final short JS_MOUSEEXIT = 9;
    static final Hashtable submitActions = new Hashtable();
    static final String DEFAULT_SUBMIT_FORMAT = "FDF";
    static final String DEFAULT_SUBMIT_METHOD = "POST";
    static final String offStateName = "Off";
    static final float[] transparent_color;
    private final String name;
    private int properties;
    private int fieldno = -1;
    private Hashtable fonts = new Hashtable();
    private List colors = new List();
    List appearanceStreams = new List();
    short type = 0;
    String caption = null;
    float[] current_color = new float[]{0.0f};
    float[] background_color = null;
    float[] border_color = null;
    String js_keystroke = null;
    String js_format = null;
    String js_validate = null;
    String js_calculate = null;
    String js_blur = null;
    String js_focus = null;
    String js_mousedown = null;
    String js_mouseup = null;
    String js_mouseenter = null;
    String js_mouseexit = null;

    AcroField(String string, IndirectObject indirectObject, float f, float f2, float f3, float f4) {
        super(indirectObject, f, f2, f3, f4);
        this.name = string;
        this.properties = 0;
        this.border_width = 0.0f;
    }

    abstract String getFieldType();

    abstract void writeAcroField(PDFOutputStream var1);

    abstract void addOption(String var1, boolean var2);

    public void setProperties(int n) {
        this.properties |= n;
    }

    public int getProperties() {
        return this.properties;
    }

    public void setFieldNo(int n) {
        this.fieldno = n;
    }

    public int getFieldNo() {
        return this.fieldno;
    }

    public String getName() {
        return this.name;
    }

    public void addFont(String string, String string2) {
        if (!this.fonts.containsKey(string)) {
            this.fonts.put(string, string2);
        }
    }

    public void addColor(String string) {
        this.colors.append(string);
    }

    public void cloneAdditionalActions(AcroField acroField) {
        this.js_keystroke = acroField.js_keystroke;
        this.js_format = acroField.js_format;
        this.js_validate = acroField.js_validate;
        this.js_calculate = acroField.js_calculate;
        this.js_blur = acroField.js_blur;
        this.js_focus = acroField.js_focus;
        this.js_mousedown = acroField.js_mousedown;
        this.js_mouseup = acroField.js_mouseup;
        this.js_mouseenter = acroField.js_mouseenter;
        this.js_mouseexit = acroField.js_mouseexit;
    }

    String getSubType() {
        return "Widget";
    }

    void write_border_style(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.print(" /BS<<");
        pDFOutputStream.print("/W " + PDFOutputStream.pdf_float(this.border_width));
        if (this.border_width != 0.0f) {
            if (this.border_style != 0) {
                pDFOutputStream.print("/S /" + Annot.border_style_names[this.border_style]);
            }
            if (this.border_style == 1) {
                pDFOutputStream.print("/D [" + PDFOutputStream.pdf_float(this.border_dash1) + " " + PDFOutputStream.pdf_float(this.border_dash2) + "]");
            }
        }
        pDFOutputStream.print(">>");
    }

    private void writeAppearanceStream(PDFOutputStream pDFOutputStream) {
        if (this.appearanceStreams.length() > 0) {
            boolean bl;
            pDFOutputStream.print(" /AP <</N");
            boolean bl2 = bl = this.appearanceStreams.length() > 1;
            if (bl) {
                pDFOutputStream.print(" <<");
            }
            Enumeration enumeration = this.appearanceStreams.elements();
            while (enumeration.hasMoreElements()) {
                AppearanceStream appearanceStream = (AppearanceStream)enumeration.nextElement();
                if (bl) {
                    pDFOutputStream.print(" /" + appearanceStream.streamName);
                }
                pDFOutputStream.print(" " + appearanceStream.getID().toStringR());
            }
            if (bl) {
                pDFOutputStream.print(">> ");
            }
            pDFOutputStream.print(">>");
        }
    }

    protected void writeMKDict(PDFOutputStream pDFOutputStream) {
        if (this.background_color != null || this.border_color != null) {
            int n;
            pDFOutputStream.print(" /MK<<");
            if (this.background_color != null) {
                pDFOutputStream.print("/BG [");
                n = 0;
                while (n < this.background_color.length) {
                    pDFOutputStream.print(" " + this.background_color[n]);
                    ++n;
                }
                pDFOutputStream.print("]");
            }
            if (this.border_color != null) {
                pDFOutputStream.print("/BC [");
                n = 0;
                while (n < this.border_color.length) {
                    pDFOutputStream.print(" " + this.border_color[n]);
                    ++n;
                }
                pDFOutputStream.print("]");
            }
            pDFOutputStream.print(">>");
        }
    }

    protected void setAdditionalAction(short s, String string) {
        switch (s) {
            case 0: {
                this.js_keystroke = string;
                break;
            }
            case 1: {
                this.js_format = string;
                break;
            }
            case 2: {
                this.js_validate = string;
                break;
            }
            case 3: {
                this.js_calculate = string;
                break;
            }
            case 4: {
                this.js_blur = string;
                break;
            }
            case 5: {
                this.js_focus = string;
                break;
            }
            case 6: {
                this.js_mousedown = string;
                break;
            }
            case 7: {
                this.js_mouseup = string;
                break;
            }
            case 8: {
                this.js_mouseenter = string;
                break;
            }
            case 9: {
                this.js_mouseexit = string;
                break;
            }
            default: {
                throw new RuntimeException("unsupported Additional Action:" + s);
            }
        }
    }

    protected void writeAdditionalActions(PDFOutputStream pDFOutputStream) {
        if (this.js_keystroke != null || this.js_format != null || this.js_validate != null || this.js_calculate != null || this.js_blur != null || this.js_focus != null || this.js_mousedown != null || this.js_mouseup != null || this.js_mouseenter != null || this.js_mouseexit != null) {
            pDFOutputStream.print(" /AA<<");
            if (this.js_keystroke != null) {
                pDFOutputStream.print("/K <</JS");
                pDFOutputStream.printStringPDFEncoding(this.js_keystroke);
                pDFOutputStream.print("/S/JavaScript>>");
            }
            if (this.js_format != null) {
                pDFOutputStream.print("/F <</JS");
                pDFOutputStream.printStringPDFEncoding(this.js_format);
                pDFOutputStream.print("/S/JavaScript>>");
            }
            if (this.js_validate != null) {
                pDFOutputStream.print("/V <</JS");
                pDFOutputStream.printStringPDFEncoding(this.js_validate);
                pDFOutputStream.print("/S/JavaScript>>");
            }
            if (this.js_calculate != null) {
                pDFOutputStream.print("/C <</JS");
                pDFOutputStream.printStringPDFEncoding(this.js_calculate);
                pDFOutputStream.print("/S/JavaScript>>");
            }
            if (this.js_blur != null) {
                pDFOutputStream.print("/Bl <</JS");
                pDFOutputStream.printStringPDFEncoding(this.js_blur);
                pDFOutputStream.print("/S/JavaScript>>");
            }
            if (this.js_focus != null) {
                pDFOutputStream.print("/Fo <</JS");
                pDFOutputStream.printStringPDFEncoding(this.js_focus);
                pDFOutputStream.print("/S/JavaScript>>");
            }
            if (this.js_mousedown != null) {
                pDFOutputStream.print("/D <</JS");
                pDFOutputStream.printStringPDFEncoding(this.js_mousedown);
                pDFOutputStream.print("/S/JavaScript>>");
            }
            if (this.js_mouseup != null) {
                pDFOutputStream.print("/U <</JS");
                pDFOutputStream.printStringPDFEncoding(this.js_mouseup);
                pDFOutputStream.print("/S/JavaScript>>");
            }
            if (this.js_mouseenter != null) {
                pDFOutputStream.print("/E <</JS");
                pDFOutputStream.printStringPDFEncoding(this.js_mouseenter);
                pDFOutputStream.print("/S/JavaScript>>");
            }
            if (this.js_mouseexit != null) {
                pDFOutputStream.print("/X <</JS");
                pDFOutputStream.printStringPDFEncoding(this.js_mouseexit);
                pDFOutputStream.print("/S/JavaScript>>");
            }
            pDFOutputStream.print(">>");
        }
    }

    protected void writeResourceDict(PDFOutputStream pDFOutputStream) {
        if (!this.fonts.isEmpty()) {
            pDFOutputStream.print(" /DA(");
            Enumeration enumeration = this.fonts.elements();
            while (enumeration.hasMoreElements()) {
                pDFOutputStream.print(" " + enumeration.nextElement());
            }
            Enumeration enumeration2 = this.colors.elements();
            while (enumeration2.hasMoreElements()) {
                pDFOutputStream.print(" " + enumeration2.nextElement());
            }
            pDFOutputStream.print(")");
            pDFOutputStream.print(" /DR<</Font<<");
            Enumeration enumeration3 = this.fonts.keys();
            while (enumeration3.hasMoreElements()) {
                pDFOutputStream.print(" " + pDFOutputStream.trailer.catalog.acroFormFonts.get(enumeration3.nextElement()));
            }
            pDFOutputStream.print(">>>>");
        }
    }

    void writeAnnotBody(PDFOutputStream pDFOutputStream) {
        if (this.type != 2) {
            pDFOutputStream.print(" /FT/" + this.getFieldType());
            pDFOutputStream.print(" /Ff " + this.properties);
            pDFOutputStream.print(" /T");
            pDFOutputStream.printStringPDFEncoding(this.name);
        }
        this.writeMKDict(pDFOutputStream);
        this.writeResourceDict(pDFOutputStream);
        this.writeAppearanceStream(pDFOutputStream);
        this.writeAcroField(pDFOutputStream);
        this.writeAdditionalActions(pDFOutputStream);
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        Enumeration enumeration = this.appearanceStreams.elements();
        while (enumeration.hasMoreElements()) {
            ((AppearanceStream)enumeration.nextElement()).write(pDFOutputStream);
        }
    }

    static {
        submitActions.put(DEFAULT_SUBMIT_FORMAT, new Short(0));
        submitActions.put("HTML", new Short(1));
        submitActions.put("XFDF", new Short(2));
        submitActions.put("PDF", new Short(3));
        submitActions.put(DEFAULT_SUBMIT_METHOD, new Short(0));
        submitActions.put("GET", new Short(1));
        transparent_color = new float[]{0.0f, 0.0f, 0.0f};
    }

    public static class Radio
    extends AcroField {
        public Button.RadioGroup parent;

        Radio(AcroField acroField, Button.RadioGroup radioGroup) {
            this(acroField.name, acroField.getID(), acroField.rect[0], acroField.rect[1], acroField.rect[2], acroField.rect[3], radioGroup);
            this.cloneAdditionalActions(acroField);
        }

        Radio(String string, IndirectObject indirectObject, float f, float f2, float f3, float f4, Button.RadioGroup radioGroup) {
            super(string, indirectObject, f, f2, f3, f4);
            this.parent = radioGroup;
            this.type = (short)2;
        }

        protected void writeMKDict(PDFOutputStream pDFOutputStream) {
            int n;
            pDFOutputStream.print(" /MK<</CA");
            pDFOutputStream.printStringPDFEncoding(this.caption);
            if (this.background_color != null) {
                pDFOutputStream.print(" /BG[");
                n = 0;
                while (n < this.background_color.length) {
                    pDFOutputStream.print(" " + this.background_color[n]);
                    ++n;
                }
                pDFOutputStream.print("]");
            }
            if (this.border_color != null) {
                pDFOutputStream.print(" /BC[");
                n = 0;
                while (n < this.border_color.length) {
                    pDFOutputStream.print(" " + this.border_color[n]);
                    ++n;
                }
                pDFOutputStream.print("]");
            }
            pDFOutputStream.print(">>");
        }

        String getFieldType() {
            return null;
        }

        void addOption(String string, boolean bl) {
        }

        void writeAcroField(PDFOutputStream pDFOutputStream) {
            String string = AcroField.offStateName;
            pDFOutputStream.print(" /AS /");
            Enumeration enumeration = this.appearanceStreams.elements();
            while (enumeration.hasMoreElements()) {
                AppearanceStream appearanceStream = (AppearanceStream)enumeration.nextElement();
                if (!appearanceStream.initiallySelected) continue;
                string = appearanceStream.streamName;
                break;
            }
            pDFOutputStream.print(string);
            pDFOutputStream.print(" /Parent " + this.parent.getID().toStringR());
        }
    }

    public static class Choice
    extends AcroField {
        private final boolean multiSelect;
        private List options;
        private boolean hasSelected;

        Choice(AcroField acroField, boolean bl) {
            this(acroField.name, acroField.getID(), acroField.rect[0], acroField.rect[1], acroField.rect[2], acroField.rect[3], bl);
            this.cloneAdditionalActions(acroField);
        }

        Choice(String string, IndirectObject indirectObject, float f, float f2, float f3, float f4, boolean bl) {
            super(string, indirectObject, f, f2, f3, f4);
            this.multiSelect = bl;
            this.options = new List();
            this.hasSelected = false;
        }

        String getFieldType() {
            return "Ch";
        }

        void addOption(String string, boolean bl) {
            List list = new List();
            this.options.snoc(list.append(string).append(new Boolean(bl)));
            if (bl) {
                this.hasSelected = true;
            }
        }

        private void writeValue(String string, PDFOutputStream pDFOutputStream) {
            boolean bl = false;
            if (this.hasSelected) {
                pDFOutputStream.print(" " + string);
                pDFOutputStream.print(this.multiSelect ? "[" : "");
                Enumeration enumeration = this.options.elements();
                while (enumeration.hasMoreElements()) {
                    List list = (List)enumeration.nextElement();
                    if (!((Boolean)list.last()).booleanValue()) continue;
                    if (this.multiSelect || !bl) {
                        pDFOutputStream.print_annotation((String)list.car());
                    }
                    bl = true;
                }
                pDFOutputStream.print(this.multiSelect ? "]" : "");
            }
        }

        void writeAcroField(PDFOutputStream pDFOutputStream) {
            this.writeValue("/V", pDFOutputStream);
            this.writeValue("/DV", pDFOutputStream);
            pDFOutputStream.print(" /Opt[");
            Enumeration enumeration = this.options.elements();
            while (enumeration.hasMoreElements()) {
                pDFOutputStream.print_annotation((String)((List)enumeration.nextElement()).car());
            }
            pDFOutputStream.print("]");
            if (this.multiSelect && this.hasSelected) {
                int n = 0;
                pDFOutputStream.print(" /I [");
                Enumeration enumeration2 = this.options.elements();
                while (enumeration2.hasMoreElements()) {
                    List list = (List)enumeration2.nextElement();
                    if (((Boolean)list.last()).booleanValue()) {
                        pDFOutputStream.print("" + n + " ");
                    }
                    ++n;
                }
                pDFOutputStream.print("]");
            }
        }
    }

    public static abstract class Button
    extends AcroField {
        Button(String string, IndirectObject indirectObject, float f, float f2, float f3, float f4) {
            super(string, indirectObject, f, f2, f3, f4);
        }

        String getFieldType() {
            return "Btn";
        }

        public static class RadioGroup
        extends Button {
            public List buttons = new List();

            RadioGroup(AcroField acroField) {
                this(acroField.name, acroField.getID(), acroField.rect[0], acroField.rect[1], acroField.rect[2], acroField.rect[3]);
                this.cloneAdditionalActions(acroField);
            }

            RadioGroup(String string, IndirectObject indirectObject, float f, float f2, float f3, float f4) {
                super(string, indirectObject, f, f2, f3, f4);
            }

            void writeAcroField(PDFOutputStream pDFOutputStream) {
                String string = null;
                pDFOutputStream.print(" /Kids [");
                Enumeration enumeration = this.buttons.elements();
                block0: while (enumeration.hasMoreElements()) {
                    Radio radio = (Radio)enumeration.nextElement();
                    pDFOutputStream.print(radio.getID().toStringR() + " ");
                    Enumeration enumeration2 = radio.appearanceStreams.elements();
                    while (enumeration2.hasMoreElements()) {
                        AppearanceStream appearanceStream = (AppearanceStream)enumeration2.nextElement();
                        if (!appearanceStream.initiallySelected || AcroField.offStateName.equals(appearanceStream.streamName)) continue;
                        string = appearanceStream.streamName;
                        continue block0;
                    }
                }
                pDFOutputStream.print("]");
                if (string != null) {
                    pDFOutputStream.print(" /V/" + string);
                    pDFOutputStream.print(" /DV/" + string);
                }
            }

            void addOption(String string, boolean bl) {
            }

            void writeSubObjects(PDFOutputStream pDFOutputStream) {
                Enumeration enumeration = this.buttons.elements();
                while (enumeration.hasMoreElements()) {
                    ((Radio)enumeration.nextElement()).write(pDFOutputStream);
                }
            }
        }

        public static class Checkbox
        extends Button {
            Checkbox(AcroField acroField) {
                this(acroField.name, acroField.getID(), acroField.rect[0], acroField.rect[1], acroField.rect[2], acroField.rect[3]);
                this.cloneAdditionalActions(acroField);
            }

            Checkbox(String string, IndirectObject indirectObject, float f, float f2, float f3, float f4) {
                super(string, indirectObject, f, f2, f3, f4);
                this.type = (short)3;
            }

            protected void writeMKDict(PDFOutputStream pDFOutputStream) {
                int n;
                pDFOutputStream.print(" /MK<</CA");
                pDFOutputStream.printStringPDFEncoding(this.caption);
                if (this.background_color != null) {
                    pDFOutputStream.print(" /BG[");
                    n = 0;
                    while (n < this.background_color.length) {
                        pDFOutputStream.print(" " + this.background_color[n]);
                        ++n;
                    }
                    pDFOutputStream.print("]");
                }
                if (this.border_color != null) {
                    pDFOutputStream.print(" /BC[");
                    n = 0;
                    while (n < this.border_color.length) {
                        pDFOutputStream.print(" " + this.border_color[n]);
                        ++n;
                    }
                    pDFOutputStream.print("]");
                }
                pDFOutputStream.print(">>");
            }

            void writeAcroField(PDFOutputStream pDFOutputStream) {
                String string = AcroField.offStateName;
                pDFOutputStream.print(" /AS /");
                Enumeration enumeration = this.appearanceStreams.elements();
                while (enumeration.hasMoreElements()) {
                    AppearanceStream appearanceStream = (AppearanceStream)enumeration.nextElement();
                    if (!appearanceStream.initiallySelected) continue;
                    string = appearanceStream.streamName;
                    break;
                }
                pDFOutputStream.print(string);
                pDFOutputStream.print(" /V /" + string);
                pDFOutputStream.print(" /DV /" + string);
            }

            void addOption(String string, boolean bl) {
            }
        }

        public static abstract class Pushbutton
        extends Button {
            private final List fields;

            Pushbutton(String string, IndirectObject indirectObject, float f, float f2, float f3, float f4, List list) {
                super(string, indirectObject, f, f2, f3, f4);
                this.fields = list;
            }

            protected void writeMKDict(PDFOutputStream pDFOutputStream) {
                int n;
                pDFOutputStream.print(" /MK<</CA");
                pDFOutputStream.printStringPDFEncoding(this.caption);
                if (this.background_color != null) {
                    pDFOutputStream.print(" /BG[");
                    n = 0;
                    while (n < this.background_color.length) {
                        pDFOutputStream.print(" " + this.background_color[n]);
                        ++n;
                    }
                    pDFOutputStream.print("]");
                }
                if (this.border_color != null) {
                    pDFOutputStream.print(" /BC[");
                    n = 0;
                    while (n < this.border_color.length) {
                        pDFOutputStream.print(" " + this.border_color[n]);
                        ++n;
                    }
                    pDFOutputStream.print("]");
                }
                pDFOutputStream.print(">>");
            }

            protected void print_fileds(PDFOutputStream pDFOutputStream) {
                if (this.fields != null && !this.fields.isEmpty()) {
                    pDFOutputStream.print(" /Fields [");
                    Enumeration enumeration = this.fields.elements();
                    while (enumeration.hasMoreElements()) {
                        pDFOutputStream.print_annotation((String)enumeration.nextElement());
                    }
                    pDFOutputStream.print("]");
                }
            }

            void addOption(String string, boolean bl) {
            }

            public static class Reset
            extends Pushbutton {
                Reset(AcroField acroField, List list) {
                    this(acroField.name, acroField.getID(), acroField.rect[0], acroField.rect[1], acroField.rect[2], acroField.rect[3], list);
                    this.cloneAdditionalActions(acroField);
                }

                Reset(String string, IndirectObject indirectObject, float f, float f2, float f3, float f4, List list) {
                    super(string, indirectObject, f, f2, f3, f4, list);
                    this.type = (short)6;
                }

                void writeAcroField(PDFOutputStream pDFOutputStream) {
                    pDFOutputStream.print(" /A <</S /ResetForm");
                    this.print_fileds(pDFOutputStream);
                    pDFOutputStream.print(">>");
                }
            }

            public static class Submit
            extends Pushbutton {
                private final String url;
                private int action_flags;

                Submit(AcroField acroField, List list, String string) {
                    this(acroField.name, acroField.getID(), acroField.rect[0], acroField.rect[1], acroField.rect[2], acroField.rect[3], list, string);
                    this.cloneAdditionalActions(acroField);
                }

                Submit(String string, IndirectObject indirectObject, float f, float f2, float f3, float f4, List list, String string2) {
                    super(string, indirectObject, f, f2, f3, f4, list);
                    this.url = string2;
                    this.type = (short)7;
                }

                void setSubmitActionFlags(int n) {
                    this.action_flags |= n;
                }

                void writeAcroField(PDFOutputStream pDFOutputStream) {
                    pDFOutputStream.print(" /A <</S /SubmitForm /F ");
                    pDFOutputStream.printStringPDFEncoding(this.url);
                    this.print_fileds(pDFOutputStream);
                    pDFOutputStream.print(" /Flags " + this.action_flags);
                    pDFOutputStream.print(">>");
                }
            }
        }
    }

    public static class Text
    extends AcroField {
        private final int maxlen;
        private final String text;

        Text(AcroField acroField, String string, int n) {
            this(string, acroField.name, acroField.getID(), acroField.rect[0], acroField.rect[1], acroField.rect[2], acroField.rect[3], n);
            this.cloneAdditionalActions(acroField);
        }

        Text(String string, String string2, IndirectObject indirectObject, float f, float f2, float f3, float f4, int n) {
            super(string2, indirectObject, f, f2, f3, f4);
            this.text = string;
            this.maxlen = n;
            this.type = 1;
        }

        String getFieldType() {
            return "Tx";
        }

        void addOption(String string, boolean bl) {
        }

        void writeAcroField(PDFOutputStream pDFOutputStream) {
            pDFOutputStream.print(" /V ");
            pDFOutputStream.print_annotation(this.text);
            pDFOutputStream.print(" /DV ");
            pDFOutputStream.print_annotation(this.text);
            if (this.maxlen > -1) {
                pDFOutputStream.print(" /MaxLen " + this.maxlen);
            }
        }
    }

    public static class Fake
    extends AcroField {
        Fake(String string, IndirectObject indirectObject, float f, float f2, float f3, float f4) {
            super(string, indirectObject, f, f2, f3, f4);
        }

        String getFieldType() {
            return null;
        }

        void writeAcroField(PDFOutputStream pDFOutputStream) {
        }

        void addOption(String string, boolean bl) {
        }
    }
}

