/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.BadICCProfileDataException;
import com.renderx.graphics.ICCProfile;
import com.renderx.graphics.ICCProfileFormatException;
import com.renderx.util.ErrorHandler;
import com.renderx.util.SeekableInput;
import com.renderx.util.URLCache;
import com.renderx.util.URLSpec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ICCRecord {
    private URLSpec iccfile = null;
    private ICCProfile profile = null;
    private final URLCache cache;
    private final ErrorHandler errHandler;

    public ICCRecord(URLSpec uRLSpec, URLCache uRLCache, ErrorHandler errorHandler) {
        this.iccfile = uRLSpec;
        this.cache = uRLCache;
        this.errHandler = errorHandler;
    }

    public synchronized ICCProfile getProfile() {
        block13: {
            if (this.profile != null) {
                return this.profile;
            }
            try {
                SeekableInput seekableInput = this.cache.openSeekableStream(this.iccfile, this.errHandler);
                if (seekableInput == null) break block13;
                try {
                    this.profile = new ICCProfile(seekableInput);
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    seekableInput.close();
                    throw throwable;
                }
                seekableInput.close();
                {
                }
            }
            catch (ICCProfileFormatException iCCProfileFormatException) {
                if (this.errHandler == null) break block13;
                ErrorHandler errorHandler = this.errHandler;
                synchronized (errorHandler) {
                    this.errHandler.error("Unsupported file format or broken file found reading ICC profile from " + this.iccfile + ": " + iCCProfileFormatException.getMessage());
                }
            }
            catch (IOException iOException) {
                if (this.errHandler == null) break block13;
                ErrorHandler errorHandler = this.errHandler;
                synchronized (errorHandler) {
                    this.errHandler.exception("Cannot read ICC profile from " + this.iccfile, iOException);
                }
            }
        }
        if (this.profile == null) {
            throw new BadICCProfileDataException("Could not obtain ICC profile for '" + this.iccfile.toString() + "'");
        }
        return this.profile;
    }

    public void copyData(OutputStream outputStream) throws IOException {
        InputStream inputStream = this.cache.openStream(this.iccfile, this.errHandler);
        try {
            int n;
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }
}

