/**
 * 
 */
package com.renderx.xepx.x4u.ct.nodedscpanel.transformpanel;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.renderx.xepx.x4u.ct.DomToJTreeAdapter;
import com.renderx.xepx.x4u.ct.FontsPanel;

/**
 * @author AlexanderR
 *
 */
public class SizePanel extends JPanel
{
    private static final long serialVersionUID = 2895517157075163526L;

    private FontsPanel parentPanel;
    
    private JCheckBox sizeCheckBox = new JCheckBox();
    private JTextField sizeTextField = new JTextField();    
    
    public SizePanel(FontsPanel _parentPanel)
    {
	this.parentPanel = _parentPanel;
	
        add(sizeCheckBox, null);
        add(sizeTextField, null);
        
        sizeTextField.setName("size");
        sizeTextField.setText("1");      
        sizeTextField.setPreferredSize(new Dimension(40, 19));
        sizeTextField.setEnabled(false);
        
	sizeCheckBox.setText("size");
	
	sizeCheckBox.addActionListener
	(
		new java.awt.event.ActionListener()
                {
                    public void actionPerformed(ActionEvent e)
                    {
                	sizeCheckBox_actionPerformed(e, (Element) parentPanel.getFontNode());
                    }
        });
	
        sizeTextField.addFocusListener
        (
        	new java.awt.event.FocusAdapter()
        	{
        	    public void focusLost(FocusEvent e)
        	    {
        		parentPanel.textField_focusLost(e, (Element) parentPanel.getFontNode());
        	    }
        
        	    public void focusGained(FocusEvent e)
        	    {
        		parentPanel.textField_focusGained(e, (Element) parentPanel.getFontNode());
        	    }
        });	
    }
    
    private void sizeCheckBox_actionPerformed(ActionEvent e, Element node)
    {
	boolean state = sizeCheckBox.isSelected();
	
	if (node == null)
	    return;
	
	Element transform;
	NodeList children = node.getElementsByTagName("font");
	if (children.getLength() == 0)
	{
	    transform = node.getOwnerDocument().createElement("font");
	    node.appendChild(transform);
	} else
	{
	    transform = (Element) children.item(0);
	}

	if (state && sizeTextField.getText().trim().length() > 0
		&& Integer.parseInt(sizeTextField.getText().trim()) != 1)
	    transform.setAttribute("size", sizeTextField.getText());

	if (!state)
	{
	    transform.removeAttribute("size");
	    if (transform.getAttributes().getLength() == 0)
		node.removeChild(transform);
	}

	sizeTextField.setEnabled(state);
    }
    
    public String getText()
    {
	return sizeTextField.getText();
    }
    
    public void setText(String text)
    {
	sizeTextField.setText(text);
    }
    
    public void setSelected(boolean value)
    {
	sizeCheckBox.setSelected(value);
    }
    
    public void setEnabled(boolean value)
    {
	sizeTextField.setEnabled(value);
    }
    
    public boolean isSelected()
    {
	return sizeCheckBox.isSelected();
    }
    
    public void setTextFromNode(DomToJTreeAdapter.FontTreeNode node)
    {
	NamedNodeMap attribs = node.getBody().getAttributes();
	if (attribs.getNamedItem("size") != null)
	{
	    setSelected(true);
	    setText(attribs.getNamedItem("size").getNodeValue());
	    setEnabled(true);
	} else
	{
	    setSelected(false);
	    setText("1");
	    setEnabled(false);
	}	
	this.updateUI();
	
	Node sizeNode = node.getBody().getAttributes().getNamedItem("size");
	String sizeValue = "";
	
	if(sizeNode != null)
	    sizeValue = node.getBody().getAttributes().getNamedItem("size").getNodeValue();
	
	setText(sizeValue);
    }
    
}
