package com.renderx.xepx.x4u.ct.charsetspanel;

/**
 * @author: Roschupkin Alexander
 * @version 1.0
 */

import javax.swing.table.*;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Attr;

public class DomToTableMappingModel extends AbstractTableModel
{

    private static final long serialVersionUID = 5493264810504538767L;

    private String[] columnNames = { "Unicode", "AFP", "Desc" }; // for charset aliase only
    Vector rowData; // vector of DOM-Elements
    int colCnt; // 
    Element root; // parent node for table elements (for add/remove action)
    String child; // Element name (languages, font-data or font-alias)
    boolean attrib; // fill rowData from attributes (for font-data) or from subchildren

    public DomToTableMappingModel(Element root, boolean attr)
    {
	if(root.getElementsByTagName("character-mapping").getLength() > 0)
	{
	    NodeList children = root.getElementsByTagName("character-mapping");
	    root = (Element)children.item(0); 
	}
	this.root = root;
	this.attrib = attr;
	if (root.getTagName().equalsIgnoreCase("character-mapping"))
	{
	    colCnt = columnNames.length;
	    child = "character";
	} else
	{
	    colCnt = columnNames.length;
	    child = (attrib) ? "charset" : "character";
	}
	
	rowData = new Vector();
	if (attrib)
	{
	    NodeList children = root.getElementsByTagName("character");
	    Element font_data;
	    if (children.getLength() == 0)
	    {
		font_data = root.getOwnerDocument().createElement("character");
		root.appendChild(font_data);
	    } else
	    {
		font_data = (Element) children.item(0);
		NamedNodeMap lst = font_data.getAttributes();
		for (int i = 0; i < lst.getLength(); i++)
		{
		    rowData.add(lst.item(i));
		}
	    }
	} else
	{
	    NodeList lst = root.getChildNodes(); // getElementsByTagName(child) gives all desendet - dont worked
	    if (lst != null)
	    {
		for (int i = 0; i < lst.getLength(); i++)
		{
		    if (lst.item(i).getNodeName().equals(child))
			rowData.add(lst.item(i));
		}
	    }
	}
    }

    public String getColumnName(int col)
    {
	if (colCnt == 1 || attrib)
	    return null;
	else
	    return columnNames[col].toString();
    }

    public int getRowCount()
    {
	return rowData.size();
    }

    public Class getColumnClass(int c)
    {
	return getValueAt(0, c).getClass();
    }

    public int getColumnCount()
    {
	return colCnt;
    }

    public Object getValueAt(int row, int col)
    {
	if (attrib)
	{
	    Attr t = (Attr) rowData.get(row);
	    return (col == 0) ? t.getNodeName() : t.getNodeValue();
	} else
	{
	    Element t = (Element) rowData.get(row);
	    if (col == 0)
		return t.getAttributes().getNamedItem("unicode") == null 
			? ""
			: t.getAttributes().getNamedItem("unicode").getNodeValue();			    
	    else if (col == 1)
		return t.getAttributes().getNamedItem("afp") == null
			? ""
			: t.getAttributes().getNamedItem("afp").getNodeValue();
	    else 
		return t.getAttributes().getNamedItem("desc") == null
			? ""
			: t.getAttributes().getNamedItem("desc").getNodeValue();
	}
    }

    public Object getNodeAt(int row)
    {
	if (attrib)
	    return (Attr) rowData.get(row);
	else
	    return (Element) rowData.get(row);
    }

    public boolean isCellEditable(int row, int col)
    {
	return true;
    }

    public void setValueAt(Object value, int row, int col)
    {
	if (attrib)
	{
	    Attr t = (Attr) rowData.get(row);
	    Element font_data = (Element) root.getElementsByTagName(
		    "character").item(0);
	    if (col == 0)
	    {
		rowData.remove(row);
		font_data.removeAttribute(t.getNodeName());
		font_data.setAttribute(value.toString(), t.getNodeValue());
		rowData.add(row, font_data.getAttributeNode(value.toString()));
	    } else
		font_data.setAttribute(t.getNodeName(), value.toString());
	} else
	{
	    Element t = (Element) rowData.get(row);
	    if (col == 0)
		t.setAttribute("unicode", value.toString());
	    else if (col == 1)
		t.setAttribute("afp", value.toString());
	    else
		t.setAttribute("desc", value.toString());
	}
	fireTableCellUpdated(row, col);
    }

    public void addRow(Element element)
    {
	if (attrib)
	{
	    NodeList ch = element.getElementsByTagName("character");
	    Element prnt; //= root.getOwnerDocument().createElement("font-data");
	    if (ch == null)
	    {
		prnt = root.getOwnerDocument().createElement("character");
		element.appendChild(prnt);
	    } else
		prnt = (Element) ch.item(0);

	    prnt.setAttribute("NEW", "VALUE");
	    Attr t = (Attr) prnt.getAttributes().getNamedItem("NEW");
	    rowData.add(t);
	} else
	    rowData.add(element);
	fireTableDataChanged();
    }

    public void deleteRow(int row)
    {
	rowData.remove(row);
	fireTableDataChanged();
    }

}
