package com.renderx.xepx.x4u.ct.charsetspanel;

import java.awt.event.FocusEvent;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import com.renderx.xepx.x4u.ct.DomToJTreeAdapter;

/**
 * @author AlexanderR
 */

public class CharsetNamePanel extends JPanel
{
    
    private static final long serialVersionUID = 6668833491099603470L;

    private CharsetsPanel parentPanel;
    private Element node;
    
    private JLabel charsetNameLabel = new JLabel();
    private JTextField charsetNameTextField = new JTextField();
    private JTextField source = new JTextField();
    
    public CharsetNamePanel(CharsetsPanel _charsetsPanel)
    {
	this.parentPanel = _charsetsPanel;
	node = new ElementImpl();
	setVisible(false);
	
	add(charsetNameLabel, null);
        add(charsetNameTextField, null);

        charsetNameLabel.setText("Charset name:");
        charsetNameTextField.setColumns(10);
        charsetNameTextField.setText("");
        charsetNameTextField.setName("charset-name");
        charsetNameTextField.setActionCommand("charset-name");
        source.setName("");
        
        charsetNameTextField.getDocument().addDocumentListener
        (
        	new DocumentListener()
        	{
        	  public void insertUpdate(DocumentEvent e) 
        	  {
        	      parentPanel.textField_focusLost(source, (Element) parentPanel.getCharsetNode());
        	  };
        	  public void removeUpdate(DocumentEvent e) 
        	  { 
        	      parentPanel.textField_focusLost(source, (Element) parentPanel.getCharsetNode());
        	  };
        	  public void changedUpdate(DocumentEvent e) 
        	  { 
        	  };
        	}
        );
      
      charsetNameTextField.addFocusListener(new java.awt.event.FocusAdapter()
      {
          public void focusLost(FocusEvent e)
          {
          }
      
          public void focusGained(FocusEvent e)
          {
              parentPanel.textField_focusGained(e, (Element) parentPanel.getCharsetNode());
          }
      });	
    }
    
    public String getText()
    {
	return charsetNameTextField.getText();
    }
    
    
    public void setTextFromNode(DomToJTreeAdapter.FontTreeNode node)
    {
	NamedNodeMap attribs = node.getBody().getAttributes();
	if (attribs.getNamedItem("name") != null)
	{
	    setText(attribs.getNamedItem("name").getNodeValue());
	    setEnabled(true);
	} else
	{
	    setText("11");
	    setEnabled(false);
	}	
	this.updateUI();
	
	Node sizeNode = node.getBody().getAttributes().getNamedItem("name");
	String sizeValue = "";
	
	if(sizeNode != null)
	    sizeValue = node.getBody().getAttributes().getNamedItem("name").getNodeValue();
	
	setText(sizeValue);
    }

    public void setText(String text)
    {
	charsetNameTextField.setText(text);
    }
    
    public void setEnabled(boolean value)
    {
	charsetNameTextField.setEnabled(value);
    }

    public JTextField getSource()
    {
        return source;
    }

    public void setSource(JTextField source)
    {
        this.source = source;
    }
    public Element getNode()
    {
        return node;
    }

    public void setNode(Element node)
    {
        this.node = node;
    }    
}
