package com.renderx.xepx.x4u.ct;

import javax.xml.parsers.*;
import org.w3c.dom.*;
import java.io.*;
import org.xml.sax.*;
import org.xml.sax.SAXException;
import java.util.*;
import javax.swing.*;
//////import com.renderx.sax.*;

public class DOMWalker{
	
  public static final String OPTIONS_TAG = "options";
  public static final String BACKEND_TAG = "generator-options";
  public static final String FORMAT_ATT = "format";
  public static final String VAL_UNDEF = "default";
  public static final int BACKEND_COUNT = 6; // current supported
  public static final String[] BACKEND_NAMES = {"PDF","PostScript","AFP","SVG","HTML","PPML"};

  /////////////  root and subroot  ///////////////
  static Element cnfRoot; // root nodes for xep configuration part
  public static Element optRoot; // accesible from all panel thru the model instance of DOMWalker.
  public static Element fntRoot; // Co for access to the some attribute of subnode we can use the snapshot:
  public static Element chrRoot;
  static Element lngRoot; //    DOMWalker.cnfRoot.removeAttribute("xml:base");

  protected static Serializer handler = null;
  private static DocumentBuilder builder;
  static File fl;
  public static org.w3c.dom.Document doc;// = null;

  //////// Document specific params //////////
  java.io.InputStream is;
  public String path="xep.xml";

  // Singleton pattern
  private static DOMWalker _instance = null;
  public static DOMWalker getDOMWalker(String pathToConfigurationFile){
    if(_instance == null) _instance = new DOMWalker(pathToConfigurationFile);
    return _instance;
  }
  public static DOMWalker getDOMWalker(Document doc){
    if(_instance == null) _instance = new DOMWalker(doc);
    return _instance;
  }

   private DOMWalker(String pathToConfigurationFile) {
    try {
      path = pathToConfigurationFile;
      builder = javax.xml.parsers.DocumentBuilderFactory.newInstance().newDocumentBuilder();
      fl = new File(pathToConfigurationFile);
      is = new BufferedInputStream(new FileInputStream(fl));
      doc = builder.parse(fl);
      initRoots();
    } catch (IOException ex1) {showError(ex1);}
      catch (SAXException ex1) {showError(ex1);}
      catch (FactoryConfigurationError ex){showError(new Exception(ex.getMessage()));}
      catch (ParserConfigurationException ex) {showError(ex);}
  }

  private DOMWalker(Document doc){
    this.doc = doc;
    initRoots();
  }

  void initRoots(){
    cnfRoot = doc.getDocumentElement();
    optRoot = (Element)cnfRoot.getElementsByTagName("options").item(0);
    fntRoot = (Element)cnfRoot.getElementsByTagName("fonts").item(0);
    lngRoot = (Element)cnfRoot.getElementsByTagName("languages").item(0);
    chrRoot = (Element)cnfRoot.getElementsByTagName("charsets").item(0);
  }

  public  void walk(Document ddd) throws org.xml.sax.SAXException 
  {
    Node docroot = ddd.getDocumentElement();
    handler.startDocument();
    if (docroot != null) 
    {
	org.w3c.dom.Document ownerdoc = docroot.getOwnerDocument();
	
	if (ownerdoc == null)
	    throw new org.xml.sax.SAXException ("DOM element does not have an owner document: cannot determine DOM Level");
	
	org.w3c.dom.DOMImplementation impl = ownerdoc.getImplementation();
	
	if (impl.hasFeature("XML", "2.0")) 
	    traverseNS(docroot);
	else 
	    throw new org.xml.sax.SAXException ("DOM Level 1 traversal unsupported");
    }
    handler.endDocument();
  }
  private void traverseNS (org.w3c.dom.Node node) throws org.xml.sax.SAXException 
  {
    if (node==null) 
	return;
    switch (node.getNodeType()) 
    {
      case org.w3c.dom.Node.ELEMENT_NODE:
        String name = null, qname = null, uri = null;
        org.w3c.dom.NamedNodeMap map = node.getAttributes();
        org.xml.sax.helpers.AttributesImpl attrs = new org.xml.sax.helpers.AttributesImpl();
        if (map != null) 
        {
          for (int i=0; i<map.getLength(); i++) 
          {
            org.w3c.dom.Attr a = (org.w3c.dom.Attr)map.item(i);
            qname = a.getName();
            if (qname.startsWith("xmlns:") || qname.equals("xmlns")) 
        	continue;
            name = a.getLocalName(); if (name == null) name = qname;
            uri = a.getNamespaceURI(); if (uri == null) uri = "";
            if (a.getParentNode() != null)System.out.println("Node parent: "+a.getParentNode().getNodeName());
            attrs.addAttribute(uri, name, qname, "CDATA", a.getValue());
          }
        }
        org.w3c.dom.Element el = (org.w3c.dom.Element)node;
        name = el.getLocalName();
        qname = el.getTagName(); if (name == null) name = qname;
        uri = el.getNamespaceURI();  if (uri == null) uri = "";
        handler.startElement(uri, name, qname, attrs);
        org.w3c.dom.NodeList children = node.getChildNodes();
        if (children != null) {
          for (int i=0; i<children.getLength(); i++)
          {
              traverseNS(children.item(i));  
          }            
        }
        handler.endElement(uri, name, qname);
        break;

      case org.w3c.dom.Node.CDATA_SECTION_NODE:
      case org.w3c.dom.Node.TEXT_NODE:
        String text = node.getNodeValue();
        if (text==null) break;
        handler.characters(text.toCharArray(), 0, text.length());
        break;
      case org.w3c.dom.Node.COMMENT_NODE:
        String comm = node.getNodeValue();
        handler.comment(comm.toCharArray(),0,comm.length());
        break;

      case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:
        org.w3c.dom.ProcessingInstruction pi = (org.w3c.dom.ProcessingInstruction) node;
        handler.processingInstruction(pi.getTarget(), pi.getData());
        break;
    }
  }


  static ArrayList getNodesName(String root){
    ArrayList temp = new ArrayList();
    NodeList nl = doc.getDocumentElement().getElementsByTagName(root);
    for(int i=0;i< nl.getLength(); i++){
      Element nd = (Element)nl.item(i);
        if(nd.getNodeName().equals(root)){
          temp.add(nd.getAttributeNode("name").getNodeValue());
        }
    }
    return temp;
  }

  public static String[] getLanguages(){
    ArrayList tmp = getNodesName("language");
    return (String[]) tmp.toArray(new String[tmp.size()]);
  }

  public static String[] getFonts(){
    ArrayList tmp = getNodesName("font-family");
    return (String[]) tmp.toArray(new String[tmp.size()]);
  }


  public static Map getLngDetail(String lngName){
    Map res = new TreeMap();
    Vector fntAliases = new Vector();
    NodeList all = cnfRoot.getElementsByTagName("language");//getSubTree("language");
    for (int i = 0; i< all.getLength(); i++){
      org.w3c.dom.Node lngNode = all.item(i);
      NamedNodeMap lngAtt = lngNode.getAttributes();
      if (lngAtt.getNamedItem("name") != null &&
          lngAtt.getNamedItem("name").getNodeValue().equalsIgnoreCase(lngName)) {
        res.put("codes",lngAtt.getNamedItem("codes").getNodeValue());
        org.w3c.dom.NodeList lngSubNodeList = lngNode.getChildNodes();
        for (int j=0; j<lngSubNodeList.getLength(); j++) {
          org.w3c.dom.Node lngSubNode = lngSubNodeList.item(j);
          if (lngSubNode.getNodeName() == "hyphenation"){
            NamedNodeMap hippAtt = lngSubNode.getAttributes();
            if (hippAtt.getNamedItem("pattern") != null)
              res.put("pattern",hippAtt.getNamedItem("pattern").getNodeValue());
            if (hippAtt.getNamedItem("encoding") != null)
              res.put("encoding",hippAtt.getNamedItem("encoding").getNodeValue());
          } else if(lngSubNode.getNodeName() == "font-alias"){
              Vector tmp = new Vector();
              NamedNodeMap hippAtt = lngSubNode.getAttributes();
              tmp.add(hippAtt.getNamedItem("name").getNodeValue());
              tmp.add(hippAtt.getNamedItem("value").getNodeValue());
              fntAliases.add(tmp);
          }
        }
       }
    }
    if (fntAliases.size() > 0) res.put("font-alias",fntAliases);
    return res;
  }
  public void setContentHandler(Serializer hnd){
    handler = hnd;
  }
  public Document getDoc(){
    return this.doc;
  }

  public static void writeDoc(Document dc, String outFileName){
    try{
      DOMWalker dw = new DOMWalker(dc);
      Writer wr = new java.io.OutputStreamWriter(
          new java.io.FileOutputStream(outFileName), "UTF8");
      dw.setContentHandler(new Serializer(wr));
      dw.walk(dc);
  }catch(java.io.IOException ex){ showError(ex);}
   catch(SAXException sex){showError(sex);}
  }

  public void writeDoc(){
	  Writer wr = null; 
	  try{
		  wr = new java.io.OutputStreamWriter(
				  new java.io.FileOutputStream(new File(path)), "UTF8");
		  this.setContentHandler(new Serializer(wr));
		  this.walk(this.doc);
	  }
	  catch(java.io.IOException ex){ showError(ex);}
	  catch(SAXException sex){showError(sex);}
	  finally {
		  if (wr != null) {
			  try {
			      wr.close();
			  } catch(Exception ex) {
			  }
		  }
	  }
  }

/*  public void removeNode(Node node){
    Node p = node.getParentNode();
    p.removeChild(node);
  }*/

  public void removeNode(Node parent, String nodeName, String attrName, String attValue){
    NodeList list = parent.getChildNodes();
    for (int i = 0; i < list.getLength(); i++) {
      if (list.item(i).getNodeName().equals(nodeName) &&
          list.item(i).getAttributes().getNamedItem(attrName).getNodeValue().equals(attValue)) {
          parent.removeChild(list.item(i));
          break;
      }
    }
		for (int i = 0; i < list.getLength(); i++) {
			int t = list.item(i).getNodeType();
			if (t == Element.TEXT_NODE || t == Element.CDATA_SECTION_NODE) parent.removeChild(list.item(i));
		}
		
		list = parent.getChildNodes();
		int n = list.getLength();
		Node tn = (Node) parent.getOwnerDocument().createTextNode("\n\t\t\t");
		while (n>0) {
			n = n-1;
			if (!(list.item(n).getNodeType()==Element.TEXT_NODE) && 
			!(list.item(n).getNodeType()==Element.CDATA_SECTION_NODE)) {
				parent.insertBefore(tn.cloneNode(true),list.item(n));
			}
		}
		Node tn1 = (Node) parent.getOwnerDocument().createTextNode("\n\t\t");
		parent.appendChild(tn1.cloneNode(true));

  }


  public void setNameValueAttrs(Node parent,String nodeName, String attName, String attValue){
   NodeList list = parent.getChildNodes();
   Element tmp = null;
   for (int i = 0; i < list.getLength(); i++) {
     if (list.item(i).getNodeName().equalsIgnoreCase(nodeName) &&
         list.item(i).getAttributes().getNamedItem("name") != null &&
         list.item(i).getAttributes().getNamedItem("name").getNodeValue().equals(attName)) {
         tmp = (Element)list.item(i);
         break;
     }
   }
   if(tmp == null){
     tmp = parent.getOwnerDocument().createElement(nodeName);
     parent.appendChild(tmp);
     tmp.setAttribute("name",attName);
   }
   tmp.setAttribute("value",attValue);
	 
		list = parent.getChildNodes();
		for (int i = 0; i < list.getLength(); i++) {
			int t = list.item(i).getNodeType();
			if (t == Element.TEXT_NODE || t == Element.CDATA_SECTION_NODE) parent.removeChild(list.item(i));
		}
		
		list = parent.getChildNodes();
		int n = list.getLength();
		Node tn = (Node) parent.getOwnerDocument().createTextNode("\n\t\t\t");
		while (n>0) {
			n = n-1;
			if (!(list.item(n).getNodeType()==Element.TEXT_NODE) && 
			!(list.item(n).getNodeType()==Element.CDATA_SECTION_NODE)) {
				parent.insertBefore(tn.cloneNode(true),list.item(n));
			}
		}
		Node tn1 = (Node) parent.getOwnerDocument().createTextNode("\n\t\t");
		parent.appendChild(tn1.cloneNode(true));

  }
	


  public static final class Test extends junit.framework.TestCase {
    DocumentBuilder builder;
    Document doc;
    ByteArrayInputStream inForTest;
    ByteArrayOutputStream outForRes = new ByteArrayOutputStream();
    ByteArrayOutputStream outForIn = new ByteArrayOutputStream();
    DOMWalker tester;
    Writer wr;
    public Test() {
      ByteArrayInputStream inStart = new ByteArrayInputStream(XEP_XML_Test.xep_xml.getBytes());
      wr = new java.io.OutputStreamWriter(outForIn);
      try {
        builder = javax.xml.parsers.DocumentBuilderFactory.newInstance().
            newDocumentBuilder();
        doc = builder.parse(inStart);
      }
      catch (IOException ex) {}
      catch (SAXException ex) {
        showError(ex);
      }
      catch (FactoryConfigurationError ex) {}
      catch (ParserConfigurationException ex) {
        showError(ex);
      }
      tester = new DOMWalker(doc);
      tester.setContentHandler(new Serializer(wr));
      try {
        tester.walk(doc);
        inForTest = new ByteArrayInputStream(outForIn.toByteArray());
        doc = builder.parse(inForTest); //  testXML);
        tester = new DOMWalker(doc);
      }
      catch (SAXException ex1) {}
      catch (IOException ex) {
        showError(ex);
      }
    }

    public void testRoots(){
      tester.initRoots();
      assertTrue(tester.cnfRoot.getNodeName().equalsIgnoreCase("config"));
      assertTrue(tester.optRoot.getNodeName().equalsIgnoreCase("options"));
      assertTrue(tester.fntRoot.getNodeName().equalsIgnoreCase("fonts"));
      assertTrue(tester.lngRoot.getNodeName().equalsIgnoreCase("languages"));
    }
    public void testReadWrite() {
      try {
        wr = new java.io.OutputStreamWriter(outForRes);
        tester.setContentHandler(new Serializer(wr));
        tester.walk(doc);
        assertTrue( (outForRes.toString()).equals(outForIn.toString()));
      }
      catch (SAXException ex1) {}

    }

   public void testRemoveNode() {
      Node node = doc.getElementsByTagName("options").item(0);
      tester.removeNode(node,"option","name","LICENSE");
      assertTrue((node.toString()).indexOf("LICENSE") < 0);
      tester.removeNode(node, "option", "name", "TMPDIR");
      assertTrue((doc.toString()).indexOf("TMPDIR") < 0);
    }

/*    public void testAddNode() {
      Node newNode = doc.createElement("TEST");
      tester.addNode(doc.getElementsByTagName("options").item(0),newNode);
      doc.getElementsByTagName("TEST");
      assertTrue(doc.getElementsByTagName("TEST").getLength() == 1);
    }*/

    public void testNameValueAttribute(){
      Node node = doc.getElementsByTagName("options").item(0);
      tester.setNameValueAttrs(node,"option","TMPDIR","NEWVALUE_1");
      assertTrue((node.toString()).indexOf("NEWVALUE_1") > 0);
      tester.setNameValueAttrs(node,"option","NEWNAME2","NEWVALUE_2");
      assertTrue(node.toString().indexOf("NEWNAME2") > 0);
      assertTrue(node.toString().indexOf("NEWVALUE_2") > 0);
    }
    public void testLngTable(){
       DomToTableModel tbl = new DomToTableModel(tester.lngRoot, false);
       assertTrue(tbl.getRowCount()==6);
     }

  }
   static void showError(Exception e) {
     JOptionPane.showMessageDialog( new JFrame(), e.getMessage(),"Error", JOptionPane.OK_OPTION);
   }
	 public static void cleanUp()
	 {
	 	_instance = null;
	 }
}
