/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xpslib;

import com.renderx.fonts.FontCatalog;
import com.renderx.fonts.FontRecord;
import com.renderx.fonts.U28;
import com.renderx.graphics.BitmapImage;
import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.graphics.VectorImage;
import com.renderx.sax.Serializer;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.ErrorHandler;
import com.renderx.util.List;
import com.renderx.util.Stack;
import com.renderx.util.URLSpec;
import com.renderx.xep.gen.backends.H4XPS;
import com.renderx.xep.lib.Session;
import com.renderx.xpslib.SVGImageHandler;
import com.renderx.xpslib.XEPOUTImageHandler;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class XPSDocument {
    private Serializer serializer = null;
    private Session session;
    private H4XPS XPSBackend;
    private AttributesImpl attrs = new AttributesImpl();
    private float SCALE = 1000.0f;
    private Hashtable Resources = new Hashtable();
    private Hashtable ResourceDict = new Hashtable();
    private int svgResources = 0;
    private int xepResources = 0;
    private Hashtable SVGImages = new Hashtable();
    private Hashtable XEPImages = new Hashtable();
    private Hashtable PagesRels = new Hashtable();
    private Hashtable CurrentPageRels = null;
    private Hashtable PageRels = new Hashtable();
    private Hashtable Images = new Hashtable();
    private Hashtable Fonts = new Hashtable();
    private Hashtable BadFonts = new Hashtable();
    private Hashtable FontGUIDs = new Hashtable();
    private Hashtable Bookmarks = new Hashtable();
    private List RootBookmarks = new List();
    private List UnsortedBookmarks = new List();
    private Stack PageTargets = new Stack();
    private Hashtable Targets = new Hashtable();
    private Hashtable TargetNames = new Hashtable();
    private Hashtable MissingDestinations = new Hashtable();
    private int targetNumber = 0;
    private Stack EmptyPages = new Stack();
    private static Hashtable Mimes = new Hashtable();
    static Random random;
    final ImageFactory imageFactory;
    final FontCatalog fontCatalog;
    final ErrorHandler errorHandler;
    final U28 u28;
    ZipOutputStream XPSStream = null;
    ZipEntry currentZipEntry = null;
    OutputStream currentStream = null;
    private float fontSize = 0.0f;
    private Integer currentPage = new Integer(0);
    private int maxPageNumber = 0;
    private static String documentPrefix;
    private static String fixedDocument;
    private static String pagesPrefix;
    private static String resourcesPrefix;
    private static String fontsPrefix;
    private static String imagesPrefix;
    private static String pageRelsPrefix;
    private static String docRelsName;
    private static String bookmarksRels;
    private static String bookmarksXPSPath;
    private static String resourceDictPath;
    private static String currentColor;
    private int resourceID = 0;
    private int fontID = 0;
    private String currentXPSFont = "";
    private int imageID = 0;
    private int openCanvases = 0;
    private String polygonPoints = "";

    public XPSDocument(String string, ImageFactory imageFactory, FontCatalog fontCatalog, ErrorHandler errorHandler, Session session, float f, H4XPS h4XPS) throws IOException {
        this(new FileOutputStream(string), imageFactory, fontCatalog, errorHandler, session, f, h4XPS);
    }

    public XPSDocument(OutputStream outputStream, ImageFactory imageFactory, FontCatalog fontCatalog, ErrorHandler errorHandler, Session session, float f, H4XPS h4XPS) throws IOException {
        this.errorHandler = errorHandler;
        this.fontCatalog = fontCatalog;
        this.imageFactory = imageFactory;
        this.XPSStream = new ZipOutputStream(outputStream);
        this.serializer = new Serializer(this.XPSStream);
        this.SCALE = f;
        this.u28 = new XPSU28();
        this.session = session;
        this.XPSBackend = h4XPS;
    }

    private void addXPSFile(String string) {
        ZipEntry zipEntry = new ZipEntry(string);
        try {
            this.XPSStream.putNextEntry(zipEntry);
        }
        catch (IOException iOException) {
            this.errorHandler.error("Cannot create ZIP Entry. " + iOException);
        }
    }

    private void endXPSFile() {
        try {
            this.XPSStream.closeEntry();
        }
        catch (IOException iOException) {
            this.errorHandler.error("Cannot close ZIP Entry. " + iOException);
        }
    }

    public void selectFont(String string, int n, String string2, String string3, float f) {
        this.fontSize = f;
        FontRecord fontRecord = this.fontCatalog.getFontRecord(string, n, string2, string3);
        if (fontRecord.datatype == 2 || fontRecord.datatype == 3 || fontRecord.datatype == 4) {
            if (this.Fonts.containsKey(fontRecord)) {
                this.currentXPSFont = (String)this.Fonts.get(fontRecord);
            } else {
                this.currentXPSFont = this.createFontResourceName(fontRecord);
                this.Fonts.put(fontRecord, this.currentXPSFont);
            }
        } else {
            String string4 = string + "-" + n + "-" + string2 + "-" + string3;
            if (!this.BadFonts.containsKey(string4)) {
                this.errorHandler.error("Unsupported font: " + string + " " + n + " " + string2 + " " + string3 + ". Only OpenType and TrueType fonts are currently supported.");
                this.BadFonts.put(string4, fontRecord);
            }
            this.currentXPSFont = "";
        }
        this.u28.selectFont(string, n, string2, string3, true);
    }

    public String createFontResourceName(FontRecord fontRecord) {
        byte[] byArray;
        while (this.Fonts.containsValue(this.GUID2String(byArray = this.getGUID()))) {
        }
        this.FontGUIDs.put(fontRecord, byArray);
        return fontsPrefix + this.GUID2String(byArray) + ".odttf";
    }

    public void printText(String string, String string2) throws SAXException {
        String string3 = currentColor;
        currentColor = string2;
        this.printText(0.0f, 0.0f, string);
        currentColor = string3;
    }

    public void printText(float f, float f2, String string) throws SAXException {
        if (this.currentXPSFont.equals("")) {
            return;
        }
        this.addPageRel(this.currentXPSFont);
        this.attrs.clear();
        this.attrs.addAttribute("", "OriginX", "OriginX", "CDATA", "0");
        this.attrs.addAttribute("", "OriginY", "OriginY", "CDATA", "0");
        this.attrs.addAttribute("", "Fill", "Fill", "CDATA", "#" + currentColor);
        this.attrs.addAttribute("", "FontRenderingEmSize", "FontRenderingEmSize", "CDATA", "" + this.fontSize);
        try {
            if (string.substring(0, 1).equalsIgnoreCase("{")) {
                this.attrs.addAttribute("", "UnicodeString", "UnicodeString", "CDATA", "{}" + string);
                this.u28.processText("{}" + string);
            } else {
                this.attrs.addAttribute("", "UnicodeString", "UnicodeString", "CDATA", string);
                this.u28.processText(string);
            }
        }
        catch (IOException iOException) {
            this.errorHandler.error("Cannot output text: " + iOException);
        }
        this.attrs.addAttribute("", "FontUri", "FontUri", "CDATA", "/" + this.currentXPSFont);
        this.serializer.startElement("", "Glyphs", "", this.attrs);
        this.serializer.endElement("", "Glyphs", "");
    }

    public void referVectorImage(String string, float f, float f2, float f3) throws SAXException {
        this.attrs.clear();
        this.serializer.startElement("", "Path", "", this.attrs);
        this.serializer.startElement("", "Path.Fill", "", this.attrs);
        this.attrs.addAttribute("", "Visual", "Visual", "CDATA", "{StaticResource " + string + "}");
        this.attrs.addAttribute("", "Viewbox", "Viewbox", "CDATA", "0,0," + f * f3 + "," + f2 * f3);
        this.attrs.addAttribute("", "Viewport", "Viewport", "CDATA", "0,0," + f * f3 + "," + f2 * f3);
        this.attrs.addAttribute("", "ViewportUnits", "ViewportUnits", "CDATA", "Absolute");
        this.attrs.addAttribute("", "ViewboxUnits", "ViewboxUnits", "CDATA", "Absolute");
        this.serializer.startElement("", "VisualBrush", "", this.attrs);
        this.serializer.endElement("", "VisualBrush", "");
        this.serializer.endElement("", "Path.Fill", "");
        this.attrs.clear();
        this.serializer.startElement("", "Path.Data", "", this.attrs);
        this.serializer.startElement("", "PathGeometry", "", this.attrs);
        this.attrs.addAttribute("", "IsClosed", "IsClosed", "CDATA", "true");
        this.attrs.addAttribute("", "StartPoint", "StartPoint", "CDATA", "0,0");
        this.serializer.startElement("", "PathFigure", "", this.attrs);
        this.attrs.clear();
        this.attrs.addAttribute("", "Points", "Points", "CDATA", "0,0 " + f * f3 + ",0 " + f * f3 + "," + f2 * f3 + " 0," + f2 * f3);
        this.serializer.startElement("", "PolyLineSegment", "", this.attrs);
        this.serializer.endElement("", "PolyLineSegment", "");
        this.attrs.clear();
        this.serializer.endElement("", "PathFigure", "");
        this.serializer.endElement("", "PathGeometry", "");
        this.serializer.endElement("", "Path.Data", "");
        this.serializer.endElement("", "Path", "");
    }

    public void drawXEPoutImage(URLSpec uRLSpec, float f, float f2, float f3, float f4, boolean bl) throws SAXException {
        try {
            Image image = this.imageFactory.makeImage(uRLSpec, "application/xepout");
            float f5 = (float)image.width;
            float f6 = (float)image.height;
            if (bl) {
                this.transform(f3, 0.0f, 0.0f, f4, f, f2);
                String string = this.cacheVectorImage(uRLSpec);
                this.referVectorImage(string, f5, f6, 1000.0f);
                this.closeCanvas();
            } else {
                this.transform(f3, 0.0f, 0.0f, f4, f, f2);
                this.writeXEPoutImageData(uRLSpec);
                this.closeCanvas();
            }
        }
        catch (Exception exception) {
            this.errorHandler.error("Error getting XEPOUT image dimensions: " + exception);
        }
    }

    public void writeXEPoutImageData(URLSpec uRLSpec) {
        try {
            InputStream inputStream = null;
            inputStream = uRLSpec.scheme == 1 ? uRLSpec.openStream() : this.session.config.cache.openStream(uRLSpec, this.session);
            XEPOUTImageHandler xEPOUTImageHandler = new XEPOUTImageHandler(this.XPSBackend, this);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            InputSource inputSource = new InputSource(inputStream);
            xMLReader.setContentHandler(xEPOUTImageHandler);
            xMLReader.parse(inputSource);
        }
        catch (Exception exception) {
            this.errorHandler.exception("Unexpected error while parsing image", exception);
        }
    }

    public void drawSVGImage(Image image, float f, float f2, float f3, float f4, boolean bl) throws SAXException {
        this.transform(this.SCALE * f3, 0.0f, 0.0f, this.SCALE * f4, f, f2);
        if (bl) {
            String string = this.cacheVectorImage(image);
            this.referVectorImage(string, (float)image.width, (float)image.height, 1.0f);
        } else {
            this.writeSVGImageData(image, bl);
        }
        this.closeCanvas();
    }

    public void writeSVGImageData(Image image, boolean bl) {
        SVGImageHandler sVGImageHandler = new SVGImageHandler("svg" + this.svgResources);
        ++this.svgResources;
        try {
            sVGImageHandler.write(((VectorImage)image).getImageTree(), this, this.SCALE, bl);
        }
        catch (Exception exception) {
            this.errorHandler.error("Error embedding SVG image: " + exception);
        }
    }

    public void drawImage(URLSpec uRLSpec, String string, float f, float f2, float f3, float f4, boolean bl) throws SAXException {
        if (!this.isImageTypeSupported(string)) {
            this.errorHandler.error("'" + string + "' - Unsupported image type, skipping '" + uRLSpec + "'.");
            this.putBrokenImage(f, f2, f3, f4);
            return;
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        Image image = null;
        try {
            image = this.imageFactory.makeImage(uRLSpec);
            f5 = (float)image.width;
            f6 = (float)image.height;
        }
        catch (ImageFormatException imageFormatException) {
            this.errorHandler.error("Cannot parse image file: " + imageFormatException);
        }
        catch (UnregisteredMIMETypeException unregisteredMIMETypeException) {
            this.errorHandler.error("Unknown MIME type: " + unregisteredMIMETypeException.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorHandler.error("Image '" + uRLSpec + "' not found.");
        }
        catch (Exception exception) {
            this.errorHandler.exception("Unexpected error while parsing image", exception);
        }
        if (image == null) {
            this.putBrokenImage(f, f2, f3, f4);
            return;
        }
        if (string.equalsIgnoreCase("application/xepout")) {
            this.drawXEPoutImage(uRLSpec, f, f2, f3, f4, bl);
            return;
        }
        if (string.equalsIgnoreCase("image/svg+xml") || string.equalsIgnoreCase("image/svg")) {
            this.drawSVGImage(image, f, f2, f3, f4, bl);
        } else {
            this.drawBitmapImage(image, string, f, f2, f3, f4);
        }
    }

    public void drawBitmapImage(Image image, String string, float f, float f2, float f3, float f4) throws SAXException {
        float f5 = (float)image.width;
        float f6 = (float)image.height;
        int n = ((BitmapImage)image).pxWidth;
        int n2 = ((BitmapImage)image).pxHeight;
        if (((BitmapImage)image).noResolution) {
            float f7 = (float)((BitmapImage)image).horzResolution;
            float f8 = (float)((BitmapImage)image).vertResolution;
            this.transform(f3 * this.SCALE * 72.0f / f7, 0.0f, 0.0f, -f4 * this.SCALE * 72.0f / f8, f, f2 + f6 * f4 * this.SCALE);
            this.putImage(image, string, f, f2, n, n2, f3, f4);
        } else {
            this.transform(f3 * this.SCALE * 72.0f / 96.0f, 0.0f, 0.0f, -f4 * this.SCALE * 72.0f / 96.0f, f, f2 + f6 * f4 * this.SCALE);
            this.putImage(image, string, f, f2, f5 * 96.0f / 72.0f, f6 * 96.0f / 72.0f, f3, f4);
        }
        this.closeCanvas();
    }

    public void putImage(Image image, String string, float f, float f2, float f3, float f4, float f5, float f6) throws SAXException {
        String string2 = this.addImage(image, string);
        if (string2.equals("")) {
            return;
        }
        this.attrs.clear();
        this.attrs.addAttribute("", "Data", "Data", "CDATA", "M 0,0 H " + f3 + " V " + f4 + " H 0 z");
        this.serializer.startElement("", "Path", "", this.attrs);
        this.serializer.startElement("", "Path.Fill", "", null);
        this.attrs.clear();
        this.attrs.addAttribute("", "TileMode", "TileMode", "CDATA", "None");
        this.attrs.addAttribute("", "ViewboxUnits", "ViewboxUnits", "CDATA", "Absolute");
        this.attrs.addAttribute("", "ViewportUnits", "ViewportUnits", "CDATA", "Absolute");
        this.attrs.addAttribute("", "Viewbox", "Viewbox", "CDATA", "0,0," + f3 + "," + f4);
        this.attrs.addAttribute("", "Viewport", "Viewport", "CDATA", "0,0," + f3 + "," + f4);
        this.attrs.addAttribute("", "ImageSource", "ImageSource", "CDATA", "/" + string2);
        this.serializer.startElement("", "ImageBrush", "", this.attrs);
        this.serializer.endElement("", "ImageBrush", "");
        this.serializer.endElement("", "Path.Fill", "");
        this.serializer.endElement("", "Path", "");
    }

    public void putBrokenImage(float f, float f2, float f3, float f4) throws SAXException {
        try {
            Image image = this.imageFactory.makeImage(this.imageFactory.brokenimage);
            this.drawBitmapImage(image, image.mimetype, f, f2, f3, f4);
        }
        catch (Exception exception) {
            this.errorHandler.error("Unexpected error while placing " + this.imageFactory.brokenimage + ": " + exception);
        }
    }

    public boolean putAnchor(float f, float f2, float f3, float f4, String string) throws SAXException {
        String string2 = this.normalizeTargetName(string);
        if (string2.equals("")) {
            return false;
        }
        this.attrs.clear();
        this.attrs.addAttribute("", "Stroke", "Stroke", "CDATA", "#" + currentColor);
        this.attrs.addAttribute("", "Data", "Data", "CDATA", "M " + f + "," + f2 + " H " + (f + f3) + " V " + (f2 + f4) + " H " + f + " z");
        this.attrs.addAttribute("", "Name", "Name", "CDATA", string2);
        this.attrs.addAttribute("", "Opacity", "Opacity", "CDATA", "0");
        this.serializer.startElement("", "Path", "", this.attrs);
        this.serializer.endElement("", "Path", "");
        this.PageTargets.push(string2);
        return true;
    }

    public void putExternalLink(float f, float f2, float f3, float f4, String string) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("", "Fill", "Fill", "CDATA", "#000000");
        this.attrs.addAttribute("", "Data", "Data", "CDATA", "M " + f + "," + f2 + " H " + f3 + " V " + f4 + " H " + f + " z");
        this.attrs.addAttribute("", "Opacity", "Opacity", "CDATA", "0");
        this.attrs.addAttribute("", "FixedPage.NavigateUri", "FixedPage.NavigateURI", "CDATA", string);
        this.serializer.startElement("", "Path", "", this.attrs);
        this.serializer.endElement("", "Path", "");
    }

    public void putInternalLink(float f, float f2, float f3, float f4, int n, String string) throws SAXException {
        String string2 = "page" + n + string;
        if (this.TargetNames.containsKey(string2)) {
            this.putExternalLink(f, f2, f3, f4, "../" + fixedDocument + "#" + (String)this.TargetNames.get(string2));
        } else if (this.MissingDestinations.containsKey(string2)) {
            this.putExternalLink(f, f2, f3, f4, "../" + fixedDocument + "#" + this.MissingDestinations.get(string2));
        } else {
            String string3 = "page" + n + "target" + this.targetNumber;
            this.MissingDestinations.put(string2, string3);
            ++this.targetNumber;
            this.putExternalLink(f, f2, f3, f4, "../" + fixedDocument + "#" + string3);
        }
    }

    public void rememberBookmark(int n, int n2, int n3, String string, String string2, boolean bl) {
        String string3;
        Bookmark bookmark = new Bookmark(n, n2, n3, string, string2, bl);
        this.UnsortedBookmarks.append(bookmark);
        this.Bookmarks.put(new Integer(n), bookmark);
        if (!bl && !this.TargetNames.containsKey(string3 = "page" + n3 + string2)) {
            this.MissingDestinations.put(string3, "page" + n3 + "target" + this.targetNumber);
            ++this.targetNumber;
        }
    }

    private void organizeBookmarks() {
        Enumeration enumeration = this.UnsortedBookmarks.elements();
        while (enumeration.hasMoreElements()) {
            Bookmark bookmark = (Bookmark)enumeration.nextElement();
            this.organizeBookmark(bookmark);
        }
    }

    private void organizeBookmark(Bookmark bookmark) {
        if (this.Bookmarks.containsKey(bookmark.parentId)) {
            Bookmark bookmark2 = (Bookmark)this.Bookmarks.get(bookmark.parentId);
            bookmark2.children.append(bookmark);
        } else if (bookmark.parentId == 0) {
            this.RootBookmarks.append(bookmark);
        } else {
            this.errorHandler.error("Skipping an orphaned bookmark: " + bookmark.label + " (ID=" + bookmark.id + ")");
        }
    }

    public void putLine(float f, float f2, float f3, float f4, float f5, String string) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("", "Stroke", "Stroke", "CDATA", "#" + currentColor);
        this.attrs.addAttribute("", "StrokeThickness", "StrokeThickness", "CDATA", "" + f5);
        if (string.equalsIgnoreCase("dotted")) {
            this.attrs.addAttribute("", "StrokeDashCap", "StrokeDashCap", "CDATA", "Round");
            this.attrs.addAttribute("", "StrokeDashArray", "StrokeDashArray", "CDATA", "0 2");
        } else if (string.equalsIgnoreCase("dashed")) {
            this.attrs.addAttribute("", "StrokeDashArray", "StrokeDashArray", "CDATA", "2 2");
        }
        this.attrs.addAttribute("", "Data", "Data", "CDATA", "M " + f + "," + f2 + " L " + f3 + "," + f4);
        this.serializer.startElement("", "Path", "", this.attrs);
        this.serializer.endElement("", "Path", "");
    }

    public void translate(float f, float f2) throws SAXException {
        this.serializer.startElement("", "Canvas", "", null);
        this.serializer.startElement("", "Canvas.RenderTransform", "", null);
        this.attrs.clear();
        this.attrs.addAttribute("", "Matrix", "Matrix", "CDATA", "1,0,0,1," + f + "," + f2);
        this.serializer.startElement("", "MatrixTransform", "", this.attrs);
        this.serializer.endElement("", "MatrixTransform", "");
        this.serializer.endElement("", "Canvas.RenderTransform", "");
        ++this.openCanvases;
    }

    public void transform(float f, float f2, float f3, float f4, float f5, float f6) throws SAXException {
        this.serializer.startElement("", "Canvas", "", null);
        this.serializer.startElement("", "Canvas.RenderTransform", "", null);
        this.attrs.clear();
        this.attrs.addAttribute("", "Matrix", "Matrix", "CDATA", f + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6);
        this.serializer.startElement("", "MatrixTransform", "", this.attrs);
        this.serializer.endElement("", "MatrixTransform", "");
        this.serializer.endElement("", "Canvas.RenderTransform", "");
        ++this.openCanvases;
    }

    public void rotate(float f) throws SAXException {
        double d = Math.cos(f);
        double d2 = Math.sin(f);
        this.serializer.startElement("", "Canvas", "", null);
        this.serializer.startElement("", "Canvas.RenderTransform", "", null);
        this.attrs.clear();
        this.attrs.addAttribute("", "Matrix", "Matrix", "CDATA", "" + d + "," + d2 + "," + -1.0 * d2 + "," + d + ",0,0");
        this.serializer.startElement("", "MatrixTransform", "", this.attrs);
        this.serializer.endElement("", "MatrixTransform", "");
        this.serializer.endElement("", "Canvas.RenderTransform", "");
        ++this.openCanvases;
    }

    public void startClip(float f, float f2, float f3, float f4) throws SAXException {
        this.serializer.startElement("", "Canvas", "", null);
        this.serializer.startElement("", "Canvas.Clip", "", null);
        this.serializer.startElement("", "PathGeometry", "", null);
        this.attrs.clear();
        this.attrs.addAttribute("", "IsClosed", "IsClosed", "CDATA", "true");
        this.attrs.addAttribute("", "StartPoint", "StartPoint", "CDATA", "" + f + "," + f2);
        this.serializer.startElement("", "PathFigure", "", this.attrs);
        this.attrs.clear();
        this.attrs.addAttribute("", "Points", "Points", "CDATA", "" + f + "," + f4 + " " + f3 + "," + f4 + " " + f3 + "," + f2);
        this.serializer.startElement("", "PolyLineSegment", "", this.attrs);
        this.serializer.endElement("", "PolyLineSegment", "");
        this.serializer.endElement("", "PathFigure", "");
        this.serializer.endElement("", "PathGeometry", "");
        this.serializer.endElement("", "Canvas.Clip", "");
    }

    public void endClip() throws SAXException {
        this.serializer.endElement("", "Canvas", "");
    }

    public void putRectangle(float f, float f2, float f3, float f4) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("", "Fill", "Fill", "CDATA", "#" + currentColor);
        this.attrs.addAttribute("", "Data", "Data", "CDATA", "M " + f + "," + f2 + " H " + f3 + " V " + f4 + " H " + f + " z");
        this.serializer.startElement("", "Path", "", this.attrs);
        this.serializer.endElement("", "Path", "");
    }

    public void startPolygon(float f, float f2) {
        this.polygonPoints = "F 1 M " + f + "," + f2;
    }

    public void addPolygonPoint(float f, float f2) {
        this.polygonPoints = this.polygonPoints + " L " + f + "," + f2;
    }

    public void endPolygon() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("", "Fill", "Fill", "CDATA", "#" + currentColor);
        this.attrs.addAttribute("", "Data", "Data", "CDATA", this.polygonPoints + " Z");
        this.serializer.startElement("", "Path", "", this.attrs);
        this.serializer.endElement("", "Path", "");
    }

    public void injectElement(String string, AttributesImpl attributesImpl) throws SAXException {
        this.serializer.startElement("", string, "", attributesImpl);
        this.serializer.endElement("", string, "");
    }

    public void openElement(String string, AttributesImpl attributesImpl) throws SAXException {
        this.serializer.startElement("", string, "", attributesImpl);
    }

    public void closeElement(String string) throws SAXException {
        this.serializer.endElement("", string, "");
    }

    public void setRGBColor(float f, float f2, float f3) {
        String string = Integer.toHexString(Math.round(255.0f * f));
        String string2 = Integer.toHexString(Math.round(255.0f * f2));
        String string3 = Integer.toHexString(Math.round(255.0f * f3));
        if (string.length() < 2) {
            string = "0" + string;
        }
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        currentColor = string + string2 + string3;
    }

    public void setGreyColor(float f) {
        String string = Integer.toHexString(Math.round(255.0f * f));
        if (string.length() < 2) {
            string = "0" + string;
        }
        currentColor = string + string + string;
    }

    public void setCMYKColor(float f, float f2, float f3, float f4) {
        float f5 = 1.0f - f4;
        int n = f5 > f ? Math.round((f5 - f) * 255.0f) : 0;
        int n2 = f5 > f2 ? Math.round((f5 - f2) * 255.0f) : 0;
        int n3 = f5 > f3 ? Math.round((f5 - f3) * 255.0f) : 0;
        String string = Integer.toHexString(n);
        String string2 = Integer.toHexString(n2);
        String string3 = Integer.toHexString(n3);
        if (string.length() < 2) {
            string = "0" + string;
        }
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        currentColor = string + string2 + string3;
    }

    public void beginPage(int n, float f, float f2) throws SAXException {
        this.CurrentPageRels = new Hashtable();
        this.currentXPSFont = "";
        this.currentPage = new Integer(n);
        if (n > this.maxPageNumber) {
            this.maxPageNumber = n;
        }
        this.openCanvases = 0;
        this.PageTargets = new Stack();
        this.addXPSFile(documentPrefix + pagesPrefix + n + ".fpage");
        this.serializer.startDocument();
        this.attrs.clear();
        this.attrs.addAttribute("", "xmlns", "xmlns", "CDATA", "http://schemas.microsoft.com/xps/2005/06");
        this.attrs.addAttribute("", "xml:lang", "xml:lang", "CDATA", "en-us");
        this.attrs.addAttribute("", "Width", "Width", "CDATA", "" + f);
        this.attrs.addAttribute("", "Height", "Height", "CDATA", "" + f2);
        this.serializer.startElement("", "FixedPage", "", this.attrs);
        this.attrs.clear();
        this.serializer.startElement("", "FixedPage.Resources", "", this.attrs);
        this.attrs.addAttribute("", "Source", "Source", "CDATA", "/" + resourceDictPath);
        this.serializer.startElement("", "ResourceDictionary", "", this.attrs);
        this.serializer.endElement("", "ResourceDictionary", "");
        this.serializer.endElement("", "FixedPage.Resources", "");
        this.attrs.clear();
    }

    public void endPage() throws SAXException {
        this.closeCanvases();
        this.serializer.endElement("", "FixedPage", "");
        this.serializer.endDocument();
        this.endXPSFile();
        this.addPageRel(resourceDictPath);
        this.Targets.put(this.currentPage, this.PageTargets);
        this.PagesRels.put(this.currentPage, this.CurrentPageRels);
    }

    public void closeCanvases() throws SAXException {
        int n = this.openCanvases;
        int n2 = 0;
        while (n2 < n) {
            this.closeCanvas();
            ++n2;
        }
    }

    public void closeCanvas() throws SAXException {
        this.serializer.endElement("", "Canvas", "");
        --this.openCanvases;
    }

    public int getOpenCanvasesCount() {
        return this.openCanvases;
    }

    public void endDocument() throws SAXException {
        try {
            this.writeContentTypes();
            this.writeFixedDocSeq();
            this.writeDocPages();
            this.writeBookmarks();
            this.writeDocRels();
            this.writeResourceDict();
            this.writeImages();
            this.writeFonts();
            this.writeEmptyPages();
            this.writePagesRels();
            this.XPSStream.flush();
            this.XPSStream.close();
        }
        catch (IOException iOException) {
            this.errorHandler.error("Cannot close document: " + iOException);
        }
    }

    private void writeEmptyPages() throws SAXException {
        while (this.EmptyPages.length() != 0) {
            this.beginPage((Integer)this.EmptyPages.pop(), 48.0f, 48.0f);
            this.endPage();
        }
    }

    private void writeContentTypes() throws SAXException {
        this.addXPSFile("[Content_Types].xml");
        this.serializer.startDocument();
        this.attrs.clear();
        this.attrs.addAttribute("", "xmlns", "xmlns", "CDATA", "http://schemas.openxmlformats.org/package/2006/content-types");
        this.serializer.startElement("", "Types", "", this.attrs);
        this.writeContentType("png", "image/png");
        this.writeContentType("odttf", "application/vnd.ms-package.obfuscated-opentype");
        this.writeContentType("fdoc", "application/vnd.ms-package.xps-fixeddocument+xml");
        this.writeContentType("rels", "application/vnd.openxmlformats-package.relationships+xml");
        this.writeContentType("xml", "application/xml");
        this.writeContentType("fdseq", "application/vnd.ms-package.xps-fixeddocumentsequence+xml");
        this.writeContentType("fpage", "application/vnd.ms-package.xps-fixedpage+xml");
        this.writeContentType("struct", "application/vnd.ms-package.xps-documentstructure+xml");
        this.writeContentType("dict", "application/vnd.ms-package.xps-resourcedictionary+xml");
        this.writeContentType("jpeg", "image/jpeg");
        this.writeContentType("jpg", "image/jpeg");
        this.writeContentType("tiff", "image/tiff");
        this.writeContentType("tif", "image/tiff");
        this.serializer.endElement("", "Types", "");
        this.serializer.endDocument();
        this.endXPSFile();
    }

    public void writeContentType(String string, String string2) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("", "Extension", "Extension", "CDATA", string);
        this.attrs.addAttribute("", "ContentType", "ContentType", "CDATA", string2);
        this.serializer.startElement("", "Default", "", this.attrs);
        this.serializer.endElement("", "Default", "");
    }

    public void writeFixedDocSeq() throws SAXException {
        this.addXPSFile("FixedDocumentSequence.fdseq");
        this.serializer.startDocument();
        this.attrs.clear();
        this.attrs.addAttribute("", "xmlns", "xmlns", "CDATA", "http://schemas.microsoft.com/xps/2005/06");
        this.serializer.startElement("", "FixedDocumentSequence", "", this.attrs);
        this.attrs.clear();
        this.attrs.addAttribute("", "Source", "Source", "CDATA", "Documents/1/" + fixedDocument);
        this.serializer.startElement("", "DocumentReference", "", this.attrs);
        this.serializer.endElement("", "DocumentReference", "");
        this.serializer.endElement("", "FixedDocumentSequence", "");
        this.serializer.endDocument();
        this.endXPSFile();
    }

    public void writeDocPages() throws SAXException {
        this.addXPSFile(documentPrefix + fixedDocument);
        this.serializer.startDocument();
        this.attrs.clear();
        this.attrs.addAttribute("", "xmlns", "xmlns", "CDATA", "http://schemas.microsoft.com/xps/2005/06");
        this.serializer.startElement("", "FixedDocument", "", this.attrs);
        int n = 1;
        while (n <= this.maxPageNumber) {
            this.mentionPage(new Integer(n));
            ++n;
        }
        this.serializer.endElement("", "FixedDocument", "");
        this.serializer.endDocument();
        this.endXPSFile();
    }

    public void mentionPage(Integer n) throws SAXException {
        if (this.Targets.containsKey(n)) {
            this.attrs.clear();
            this.attrs.addAttribute("", "Source", "Source", "CDATA", pagesPrefix + n + ".fpage");
            this.serializer.startElement("", "PageContent", "", this.attrs);
            this.PageTargets = (Stack)this.Targets.get(n);
            if (this.PageTargets.length() > 0) {
                this.attrs.clear();
                this.serializer.startElement("", "PageContent.LinkTargets", "", this.attrs);
                while (this.PageTargets.length() != 0) {
                    this.attrs.clear();
                    this.attrs.addAttribute("", "Name", "Name", "CDATA", "" + this.PageTargets.pop());
                    this.serializer.startElement("", "LinkTarget", "", this.attrs);
                    this.serializer.endElement("", "LinkTarget", "");
                }
                this.serializer.endElement("", "PageContent.LinkTargets", "");
            }
            this.serializer.endElement("", "PageContent", "");
        } else {
            this.attrs.clear();
            this.attrs.addAttribute("", "Source", "Source", "CDATA", pagesPrefix + n + ".fpage");
            this.serializer.startElement("", "PageContent", "", this.attrs);
            this.serializer.endElement("", "PageContent", "");
            this.EmptyPages.push(n);
        }
    }

    public void writeDocRels() throws SAXException {
        this.addXPSFile(docRelsName);
        this.serializer.startDocument();
        this.attrs.clear();
        this.attrs.addAttribute("", "xmlns", "xmlns", "CDATA", "http://schemas.openxmlformats.org/package/2006/relationships");
        this.serializer.startElement("", "Relationships", "", this.attrs);
        this.writeDocRel("http://schemas.microsoft.com/xps/2005/06/fixedrepresentation", "/FixedDocumentSequence.fdseq", "R9f24b890c07d46f7");
        this.serializer.endElement("", "Relationships", "");
        this.serializer.endDocument();
        this.endXPSFile();
    }

    public void writeDocRel(String string, String string2, String string3) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("", "Type", "Type", "CDATA", string);
        this.attrs.addAttribute("", "Target", "Target", "CDATA", string2);
        this.attrs.addAttribute("", "Id", "Id", "CDATA", string3);
        this.serializer.startElement("", "Relationship", "", this.attrs);
        this.serializer.endElement("", "Relationship", "");
    }

    private void writePagesRels() throws SAXException {
        Enumeration enumeration = this.PagesRels.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            this.CurrentPageRels = (Hashtable)this.PagesRels.get(n);
            this.writePageRels(n);
        }
    }

    private void writePageRels(int n) throws SAXException {
        this.addXPSFile(pageRelsPrefix + n + ".fpage.rels");
        this.serializer.startDocument();
        this.attrs.clear();
        this.attrs.addAttribute("", "xmlns", "xmlns", "CDATA", "http://schemas.openxmlformats.org/package/2006/relationships");
        this.serializer.startElement("", "Relationships", "", this.attrs);
        Enumeration enumeration = this.CurrentPageRels.keys();
        while (enumeration.hasMoreElements()) {
            ++this.resourceID;
            this.writePageRel((String)enumeration.nextElement(), "" + this.resourceID);
        }
        this.serializer.endElement("", "Relationships", "");
        this.serializer.endDocument();
        this.endXPSFile();
    }

    private void writePageRel(String string, String string2) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("", "Type", "Type", "CDATA", "http://schemas.microsoft.com/xps/2005/06/required-resource");
        this.attrs.addAttribute("", "Id", "Id", "CDATA", "res" + string2);
        this.attrs.addAttribute("", "Target", "Target", "CDATA", "/" + string);
        this.serializer.startElement("", "Relationship", "", this.attrs);
        this.serializer.endElement("", "Relationship", "");
    }

    public boolean isImageTypeSupported(String string) {
        return Mimes.containsKey(string);
    }

    private String cacheVectorImage(Image image) {
        if (!this.SVGImages.containsKey(image)) {
            SVGImageHandler sVGImageHandler = new SVGImageHandler("svg" + this.svgResources);
            this.SVGImages.put(image, sVGImageHandler);
            ++this.svgResources;
        }
        return ((SVGImageHandler)this.SVGImages.get(image)).getID();
    }

    private String cacheVectorImage(URLSpec uRLSpec) {
        if (!this.XEPImages.containsKey(uRLSpec)) {
            this.XEPImages.put(uRLSpec, "xep" + this.xepResources);
            ++this.xepResources;
        }
        return (String)this.XEPImages.get(uRLSpec);
    }

    private String addImage(Image image, String string) {
        if (!this.Images.containsKey(image)) {
            if (!Mimes.containsKey(string)) {
                return "";
            }
            ++this.imageID;
            String string2 = imagesPrefix + "Image" + this.imageID + "." + (String)Mimes.get(string);
            this.Images.put(image, string2);
            this.addPageRel(string2);
            return string2;
        }
        this.addPageRel((String)this.Images.get(image));
        return (String)this.Images.get(image);
    }

    private void addPageRel(String string) {
        if (!this.CurrentPageRels.containsKey(string)) {
            this.CurrentPageRels.put(string, new Integer(0));
        }
    }

    private void writeImages() {
        InputStream inputStream = null;
        Enumeration enumeration = this.Images.keys();
        while (enumeration.hasMoreElements()) {
            try {
                Image image = (Image)enumeration.nextElement();
                String string = (String)this.Images.get(image);
                inputStream = image.openImageStream();
                this.addXPSFile(string);
                this.copyData(inputStream);
                inputStream.close();
                this.endXPSFile();
            }
            catch (Exception exception) {
                this.errorHandler.error("Cannot add image: " + exception);
            }
        }
    }

    public void writeBookmarks() throws SAXException {
        try {
            this.organizeBookmarks();
            if (this.RootBookmarks.length() > 0) {
                this.addXPSFile(documentPrefix + bookmarksXPSPath);
                this.serializer.startDocument();
                this.attrs.clear();
                this.attrs.addAttribute("", "xmlns", "xmlns", "CDATA", "http://schemas.microsoft.com/xps/2005/06/documentstructure");
                this.serializer.startElement("", "DocumentStructure", "", this.attrs);
                this.attrs.clear();
                this.serializer.startElement("", "DocumentStructure.Outline", "", this.attrs);
                this.attrs.addAttribute("", "xml:lang", "xml:lang", "CDATA", "en-US");
                this.serializer.startElement("", "DocumentOutline", "", this.attrs);
                this.writeBookmarksList(this.RootBookmarks, 1);
                this.serializer.endElement("", "DocumentOutline", "");
                this.serializer.endElement("", "DocumentStructure.Outline", "");
                this.serializer.endElement("", "DocumentStructure", "");
                this.serializer.endDocument();
                this.endXPSFile();
                this.addXPSFile(bookmarksRels);
                this.serializer.startDocument();
                this.attrs.clear();
                this.attrs.addAttribute("", "xmlns", "xmlns", "CDATA", "http://schemas.openxmlformats.org/package/2006/relationships");
                this.serializer.startElement("", "Relationships", "", this.attrs);
                this.writeDocRel("http://schemas.microsoft.com/xps/2005/06/documentstructure", bookmarksXPSPath, "Ridbookmarks1");
                this.serializer.endElement("", "Relationships", "");
                this.serializer.endDocument();
                this.endXPSFile();
            }
        }
        catch (Exception exception) {
            this.errorHandler.error("Cannot write bookmark: " + exception);
        }
    }

    public void writeResourceDict() throws SAXException {
        Object object;
        this.addXPSFile(resourceDictPath);
        this.serializer.startDocument();
        this.attrs.clear();
        this.attrs.addAttribute("", "xmlns", "xmlns", "CDATA", "http://schemas.microsoft.com/xps/2005/06");
        this.attrs.addAttribute("", "xmlns:x", "xmlns:x", "CDATA", "http://schemas.microsoft.com/xps/2005/06/resourcedictionary-key");
        this.serializer.startElement("", "ResourceDictionary", "", this.attrs);
        this.attrs.clear();
        Enumeration enumeration = this.SVGImages.keys();
        while (enumeration.hasMoreElements()) {
            try {
                object = (Image)enumeration.nextElement();
                SVGImageHandler sVGImageHandler = (SVGImageHandler)this.SVGImages.get(object);
                sVGImageHandler.write(((VectorImage)object).getImageTree(), this, this.SCALE);
            }
            catch (Exception exception) {
                this.errorHandler.error("Error embedding SVG image: " + exception);
            }
        }
        this.attrs.clear();
        enumeration = this.XEPImages.keys();
        while (enumeration.hasMoreElements()) {
            try {
                object = (URLSpec)enumeration.nextElement();
                this.attrs.addAttribute("", "x:Key", "x:Key", "CDATA", (String)this.XEPImages.get(object));
                this.serializer.startElement("", "Canvas", "", this.attrs);
                this.writeXEPoutImageData((URLSpec)object);
                this.serializer.endElement("", "Canvas", "");
                this.attrs.clear();
            }
            catch (Exception exception) {
                this.errorHandler.error("Error embedding XEP image: " + exception);
            }
        }
        this.serializer.endElement("", "ResourceDictionary", "");
        this.serializer.endDocument();
        this.endXPSFile();
    }

    private void writeBookmarksList(List list, int n) throws SAXException {
        Enumeration enumeration = list.elements();
        while (enumeration.hasMoreElements()) {
            Bookmark bookmark = (Bookmark)enumeration.nextElement();
            this.writeBookmark(bookmark, n);
            this.writeBookmarksList(bookmark.children, n + 1);
        }
    }

    private void writeBookmark(Bookmark bookmark, int n) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("", "OutlineLevel", "OutlineLevel", "CDATA", "" + n);
        this.attrs.addAttribute("", "Description", "Description", "CDATA", bookmark.label);
        if (bookmark.isExternal) {
            this.attrs.addAttribute("", "OutlineTarget", "OutlineTarget", "CDATA", bookmark.target);
        } else if (this.TargetNames.containsKey(bookmark.target)) {
            this.attrs.addAttribute("", "OutlineTarget", "OutlineTarget", "CDATA", "../" + fixedDocument + "#" + (String)this.TargetNames.get(bookmark.target));
        } else {
            this.errorHandler.error("Bookmark \"" + bookmark.label + "\" (ID=" + bookmark.id + ") points to a missing destination: \"" + bookmark.origdst + "\" on page " + bookmark.pageNumber);
            this.attrs.addAttribute("", "OutlineTarget", "OutlineTarget", "CDATA", "../" + fixedDocument + "#" + bookmark.target);
        }
        this.serializer.startElement("", "OutlineEntry", "", this.attrs);
        this.serializer.endElement("", "OutlineEntry", "");
    }

    private void writeFonts() {
        Enumeration enumeration = this.Fonts.keys();
        FontRecord fontRecord = null;
        while (enumeration.hasMoreElements()) {
            fontRecord = (FontRecord)enumeration.nextElement();
            this.writeFont(fontRecord);
        }
    }

    private void writeFont(FontRecord fontRecord) {
        byte[] byArray = (byte[])this.FontGUIDs.get(fontRecord);
        String string = (String)this.Fonts.get(fontRecord);
        if (fontRecord.subset) {
            this.writeSubsettedFont(fontRecord, byArray, string);
            return;
        }
        try {
            InputStream inputStream = fontRecord.openFontStream();
            this.addXPSFile(string);
            byte[] byArray2 = new byte[32];
            int n = inputStream.read(byArray2, 0, byArray2.length);
            int n2 = 0;
            while (n2 < 2) {
                int n3 = 0;
                while (n3 < 16) {
                    int n4 = n3 + n2 * 16;
                    byArray2[n4] = (byte)(byArray2[n4] ^ byArray[n3]);
                    ++n3;
                }
                ++n2;
            }
            this.XPSStream.write(byArray2);
            this.copyData(inputStream);
            inputStream.close();
            this.endXPSFile();
        }
        catch (IOException iOException) {
            this.errorHandler.error("Cannot embed font: " + iOException);
        }
    }

    /*
     * Exception decompiling
     */
    private void writeSubsettedFont(FontRecord var1_1, byte[] var2_2, String var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[DOLOOP]], but top level block is 28[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void copyData(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
            this.XPSStream.write(byArray, 0, n);
        }
    }

    private byte[] getGUID() {
        byte[] byArray = new byte[16];
        random.nextBytes(byArray);
        return byArray;
    }

    private String GUID2String(byte[] byArray) {
        String string = "" + XPSDocument.b2hex(byArray[15]) + XPSDocument.b2hex(byArray[14]) + XPSDocument.b2hex(byArray[13]) + XPSDocument.b2hex(byArray[12]) + "-" + XPSDocument.b2hex(byArray[11]) + XPSDocument.b2hex(byArray[10]) + "-" + XPSDocument.b2hex(byArray[9]) + XPSDocument.b2hex(byArray[8]) + "-" + XPSDocument.b2hex(byArray[7]) + XPSDocument.b2hex(byArray[6]) + "-" + XPSDocument.b2hex(byArray[5]) + XPSDocument.b2hex(byArray[4]) + XPSDocument.b2hex(byArray[3]) + XPSDocument.b2hex(byArray[2]) + XPSDocument.b2hex(byArray[1]) + XPSDocument.b2hex(byArray[0]);
        return string;
    }

    private static char toHexDigit(int n) {
        if (0 <= n && n <= 9) {
            return (char)(48 + n);
        }
        return (char)(97 + (n - 10));
    }

    private static String b2hex(byte by) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XPSDocument.toHexDigit(by >>> 4 & 0xF));
        stringBuffer.append(XPSDocument.toHexDigit(by & 0xF));
        return "" + stringBuffer;
    }

    private String normalizeTargetName(String string) {
        String string2 = "page" + this.currentPage + string;
        if (!this.TargetNames.containsKey(string2)) {
            if (this.MissingDestinations.containsKey(string2)) {
                this.TargetNames.put(string2, (String)this.MissingDestinations.get(string2));
                this.MissingDestinations.remove(string2);
            } else {
                this.TargetNames.put(string2, "page" + this.currentPage + "target" + this.targetNumber);
                ++this.targetNumber;
            }
            return (String)this.TargetNames.get(string2);
        }
        return "";
    }

    public void addResource(String string) {
        try {
            if (!this.Resources.containsKey(string)) {
                int n;
                byte[] byArray = new byte[8192];
                this.addXPSFile(resourcesPrefix + string);
                FileInputStream fileInputStream = new FileInputStream(string);
                while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                    this.XPSStream.write(byArray, 0, n);
                }
                fileInputStream.close();
                this.endXPSFile();
                this.Resources.put(string, this.getGUID());
            }
        }
        catch (IOException iOException) {
            this.errorHandler.error("Cannot add resource: " + iOException);
        }
    }

    public void svgPath(String string, String string2, String string3, float f) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("", "Data", "Data", "CDATA", string);
        this.svgSetFillStroke(string2, string3);
        this.attrs.addAttribute("", "StrokeThickness", "StrokeThickness", "CDATA", "" + f);
        this.serializer.startElement("", "Path", "", this.attrs);
        this.serializer.endElement("", "Path", "");
    }

    public void svgRect(float f, float f2, float f3, float f4, String string, String string2, float f5) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("", "Data", "Data", "CDATA", "M " + f + "," + f2 + " h " + f3 + " v " + f4 + " H " + f + " z");
        this.svgSetFillStroke(string, string2);
        this.attrs.addAttribute("", "StrokeThickness", "StrokeThickness", "CDATA", "" + f5);
        this.serializer.startElement("", "Path", "", this.attrs);
        this.serializer.endElement("", "Path", "");
    }

    public void svgSetFillStroke(String string, String string2) throws SAXException {
        if (!string.equals("")) {
            this.attrs.addAttribute("", "Fill", "Fill", "CDATA", string);
        }
        if (!string2.equals("")) {
            this.attrs.addAttribute("", "Stroke", "Stroke", "CDATA", string2);
        }
    }

    public void svgLine(float f, float f2, float f3, float f4, String string, String string2, float f5) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("", "Data", "Data", "CDATA", "M " + f + "," + f2 + " L " + f3 + "," + f4);
        this.svgSetFillStroke(string, string2);
        this.attrs.addAttribute("", "StrokeThickness", "StrokeThickness", "CDATA", "" + f5);
        this.serializer.startElement("", "Path", "", this.attrs);
        this.serializer.endElement("", "Path", "");
    }

    public void svgCircle(float f, float f2, float f3, String string, String string2, float f4) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("", "Data", "Data", "CDATA", "M " + (f - f3) + "," + f2 + " A " + f3 + "," + f3 + " 0 0 1 " + (f + f3) + "," + f2 + " A " + f3 + "," + f3 + " 0 0 1 " + (f - f3) + "," + f2 + " z");
        this.svgSetFillStroke(string, string2);
        this.attrs.addAttribute("", "StrokeThickness", "StrokeThickness", "CDATA", "" + f4);
        this.serializer.startElement("", "Path", "", this.attrs);
        this.serializer.endElement("", "Path", "");
    }

    public void svgEllipse(float f, float f2, float f3, float f4, String string, String string2, float f5) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("", "Data", "Data", "CDATA", "M " + (f - f3) + "," + f2 + " A " + f3 + "," + f4 + " 0 0 1 " + (f + f3) + "," + f2 + " A " + f3 + "," + f4 + " 0 0 1 " + (f - f3) + "," + f2 + " z");
        this.svgSetFillStroke(string, string2);
        this.attrs.addAttribute("", "StrokeThickness", "StrokeThickness", "CDATA", "" + f5);
        this.serializer.startElement("", "Path", "", this.attrs);
        this.serializer.endElement("", "Path", "");
    }

    public void svgPolygon(String string, String string2, String string3, String string4, float f) throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("", "Data", "Data", "CDATA", "M " + string + " L " + string2 + " z");
        this.svgSetFillStroke(string3, string4);
        this.attrs.addAttribute("", "StrokeThickness", "StrokeThickness", "CDATA", "" + f);
        this.serializer.startElement("", "Path", "", this.attrs);
        this.serializer.endElement("", "Path", "");
    }

    public void svgPolyline(String string, String string2, String string3, String string4, float f) throws SAXException {
        this.attrs.clear();
        this.svgSetFillStroke(string3, string4);
        this.attrs.addAttribute("", "StrokeThickness", "StrokeThickness", "CDATA", "" + f);
        this.serializer.startElement("", "Path", "", this.attrs);
        this.attrs.clear();
        this.serializer.startElement("", "Path.Data", "", this.attrs);
        this.serializer.startElement("", "PathGeometry", "", this.attrs);
        this.attrs.addAttribute("", "StartPoint", "StartPoint", "CDATA", string);
        this.serializer.startElement("", "PathFigure", "", this.attrs);
        this.attrs.clear();
        this.attrs.addAttribute("", "Point", "Points", "CDATA", string2);
        this.serializer.startElement("", "PolyLineSegment", "", this.attrs);
        this.serializer.endElement("", "PolyLineSegment", "");
        this.serializer.endElement("", "PathFigure", "");
        this.serializer.endElement("", "PathGeometry", "");
        this.serializer.endElement("", "Path.Data", "");
        this.serializer.endElement("", "Path", "");
    }

    static {
        Mimes.put("image/png", "png");
        Mimes.put("image/jpeg", "jpg");
        Mimes.put("image/jpg", "jpg");
        Mimes.put("image/tiff", "tiff");
        Mimes.put("image/svg", "svg");
        Mimes.put("image/svg+xml", "svg");
        Mimes.put("application/xepout", "xep");
        random = new Random();
        documentPrefix = "Documents/1/";
        fixedDocument = "FixedDocument.fdoc";
        pagesPrefix = "Pages/";
        resourcesPrefix = "Resources/";
        fontsPrefix = resourcesPrefix + "Fonts/";
        imagesPrefix = resourcesPrefix + "Images/";
        pageRelsPrefix = documentPrefix + pagesPrefix + "_rels/";
        docRelsName = "_rels/.rels";
        bookmarksRels = documentPrefix + "_rels/" + fixedDocument + ".rels";
        bookmarksXPSPath = "Structure/DocStructure.struct";
        resourceDictPath = resourcesPrefix + "dict.dict";
        currentColor = "000000";
    }

    protected class XPSFontObfuscatorStream
    extends FilterOutputStream {
        private int bytesProcessed = 0;
        private byte[] guidArray;
        private OutputStream outStream;

        public XPSFontObfuscatorStream(OutputStream outputStream, byte[] byArray) {
            super(outputStream);
            this.guidArray = byArray;
            this.outStream = outputStream;
        }

        public void write(byte[] byArray) throws IOException {
            if (this.bytesProcessed < 32) {
                int n = 0;
                while (n < byArray.length) {
                    this.write(byArray[n] & 0xFF);
                    ++n;
                }
            } else {
                super.write(byArray);
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.bytesProcessed < 32) {
                int n3 = 0;
                while (n3 < n2) {
                    this.write(byArray[n + n3] & 0xFF);
                    ++n3;
                }
            } else {
                super.write(byArray, n, n2);
            }
        }

        public void write(int n) throws IOException {
            if (this.bytesProcessed < 32) {
                this.outStream.write(n ^ this.guidArray[this.bytesProcessed % this.guidArray.length]);
                ++this.bytesProcessed;
            } else {
                this.outStream.write(n);
            }
        }
    }

    protected class Bookmark {
        private Integer id;
        private Integer parentId;
        private int number;
        private int pageNumber;
        private String label;
        private String target;
        private List children = new List();
        private boolean isExternal;
        private String origdst;

        public Bookmark(int n, int n2, int n3, String string, String string2, boolean bl) {
            this.origdst = string2;
            this.isExternal = bl;
            this.id = new Integer(n);
            this.parentId = new Integer(n2);
            this.pageNumber = n3;
            this.label = string;
            this.target = this.isExternal ? string2 : "page" + this.pageNumber + string2;
        }
    }

    protected class XPSU28
    extends U28 {
        XPSU28() {
            super(XPSDocument.this.fontCatalog);
        }

        protected void flushTextBuffer() {
            this.itxt = 0;
        }

        protected boolean isOneByteText(FontRecord fontRecord) {
            switch (fontRecord.datatype) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 4: {
                    return false;
                }
            }
            throw new RuntimeException("Invalid data type in font record");
        }

        protected boolean isProcessAsUnicode(FontRecord fontRecord) {
            return false;
        }
    }
}

