/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.gen.backends;

import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.ppmllib.PPMLDocument;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.URLSpec;
import com.renderx.xep.gen.H4base;
import com.renderx.xep.lib.LicenseException;
import com.renderx.xep.lib.Session;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class H4PPML
extends H4base {
    private Attributes docAtts = null;
    private PPMLDocument ppml = null;
    private boolean inside_a_page = false;
    private static final Hashtable optab = new Hashtable();
    private static final List supportedTargetFormats = new List();
    private static final short O_DEBUG_ZIP_CONTENT = 0;
    private static final short O_TARGET_FORMAT = 1;
    private static final short O_GA_LEVEL = 2;
    private static final String DEFAULT_TARGET_FORMAT = "PS";
    private static final int DEFAULT_GA_LEVEL = 0;
    private boolean DEBUG_ZIP_CONTENT;
    private String TARGET_FORMAT;
    private int GA_LEVEL;

    protected void resetDefaultOptions() {
        this.DEBUG_ZIP_CONTENT = false;
        this.TARGET_FORMAT = DEFAULT_TARGET_FORMAT;
        this.GA_LEVEL = 0;
    }

    protected void setOption(String string, String string2) {
        Object object = optab.get(string);
        if (object == null) {
            this.session.warning("Unrecognized PPML option \"" + string + "\": setting ignored");
            return;
        }
        switch ((Short)object) {
            case 0: {
                this.DEBUG_ZIP_CONTENT = "true".equalsIgnoreCase(string2);
                try {
                    this.ppml.setDebug(this.DEBUG_ZIP_CONTENT);
                }
                catch (Exception exception) {}
                break;
            }
            case 1: {
                this.TARGET_FORMAT = null;
                Enumeration enumeration = supportedTargetFormats.elements();
                while (enumeration.hasMoreElements()) {
                    if (!string2.equals((String)enumeration.nextElement())) continue;
                    this.TARGET_FORMAT = string2;
                }
                if (this.TARGET_FORMAT == null) {
                    this.session.warning("Unsupported target format \"" + string2 + "\" for PPML generator; reset to " + DEFAULT_TARGET_FORMAT + ".");
                    this.TARGET_FORMAT = DEFAULT_TARGET_FORMAT;
                }
                try {
                    this.ppml.setFormat(this.TARGET_FORMAT);
                }
                catch (Exception exception) {}
                break;
            }
            case 2: {
                if ("0".equals(string2) || "1".equals(string2) || "2".equals(string2) || "-1".equals(string2)) {
                    this.GA_LEVEL = Integer.parseInt(string2);
                } else {
                    this.session.warning("Incorrect Graphic Arts Conformance level: \"" + string2 + "\"; reset to " + 0 + ".");
                }
                try {
                    this.ppml.setGA(this.GA_LEVEL);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String outFormat() {
        return "ppml";
    }

    protected String getPropertyPrefix() {
        return "com.renderx.xep.H4PPML.";
    }

    protected String getProcessingInstructionPrefix() {
        return "xep-ppml-";
    }

    public H4PPML(OutputStream outputStream, Session session, Properties properties) throws IOException, LicenseException {
        super(outputStream, session, properties);
        if (!session.config.PPML && !session.config.PPMLTrial) {
            session.error("PPML support is not licensed for this installation.");
            throw new LicenseException("PPML support is not licensed for this installation.");
        }
        this.ppml = new PPMLDocument(this.outstream, this.TARGET_FORMAT, this.GA_LEVEL, session);
        this.ppml.setDebug(this.DEBUG_ZIP_CONTENT);
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!"http://www.renderx.com/XEP/xep".equals(string)) {
            return;
        }
        switch ((Short)H4base.idtab.get(string2)) {
            case 0: {
                this.docAtts = new AttributesImpl(attributes);
                this.ppml.setCreator(attributes.getValue("creator"));
                this.ppml.startDocument();
                break;
            }
            case 1: {
                this.inside_a_page = true;
                this.ppml.storage.startDocument();
                this.ppml.pistorage.play();
                this.ppml.storage.startElement("http://www.renderx.com/XEP/xep", "document", "xep:document", this.docAtts);
                this.ppml.storage.startElement(string, string2, string3, attributes);
                this.ppml.startPage(attributes);
                break;
            }
            case 15: {
                if ("true".equals(attributes.getValue("is-background"))) {
                    this.ppml.storage.startElement(string, string2, string3, attributes);
                    this.ppml.storage.endElement(string, string2, string3);
                    return;
                }
                String string4 = attributes.getValue("src");
                String string5 = attributes.getValue("base");
                URLSpec uRLSpec = null;
                try {
                    uRLSpec = new URLSpec(string5 == null ? null : new URLSpec(string5), string4);
                }
                catch (MalformedURLException malformedURLException) {
                    this.session.error("Failed to create URL from \"" + string4 + "\": " + malformedURLException.getMessage());
                    return;
                }
                String string6 = attributes.getValue("type");
                Image image = null;
                try {
                    image = this.session.config.imageFactory.makeImage(uRLSpec, string6);
                }
                catch (IOException iOException) {
                    this.session.error("Failed to create image \"" + uRLSpec + "\" of type \"" + string6 + "\": " + iOException.getMessage());
                    return;
                }
                catch (ImageFormatException imageFormatException) {
                    this.session.error("Failed to create image \"" + uRLSpec + "\" of type \"" + string6 + "\": " + imageFormatException.getMessage());
                    return;
                }
                catch (UnregisteredMIMETypeException unregisteredMIMETypeException) {
                    this.session.error("Failed to create image \"" + uRLSpec + "\" of type \"" + string6 + "\": " + unregisteredMIMETypeException.getMessage());
                    return;
                }
                if (this.GA_LEVEL < 0 || !this.ppml.isCacheableResource(image)) {
                    this.ppml.storage.startElement(string, string2, string3, attributes);
                    this.ppml.storage.endElement(string, string2, string3);
                    return;
                }
                this.ppml.placeImage(image, attributes.getValue("x-from"), attributes.getValue("y-from"), attributes.getValue("scale-x"), attributes.getValue("scale-y"), "" + image.width * 1000.0, "" + image.height * 1000.0);
                break;
            }
            case 2: {
                this.ppml.rotate(PPMLDocument.parseAngle(attributes.getValue("phi")));
                this.ppml.storage.startElement(string, string2, string3, attributes);
                break;
            }
            case 3: {
                this.ppml.translate(PPMLDocument.parseLength(attributes.getValue("x")), PPMLDocument.parseLength(attributes.getValue("y")));
                this.ppml.storage.startElement(string, string2, string3, attributes);
                break;
            }
            case 4: {
                this.ppml.transform(PPMLDocument.parseFloat(attributes.getValue("a")), PPMLDocument.parseFloat(attributes.getValue("b")), PPMLDocument.parseFloat(attributes.getValue("c")), PPMLDocument.parseFloat(attributes.getValue("d")), PPMLDocument.parseFloat(attributes.getValue("e")), PPMLDocument.parseFloat(attributes.getValue("f")));
                this.ppml.storage.startElement(string, string2, string3, attributes);
                break;
            }
            case 24: 
            case 25: {
                break;
            }
            default: {
                this.ppml.storage.startElement(string, string2, string3, attributes);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!"http://www.renderx.com/XEP/xep".equals(string)) {
            return;
        }
        switch ((Short)H4base.idtab.get(string2)) {
            case 0: {
                this.ppml.endDocument();
                break;
            }
            case 1: {
                this.inside_a_page = false;
                this.ppml.storage.endElement(string, string2, string3);
                this.ppml.storage.endElement("http://www.renderx.com/XEP/xep", "document", "xep:document");
                this.ppml.storage.endDocument();
                this.ppml.endPage();
                break;
            }
            case 15: 
            case 24: 
            case 25: {
                break;
            }
            default: {
                this.ppml.storage.endElement(string, string2, string3);
            }
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.inside_a_page) {
            this.ppml.storage.processingInstruction(string, string2);
        } else {
            super.processingInstruction(string, string2);
            this.ppml.pistorage.processingInstruction(string, string2);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.ppml.storage.startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.ppml.storage.endPrefixMapping(string);
    }

    public void skippedEntity(String string) throws SAXException {
        this.ppml.storage.skippedEntity(string);
    }

    public void setDocumentLocator(Locator locator) {
        this.ppml.storage.setDocumentLocator(locator);
    }

    static {
        optab.put("DEBUG_ZIP_CONTENT", new Short(0));
        optab.put("TARGET_FORMAT", new Short(1));
        optab.put("GA_LEVEL", new Short(2));
        supportedTargetFormats.append(DEFAULT_TARGET_FORMAT);
        supportedTargetFormats.append("PDF");
        supportedTargetFormats.append("XEP");
    }
}

