/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.svg.css;

import java.io.InputStreamReader;
import junit.framework.Assert;
import junit.framework.TestCase;

public class Lexer {
    private String buffer;
    private int type = -1;
    private int current;
    private int parse;
    private int start;

    public Lexer(String string) {
        this.buffer = string;
        this.parse = 0;
        this.start = 0;
        this.current = this.buffer.length() == 0 ? -1 : this.nextChar();
    }

    public int getType() {
        return this.type;
    }

    public int getStartPosition() {
        return this.start;
    }

    private int nextChar() {
        if (this.parse < this.buffer.length()) {
            char c = this.buffer.charAt(this.parse++);
            this.current = c;
            return c;
        }
        if (this.parse == this.buffer.length()) {
            ++this.parse;
        }
        this.current = -1;
        return -1;
    }

    public String getStringValue() {
        return this.buffer.substring(this.start, this.parse - 1);
    }

    /*
     * Unable to fully structure code
     */
    public int nextToken() {
        var1_1 = 0;
        this.start = this.parse - 1;
        switch (this.current) {
            case -1: {
                this.type = 0;
                break;
            }
            case 123: {
                this.nextChar();
                this.type = 1;
                break;
            }
            case 125: {
                this.nextChar();
                this.type = 2;
                break;
            }
            case 61: {
                this.nextChar();
                this.type = 3;
                break;
            }
            case 43: {
                this.nextChar();
                this.type = 4;
                break;
            }
            case 45: {
                this.nextChar();
                this.type = 5;
                break;
            }
            case 44: {
                this.nextChar();
                this.type = 6;
                break;
            }
            case 59: {
                this.nextChar();
                this.type = 8;
                break;
            }
            case 40: {
                this.nextChar();
                this.type = 14;
                break;
            }
            case 41: {
                this.nextChar();
                this.type = 15;
                break;
            }
            case 58: {
                this.nextChar();
                this.type = 16;
                break;
            }
            case 34: 
            case 39: {
                this.type = this.string((char)this.current);
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                do {
                    this.nextChar();
                } while (Lexer.isSpace((char)this.current));
                this.type = 17;
                break;
            }
            case 47: {
                this.nextChar();
                if (this.current != 42) {
                    this.type = 10;
                    break;
                }
                this.nextChar();
                this.start = this.parse - 1;
                while (true) {
                    if (this.current != -1 && this.current != 42) {
                        this.nextChar();
                        continue;
                    }
                    do {
                        this.nextChar();
                    } while (this.current != -1 && this.current == 42);
                    if (this.current == -1 || this.current == 47) break;
                }
                if (this.current == -1) {
                    this.type = -1;
                    break;
                }
                this.nextChar();
                this.type = 18;
                break;
            }
            case 35: {
                this.nextChar();
                this.type = 27;
                break;
            }
            case 64: {
                this.nextChar();
                var1_1 = this.isIdent(this.parse - 1);
                if (var1_1 > 0 && "import".equalsIgnoreCase(this.buffer.substring(this.parse - 1, this.parse + var1_1 - 1))) {
                    this.parse += var1_1 - 1;
                    this.type = 28;
                } else {
                    this.type = -1;
                }
                this.nextChar();
                break;
            }
            case 33: {
                this.nextChar();
                this.type = 23;
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.nextChar();
                while (this.current >= 48 && this.current <= 57) {
                    this.nextChar();
                }
                if (this.current != 46) ** GOTO lbl133
                this.nextChar();
                if (this.current >= 48 && this.current <= 57) ** GOTO lbl133
                this.nextChar();
                this.type = -1;
                return -1;
lbl-1000:
                // 1 sources

                {
                    this.nextChar();
lbl133:
                    // 3 sources

                    ** while (this.isNotnum((int)this.current))
                }
lbl134:
                // 1 sources

                if (this.current == 46) {
                    this.nextChar();
                    this.type = -1;
                    return -1;
                }
                this.type = 51;
                break;
            }
            case 46: {
                this.nextChar();
                if (this.current >= 48 && this.current <= 57) {
                    while (this.isNotnum(this.current)) {
                        this.nextChar();
                    }
                    if (this.current == 46) {
                        this.nextChar();
                        this.type = -1;
                        return -1;
                    }
                    this.type = 51;
                    break;
                }
                this.type = 7;
                break;
            }
            default: {
                var1_1 = this.isIdent(this.start);
                if (var1_1 > 0) {
                    this.parse += var1_1 - 1;
                    this.nextChar();
                    if (this.current == 40) {
                        this.nextChar();
                        this.type = 52;
                        break;
                    }
                    this.type = 20;
                    break;
                }
                this.nextChar();
                this.type = -1;
            }
        }
        return this.type;
    }

    public int nextIgnoreSpaces() {
        boolean bl = true;
        while (bl) {
            switch (this.nextToken()) {
                case 17: 
                case 18: {
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return this.type;
    }

    public int skipSpaces() {
        if (this.type == 17 || this.type == 18) {
            return this.nextIgnoreSpaces();
        }
        return this.type;
    }

    private int isIdent(int n) {
        if (n >= this.buffer.length()) {
            return 0;
        }
        int n2 = n;
        int n3 = 0;
        n3 = this.isNmstrt(n2);
        if (n3 > 0) {
            while ((n3 = this.isNmchar(++n2)) > 0) {
                n2 += n3 - 1;
            }
        }
        return n2 - n;
    }

    private int isNmstrt(int n) {
        if (n >= this.buffer.length()) {
            return 0;
        }
        int n2 = n;
        int n3 = 0;
        char c = Character.toLowerCase(this.buffer.charAt(n2));
        if (c >= 'a' && c <= 'z' || c >= '\u00a1' && c <= '\u00ff') {
            return ++n2 - n;
        }
        n3 = this.isUnicode(n2);
        if (n3 > 0) {
            n2 += n3;
        }
        return n2 - n;
    }

    private int isNmchar(int n) {
        if (n >= this.buffer.length()) {
            return 0;
        }
        int n2 = n;
        int n3 = 0;
        char c = Character.toLowerCase(this.buffer.charAt(n2));
        if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= '\u00a1' && c <= '\u00ff' || c == '-' || c == '_') {
            return ++n2 - n;
        }
        n3 = this.isUnicode(n2);
        if (n3 > 0) {
            n2 += n3;
        }
        return n2 - n;
    }

    private int isUnicode(int n) {
        if (n >= this.buffer.length()) {
            return 0;
        }
        int n2 = n;
        if (this.buffer.charAt(n2) == '\\') {
            while (n2 < this.buffer.length() && n2 - n < 5 && (this.buffer.charAt(n2 + 1) >= '0' && this.buffer.charAt(n2 + 1) <= '9' || Character.toLowerCase(this.buffer.charAt(n2 + 1)) >= 'a' && Character.toLowerCase(this.buffer.charAt(n2 + 1)) <= 'z')) {
                ++n2;
            }
        }
        return n2 - n;
    }

    private boolean isNotnum(int n) {
        char c = Character.toLowerCase((char)n);
        return n >= 0 && (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= '\u00a1' && c <= '\u00ff' || c == '-' || c == '^' || c == '%');
    }

    private int string(char c) {
        this.start = this.parse - 1;
        this.nextChar();
        do {
            switch (this.current) {
                case -1: {
                    return -1;
                }
                case 92: {
                    this.nextChar();
                }
            }
            this.nextChar();
        } while (c != this.current);
        this.nextChar();
        return 19;
    }

    private static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f';
    }

    public static void main(String[] stringArray) throws Exception {
        char[] cArray = new char[8192];
        int n = 0;
        block0: while (true) {
            InputStreamReader inputStreamReader;
            if ((n = (inputStreamReader = new InputStreamReader(System.in)).read(cArray)) < 0) {
                System.exit(0);
            }
            Lexer lexer = new Lexer(new String(cArray, 0, n).trim());
            while (true) {
                lexer.nextToken();
                if (lexer.getType() == 0) continue block0;
                System.err.println("[" + lexer.getType() + "] \"" + lexer.getStringValue() + "\"");
            }
            break;
        }
    }

    public static final class Test
    extends TestCase {
        public void testLexer() {
            Lexer lexer = new Lexer("abc abc a abc-40 a&");
            Assert.assertTrue((lexer.nextToken() == 20 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == 17 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == 20 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == 17 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == 20 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == 17 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == -1 ? 1 : 0) != 0);
            lexer = new Lexer("33 .2 33.2 33.% 33.2%pc 33a.2 33.2.a");
            Assert.assertTrue((lexer.nextToken() == 51 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == 17 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == 51 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == 17 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == 51 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == 17 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == 51 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == 17 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == 51 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == 17 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == 17 ? 1 : 0) != 0);
            Assert.assertTrue((lexer.nextToken() == -1 ? 1 : 0) != 0);
            lexer = new Lexer("/* 12345abcd */");
            Assert.assertTrue((lexer.nextToken() == 18 ? 1 : 0) != 0);
            lexer = new Lexer("/* 12345abcd ");
            Assert.assertTrue((lexer.nextToken() == -1 ? 1 : 0) != 0);
            lexer = new Lexer("\"abcd\\'dcba\"");
            Assert.assertTrue((lexer.nextToken() == 19 ? 1 : 0) != 0);
            lexer = new Lexer("\"abcd'dcba\"");
            Assert.assertTrue((lexer.nextToken() == -1 ? 1 : 0) != 0);
            lexer = new Lexer("abcd");
            lexer.nextToken();
            Assert.assertTrue((boolean)lexer.getStringValue().equals("abcd"));
        }
    }
}

