/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.graphics.vector.GraphicGroup;
import com.renderx.graphics.vector.ImageTree;
import com.renderx.pdflib.ColorSpace;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFImage;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;

public class SMask
extends PDFObject {
    PDFImage content = null;

    SMask(IndirectObject indirectObject) {
        super(indirectObject);
    }

    String getType() {
        return "Mask";
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println("/S /Luminosity");
        pDFOutputStream.println("/G " + this.content.getID().toStringR());
    }

    void setContent(IndirectObject indirectObject, GraphicGroup graphicGroup, double[] dArray) throws UnregisteredMIMETypeException {
        ImageTree imageTree = new ImageTree(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
        imageTree.root = (GraphicGroup)graphicGroup.clone();
        PDFImage.SubTreeVectorImage subTreeVectorImage = new PDFImage.SubTreeVectorImage(imageTree);
        subTreeVectorImage.supportsVectorRendering = true;
        this.content = new PDFImage(indirectObject, subTreeVectorImage);
        this.content.isSoftMask = true;
        this.content.colorSpace = new ColorSpace(4);
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        this.content.write(pDFOutputStream);
    }
}

