/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.fonts.AFMMetric;
import com.renderx.fonts.FontDescriptor;
import com.renderx.fonts.Metric;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import java.util.StringTokenizer;

public abstract class PDFFont
extends PDFObject {
    static final int FIXEDWIDTH = 1;
    static final int SERIF = 2;
    static final int SYMBOL = 4;
    static final int SCRIPT = 8;
    static final int ADOBESTANDARD = 32;
    static final int ITALIC = 64;
    static final int SMALLCAPS = 131072;
    static final int FORCEBOLD = 262144;
    static final int LAST_MODE = 7;
    boolean enableSubset;
    FontDescriptor descriptor;
    int encoding;
    String fontName;
    String subsetName;

    String getType() {
        return "Font";
    }

    abstract String getSubType();

    public PDFFont(IndirectObject indirectObject, FontDescriptor fontDescriptor) {
        super(indirectObject);
        this.descriptor = fontDescriptor;
        StringTokenizer stringTokenizer = new StringTokenizer(fontDescriptor.record.getMetric().fontName);
        this.fontName = "";
        while (stringTokenizer.hasMoreTokens()) {
            this.fontName = this.fontName + stringTokenizer.nextToken();
        }
        this.subsetName = "";
        this.enableSubset = true;
    }

    void setEnableSubset(boolean bl) {
        this.enableSubset = bl;
    }

    boolean getEnableSubset() {
        return this.enableSubset;
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println("/Subtype/" + this.getSubType());
        this.writeAddInfo(pDFOutputStream);
        pDFOutputStream.println("/BaseFont/" + this.subsetName + this.fontName);
    }

    void subsetName() {
        this.subsetName = "";
        int n = 1193046;
        int n2 = 0;
        while (n2 < 6) {
            int n3 = n >> 4 * n2 & 0xF;
            this.subsetName = this.subsetName + (char)(65 + n3);
            ++n2;
        }
        this.subsetName = this.subsetName + "+";
    }

    int make_fontflags() {
        Metric metric = this.descriptor.record.getMetric();
        int n = 0;
        if (metric.isFixedPitch) {
            n |= 1;
        }
        n = metric instanceof AFMMetric && ((AFMMetric)metric).encodingScheme.equals("AdobeStandardEncoding") ? (n |= 0x20) : (n |= 4);
        if (metric.italicAngle < 0.0f) {
            n |= 0x40;
        }
        if (metric.weight != null && metric.weight.equalsIgnoreCase("Bold")) {
            n |= 0x40000;
        }
        return n;
    }

    abstract void writeAddInfo(PDFOutputStream var1);

    abstract void writeSubObjects(PDFOutputStream var1);
}

