/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.Pages;
import com.renderx.util.Hashtable;
import java.util.Enumeration;

abstract class Bookmark
extends PDFObject {
    String label;
    String color;
    int font_flag;
    int external_id;
    int ext_parent_id;
    IndirectObject parent_id;
    IndirectObject prev_id;
    IndirectObject next_id;
    IndirectObject first_id;
    IndirectObject last_id;
    int count;
    boolean open;
    Hashtable bookmarks;

    Bookmark(IndirectObject indirectObject, String string, int n, int n2, int n3, boolean bl) {
        super(indirectObject);
        this.label = string;
        this.font_flag = n;
        this.external_id = n2;
        this.ext_parent_id = n3;
        this.parent_id = null;
        this.prev_id = null;
        this.next_id = null;
        this.first_id = null;
        this.last_id = null;
        this.count = 0;
        this.bookmarks = null;
        this.open = bl;
    }

    void setType() {
    }

    void addOutline(Bookmark bookmark) {
        this.bookmarks.put(new Integer(bookmark.getExternalID()), bookmark);
        if (bookmark.getParentID() == null) {
            if (this.first_id == null || this.first_id.num > bookmark.getID().num) {
                this.first_id = bookmark.getID();
            }
            if (this.last_id == null || this.last_id.num < bookmark.getID().num) {
                this.last_id = bookmark.getID();
            }
            ++this.count;
        }
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.generateCurrentKey(this.getID().num);
        this.writeBookmarkBody(pDFOutputStream);
        pDFOutputStream.print("/Title ");
        pDFOutputStream.print_annotation(this.label);
        pDFOutputStream.println("");
        if (this.color != null) {
            pDFOutputStream.println("/C [" + this.color + "]");
        }
        if (this.font_flag != 0) {
            pDFOutputStream.print("/F ");
            pDFOutputStream.print(" " + this.font_flag);
            pDFOutputStream.println("");
        }
        pDFOutputStream.println("/Parent " + this.parent_id.toStringR());
        if (this.next_id != null) {
            pDFOutputStream.println("/Next " + this.next_id.toStringR());
        }
        if (this.prev_id != null) {
            pDFOutputStream.println("/Prev " + this.prev_id.toStringR());
        }
        if (this.count != 0) {
            pDFOutputStream.println("/First " + this.first_id.toStringR());
            pDFOutputStream.println("/Last " + this.last_id.toStringR());
            pDFOutputStream.println("/Count " + (this.open ? "" : "-") + this.count);
        }
    }

    void setOpen(boolean bl) {
        this.open = bl;
    }

    void setColor(String string) {
        this.color = string;
    }

    int getExternalID() {
        return this.external_id;
    }

    int getExtParentID() {
        return this.ext_parent_id;
    }

    IndirectObject getParentID() {
        return this.parent_id;
    }

    IndirectObject getNextID() {
        return this.next_id;
    }

    IndirectObject getPrevID() {
        return this.prev_id;
    }

    IndirectObject getFirstID() {
        return this.first_id;
    }

    IndirectObject getLastID() {
        return this.last_id;
    }

    void setParentID(IndirectObject indirectObject) {
        this.parent_id = indirectObject;
    }

    void setNextID(IndirectObject indirectObject) {
        this.next_id = indirectObject;
    }

    void setPrevID(IndirectObject indirectObject) {
        this.prev_id = indirectObject;
    }

    void setFirstID(IndirectObject indirectObject) {
        this.first_id = indirectObject;
    }

    void setLastID(IndirectObject indirectObject) {
        this.last_id = indirectObject;
    }

    abstract void writeBookmarkBody(PDFOutputStream var1);

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        if (this.bookmarks == null) {
            return;
        }
        Enumeration enumeration = this.bookmarks.keys();
        while (enumeration.hasMoreElements()) {
            Bookmark bookmark = (Bookmark)this.bookmarks.get(enumeration.nextElement());
            bookmark.write(pDFOutputStream);
        }
    }

    boolean addBookmark(Bookmark bookmark) {
        if (this.bookmarks == null) {
            this.bookmarks = new Hashtable();
        }
        if (bookmark.getExtParentID() == this.external_id) {
            if (this.first_id == null || this.first_id.num > bookmark.getID().num) {
                this.first_id = bookmark.getID();
            }
            if (this.last_id == null || this.last_id.num < bookmark.getID().num) {
                this.last_id = bookmark.getID();
            }
            ++this.count;
            bookmark.setParentID(this.obj_id);
            this.addNext(bookmark);
            return true;
        }
        Bookmark bookmark2 = (Bookmark)this.bookmarks.get(new Integer(bookmark.getExtParentID()));
        if (bookmark2 != null) {
            bookmark2.addBookmark(bookmark);
            this.bookmarks.put(new Integer(bookmark2.getExternalID()), bookmark2);
            return true;
        }
        Enumeration enumeration = this.bookmarks.keys();
        while (enumeration.hasMoreElements()) {
            Bookmark bookmark3 = (Bookmark)this.bookmarks.get(enumeration.nextElement());
            if (!bookmark3.addBookmark(bookmark)) continue;
            this.bookmarks.put(new Integer(bookmark3.getExternalID()), bookmark3);
            return true;
        }
        return false;
    }

    void addNext(Bookmark bookmark) {
        Enumeration enumeration = this.bookmarks.keys();
        IndirectObject indirectObject = null;
        Bookmark bookmark2 = null;
        while (enumeration.hasMoreElements() && indirectObject == null) {
            bookmark2 = (Bookmark)this.bookmarks.get(enumeration.nextElement());
            if (bookmark2.getNextID() != null) continue;
            indirectObject = bookmark2.getID();
        }
        if (indirectObject != null && bookmark2 != null) {
            bookmark.setPrevID(indirectObject);
            bookmark2.setNextID(bookmark.getID());
            this.bookmarks.put(new Integer(bookmark2.getExternalID()), bookmark2);
        }
        this.bookmarks.put(new Integer(bookmark.getExternalID()), bookmark);
    }

    void finish(Pages pages) {
        if (this.bookmarks == null) {
            return;
        }
        Enumeration enumeration = this.bookmarks.keys();
        while (enumeration.hasMoreElements()) {
            Bookmark bookmark = (Bookmark)this.bookmarks.get(enumeration.nextElement());
            bookmark.finish(pages);
            this.bookmarks.put(new Integer(bookmark.getExternalID()), bookmark);
        }
    }
}

