/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts.afp;

import com.renderx.fonts.afp.FontResourceObject;
import com.renderx.fonts.afp.GraphicCharacterData;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;

public class CodePage
extends FontResourceObject {
    public static final byte[] BCP = new byte[]{-45, -88, -121};
    public static final byte[] CPD = new byte[]{-45, -90, -121};
    public static final byte[] CPC = new byte[]{-45, -89, -121};
    public static final byte[] CPI = new byte[]{-45, -116, -121};
    private String name;
    private String description;
    private byte[] gcGIDLength;
    private byte[] cgcLength;
    private byte[] gcsGID;
    private byte[] cpGID;
    private byte[] encodingScheme;
    private String defaultGCGID;
    private byte defaultCharacterFlags;
    private byte cpiRepeatingGroupLength;
    private byte spaceCharSectionNumber;
    private byte spaceCharCodePoint;
    private byte codePageFlags;
    private HashMap codePageIndex;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public byte[] getGcGIDLength() {
        return this.gcGIDLength;
    }

    public byte[] getCgcLength() {
        return this.cgcLength;
    }

    public byte[] getGcsGID() {
        return this.gcsGID;
    }

    public byte[] getCpGID() {
        return this.cpGID;
    }

    public byte[] getEncodingScheme() {
        return this.encodingScheme;
    }

    public String getDefaultGCGID() {
        return this.defaultGCGID;
    }

    public byte getDefaultCharacterFlags() {
        return this.defaultCharacterFlags;
    }

    public byte getCpiRepeatingGroupLength() {
        return this.cpiRepeatingGroupLength;
    }

    public byte getSpaceCharSectionNumber() {
        return this.spaceCharSectionNumber;
    }

    public byte getSpaceCharCodePoint() {
        return this.spaceCharCodePoint;
    }

    public byte getCodePageFlags() {
        return this.codePageFlags;
    }

    public HashMap getCodePageIndex() {
        return this.codePageIndex;
    }

    public void load(String string) throws IOException {
        this.load(new FileInputStream(string));
    }

    public void load(InputStream inputStream) throws IOException {
        byte[] byArray = FontResourceObject.readStructuredField(inputStream, BCP);
        byte[] byArray2 = new byte[8];
        int n = 0;
        while (n < byArray.length) {
            if (n < 8) {
                byArray2[n] = byArray[n];
            }
            ++n;
        }
        this.name = new String(byArray2, this.getEncoding()).trim();
        byArray2 = null;
        byArray = FontResourceObject.readStructuredField(inputStream, CPD);
        byte[] byArray3 = new byte[32];
        this.gcGIDLength = new byte[2];
        this.cgcLength = new byte[4];
        this.gcsGID = new byte[2];
        this.cpGID = new byte[2];
        this.encodingScheme = new byte[2];
        int n2 = 0;
        while (n2 < byArray.length) {
            if (n2 <= 31) {
                byArray3[n2] = byArray[n2];
            } else if (n2 <= 33) {
                this.gcGIDLength[n2 - 32] = byArray[n2];
            } else if (n2 <= 37) {
                this.cgcLength[n2 - 34] = byArray[n2];
            } else if (n2 <= 39) {
                this.gcsGID[n2 - 38] = byArray[n2];
            } else if (n2 <= 41) {
                this.cpGID[n2 - 40] = byArray[n2];
            } else if (n2 <= 43) {
                this.encodingScheme[n2 - 42] = byArray[n2];
            }
            ++n2;
        }
        this.description = new String(byArray3, FontResourceObject.EBCDIC).trim();
        byArray3 = null;
        byArray = FontResourceObject.readStructuredField(inputStream, CPC);
        byte[] byArray4 = new byte[8];
        int n3 = 0;
        while (n3 < byArray.length) {
            if (n3 <= 7) {
                byArray4[n3] = byArray[n3];
            } else if (n3 == 8) {
                this.defaultCharacterFlags = byArray[n3];
            } else if (n3 == 9) {
                this.cpiRepeatingGroupLength = byArray[n3];
            } else if (n3 == 10) {
                this.spaceCharSectionNumber = byArray[n3];
            } else if (n3 == 11) {
                this.spaceCharCodePoint = byArray[n3];
            } else if (n3 == 12) {
                this.codePageFlags = byArray[n3];
            }
            ++n3;
        }
        this.defaultGCGID = new String(byArray4, FontResourceObject.EBCDIC).trim();
        byArray4 = null;
        byArray = FontResourceObject.readStructuredField(inputStream, CPI);
        this.codePageIndex = new HashMap();
        byte[] byArray5 = new byte[this.cpiRepeatingGroupLength];
        int n4 = 0;
        int n5 = 0;
        while (n5 < byArray.length) {
            int n6 = n5 - this.cpiRepeatingGroupLength * n4;
            byArray5[n6] = byArray[n5];
            if (n6 == this.cpiRepeatingGroupLength - 1) {
                GraphicCharacterData graphicCharacterData = new GraphicCharacterData();
                graphicCharacterData.parse(byArray5, this.getEncoding());
                Integer n7 = new Integer(FontResourceObject.bytesToInt(graphicCharacterData.getCodePoint()));
                this.codePageIndex.put(n7, graphicCharacterData);
                byArray5 = new byte[this.cpiRepeatingGroupLength];
                ++n4;
            }
            ++n5;
        }
        byArray5 = null;
        byArray = null;
    }

    public char[] getCharactersByGcgid(String string) {
        char[] cArray = new char[]{};
        Iterator iterator = this.codePageIndex.values().iterator();
        while (iterator.hasNext()) {
            GraphicCharacterData graphicCharacterData = (GraphicCharacterData)iterator.next();
            if (graphicCharacterData == null || !graphicCharacterData.getGlobalID().equals(string)) continue;
            char[] cArray2 = new char[cArray.length + 1];
            int n = 0;
            while (n < cArray.length) {
                cArray2[n] = cArray[n];
                ++n;
            }
            cArray2[cArray2.length - 1] = graphicCharacterData.getCharacter();
            cArray = cArray2;
        }
        return cArray;
    }
}

