/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.AFP;
import com.renderx.afplib.AFPDocument;
import com.renderx.afplib.AFPException;
import com.renderx.afplib.AFPInternalException;
import com.renderx.afplib.ConfigManager;
import com.renderx.afplib.Point2D;
import com.renderx.afplib.XBilevelShadingPattern;
import com.renderx.afplib.XGraphic;
import com.renderx.afplib.XGreyScaleImage;
import com.renderx.afplib.XNativeImage;
import com.renderx.afplib.XTIFFFaxImage;
import com.renderx.graphics.BitmapImage;
import com.renderx.graphics.Image;
import com.renderx.util.ErrorHandler;
import com.renderx.xep.lib.Conf;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.imageio.ImageIO;

public abstract class XImage {
    private static final double[][] convFactors = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.299, 0.587, 0.114, 0.0}, {0.0, 0.299, 0.587, 0.114}};
    private static int MAX_8BIT_UNUMBER = 255;
    private static int HALF_MAX_8BIT_UNUMBER = 127;
    protected Image image;
    protected Raster raster = null;
    public Point2D pixelSize;
    protected Point2D resolution;
    protected int minX;
    protected int minY;
    public byte[] data;
    protected ErrorHandler logger;
    public XGraphic graphic;

    protected XImage(Image image) {
        this.image = image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadImage() throws MalformedURLException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.image.openImageStream();
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            if (bufferedImage == null) {
                throw new AFPException("Can't process image " + this.image.source + ". Image format is not supported.");
            }
            this.raster = bufferedImage.getRaster();
            this.pixelSize = new Point2D(this.raster.getWidth(), this.raster.getHeight());
            this.minX = this.raster.getMinX();
            this.minY = this.raster.getMinY();
            BitmapImage bitmapImage = (BitmapImage)this.image;
            this.resolution = new Point2D(bitmapImage.horzResolution, bitmapImage.vertResolution);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public abstract short getIOCAEncodingCode();

    public short getIocaRecordingCode() {
        short s = 0;
        if (this.image instanceof BitmapImage) {
            s = AFP.getCompressionAlgorithmCode((BitmapImage)this.image);
        }
        return s;
    }

    public abstract short getIDESize();

    public void writeImageData(AFP aFP) throws IOException {
        for (int i = 0; i < this.data.length; i += 32000) {
            int n = 32000;
            if (i + n >= this.data.length) {
                n = this.data.length - i;
            }
            aFP.writeModcaSF("IPD", 12 + n);
            aFP.writeIocaESDF(65170, n);
            int n2 = aFP.writeBytes(this.data, i, n);
            aFP.flush();
        }
    }

    protected static boolean isDarkPixel(Raster raster, int n, int n2) {
        return XImage.grayWeight(raster, n, n2) > HALF_MAX_8BIT_UNUMBER;
    }

    protected static int grayWeight(Raster raster, int n, int n2) {
        int n3 = raster.getNumBands();
        double d = 0.0;
        for (int i = 0; i < n3; ++i) {
            int n4 = raster.getSampleModel().getSampleSize(i);
            double d2 = raster.getSample(n2, n, i);
            double d3 = d2 * convFactors[n3 - 1][i] * (double)MAX_8BIT_UNUMBER / (Math.pow(2.0, n4) - 1.0);
            d += d3;
        }
        return (int)d;
    }

    public static XImage createImageProcessor(XGraphic xGraphic, ConfigManager configManager) {
        Conf.DataType dataType;
        AFPDocument aFPDocument = xGraphic.document;
        if (xGraphic.isShadingPattern()) {
            XBilevelShadingPattern.Key key = new XBilevelShadingPattern.Key(xGraphic);
            XImage xImage = aFPDocument.checkCache(key);
            if (xImage != null) {
                return xImage;
            }
            xImage = new XBilevelShadingPattern(xGraphic, configManager);
            aFPDocument.addToCache(key, xImage);
            return xImage;
        }
        XImage xImage = aFPDocument.checkCache(xGraphic.image.source);
        if (xImage != null) {
            return xImage;
        }
        AFP.EmbeddableObjectType embeddableObjectType = AFP.getMoDcaEmbeddableObjectType(xGraphic.mimeType);
        xImage = embeddableObjectType != null && XImage.isMimeTypeAllowedNative(xGraphic) ? new XNativeImage(xGraphic) : ((dataType = XImage.getConfig(xGraphic).getDefaultDataType()) == null || dataType.getCompressionCode() == 130 ? new XTIFFFaxImage(xGraphic.image) : new XGreyScaleImage(xGraphic.image));
        aFPDocument.addToCache(xGraphic.image.source, xImage);
        return xImage;
    }

    public static boolean isMimeTypeAllowedNative(XGraphic xGraphic) {
        Conf.DataType dataType = XImage.getConfig(xGraphic).getDataType(xGraphic.mimeType);
        return null != dataType && dataType.isAllowInstream();
    }

    public ConfigManager getConfig() {
        return this.graphic.page.getConfig();
    }

    public static ConfigManager getConfig(XGraphic xGraphic) {
        return xGraphic.page.getConfig();
    }

    public static boolean isMimeTypeValid(String string) {
        AFP.EmbeddableObjectType embeddableObjectType = AFP.getMoDcaEmbeddableObjectType(string);
        return embeddableObjectType != null;
    }

    public void writeExtras(AFP aFP) throws IOException, AFPInternalException {
    }

    public int getExtrasSize() {
        return 0;
    }

    public Point2D getResolution() {
        return this.resolution;
    }
}

