/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afpcommon.CodePage;
import com.renderx.afplib.AFPException;
import com.renderx.afplib.XFont;
import com.renderx.fonts.AFPMetric;
import com.renderx.fonts.FontRecord;
import com.renderx.graphics.vector.FontSpec;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.xep.lib.Session;
import java.util.Arrays;
import java.util.Map;
import org.xml.sax.Attributes;

public class FontFactory {
    private Map afpFonts;
    private Session session;
    private ErrorHandler logger;
    private CodePage codePage;
    private int lastFontLocalID = 0;
    private Hashtable generatedFonts;

    public FontFactory(Hashtable hashtable, Map map, Session session, ErrorHandler errorHandler, CodePage codePage, int n) {
        this.afpFonts = map;
        this.session = session;
        this.logger = errorHandler;
        this.codePage = codePage;
        this.lastFontLocalID = n;
        this.generatedFonts = hashtable;
    }

    public XFont getXFont(Attributes attributes) {
        String string = attributes.getValue("family");
        int n = Integer.parseInt(attributes.getValue("weight"));
        String string2 = attributes.getValue("style");
        String string3 = attributes.getValue("variant");
        int n2 = Integer.parseInt(attributes.getValue("size").trim());
        return this.getXFont(string, string2, n, string3, n2);
    }

    public XFont getXFont(Attributes attributes, CodePage codePage) {
        this.codePage = codePage;
        return this.getXFont(attributes);
    }

    public XFont getXFont(FontSpec fontSpec) {
        String string = fontSpec.family;
        int n = fontSpec.weight;
        String string2 = fontSpec.style;
        String string3 = fontSpec.variant;
        int n2 = (int)fontSpec.size;
        return this.getXFont(string, string2, n, string3, n2);
    }

    private XFont getXFont(String string, String string2, int n, String string3, int n2) {
        XFont xFont = null;
        Object[] objectArray = null;
        FontRecord fontRecord = this.session.config.fontCatalog.getFontRecord(string, n, string2, string3, n2 / 1000);
        if (fontRecord != null && fontRecord.getMetric() != null && fontRecord.getMetric() instanceof AFPMetric) {
            AFPMetric aFPMetric = (AFPMetric)fontRecord.getMetric();
            CodePage codePage = new CodePage(aFPMetric.codepageName, aFPMetric.encoding, 0, 0, true);
            objectArray = new String[9];
            Arrays.fill(objectArray, aFPMetric.charsetName);
            objectArray[8] = "" + aFPMetric.wordSpacing;
            xFont = new XFont(this.session, string, string2, n, string3, n2, (String[])objectArray, codePage);
            this.setTextStyle(xFont);
            return xFont;
        }
        objectArray = (String[])this.afpFonts.get(string);
        if (objectArray != null) {
            xFont = new XFont(this.session, string, string2, n, string3, n2, (String[])objectArray, this.codePage);
        } else {
            this.logger.warning("Could not find any font family matching " + string + "; replaced by " + "Helvetica");
            xFont = XFont.createDefaultFont(this.session, this.afpFonts, this.codePage);
        }
        this.setTextStyle(xFont);
        return xFont;
    }

    public XFont setTextStyle(XFont xFont) {
        if (xFont != null) {
            this.registerCodedFont(xFont);
        }
        return xFont;
    }

    private void registerCodedFont(XFont xFont) throws AFPException {
        try {
            Integer n = (Integer)this.generatedFonts.get(xFont);
            if (n == null) {
                xFont.fontAFPLocalId = ++this.lastFontLocalID;
                this.generatedFonts.put(xFont, new Integer(xFont.fontAFPLocalId));
            } else {
                xFont.fontAFPLocalId = n;
            }
        }
        catch (Exception exception) {
            throw new AFPException(exception);
        }
    }
}

