package com.renderx.xepx.x4u.ct;
/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

import org.xml.sax.*;
import org.xml.sax.helpers.NamespaceSupport;
import com.renderx.util.*;

import java.io.IOException;

/**
 * A generic serializer class. Just saves data to an output destination.
 * It tries to reproduce prefixes found in the original document;
 * if they cannot be restored safely, it invents ones of its own.
 * The serializer expects namespace support to be turned on.
 */

public class Serializer implements ContentHandler {
  private java.io.BufferedWriter out = null;
  private String topURI = null;
  private Hashtable uritab = new Hashtable();
  private Hashtable prefixtab = new Hashtable();
  private boolean hasUTF8 = true;
  private boolean opentag = true;
  private boolean closeOnExit = false;
  private Stack elementNames = new Stack();
  private int prefIndex = 0;
  private static final String[] prefixCharacters = {
    "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m",
    "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"
  };


  /** Constructs an empty serializer. Output writer shall be initialized later. */
  public Serializer () {}

  /** Constructs a serializer from a file name */
  public Serializer (String name) throws IOException {
    this(new java.io.FileOutputStream(name));
    closeOnExit = true;
  }

  /** Constructs a serializer from an output stream */
  public Serializer (java.io.OutputStream ostream) throws IOException {
    super();
    try {
      setWriter(new java.io.OutputStreamWriter(ostream, "UTF8"));
      hasUTF8 = true;
    } catch (java.io.UnsupportedEncodingException e) {
      setWriter(new java.io.OutputStreamWriter(ostream));
      hasUTF8 = false;
    }
  }

  /** Constructs a serializer from a writer */
  public Serializer (java.io.Writer writer) {
    super(); setWriter(writer);
  }

  /** Sets an output writer  */
  public void setWriter (java.io.Writer writer) {
    out = new java.io.BufferedWriter(writer);
  }

  public java.io.Writer getWriter(){
    return out;
  }
  // SAX methods


  public void startDocument() throws SAXException {
    opentag = false;
    elementNames.clear();
    topURI = null;
    try {
      out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
      out.newLine();
    } catch (IOException e) {
      throw new SAXException(e);
    }
  }

  public void endDocument() throws SAXException {
    try {
      if (opentag) { out.write (">"); opentag = false; }
      out.flush();
      if (closeOnExit) out.close();
    } catch (IOException e) {
      throw new SAXException(e);
    }
  }

  public void processingInstruction(String target, String data) throws SAXException {
    try {
      if (opentag) { out.write (">"); opentag = false; }
      out.write("<?");
      writeMarkupElement(target);
      if (data != null && data.length() > 0) {
        out.write(' ');
        writeMarkupElement(data);
      }
      out.write("?>");
    } catch (IOException e) {
      throw new SAXException(e);
    }
  }

  public void characters(char ch[], int start, int length) throws SAXException {
    try {
      if (opentag) { out.write (">"); opentag = false; }
      writePCDATA(ch, start, length);
    } catch (IOException e) {
      throw new SAXException(e);
    }
  }

  public void ignorableWhitespace(char ch[], int start, int length) throws SAXException {
    characters(ch, start, length);
  }

  public void skippedEntity(String name) {}

  public void startPrefixMapping(String uri, String prefix) {}

  public void endPrefixMapping(String prefix) {}

  public void setDocumentLocator(Locator locator) {}

  public void startElement(String uri, String name, String qname,
                           Attributes attrs) throws SAXException {
    String prefix = null;
    if (name != null) {
      if (uri == null || uri.length() == 0) {
        qname = name;
      } else {
        prefix = (String)uritab.get(uri);
        if (prefix == null) {
          if (uri.equals(NamespaceSupport.XMLNS)) prefix = "xml";
          else prefix = assignPrefix(uri, qname);
        }
        qname = prefix +":" + name;
      }
    }
    elementNames.push(qname);

    try {
      if (opentag) out.write (">");
      out.write("<"); writeMarkupElement(qname);

      if (name != null &&
          uri != null && uri.length() != 0 &&
          !uri.equals(NamespaceSupport.XMLNS) &&
          !uri.equals(topURI)) {
        out.write(" xmlns:"); writeMarkupElement(prefix);
        out.write("=\""); writeMarkupElement(uri); out.write("\"");
        if (topURI == null) topURI = uri;
      }

      if (attrs != null) {
        Hashtable usedURIs = new Hashtable();

        int len = attrs.getLength();
        for (int i = 0; i < len; i++) {
          String aname = attrs.getLocalName(i);
          String auri = attrs.getURI(i);
          String aqname = attrs.getQName(i);

          if (aname != null) {
            if (auri == null || auri.length() == 0) {
              aqname = aname;
            } else {
              prefix = (String)uritab.get(auri);
              if (prefix == null) {
                if (auri.equals(NamespaceSupport.XMLNS)) prefix = "xml";
                else prefix = assignPrefix(auri, aqname);
              }
              aqname = prefix +":" + aname;
              if (!usedURIs.containsKey(auri) &&
                  !auri.equals(uri) &&
                  !auri.equals(topURI) &&
                  !auri.equals(NamespaceSupport.XMLNS)) {
                out.write(" xmlns:"); writeMarkupElement(prefix);
                out.write("=\""); writeMarkupElement(auri); out.write("\"");
                usedURIs.put(auri, prefix);
              }
            }
          }

          out.write(" "); writeMarkupElement(aqname);
          out.write("=\""); writeMarkupElement(attrs.getValue(i)); out.write("\"");
        }
      }
      opentag = true;
    } catch (IOException e) {
      throw new SAXException(e);
    }
  }

  public void endElement(String uri, String name, String qname) throws SAXException {
    String elementName = (String)elementNames.pop();
    if (name != null) {
      if (uri == null || uri.length() == 0) {
        qname = name;
      } else {
        String prefix = (String)uritab.get(uri);
        if (prefix == null) {
          if (org.xml.sax.helpers.NamespaceSupport.XMLNS.equals(uri)) prefix = "xml";
          else throw new SAXException ("Namespace \'"+uri+"\' first mentioned on the closing tag \'"+name+"\'");
        }
        qname = prefix +":" + name;
      }
    }

    if (!qname.equals(elementName))
      throw new SAXException ("Open tag \'"+elementName+"\' does not match closing tag \'"+qname+"\'");

    try {
      if (opentag) {
        out.write ("/>");
				//out.write(13);
				//System.out.println(System.getProperties().getProperty("line.separator").toString());
				//String endl = System.getProperties().getProperty("line.separator").toString();
				//out.write(endl);
				opentag = false;
      } else {
        out.write("</"); writeMarkupElement(elementName); out.write(">"); 
      }
    } catch (IOException e) {
      throw new SAXException(e);
    }
  }

  protected void writeNormalized(char[] chs, int start, int length, boolean markup)  throws IOException {
    for (int i = 0; i < length; i++) {
      char ch = chs[start+i];
      switch (ch) {
        case '<':  out.write("&lt;"); break;
        case '>':  out.write("&gt;"); break;
        case '&':  out.write("&amp;"); break;
        case '\"':  if (markup) { out.write("&quot;"); break; }
        case '\'':  if (markup) { out.write("&apos;"); break; }
        case '\n':  if (markup) { out.write("&#xA;"); break; }
        case '\t':  if (markup) { out.write("&#x9;"); break; }
        // else, process character in default mode
        default:
          if (!hasUTF8 && (ch > 0x7F || ch < 0)) out.write("&#"+(int)ch+";");
          else out.write(ch);
      }
    }
  }

  protected void writeMarkupElement(String s) throws IOException {
    writeNormalized(s.toCharArray(), 0, s.length(), true);
  }
  protected void writePCDATA(char[] chs, int start, int length) throws IOException {
    writeNormalized(chs, start, length, false);
  }

  protected String assignPrefix (String uri, String qname) throws SAXException {
    String prefix = null;
    if (qname != null &&
        qname.indexOf(':') != -1) {
      prefix = qname.substring(0, qname.indexOf(':'));
      if (prefixtab.containsKey(prefix)) prefix = null;
    }
    if (prefix == null) {
      int base = prefixCharacters.length;
      while (prefIndex < Integer.MAX_VALUE) {
        int ord = ++prefIndex;
        prefix = "";
        while (ord != 0) {
          int digit = ord % base;
          ord = (ord - digit)/base;
          prefix += prefixCharacters[digit];
        }

        if (prefix.equals("xml")) continue;
        if (prefixtab.containsKey(prefix)) continue;
        break;
      }
      if (prefIndex == Integer.MAX_VALUE) {
        throw new SAXException ("Cannot assign more than "+(Integer.MAX_VALUE -2)+" different prefixes");
      }
    }
    uritab.put(uri, prefix);
    prefixtab.put(prefix, uri);

    return prefix;
  }

public void comment(char[] ch, int start, int length){
            try{
              characters(ch, 0, 0); /* so that an open tag is closed */
                 out.write("<!--"+new String(ch,start,length)+"-->");
                 out.flush();
            }
            catch(java.io.IOException e){
            }
            catch (SAXException ex) {}
    }
}
