/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class Frame
extends JFrame
implements ActionListener {
    Options options;
    FileComponent xep;
    FileComponent plugin;
    JButton install;

    Frame(Options options) {
        super("XEP Connector for JEdit setup");
        this.options = options;
        this.install = new JButton("Install");
        this.install.addActionListener(this);
        this.plugin = new FileComponent(this, "jEdit plugin's directory", options.pluginPath);
        this.xep = new FileComponent(this, "XEP location", options.xepPath);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 20, 0, 20);
        container.add((Component)this.plugin, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        container.add((Component)this.xep, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        container.add((Component)this.install, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.install);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        ((Component)this).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setDefaultCloseOperation(3);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.options.xepPath = this.xep.path.getText();
        this.options.pluginPath = this.plugin.path.getText();
        File file = new File(this.options.xepPath);
        if (!file.isDirectory()) {
            JOptionPane.showMessageDialog(this, "XEP isn't installed in the directory " + this.options.xepPath, "Error", 0);
            return;
        }
        if (!this.options.xepPath.endsWith(File.separator)) {
            this.options.xepPath = this.options.xepPath + File.separator;
        }
        if (!this.options.pluginPath.endsWith(File.separator)) {
            this.options.pluginPath = this.options.pluginPath + File.separator;
        }
        Install install = new Install(this.options);
        this.install.setEnabled(false);
        try {
            install.start();
            JOptionPane.showMessageDialog(this, "Installation successful.", "XEP Connector for JEdit", 1);
            this.dispose();
            System.exit(0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Installation failed. The problem source is: " + iOException.getMessage(), "Error", 0);
            this.install.setEnabled(true);
        }
    }

    class FileComponent
    extends JPanel
    implements ActionListener {
        String current;
        JTextField path;
        JButton browse;
        JFileChooser filechooser;
        Component parentComponent;

        FileComponent(Component component, String string, String string2) {
            this.parentComponent = component;
            this.current = string2;
            this.browse = new JButton("Browse...");
            this.browse.addActionListener(this);
            this.path = new JTextField(string2, 50);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            this.add((Component)new JLabel(string), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.path, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)this.browse, gridBagConstraints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.filechooser = new JFileChooser(this.current);
            this.filechooser.setFileSelectionMode(1);
            if (this.filechooser.showOpenDialog(this.parentComponent) == 0) {
                this.current = this.filechooser.getSelectedFile().getAbsolutePath();
                this.path.setText(this.current);
            }
        }
    }
}

