/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.cmp;

import com.renderx.util.List;
import com.renderx.xep.cmp.FO;
import com.renderx.xep.cmp.Item;
import com.renderx.xep.cmp.JavaScript;
import com.renderx.xep.cmp.JavaScriptHandler;
import com.renderx.xep.cmp.LMSHandler;
import com.renderx.xep.cmp.NullHandler;
import com.renderx.xep.cmp.OutlineHandler;
import com.renderx.xep.cmp.Sequence;
import com.renderx.xep.cmp.SequenceHandler;
import com.renderx.xep.lib.Session;
import com.renderx.xep.pre.AttList;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.CompilerException;
import com.renderx.xep.pre.ElementHandler;
import com.renderx.xep.pre.PI;
import com.renderx.xep.pre.PIHandler;
import java.util.Enumeration;

public class RootHandler
implements ElementHandler,
PIHandler {
    private ElementHandler subhandler = null;
    private final Session session;
    private final FO fo;
    private Sequence seq;

    public RootHandler(FO fO, Session session) {
        this.fo = fO;
        this.session = session;
    }

    public void startElement(short s, AttList attList) throws CompilerException {
        block21: {
            block20: {
                if (this.subhandler != null) break block20;
                switch (s) {
                    case 1: {
                        if (attList.containsKey(Attn.$initial_destination)) {
                            this.fo.initial_destination = attList.get(Attn.$initial_destination);
                        }
                        if (attList.containsKey(Attn.$id)) {
                            this.fo.id = attList.get(Attn.$id);
                        }
                        if (attList.containsKey(Attn.$language)) {
                            this.fo.language = attList.get(Attn.$language);
                        }
                        if (attList.containsKey(Attn.$country)) {
                            this.fo.country = attList.get(Attn.$country);
                        }
                        if (attList.containsKey(Attn.$js_didprint)) {
                            this.fo.js_didprint = attList.get(Attn.$js_didprint);
                        }
                        if (attList.containsKey(Attn.$js_didsave)) {
                            this.fo.js_didsave = attList.get(Attn.$js_didsave);
                        }
                        if (attList.containsKey(Attn.$js_open)) {
                            this.fo.js_open = attList.get(Attn.$js_open);
                        }
                        if (attList.containsKey(Attn.$js_willprint)) {
                            this.fo.js_willprint = attList.get(Attn.$js_willprint);
                        }
                        if (attList.containsKey(Attn.$js_willsave)) {
                            this.fo.js_willsave = attList.get(Attn.$js_willsave);
                        }
                        if (attList.containsKey(Attn.$js_willclose)) {
                            this.fo.js_willclose = attList.get(Attn.$js_willclose);
                        }
                        break block21;
                    }
                    case 106: {
                        this.session.openState("meta-info");
                        break block21;
                    }
                    case 105: {
                        this.fo.metainfo.put(attList.get(Attn.$name).word(), attList.get(Attn.$value).word());
                        break block21;
                    }
                    case 2: {
                        this.session.openState("declarations");
                        this.subhandler = new NullHandler();
                        break block21;
                    }
                    case 104: {
                        this.session.openState("outline");
                        this.subhandler = new OutlineHandler(this.fo.outline, this.session);
                        break block21;
                    }
                    case 123: {
                        this.fo.javascript = new JavaScript();
                        this.fo.javascript.name = attList.get(Attn.$name).word();
                        this.subhandler = new JavaScriptHandler(this.fo.javascript, this.session);
                        break block21;
                    }
                    case 4: {
                        this.session.openState("masters");
                        this.subhandler = new LMSHandler(this.fo.masters, this.session);
                        break block21;
                    }
                    case 16: {
                        this.session.openState("sequence");
                        this.seq = new Sequence(attList);
                        this.subhandler = new SequenceHandler(this.seq, this.fo.masters, this.session);
                        break block21;
                    }
                    default: {
                        throw new CompilerException("invalid element id: " + s);
                    }
                }
            }
            this.subhandler.startElement(s, attList);
        }
    }

    public void endElement(short s) throws CompilerException {
        block15: {
            block14: {
                if (this.subhandler != null) break block14;
                switch (s) {
                    case 1: {
                        this.resolveForcePageCount();
                        if (this.fo.id != null) {
                            ((Sequence)this.fo.sequences.last()).lids.snoc(this.fo.id);
                        }
                        this.reportUnclosedChangeBars();
                        break block15;
                    }
                    case 106: {
                        this.session.closeState("meta-info");
                        break block15;
                    }
                    case 105: {
                        break block15;
                    }
                    default: {
                        throw new CompilerException("invalid element id: " + s);
                    }
                }
            }
            switch (s) {
                case 104: {
                    this.subhandler = null;
                    this.session.closeState("outline");
                    break;
                }
                case 123: {
                    this.subhandler = null;
                    break;
                }
                case 4: {
                    this.subhandler = null;
                    this.session.closeState("masters");
                    break;
                }
                case 2: {
                    this.subhandler = null;
                    this.session.closeState("declarations");
                    break;
                }
                case 16: {
                    this.fo.sequences.snoc(this.seq);
                    if (this.seq.containsKey(Attn.$id)) {
                        this.seq.lids.snoc(this.seq.get(Attn.$id));
                    }
                    this.seq = null;
                    this.subhandler = null;
                    this.session.closeState("sequence");
                    break;
                }
                default: {
                    this.subhandler.endElement(s);
                }
            }
        }
    }

    public void processingInstruction(String string, String string2) throws CompilerException {
        if (this.subhandler == null) {
            this.fo.pilist.append(new PI(string, string2));
        } else if (this.subhandler instanceof PIHandler) {
            ((PIHandler)((Object)this.subhandler)).processingInstruction(string, string2);
        }
    }

    private void resolveForcePageCount() {
        if (!this.fo.sequences.isEmpty()) {
            Sequence sequence = (Sequence)this.fo.sequences.car();
            List list = this.fo.sequences.cdr();
            while (true) {
                if (sequence.get(Attn.$force_page_count) == Attr.auto) {
                    if (list.isEmpty()) {
                        sequence.put(Attn.$force_page_count, Attr.newWord("no-force"));
                        break;
                    }
                    Sequence sequence2 = (Sequence)list.car();
                    if (sequence2.get(Attn.$initial_page_number) instanceof Attr.Count) {
                        sequence.put(Attn.$force_page_count, Attr.newWord(sequence2.get(Attn.$initial_page_number).count() % 2 == 1 ? "end-on-even" : "end-on-odd"));
                    } else if (sequence2.get(Attn.$initial_page_number) == Attr.newWord("auto-even")) {
                        sequence.put(Attn.$force_page_count, Attr.newWord("end-on-odd"));
                    } else if (sequence2.get(Attn.$initial_page_number) == Attr.newWord("auto-odd")) {
                        sequence.put(Attn.$force_page_count, Attr.newWord("end-on-even"));
                    } else {
                        sequence.put(Attn.$force_page_count, Attr.newWord("no-force"));
                    }
                    sequence = sequence2;
                    list = list.cdr();
                    continue;
                }
                if (list.isEmpty()) break;
                sequence = (Sequence)list.car();
                list = list.cdr();
            }
        }
    }

    private void reportUnclosedChangeBars() {
        if (this.session.cbStack.isPair()) {
            Enumeration enumeration = this.session.cbStack.elements();
            while (enumeration.hasMoreElements()) {
                Item.ChangeBar changeBar = (Item.ChangeBar)enumeration.nextElement();
                this.session.warning("Unclosed change-bar-begin element of class " + changeBar.cbclass);
            }
        }
    }
}

