/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

import com.renderx.util.Applicator;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class List
implements Cloneable {
    private Link head;
    private Link tail;
    private int length;

    public List() {
        this.clear();
    }

    public final List clear() {
        this.head = new Link();
        this.head.next = null;
        this.tail = new Link();
        this.tail.next = this.head;
        this.length = 0;
        return this;
    }

    protected List newList() {
        try {
            return ((List)super.clone()).clear();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
    }

    public Object clone() {
        List list = this.newList();
        if (this.isPair()) {
            Link link = this.head.next;
            while (true) {
                list.snoc(link.data);
                if (link == this.tail.next) break;
                link = link.next;
            }
        }
        return list;
    }

    public final List enolc() {
        List list = this.newList();
        if (this.isPair()) {
            Link link = this.head.next;
            while (true) {
                list.cons(link.data);
                if (link == this.tail.next) break;
                link = link.next;
            }
        }
        return list;
    }

    public final List reverse() {
        return this.length > 1 ? this.enolc() : this;
    }

    public final List unshift(Object object) {
        return this.cons(object);
    }

    public final List cons(Object object) {
        Link link = new Link();
        this.head.data = object;
        link.next = this.head;
        this.head = link;
        ++this.length;
        return this;
    }

    public final List prepend(List list) {
        if (list.isPair()) {
            list.tail.next.next = this.head.next;
            this.head.next = list.head.next;
            this.length += list.length;
        }
        return this;
    }

    public final List append(Object object) {
        return this.snoc(object);
    }

    public final List snoc(Object object) {
        Link link = new Link();
        link.data = object;
        link.next = this.tail.next.next;
        this.tail.next.next = link;
        this.tail.next = link;
        ++this.length;
        return this;
    }

    public final List append(List list) {
        if (list.isPair()) {
            this.tail.next.next = list.head.next;
            this.tail.next = list.tail.next;
            this.length += list.length;
        }
        return this;
    }

    public final Object shift() {
        if (!this.isPair()) {
            throw new NoSuchElementException("list is not a pair");
        }
        this.head = this.head.next;
        --this.length;
        return this.head.data;
    }

    public final boolean isEmpty() {
        return !this.isPair();
    }

    public final boolean isPair() {
        return this.head.next != this.tail.next.next;
    }

    public final int length() {
        return this.length;
    }

    public final Object car() {
        if (!this.isPair()) {
            throw new NoSuchElementException("list is not a pair");
        }
        return this.head.next.data;
    }

    public final Object last() {
        if (!this.isPair()) {
            throw new NoSuchElementException("list is not a pair");
        }
        return this.tail.next.data;
    }

    public final List cdr() {
        List list = this.newList();
        if (!this.isPair()) {
            throw new NoSuchElementException("list is not a pair");
        }
        list.head.next = this.head.next.next;
        list.tail.next = this.tail.next;
        list.length = this.length - 1;
        return list;
    }

    public final List setCar(Object object) {
        if (!this.isPair()) {
            throw new NoSuchElementException("list is not a pair");
        }
        this.head.next.data = object;
        return this;
    }

    public final List setLast(Object object) {
        if (!this.isPair()) {
            throw new NoSuchElementException("list is not a pair");
        }
        this.tail.next.data = object;
        return this;
    }

    public final List setCdr(List list) {
        if (!this.isPair()) {
            throw new NoSuchElementException("list is not a pair");
        }
        this.head.next.next = list.head.next;
        this.length = list.length + 1;
        return this;
    }

    public final boolean contains(Object object) {
        Object var2_2 = null;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            var2_2 = enumeration.nextElement();
            if (object != var2_2) continue;
            return true;
        }
        return false;
    }

    public final void foreach(Applicator applicator) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            applicator.f(enumeration.nextElement());
        }
    }

    public final List map(List list, Applicator applicator) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            list.append(applicator.f(enumeration.nextElement()));
        }
        return list;
    }

    public final List remove(Object object) {
        List list = this.newList();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == object) continue;
            list.append(e);
        }
        return list;
    }

    public final Mark mark() {
        return new Mark();
    }

    public final List insert(Mark mark, Object object) {
        Link link = new Link();
        link.next = mark.link.next;
        link.data = object;
        mark.link.next = link;
        if (this.tail.next == mark.link) {
            this.tail.next = link;
        }
        ++this.length;
        return this;
    }

    public final List cut(Mark mark) {
        this.tail.next = mark.link;
        this.length = mark.length;
        return this;
    }

    public final List hcut(Mark mark) {
        this.tail.next = mark.link;
        this.length = 0;
        Link link = this.head.next;
        while (link != this.tail.next.next) {
            ++this.length;
            link = link.next;
        }
        return this;
    }

    public final List insert(Link link, List list) {
        Link link2;
        list.tail.next.next = link2 = link.next;
        link.next = list.head.next;
        if (this.tail.next == link) {
            this.tail.next = list.tail.next;
        }
        this.length += list.length;
        return this;
    }

    public String toString() {
        return this.isPair() ? this.cdr().addToString(this.car().toString()) : "()";
    }

    private String addToString(String string) {
        if (this.isPair()) {
            return this.cdr().addToString(string + " " + this.car());
        }
        return "(" + string + ")";
    }

    public final Enumeration elements() {
        return new Enumerator();
    }

    private class Enumerator
    implements Enumeration {
        private Link cur;

        Enumerator() {
            this.cur = ((List)List.this).head.next;
        }

        public final Object nextElement() {
            if (this.cur == ((List)List.this).tail.next.next) {
                throw new NoSuchElementException("attempt to access element past the end of a list");
            }
            Object object = this.cur.data;
            this.cur = this.cur.next;
            return object;
        }

        public final boolean hasMoreElements() {
            return this.cur != ((List)List.this).tail.next.next;
        }
    }

    public final class Mark {
        Link link;
        int length;

        Mark() {
            this.link = ((List)List.this).tail.next;
            this.length = List.this.length;
        }
    }

    static final class Link {
        Object data;
        Link next;

        Link() {
        }
    }
}

