/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.PDFSeparateColorSpace;
import com.renderx.util.Hashtable;
import java.util.Enumeration;

public class SpotColors {
    int colorantsCount = -1;
    Hashtable colorants = new Hashtable();
    Hashtable colorantsOID = new Hashtable();

    SpotColors() {
    }

    String getPDFSpotColorName(String string, float[] fArray) {
        SpotColor spotColor = new SpotColor(string, fArray);
        return (String)this.colorants.get(spotColor);
    }

    void addSpotColor(float f, String string, float[] fArray, IndirectObject indirectObject) {
        ++this.colorantsCount;
        SpotColor spotColor = new SpotColor(string, fArray);
        this.colorants.put(spotColor, "CS" + this.colorantsCount);
        this.colorantsOID.put(spotColor, indirectObject);
    }

    IndirectObject getSpotColorOID(String string, float[] fArray) {
        SpotColor spotColor = new SpotColor(string, fArray);
        return (IndirectObject)this.colorantsOID.get(spotColor);
    }

    void write(PDFOutputStream pDFOutputStream) {
        Enumeration enumeration = this.colorants.keys();
        while (enumeration.hasMoreElements()) {
            SpotColor spotColor = (SpotColor)enumeration.nextElement();
            PDFSeparateColorSpace pDFSeparateColorSpace = new PDFSeparateColorSpace((IndirectObject)this.colorantsOID.get(spotColor), spotColor.colorant, spotColor.altcolor);
            pDFSeparateColorSpace.write(pDFOutputStream);
        }
    }

    private class SpotColor {
        String colorant;
        float[] altcolor;

        SpotColor(String string, float[] fArray) {
            this.colorant = string;
            this.altcolor = fArray;
            if (fArray == null) {
                this.altcolor = new float[]{0.0f};
            }
        }

        public int hashCode() {
            return this.colorant.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof SpotColor)) {
                return false;
            }
            SpotColor spotColor = (SpotColor)object;
            if (!spotColor.colorant.equals(this.colorant)) {
                return false;
            }
            if (spotColor.altcolor.length != this.altcolor.length) {
                return false;
            }
            int n = 0;
            while (n < this.altcolor.length) {
                if (spotColor.altcolor[n] != this.altcolor[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }
}

