/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics.vector;

import com.renderx.graphics.vector.GraphicObject;
import com.renderx.graphics.vector.PaintSpec;
import com.renderx.graphics.vector.Path;
import com.renderx.graphics.vector.StrokeSpec;
import com.renderx.util.List;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;

public class GraphicGroup
extends GraphicObject
implements Cloneable {
    public List children = new List();
    public GraphicGroup clippath = null;
    public double opacity = 1.0;
    public double[] matrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    public PaintSpec fill = null;
    public StrokeSpec stroke = null;

    public boolean isSimple() {
        if (this.children.length() > 1) {
            return false;
        }
        if (this.children.length() == 1 && this.children.car() instanceof GraphicGroup) {
            return ((GraphicGroup)this.children.car()).isSimple();
        }
        return true;
    }

    public boolean isIdentityTransform() {
        return GraphicObject.isIdentityTransform(this.matrix);
    }

    public void reverseMatrix() {
        this.matrix = GraphicObject.reverseMatrix(this.matrix);
    }

    public void transform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.matrix = GraphicObject.multipleMatrix(this.matrix, new double[]{d, d2, d3, d4, d5, d6});
    }

    public void rotate(double d) {
        this.matrix = GraphicObject.rotate(this.matrix, d);
    }

    public void translate(double d, double d2) {
        this.matrix = GraphicObject.translate(this.matrix, d, d2);
    }

    public void scale(double d, double d2) {
        this.matrix = GraphicObject.scale(this.matrix, d, d2);
    }

    public void skew(double d, double d2) {
        this.matrix = GraphicObject.skew(this.matrix, d, d2);
    }

    public void clipRect(double d, double d2, double d3, double d4) {
        Path path = new Path();
        path.rectangle(d, d2, d3, d4);
        if (this.clippath == null) {
            this.clippath = new GraphicGroup();
        }
        this.clippath.append(path);
    }

    public void append(GraphicObject graphicObject) {
        this.children.append(graphicObject);
    }

    public void dump(PrintStream printStream, String string) throws IOException {
        printStream.println(string + "%<group opacity=\"" + this.opacity + "\" " + "matrix=\"" + this.matrix[0] + " " + this.matrix[1] + " " + this.matrix[2] + " " + this.matrix[3] + " " + this.matrix[4] + " " + this.matrix[5] + "\">");
        printStream.println(string + "  gsave");
        printStream.println(string + "  [" + this.matrix[0] + " " + this.matrix[1] + " " + this.matrix[2] + " " + this.matrix[3] + " " + this.matrix[4] + " " + this.matrix[5] + "] concat");
        if (this.clippath != null) {
            printStream.println(string + "  %<clippathref>");
            this.clippath.dump(printStream, string + "  ");
            printStream.println(string + "  %</clippathref>");
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            ((GraphicObject)enumeration.nextElement()).dump(printStream, string + "  ");
        }
        printStream.println(string + "  grestore");
        printStream.println(string + "%</group>");
    }

    public Object clone() {
        GraphicGroup graphicGroup = new GraphicGroup();
        graphicGroup.children = this.children;
        graphicGroup.clippath = this.clippath;
        graphicGroup.opacity = this.opacity;
        graphicGroup.matrix = this.matrix;
        return graphicGroup;
    }

    public GraphicGroup deepCopy() {
        GraphicGroup graphicGroup = new GraphicGroup();
        graphicGroup.children = (List)this.children.clone();
        graphicGroup.clippath = this.clippath == null ? null : this.clippath.deepCopy();
        graphicGroup.matrix = new double[this.matrix.length];
        int n = 0;
        while (n < this.matrix.length) {
            graphicGroup.matrix[n] = this.matrix[n];
            ++n;
        }
        return graphicGroup;
    }
}

