/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib.barcodes;

import com.renderx.afplib.ConfigManager;
import com.renderx.afplib.XBarcode;
import com.renderx.afplib.barcodes.BarcodeParams;
import com.renderx.afplib.barcodes.Code_128;
import com.renderx.afplib.barcodes.Code_39;
import com.renderx.afplib.barcodes.Codebar;
import com.renderx.afplib.barcodes.Ean_13;
import com.renderx.afplib.barcodes.Ean_8;
import com.renderx.afplib.barcodes.FourState_AU;
import com.renderx.afplib.barcodes.Interlived_25;
import com.renderx.afplib.barcodes.RM4SCC;
import com.renderx.afplib.barcodes.Upc_a;
import java.io.IOException;

public class BarcodeFactory {
    public static XBarcode getBarcode(BarcodeParams barcodeParams, ConfigManager configManager) throws IOException {
        if (barcodeParams.getBarcode().getType().equals("UPC-A")) {
            return new Upc_a(barcodeParams, configManager);
        }
        if (barcodeParams.getBarcode().getType().equals("code39")) {
            return new Code_39(barcodeParams, configManager);
        }
        if (barcodeParams.getBarcode().getType().equals("i2of5")) {
            return new Interlived_25(barcodeParams, configManager);
        }
        if (barcodeParams.getBarcode().getType().equals("code128")) {
            return new Code_128(barcodeParams, configManager);
        }
        if (barcodeParams.getBarcode().getType().equals("codabar")) {
            return new Codebar(barcodeParams, configManager);
        }
        if (barcodeParams.getBarcode().getType().equals("EAN-13")) {
            return new Ean_13(barcodeParams, configManager);
        }
        if (barcodeParams.getBarcode().getType().equals("EAN-8")) {
            return new Ean_8(barcodeParams, configManager);
        }
        if (barcodeParams.getBarcode().getType().equals("au_post")) {
            return new FourState_AU(barcodeParams, configManager);
        }
        if (barcodeParams.getBarcode().getType().equals("RM4SCC")) {
            return new RM4SCC(barcodeParams, configManager);
        }
        return null;
    }
}

