/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afplib.Util;
import com.renderx.util.Hashtable;
import com.renderx.xep.lib.Conf;
import com.renderx.xep.lib.Session;
import java.util.HashMap;
import java.util.Properties;

public class ConfigManager {
    private Session session = null;
    private static final short O_AFPLOGLEVEL = 2;
    private static final short O_AFP_RESOURCE_FILE = 5;
    private static final short O_USE_SHADING_PATTERNS = 6;
    private static final short O_USE_REPLICATE_AND_TRIM = 7;
    private static final short O_SHADING_PATTERN_RESOLUTION = 8;
    private static final short O_TRY_USING_TIFF_COMPRESSION = 9;
    private static final short O_RESOLUTION = 10;
    private static final short O_PTOCA_LEVEL = 11;
    private static final short O_GOCA_LEVEL = 12;
    private static final short O_BCOCA_LEVEL = 13;
    private static final short O_UNKNOWN_SYMBOL = 14;
    private static final short O_ALL_IMAGES_TO_RESOURCE = 15;
    private HashMap optionsMap;
    public Hashtable dataTypes;
    private static final Hashtable optab = new Hashtable();

    public ConfigManager(Session session) {
        this.session = session;
        this.optionsMap = new HashMap();
        this.resetOptions();
    }

    public void reset() {
        this.optionsMap.clear();
    }

    public Session getLogger() {
        return this.session;
    }

    public boolean setOptionFromConfig(String string, String string2) {
        Object object = optab.get(string);
        if (object == null) {
            return false;
        }
        switch ((Short)object) {
            case 2: {
                this.setOptionInt(string2, "AFPLOGLEVEL", 1, new int[]{0, 1, 2, 3});
                break;
            }
            case 5: {
                this.optionsMap.put("RESOURCE", string2.trim());
                break;
            }
            case 6: {
                this.setOptionBoolean(string2, "USE_SHADING_PATTERNS");
            }
            case 9: {
                this.setOptionBoolean(string2, "TRY_USING_TIFF_COMPRESSION");
                break;
            }
            case 7: {
                this.setOptionBoolean(string2, "USE_REPLICATE_AND_TRIM");
                break;
            }
            case 8: {
                this.setOptionDouble(string2, "SHADING_PATTERN_RESOLUTION");
                break;
            }
            case 10: {
                int n = this.getOptionInt("RESOLUTION") / 10;
                n = this.parseInt(string2, "RESOLUTION", n);
                this.optionsMap.put("RESOLUTION", new Integer(n * 10));
                break;
            }
            case 11: {
                this.setOptionInt(string2, "USE_PTOCA_LEVEL", 1, new int[]{1, 2, 3});
                break;
            }
            case 12: {
                this.setOptionInt(string2, "USE_GOCA_LEVEL", 0, new int[]{0, 1});
                break;
            }
            case 13: {
                this.setOptionInt(string2, "USE_BCOCA_LEVEL", 0, new int[]{0, 1});
                break;
            }
            case 14: {
                this.setOptionEnum(string2, "UNKNOWN_SYMBOL", "Question", new String[]{"Question", "Blank", "Ignore"});
                break;
            }
            case 15: {
                this.setOptionBoolean(string2, "ALL_IMAGES_TO_RESOURCE");
            }
        }
        return true;
    }

    private void setOptionEnum(String string, String string2, String string3, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            this.optionsMap.put(string2, string);
            return;
        }
        this.session.warning("Invalid " + string2 + " value: " + string + "; setting ignored; default value of " + String.valueOf(string3) + " applied");
    }

    private void setOptionInt(String string, String string2, int n, int[] nArray) {
        int n2 = this.parseInt(string, string2, n, nArray);
        this.optionsMap.put(string2, new Integer(n2));
    }

    private void setOptionBoolean(String string, String string2) {
        boolean bl = this.parseBoolean(string, string2, this.getOptionBoolean(string2));
        this.optionsMap.put(string2, new Boolean(bl));
    }

    private void setOptionDouble(String string, String string2) {
        double d = this.parseFloat(string, string2, this.getOptionDouble(string2));
        this.optionsMap.put(string2, new Double(d));
    }

    public void setOption(String string, Object object) {
        this.optionsMap.put(string, object);
    }

    public int getOptionInt(String string) {
        return (Integer)this.optionsMap.get(string);
    }

    public double getOptionDouble(String string) {
        return (Double)this.optionsMap.get(string);
    }

    public boolean getOptionBoolean(String string) {
        return (Boolean)this.optionsMap.get(string);
    }

    public String getOptionString(String string) {
        return (String)this.optionsMap.get(string);
    }

    public void resetOptions() {
        this.setOption("AFPLOGLEVEL", new Integer(1));
        this.setOption("RESOURCE", null);
        this.setOption("USE_SHADING_PATTERNS", new Boolean(false));
        this.setOption("USE_REPLICATE_AND_TRIM", new Boolean(false));
        this.setOption("TRY_USING_TIFF_COMPRESSION", new Boolean(false));
        this.setOption("SHADING_PATTERN_RESOLUTION", new Double(0.25));
        this.setOption("RESOLUTION", new Integer(14400));
        this.setOption("USE_PTOCA_LEVEL", new Integer(1));
        this.setOption("USE_GOCA_LEVEL", new Integer(0));
        this.setOption("USE_BCOCA_LEVEL", new Integer(0));
        this.setOption("UNKNOWN_SYMBOL", "Question");
        this.setOption("ALL_IMAGES_TO_RESOURCE", new Boolean(false));
        this.dataTypes = new Hashtable();
        Conf.DataType dataType = new Conf.DataType("Uncompressed", true, 3, 1);
        this.dataTypes.put("Uncompressed", dataType);
        Conf.DataType dataType2 = new Conf.DataType("G4 MMR modified", true, 130, 1);
        this.dataTypes.put("", dataType2);
        this.dataTypes.put("G4 MMR modified", dataType2);
    }

    public int getLogLevel() {
        return this.getOptionInt("AFPLOGLEVEL");
    }

    public String getResourceFile() {
        try {
            return this.getOptionString("RESOURCE");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isUseShadingPatterns() {
        return this.getOptionBoolean("USE_SHADING_PATTERNS");
    }

    public boolean isReplicateAndTrim() {
        return this.getOptionBoolean("USE_REPLICATE_AND_TRIM");
    }

    public boolean isTryUsingTiffCompression() {
        return this.getOptionBoolean("TRY_USING_TIFF_COMPRESSION");
    }

    public double getShadingPatternResolution() {
        return this.getOptionDouble("SHADING_PATTERN_RESOLUTION");
    }

    public int getResolution() {
        return this.getOptionInt("RESOLUTION");
    }

    public int getPtocaLevels() {
        return this.getOptionInt("USE_PTOCA_LEVEL");
    }

    public int getGocaLevels() {
        return this.getOptionInt("USE_GOCA_LEVEL");
    }

    public int getBcocaLevels() {
        return this.getOptionInt("USE_BCOCA_LEVEL");
    }

    public String getActionUnrecognizedChar() {
        return this.getOptionString("UNKNOWN_SYMBOL");
    }

    public boolean isAllImagesToResource() {
        return this.getOptionBoolean("ALL_IMAGES_TO_RESOURCE");
    }

    private int parseInt(String string, String string2, int n, int[] nArray) {
        int n2 = this.parseInt(string, string2, n);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n2) continue;
            return n2;
        }
        return n;
    }

    private int parseInt(String string, String string2, int n) {
        int n2 = n;
        try {
            n2 = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.session.warning("Invalid " + string2 + " value: " + string + "; setting ignored; default value of " + String.valueOf(n) + " applied");
        }
        return n2;
    }

    private double parseFloat(String string, String string2, double d) {
        double d2 = d;
        try {
            d2 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.session.warning("Invalid " + string2 + " value: " + string + "; setting ignored; default value of " + String.valueOf(d) + " applied");
        }
        return d2;
    }

    private boolean parseBoolean(String string, String string2, boolean bl) {
        boolean bl2 = bl;
        try {
            bl2 = Util.parseBoolean(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.session.warning("Invalid " + string2 + " value: " + string + "; setting ignored; default value of " + String.valueOf(bl) + " applied");
        }
        return bl2;
    }

    public void readDataTypes(Properties properties) {
        Hashtable hashtable = (Hashtable)properties.get("DATATYPES");
        if (hashtable != null) {
            this.dataTypes = hashtable;
        }
    }

    public Conf.DataType getDataType(String string) {
        return (Conf.DataType)this.dataTypes.get(string);
    }

    public Conf.DataType getDefaultDataType() {
        return this.getDataType("");
    }

    static {
        optab.put("AFPLOGLEVEL", new Short(2));
        optab.put("AFPLOGLEVEL", new Short(2));
        optab.put("RESOURCE", new Short(5));
        optab.put("USE_SHADING_PATTERNS", new Short(6));
        optab.put("USE_REPLICATE_AND_TRIM", new Short(7));
        optab.put("TRY_USING_TIFF_COMPRESSION", new Short(9));
        optab.put("SHADING_PATTERN_RESOLUTION", new Short(8));
        optab.put("RESOLUTION", new Short(10));
        optab.put("USE_PTOCA_LEVEL", new Short(11));
        optab.put("USE_GOCA_LEVEL", new Short(12));
        optab.put("USE_BCOCA_LEVEL", new Short(13));
        optab.put("UNKNOWN_SYMBOL", new Short(14));
        optab.put("ALL_IMAGES_TO_RESOURCE", new Short(15));
    }
}

