package com.renderx.xepx.x4u.ct.nodedscpanel.transformpanel;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import com.renderx.xepx.x4u.ct.FontsPanel;

/**
 * @author AlexanderR
 */
public class SmallcapPanel extends JPanel
{
    private static final long serialVersionUID = 240820381920133759L;

    private FontsPanel parentPanel;
    
    private JCheckBox smallcapCheckBox = new JCheckBox();
    private JTextField smallcapTextField = new JTextField();    
    
    public SmallcapPanel(FontsPanel _parentPanel)
    {
	this.parentPanel = _parentPanel;
	
        add(smallcapCheckBox, null);
        add(smallcapTextField, null);
        
        smallcapTextField.setName("smallcaps");
        smallcapTextField.setText("1");      
        smallcapTextField.setPreferredSize(new Dimension(40, 19));
        smallcapTextField.setEnabled(false);
        
	smallcapCheckBox.setText("Smallcaps");
	
	smallcapCheckBox.addActionListener(
		new java.awt.event.ActionListener()
                {
                    public void actionPerformed(ActionEvent e)
                    {
                	smallcapCheckBox_actionPerformed(e, (Element) parentPanel.getFontNode());
                    }
                });
	
        smallcapTextField.addFocusListener(
        	new java.awt.event.FocusAdapter()
        	{
        	    public void focusLost(FocusEvent e)
        	    {
        		parentPanel.textField_focusLost(e, (Element) parentPanel.getFontNode());
        	    }
        
        	    public void focusGained(FocusEvent e)
        	    {
        		parentPanel.textField_focusGained(e, (Element) parentPanel.getFontNode());
        	    }
        	});	
    }
    
    private void smallcapCheckBox_actionPerformed(ActionEvent e, Element node)
    {
	boolean state = smallcapCheckBox.isSelected();
	
	if (node == null)
	    return;
	
	Element transform;
	NodeList children = node.getElementsByTagName("transform");
	if (children.getLength() == 0)
	{
	    transform = node.getOwnerDocument().createElement("transform");
	    node.appendChild(transform);
	} else
	{
	    transform = (Element) children.item(0);
	}

	if (state && smallcapTextField.getText().trim().length() > 0
		&& Integer.parseInt(smallcapTextField.getText().trim()) != 1)
	    transform.setAttribute("smallcap-size", smallcapTextField.getText());

	if (!state)
	{
	    transform.removeAttribute("smallcap-size");
	    if (transform.getAttributes().getLength() == 0)
		node.removeChild(transform);
	}

	smallcapTextField.setEnabled(state);
    }
    
    public String getText()
    {
	return smallcapTextField.getText();
    }
    
    public void setText(String text)
    {
	smallcapTextField.setText(text);
    }
    
    public void setSelected(boolean value)
    {
	smallcapCheckBox.setSelected(value);
    }
    
    public void setEnabled(boolean value)
    {
	smallcapTextField.setEnabled(value);
    }
    
    public boolean isSelected()
    {
	return smallcapCheckBox.isSelected();
    }    
}
