package com.renderx.xepx.x4u.ct;

import java.awt.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.border.*;
import java.awt.event.*;
import javax.swing.event.*;
import org.w3c.dom.*;

import com.renderx.xepx.x4u.ct.nodedscpanel.FontsDataPanel;
import com.renderx.xepx.x4u.ct.nodedscpanel.TransformPanel;

import java.net.*;


/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

public class FontsPanel extends JPanel {

  private static final long serialVersionUID = -6622149119140306676L;

// Font option variable
  public static String DEFAULTFONT = null;

  public static final String[] COMBO_VALUE  = {"unspecified", "true", "false"};
  public static final String[] NEW_COMMANDS = {"AddGroup","AddFamily","AddFont"};

  JTree fontsTree;

  protected DomToJTreeAdapter domModel;
  Document doc;

  BorderLayout borderLayout1 = new BorderLayout();
  Border border1;
  JPanel parametersPanel = new JPanel();
  Border border2;
  TitledBorder titledBorder1;
  BorderLayout borderLayout2 = new BorderLayout();
  JPanel treePanel = new JPanel();
  JPanel detailPanel = new JPanel();
  JScrollPane fontsScrollPane = new JScrollPane();
  JSplitPane jSplitPane1 = new JSplitPane();
  GridLayout gridLayout1 = new GridLayout();
  GridBagLayout gridBagLayout2 = new GridBagLayout();
  BorderLayout borderLayout3 = new BorderLayout();
  JPanel commonPanel = new JPanel();
  JPanel commandPanel = new JPanel(); // = new JTable();
  JButton deleteButton = new JButton();
  JButton groupButton = new JButton();
  JButton familyButton = new JButton();
  JButton fontButton = new JButton();
  JLabel xmlLabel = new JLabel();
  
  JLabel encodingLabel = new JLabel();  
  JLabel codePageNameLabel = new JLabel();
  JLabel codePageFileLabel = new JLabel();
  
  JTextField xmlTextField = new JTextField();
  JTextField encodingTextField = new JTextField();
  JTextField codePageNameTextField = new JTextField();
  JTextField codePageFileTextField = new JTextField();
  
  JButton browseButton = new JButton();
  GridBagLayout gridBagLayout3 = new GridBagLayout();
  Border border3;
  TitledBorder titledBorder2;
  JPanel nodeDscPanel = new JPanel();
  JPanel charsetPanel = new JPanel();
  
  JComboBox embedComboBox = new JComboBox(COMBO_VALUE);
  JLabel embedLabel = new JLabel();
  JComboBox subsetComboBox = new JComboBox(COMBO_VALUE);
  JLabel subsetLabel = new JLabel();
  
  JPanel fontsDataPanel = new JPanel();
  FontsDataPanel customFontsDataPanel = new FontsDataPanel(); 
  JScrollPane fontDetScrollPane = new JScrollPane();
  JTable fontDetTable;///// = new JTable();
  GridLayout gridLayout2 = new GridLayout();
  
  TransformPanel customTransformPanel = new TransformPanel(this);
  TitledBorder titledBorder3;
  
  BorderLayout borderLayout4 = new BorderLayout();
  Border border4;
 
  JPanel aliasPanel = new JPanel();
  JScrollPane aliasScrollPane = new JScrollPane();
  JTable aliasTable;
  Border border5;
  TitledBorder titledBorder4;
  GridLayout gridLayout3 = new GridLayout();
  Border border6;
  TitledBorder titledBorder5; // = new JTable();
  Element fontNode = null;
  JPanel dataCommandsPanel = new JPanel();
  JButton deleteDataButton = new JButton();
  JButton addDataButton = new JButton();


  public FontsPanel(Document dw) {
    this.doc = dw;
    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    border1 = new EtchedBorder(EtchedBorder.RAISED, Color.white, new Color(148, 145, 140));
    border2 = new EtchedBorder(EtchedBorder.RAISED, Color.white, new Color(148, 145, 140));
    titledBorder1 = new TitledBorder(new EtchedBorder(EtchedBorder.RAISED, Color.white,
                                                      new Color(148, 145, 140)), "Supported Fonts");
    border3 = BorderFactory.createEmptyBorder();
    titledBorder2 = new TitledBorder(border3, "Common Attributes");
    border4 = BorderFactory.createEmptyBorder();
    titledBorder3 = new TitledBorder(border4, "Transformation");
    border5 = BorderFactory.createEmptyBorder();
    titledBorder4 = new TitledBorder(border5, "Font Aliases");
    border6 = BorderFactory.createEmptyBorder();
    titledBorder5 = new TitledBorder(border6, "Font data");

    this.setLayout(borderLayout1);
    parametersPanel.setBorder(titledBorder1);
    parametersPanel.setLayout(borderLayout2);
    detailPanel.setLayout(borderLayout3);
    treePanel.setPreferredSize(new Dimension(160, 300));
    treePanel.setLayout(gridLayout1);
    jSplitPane1.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
    jSplitPane1.setPreferredSize(new Dimension(350, 300));
    jSplitPane1.setDividerLocation(300);
    gridLayout1.setColumns(1);
    gridLayout1.setRows(0);
    commonPanel.setLayout(gridBagLayout3);
    groupButton.setActionCommand(NEW_COMMANDS[0]);
    groupButton.setText("New Group");
    groupButton.addActionListener(new java.awt.event.ActionListener()
    {
        public void actionPerformed(ActionEvent e)
        {
    	new_actionPerformed(e);
        }
    });
    familyButton.setText("New Family");
    familyButton.setActionCommand(NEW_COMMANDS[1]);
    familyButton.addActionListener(new java.awt.event.ActionListener()
    {
        public void actionPerformed(ActionEvent e)
        {
    	new_actionPerformed(e);
        }
    });
    fontButton.setText("New Font");
    fontButton.setActionCommand(NEW_COMMANDS[2]);
    fontButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        new_actionPerformed(e);
      }
    });

    deleteButton.setText("Delete Node");
    deleteButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        deleteButton_actionPerformed(e);
      }
    });

    xmlLabel.setPreferredSize(new Dimension(70, 15));
    xmlLabel.setText("Base path:");
    xmlTextField.setPreferredSize(new Dimension(70, 19));
    xmlTextField.setText("");
    xmlTextField.setName("xmlbase");
    xmlTextField.addFocusListener(new java.awt.event.FocusAdapter()
    {
        public void focusLost(FocusEvent e)
        {
    		textField_focusLost(e, (Element) fontNode);
        }
    
        public void focusGained(FocusEvent e)
        {
    		textField_focusGained(e, (Element) fontNode);
        }
    });
    encodingLabel.setPreferredSize(new Dimension(60, 15));
    encodingLabel.setText("Encoding:");
    encodingTextField.setPreferredSize(new Dimension(70, 19));
    encodingTextField.setText("");
    encodingTextField.setName("size");
    encodingTextField.addFocusListener(new java.awt.event.FocusAdapter()
    {
        public void focusLost(FocusEvent e)
        {
    		textField_focusLost(e, (Element) fontNode);
        }
    
        public void focusGained(FocusEvent e)
        {
    		textField_focusGained(e, (Element) fontNode);
        }
    });     

    codePageNameLabel.setPreferredSize(new Dimension(60, 15));
    codePageNameLabel.setText("Code page:");
    codePageNameTextField.setPreferredSize(new Dimension(70, 19));
    codePageNameTextField.setText("");
    codePageNameTextField.setName("codepage-name");
    codePageNameTextField.addFocusListener(new java.awt.event.FocusAdapter()
    {
        public void focusLost(FocusEvent e)
        {
    		textField_focusLost(e, (Element) fontNode);
        }
    
        public void focusGained(FocusEvent e)
        {
    		textField_focusGained(e, (Element) fontNode);
        }
    });
    
    codePageFileLabel.setPreferredSize(new Dimension(60, 15));
    codePageFileLabel.setText("Code page:");
    codePageFileTextField.setPreferredSize(new Dimension(70, 19));
    codePageFileTextField.setText("");
    codePageFileTextField.setName("codepage-file");
    codePageFileTextField.addFocusListener(new java.awt.event.FocusAdapter()
    {
        public void focusLost(FocusEvent e)
        {
    		textField_focusLost(e, (Element) fontNode);
        }
    
        public void focusGained(FocusEvent e)
        {
    		textField_focusGained(e, (Element) fontNode);
        }
    });

    browseButton.setText("Browse");
    browseButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        browseButton_actionPerformed(e,(Element)fontNode);
      }
    });

    commonPanel.setBorder(titledBorder2);
    embedLabel.setText("Embedded:");
    subsetLabel.setText("Subsetted:");

    fontsDataPanel.setLayout(gridLayout2);
    gridLayout2.setColumns(1);
    gridLayout2.setRows(0);
    nodeDscPanel.setLayout(borderLayout4);
    nodeDscPanel.setVisible(false);
    //charsetPanel.setLayout(new FlowLayout());


    aliasPanel.setVisible(false);
    fontsDataPanel.setBorder(titledBorder5);
    embedComboBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        embedComboBox_actionPerformed(e);
      }
    });
    subsetComboBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        subsetComboBox_actionPerformed(e);
      }
    });
    deleteDataButton.setText("Delete");
    deleteDataButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        deleteDataButton_actionPerformed(e, (Element) fontNode);
      }
    });
    addDataButton.setText("Add");
    addDataButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        addDataButton_actionPerformed(e, (Element) fontNode);
      }
    });
    this.add(parametersPanel, BorderLayout.CENTER);
    parametersPanel.add(jSplitPane1, BorderLayout.CENTER);
    jSplitPane1.add(treePanel, JSplitPane.TOP);
    treePanel.add(fontsScrollPane, null);
    domModel = new DomToJTreeAdapter(this.doc, DOMWalker.fntRoot);
    fontsTree = new JTree(domModel); //new DomToTreeModelAdapter());
    fontsTree.setEditable(true);
    fontsTree.setVisible(true);
    fontsScrollPane.getViewport().add(fontsTree, null);
    fontsTree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    fontsTree.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
      public void valueChanged(TreeSelectionEvent e) {
        fontsTree_valueChanged(e);
      }
    });
    fontsTree.setSelectionRow(0);
    jSplitPane1.add(detailPanel, JSplitPane.BOTTOM);
    detailPanel.add(commonPanel, BorderLayout.NORTH);
    commandPanel.add(groupButton, null);
    commandPanel.add(familyButton, null);
    commandPanel.add(fontButton, null);
    commandPanel.add(deleteButton, null);
    //
    fontDetTable = null;
    fontDetScrollPane.getViewport().add(fontDetTable, null);

    detailPanel.add(nodeDscPanel,  BorderLayout.CENTER);
    nodeDscPanel.add(fontsDataPanel, BorderLayout.CENTER);
    
    charsetPanel.add(encodingLabel);
    charsetPanel.add(encodingTextField);
    charsetPanel.add(codePageNameLabel);
    charsetPanel.add(codePageNameTextField);
    charsetPanel.add(codePageFileLabel);
    charsetPanel.add(codePageFileTextField);
    //charsetPanel.add(encodingLabel);
    
    
    
    
    commonPanel.add(xmlLabel,  new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));    
    commonPanel.add(xmlTextField,  new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    
    int gridx = 0;
    int gridy = 1;
    int gridwidth = 1;
    int gridheight = 1;
    double weightx = 1.0;
    double weighty = 0.0;
    int anchor = GridBagConstraints.WEST;
    int fill = GridBagConstraints.HORIZONTAL;
    Insets insets = new Insets(5, 5, 5, 5);
    int ipadx = 0;
    int ipady = 0;
    
    GridBagConstraints charsetGridBagConstraints = 
	new GridBagConstraints(gridx, gridy, gridwidth, gridheight, weightx, weighty, anchor, fill, insets, ipadx, ipady);
    
/*    //commonPanel.add(charsetPanel, charsetGridBagConstraints );
    commonPanel.add(encodingLabel,  charsetGridBagConstraints);
    charsetGridBagConstraints.gridx = 1;
    commonPanel.add(encodingTextField, charsetGridBagConstraints);
    
    
    commonPanel.add(codePageNameLabel,  new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    commonPanel.add(codePageNameTextField,     new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    
//    commonPanel.add(codePageFileLabel,  new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0
//            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));            
    commonPanel.add(codePageFileTextField,     new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
*/
    commonPanel.add(embedComboBox,    new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0	    
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    
    commonPanel.add(embedLabel,    new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    commonPanel.add(subsetComboBox,    new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    commonPanel.add(subsetLabel,  new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    commonPanel.add(browseButton,     new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 0, 5, 0), 0, 0));
    
    fontsDataPanel.add(fontDetScrollPane, null);
    nodeDscPanel.add(customTransformPanel, BorderLayout.NORTH);

    dataCommandsPanel.setVisible(false);
    detailPanel.add(dataCommandsPanel,  BorderLayout.SOUTH);
    parametersPanel.add(commandPanel, BorderLayout.SOUTH);
    aliasScrollPane.getViewport().add(aliasTable, null);
    dataCommandsPanel.add(addDataButton, null);
    dataCommandsPanel.add(deleteDataButton, null);
  }

    public void setCommonAttribs(org.w3c.dom.Node node)
    {
	NamedNodeMap attribs = node.getAttributes();

	this.embedComboBox
		.setSelectedIndex((attribs.getNamedItem("embed") == null) ? 0
			: ((attribs.getNamedItem("embed").getNodeValue()
				.toString()).equalsIgnoreCase("true")) ? 1 : 2);
	this.subsetComboBox
		.setSelectedIndex((attribs.getNamedItem("subset") == null) ? 0
			: ((attribs.getNamedItem("subset").getNodeValue()
				.toString()).equalsIgnoreCase("true")) ? 1 : 2);
	this.xmlTextField
		.setText((attribs.getNamedItem("xml:base") == null) ? COMBO_VALUE[0]
			: attribs.getNamedItem("xml:base").getNodeValue());	
	this.encodingTextField
		.setText((attribs.getNamedItem("encoding") == null) ? COMBO_VALUE[0]
		: attribs.getNamedItem("encoding").getNodeValue());
	this.codePageNameTextField
		.setText((attribs.getNamedItem("codepage-name") == null) ? COMBO_VALUE[0]
		: attribs.getNamedItem("codepage-name").getNodeValue());
	this.codePageFileTextField
		.setText((attribs.getNamedItem("codepage-file") == null) ? COMBO_VALUE[0]
		: attribs.getNamedItem("codepage-file").getNodeValue());
		

    }

  public static String getDefFont() { // ToDo: check for null
    if (DEFAULTFONT == null)
      //getElementsByTagName(rootName);
      DEFAULTFONT = DOMWalker.fntRoot.getAttribute("default-family");
  //DOMWalker.getSubTree("fonts").item(0).getAttributes().getNamedItem(
          //"default-family").getNodeValue();
    return DEFAULTFONT;
  }



    void fontsTree_valueChanged(TreeSelectionEvent e)
    {
	TreePath p = e.getNewLeadSelectionPath();
	fontNode = null;
	if (p == null)
	    return;
	DomToJTreeAdapter.FontTreeNode node = (DomToJTreeAdapter.FontTreeNode) p
		.getLastPathComponent();
	// //////////System.out.println("CURRENT NODE="+node.body);
	fontNode = node.body;
	setCommonAttribs(node.body);
	dataCommandsPanel.setVisible(false); // show only for font nodes
	if (node.body.getNodeName() == "font-group" || node.body.getNodeName() == "fonts")
	{
	    this.fontButton.setEnabled(false);
	    this.familyButton.setEnabled(true);
	    this.groupButton.setEnabled(true);
	    nodeDscPanel.setVisible(false);

	    detailPanel.remove(aliasPanel);
	    aliasPanel = new FontAliasesPanel(node.body);
	    aliasPanel.setVisible(true);
	    detailPanel.add(aliasPanel, BorderLayout.CENTER);
	    detailPanel.updateUI();

	} else
	{
	    this.fontButton.setEnabled(true);
	    this.familyButton.setEnabled(false);
	    this.groupButton.setEnabled(false);
	    aliasPanel.setVisible(false);
	    this.fontDetScrollPane.getViewport().removeAll();
	    if (node.body.getNodeName() == "font")
	    {
		//dataCommandsPanel.setVisible(false);
		detailPanel.remove(nodeDscPanel);
		nodeDscPanel.setVisible(true);
		detailPanel.add(nodeDscPanel, BorderLayout.CENTER);
		detailPanel.updateUI();
		
		// Set size panel patameters
		customTransformPanel.getSizePanel().setTextFromNode(node);
		

		dataCommandsPanel.setVisible(true);

		NodeList children = node.body.getElementsByTagName("font-data");
		if (children.getLength() == 0)
		    fontDetTable = null;
		else
		{
		    fontDetTable = new JTable(new DomToTableModel(
			    (Element) node.body, true));// ////currNode,true));
		    this.fontDetScrollPane.getViewport().add(fontDetTable, null);
		}
		children = node.body.getElementsByTagName("transform");
		if (children.getLength() > 0)
		    customTransformPanel.setFontTrans(children.item(0));
		else
		{// // set default values
		    customTransformPanel.setDefaultValues();
		}

	    } else
	    {
		nodeDscPanel.setVisible(false);
	    }
	    this.fontDetScrollPane.updateUI();
	}
    }

    JTable setFontDataTable(Node node)
    {
	NamedNodeMap attribs = node.getAttributes();
	if (attribs == null)
	    return new JTable(0, 2);
	// System.out.println(" FONT DATA="+attribs.toString());
	String[][] tmp = new String[attribs.getLength()][2];
	int i = 0;
	if (attribs.getNamedItem("afm") != null)
	{
	    tmp[i][0] = "afm";
	    tmp[i][1] = attribs.getNamedItem("afm").getNodeValue();
	    i++;
	}
	if (attribs.getNamedItem("pfa") != null)
	{
	    tmp[i][0] = "pfa";
	    tmp[i][1] = attribs.getNamedItem("pfa").getNodeValue();
	    i++;
	}
	if (attribs.getNamedItem("pfb") != null)
	{
	    tmp[i][0] = "pfb";
	    tmp[i][1] = attribs.getNamedItem("pfb").getNodeValue();
	    i++;
	}
	if (attribs.getNamedItem("ttf") != null)
	{
	    tmp[i][0] = "ttf";
	    tmp[i][1] = attribs.getNamedItem("ttf").getNodeValue();
	    i++;
	}
	if (attribs.getNamedItem("otf") != null)
	{
	    tmp[i][0] = "otf";
	    tmp[i][1] = attribs.getNamedItem("otf").getNodeValue();
	    i++;
	}
	if (attribs.getNamedItem("cff") != null)
	{
	    tmp[i][0] = "cff";
	    tmp[i][1] = attribs.getNamedItem("cff").getNodeValue();
	    i++;
	}
	if (attribs.getNamedItem("glyph-list") != null)
	{
	    tmp[i][0] = "glyph-list";
	    tmp[i][1] = attribs.getNamedItem("glyph-list").getNodeValue();
	    i++;
	}
	if (attribs.getNamedItem("adobe-ordering") != null)
	{
	    tmp[i][0] = "adobe-ordering";
	    tmp[i][1] = attribs.getNamedItem("adobe-ordering").getNodeValue();
	    i++;
	}
	if (attribs.getNamedItem("adobe-encoding") != null)
	{
	    tmp[i][0] = "adobe-encoding";
	    tmp[i][1] = attribs.getNamedItem("adobe-encoding").getNodeValue();
	    i++;
	}
	if (attribs.getNamedItem("adobe-supplement") != null)
	{
	    tmp[i][0] = "adobe-supplement";
	    tmp[i][1] = attribs.getNamedItem("adobe-supplement").getNodeValue();
	    i++;
	}
	String[] nm = { "", "" };
	JTable res = new JTable(tmp, nm);
	return res;
    }

    String currTextValue = "";

    public void textField_focusGained(FocusEvent e, Element node)
    {
	String cmd = ((JTextField) e.getSource()).getName();
	if (cmd.equalsIgnoreCase("slant"))
	    currTextValue = customTransformPanel.getCustomSlantPanel().getText().trim();
	else if (cmd.equalsIgnoreCase("xmlbase"))
	    currTextValue = xmlTextField.getText().trim();
	else if (cmd.equalsIgnoreCase("encoding"))
	    currTextValue = encodingTextField.getText().trim();
	else if (cmd.equalsIgnoreCase("codepage-file"))
	    currTextValue = codePageFileTextField.getText().trim();
	else if (cmd.equalsIgnoreCase("codepage-name"))
	    currTextValue = codePageNameTextField.getText().trim();	
	else if (cmd.equalsIgnoreCase("smallcaps"))
	    currTextValue = customTransformPanel.getCustomSmallcapPanel().getText().trim();
    }

    public void textField_focusLost(FocusEvent e, Element node)
    {
	if (node == null)
	    return;
	Element transform;
	String cmd = ((JTextField) e.getSource()).getName();
	if (cmd.equalsIgnoreCase("slant")
		&& currTextValue != customTransformPanel.getCustomSmallcapPanel().getText().trim())
	{
	    transform = (Element) node.getElementsByTagName("transform").item(0);
	    if (customTransformPanel.getCustomSmallcapPanel().getText().trim().length() == 0)
		transform.removeAttribute("slant-angle");
	    else
		transform.setAttribute("slant-angle", customTransformPanel.getCustomSlantPanel().getText());
	} 
	else if (cmd.equalsIgnoreCase("smallcaps")
		&& currTextValue != customTransformPanel.getCustomSmallcapPanel().getText().trim())
	{
	    transform = (Element) node.getElementsByTagName("transform").item(0);
	    if (customTransformPanel.getCustomSmallcapPanel().getText().trim().length() == 0)
		transform.removeAttribute("smallcap-size");
	    else
		transform.setAttribute("smallcap-size", customTransformPanel.getCustomSmallcapPanel().getText());
	}
	
	//---------------------
	else if (cmd.equalsIgnoreCase("xmlbase")
		&& currTextValue != xmlTextField.getText().trim())
	{
	    if (xmlTextField.getText().trim().length() == 0
		    || xmlTextField.getText().equalsIgnoreCase(COMBO_VALUE[0]))
		node.removeAttribute("xml:base");
	    else
		node.setAttribute("xml:base", xmlTextField.getText());
	}
	//----------------------
	else if (cmd.equalsIgnoreCase("encoding")
		&& currTextValue != encodingTextField.getText().trim())
	{
	    if (encodingTextField.getText().trim().length() == 0
		    || encodingTextField.getText().equalsIgnoreCase(COMBO_VALUE[0]))
		node.removeAttribute("encoding");
	    else
		node.setAttribute("encoding", encodingTextField.getText());
	}
	//----------------------
	else if (cmd.equalsIgnoreCase("codepage-file")
		&& currTextValue != codePageFileTextField.getText().trim())
	{
	    if (codePageFileTextField.getText().trim().length() == 0
		    || codePageFileTextField.getText().equalsIgnoreCase(COMBO_VALUE[0]))
		node.removeAttribute("codepage-file");
	    else
		node.setAttribute("codepage-file", codePageFileTextField.getText());
	}	
	//-----------------------
	else if (cmd.equalsIgnoreCase("codepage-name")
		&& currTextValue != codePageNameTextField.getText().trim())
	{
	    if (codePageNameTextField.getText().trim().length() == 0
		    || codePageNameTextField.getText().equalsIgnoreCase(COMBO_VALUE[0]))
		node.removeAttribute("codepage-name");
	    else
		node.setAttribute("codepage-name", codePageNameTextField.getText());
	}		
	// ----------------------
	  else if (cmd.equalsIgnoreCase("size")
		&& currTextValue != customTransformPanel.getSizePanel().getText().trim())
	  {
	    if (customTransformPanel.getSizePanel().getText().trim().length() == 0
		    || customTransformPanel.getSizePanel().getText().equalsIgnoreCase(COMBO_VALUE[0]))
		node.removeAttribute("size");
	    else
		node.setAttribute("size", customTransformPanel.getSizePanel().getText());
	  }
	else if (cmd.equalsIgnoreCase("smallcap-size")
		&& currTextValue != customTransformPanel.getCustomSmallcapPanel().getText().trim())
	{
	    transform = (Element) node.getElementsByTagName("transform").item(0);
	    if (customTransformPanel.getCustomSmallcapPanel().getText().trim().length() == 0)
		transform.removeAttribute("smallcap-size");
	    else
		transform.setAttribute("smallcap-size", customTransformPanel.getCustomSmallcapPanel().getText());
	} 

	// //// System.out.println("Com"+cmd+" Old="+currTextValue+"
        // Attr="+node.getAttributes().toString());
	currTextValue = "";
    }

    void new_actionPerformed(ActionEvent e)
    {
	domModel.insertInCurrentNode(new TreeModelEvent(e.getSource(),
		fontsTree.getSelectionPath()), e.getActionCommand());
	// fontsTree.scrollPathToVisible(new TreePath(
        // fontsTree.getSelectionPath().getLastPathComponent()));
    }

    void deleteButton_actionPerformed(ActionEvent e)
    {
	TreePath path = fontsTree.getSelectionPath();
	if (path.getParentPath() == null)
	    return;
	domModel.removeCurrentNode(new TreeModelEvent(e.getSource(), path));
	fontsTree.setSelectionPath(path.getParentPath());
	// fontsTree_removeCurrentNode(new TreeModelEvent(e.getSource(),
        // fontsTree.getSelectionPath()));
    }

    void browseButton_actionPerformed(ActionEvent e, Element node)
    {
	JFileChooser fc = new JFileChooser();
	currTextValue = xmlTextField.getText();
	fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
	int returnVal = fc.showOpenDialog(this);
	if (returnVal == JFileChooser.APPROVE_OPTION)
	{
	    try
	    {
		xmlTextField.setText(fc.getSelectedFile().toURL()
			.toExternalForm());

		textField_focusLost(new FocusEvent(xmlTextField, e.getID(),
			true), node);
		// / configElement.setAttribute("xml:base",
                // xmlTextField.getText());
	    } catch (MalformedURLException ex)
	    {
		xmlTextField.setText("");// "Invalid URL for xml:base.
                                                // Value not defined");
	    }
	}
    }

  void embedComboBox_actionPerformed(ActionEvent e) {
    if (this.fontNode == null) return;
    String txt = embedComboBox.getSelectedItem().toString();
    if(txt.equalsIgnoreCase(COMBO_VALUE[0])){
      if(fontNode.getAttribute("embed") != null)
        fontNode.removeAttribute("embed");
    }
    else fontNode.setAttribute("embed",  COMBO_VALUE[embedComboBox.getSelectedIndex()]);
  }

  void subsetComboBox_actionPerformed(ActionEvent e) {
    if (this.fontNode == null) return;
    String txt = subsetComboBox.getSelectedItem().toString();
    if(txt.equalsIgnoreCase(COMBO_VALUE[0])){
      if(fontNode.getAttribute("subset") != null)
        fontNode.removeAttribute("subset");
    }
    else fontNode.setAttribute("subset",COMBO_VALUE[subsetComboBox.getSelectedIndex()]);
  }

  void addDataButton_actionPerformed(ActionEvent e, Element parent) {
    DomToTableModel tm;
    if(fontDetTable == null){
      tm = new DomToTableModel(parent, true);
/////////////System.out.println(" Font="+parent.toString());
      fontDetTable = new JTable(tm);
      fontDetScrollPane.getViewport().add(fontDetTable, null);
      fontDetScrollPane.updateUI();
    }
    else tm = (DomToTableModel) fontDetTable.getModel();
    tm.addRow(parent);
  }

  void deleteDataButton_actionPerformed(ActionEvent e, Element parent) {
    int row = fontDetTable.getSelectedRow();
    if(row < 0) return;
//////System.out.println(" Font="+parent.toString()+" sss="+this.fontDetTable.getValueAt(0,0));
    DomToTableModel tm = (DomToTableModel) fontDetTable.getModel();
    Attr temp = (Attr) tm.getNodeAt(row);
    Element fdata = (Element)parent.getElementsByTagName("font-data").item(0);
    fdata.removeAttributeNode(temp);
    tm.deleteRow(row);
  }

/**
 * @return the fontNode
 */
public Element getFontNode()
{
    return fontNode;
}

}
