/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre;

import com.renderx.xep.lib.InternalException;
import com.renderx.xep.pre.Attr;
import junit.framework.Assert;
import junit.framework.TestCase;

public class Bidi {
    public static final Attr[] classes = new Attr[65536];
    public static final char[] mirrorChars = new char[65536];
    public static final char[] initialShape;
    public static final char[] medialShape;
    public static final char[] finalShape;
    public static final boolean[] transparentShape;
    public static Attr LEFTTORIGHT;
    public static Attr RIGHTTOLEFT;
    public static Attr NEUTRAL;
    public static Attr EN;
    public static Attr AN;
    public static Attr CS;
    private static boolean initialized;

    private static void set(int n, Attr attr) {
        Bidi.classes[n] = attr;
    }

    private static void setRange(int n, int n2, Attr attr) {
        int n3 = n;
        while (n3 <= n2) {
            Bidi.set(n3, attr);
            ++n3;
        }
    }

    private static void setMirror(int n, char c) {
        Bidi.mirrorChars[n] = c;
    }

    public static String mirror(String string) {
        int n = 0;
        while (n < string.length() && mirrorChars[string.charAt(n)] == '\u0000') {
            ++n;
        }
        if (n == string.length()) {
            return string;
        }
        char[] cArray = string.toCharArray();
        while (n < string.length()) {
            char c = mirrorChars[string.charAt(n)];
            if (c != '\u0000') {
                cArray[n] = c;
            }
            ++n;
        }
        return new String(cArray);
    }

    public static String shape(String string, boolean bl) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (bl && mirrorChars[c] != '\u0000' || initialShape[c] != '\u0000' || medialShape[c] != '\u0000' || finalShape[c] != '\u0000') break;
            ++n;
        }
        if (n == string.length()) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = n;
        boolean bl2 = false;
        while (n < cArray.length) {
            int n3;
            int n4 = string.charAt(n++);
            if (bl && (n3 = mirrorChars[n4]) != 0) {
                n4 = n3;
            }
            if (n4 == 1604 && n < cArray.length) {
                switch (string.charAt(n)) {
                    case '\u0622': {
                        n4 = 65269;
                        break;
                    }
                    case '\u0623': {
                        n4 = 65271;
                        ++n;
                        break;
                    }
                    case '\u0625': {
                        n4 = 65273;
                        ++n;
                        break;
                    }
                    case '\u0627': {
                        n4 = 65275;
                        ++n;
                    }
                }
            }
            n3 = ++n;
            while (n < cArray.length && transparentShape[string.charAt(n)]) {
                ++n;
            }
            if (n == cArray.length || finalShape[string.charAt(n)] == '\u0000') {
                if (bl2) {
                    n4 = finalShape[n4];
                }
                bl2 = false;
            } else {
                int n5;
                int n6 = n5 = bl2 ? medialShape[n4] : initialShape[n4];
                if (n5 == 0) {
                    if (bl2) {
                        n4 = finalShape[n4];
                    }
                    bl2 = false;
                } else {
                    n4 = n5;
                    bl2 = true;
                }
            }
            cArray[n2++] = n4;
            while (n3 != n) {
                cArray[n2++] = string.charAt(n3++);
            }
        }
        return new String(cArray, 0, n2);
    }

    public static boolean isNeutral(char c) {
        return classes[c] == NEUTRAL || classes[c] == CS;
    }

    public static synchronized void init() throws InternalException {
        if (initialized) {
            return;
        }
        LEFTTORIGHT = Attr.Word.create("ltr");
        RIGHTTOLEFT = Attr.Word.create("rtl");
        NEUTRAL = Attr.Word.create("neutral");
        EN = Attr.Word.create("EN");
        AN = Attr.Word.create("AN");
        CS = Attr.Word.create("CS");
        Bidi.setRange(0, 65535, LEFTTORIGHT);
        Bidi.setRange(0, 31, NEUTRAL);
        Bidi.setRange(127, 159, NEUTRAL);
        Bidi.setRange(768, 879, NEUTRAL);
        Bidi.setRange(1155, 1161, NEUTRAL);
        Bidi.setRange(8192, 8303, NEUTRAL);
        Bidi.setRange(8400, 8447, NEUTRAL);
        Bidi.setRange(8592, 8703, NEUTRAL);
        Bidi.setRange(9472, 10175, NEUTRAL);
        Bidi.setRange(65520, 65535, NEUTRAL);
        Bidi.setRange(1424, 1983, RIGHTTOLEFT);
        Bidi.setRange(64285, 65023, RIGHTTOLEFT);
        Bidi.setRange(65136, 65279, RIGHTTOLEFT);
        Bidi.setRange(48, 57, EN);
        Bidi.setRange(1632, 1641, AN);
        Bidi.set(9, NEUTRAL);
        Bidi.set(10, NEUTRAL);
        Bidi.set(13, NEUTRAL);
        Bidi.set(32, NEUTRAL);
        Bidi.set(160, NEUTRAL);
        Bidi.setRange(8192, 8203, NEUTRAL);
        Bidi.set(8232, NEUTRAL);
        Bidi.set(8239, NEUTRAL);
        Bidi.setRange(33, 34, NEUTRAL);
        Bidi.setRange(38, 43, NEUTRAL);
        Bidi.set(44, CS);
        Bidi.set(45, NEUTRAL);
        Bidi.setRange(46, 47, CS);
        Bidi.set(58, CS);
        Bidi.setRange(59, 64, NEUTRAL);
        Bidi.setRange(91, 96, NEUTRAL);
        Bidi.setRange(123, 126, NEUTRAL);
        Bidi.set(161, NEUTRAL);
        Bidi.setRange(166, 169, NEUTRAL);
        Bidi.setRange(171, 175, NEUTRAL);
        Bidi.set(180, NEUTRAL);
        Bidi.setRange(182, 184, NEUTRAL);
        Bidi.set(187, NEUTRAL);
        Bidi.set(191, NEUTRAL);
        Bidi.set(215, NEUTRAL);
        Bidi.set(247, NEUTRAL);
        Bidi.setRange(1643, 1644, NEUTRAL);
        Bidi.set(8206, LEFTTORIGHT);
        Bidi.set(8234, LEFTTORIGHT);
        Bidi.set(8237, LEFTTORIGHT);
        Bidi.set(8207, RIGHTTOLEFT);
        Bidi.set(8235, RIGHTTOLEFT);
        Bidi.set(8238, RIGHTTOLEFT);
        Bidi.set(1548, CS);
        Bidi.setMirror(40, ')');
        Bidi.setMirror(41, '(');
        Bidi.setMirror(60, '>');
        Bidi.setMirror(62, '<');
        Bidi.setMirror(91, ']');
        Bidi.setMirror(93, '[');
        Bidi.setMirror(123, '}');
        Bidi.setMirror(125, '{');
        Bidi.setMirror(171, '\u00bb');
        Bidi.setMirror(187, '\u00ab');
        Bidi.setMirror(3898, '\u0f3b');
        Bidi.setMirror(3899, '\u0f3a');
        Bidi.setMirror(3900, '\u0f3d');
        Bidi.setMirror(3901, '\u0f3c');
        Bidi.setMirror(5787, '\u169c');
        Bidi.setMirror(5788, '\u169b');
        Bidi.setMirror(8249, '\u203a');
        Bidi.setMirror(8250, '\u2039');
        Bidi.setMirror(8261, '\u2046');
        Bidi.setMirror(8262, '\u2045');
        Bidi.setMirror(8317, '\u207e');
        Bidi.setMirror(8318, '\u207d');
        Bidi.setMirror(8333, '\u208e');
        Bidi.setMirror(8334, '\u208d');
        Bidi.setMirror(8712, '\u220b');
        Bidi.setMirror(8713, '\u220c');
        Bidi.setMirror(8714, '\u220d');
        Bidi.setMirror(8715, '\u2208');
        Bidi.setMirror(8716, '\u2209');
        Bidi.setMirror(8717, '\u220a');
        Bidi.setMirror(8725, '\u29f5');
        Bidi.setMirror(8764, '\u223d');
        Bidi.setMirror(8765, '\u223c');
        Bidi.setMirror(8771, '\u22cd');
        Bidi.setMirror(8786, '\u2253');
        Bidi.setMirror(8787, '\u2252');
        Bidi.setMirror(8788, '\u2255');
        Bidi.setMirror(8789, '\u2254');
        Bidi.setMirror(8804, '\u2265');
        Bidi.setMirror(8805, '\u2264');
        Bidi.setMirror(8806, '\u2267');
        Bidi.setMirror(8807, '\u2266');
        Bidi.setMirror(8808, '\u2269');
        Bidi.setMirror(8809, '\u2268');
        Bidi.setMirror(8810, '\u226b');
        Bidi.setMirror(8811, '\u226a');
        Bidi.setMirror(8814, '\u226f');
        Bidi.setMirror(8815, '\u226e');
        Bidi.setMirror(8816, '\u2271');
        Bidi.setMirror(8817, '\u2270');
        Bidi.setMirror(8818, '\u2273');
        Bidi.setMirror(8819, '\u2272');
        Bidi.setMirror(8820, '\u2275');
        Bidi.setMirror(8821, '\u2274');
        Bidi.setMirror(8822, '\u2277');
        Bidi.setMirror(8823, '\u2276');
        Bidi.setMirror(8824, '\u2279');
        Bidi.setMirror(8825, '\u2278');
        Bidi.setMirror(8826, '\u227b');
        Bidi.setMirror(8827, '\u227a');
        Bidi.setMirror(8828, '\u227d');
        Bidi.setMirror(8829, '\u227c');
        Bidi.setMirror(8830, '\u227f');
        Bidi.setMirror(8831, '\u227e');
        Bidi.setMirror(8832, '\u2281');
        Bidi.setMirror(8833, '\u2280');
        Bidi.setMirror(8834, '\u2283');
        Bidi.setMirror(8835, '\u2282');
        Bidi.setMirror(8836, '\u2285');
        Bidi.setMirror(8837, '\u2284');
        Bidi.setMirror(8838, '\u2287');
        Bidi.setMirror(8839, '\u2286');
        Bidi.setMirror(8840, '\u2289');
        Bidi.setMirror(8841, '\u2288');
        Bidi.setMirror(8842, '\u228b');
        Bidi.setMirror(8843, '\u228a');
        Bidi.setMirror(8847, '\u2290');
        Bidi.setMirror(8848, '\u228f');
        Bidi.setMirror(8849, '\u2292');
        Bidi.setMirror(8850, '\u2291');
        Bidi.setMirror(8856, '\u29b8');
        Bidi.setMirror(8866, '\u22a3');
        Bidi.setMirror(8867, '\u22a2');
        Bidi.setMirror(8870, '\u2ade');
        Bidi.setMirror(8872, '\u2ae4');
        Bidi.setMirror(8873, '\u2ae3');
        Bidi.setMirror(8875, '\u2ae5');
        Bidi.setMirror(8880, '\u22b1');
        Bidi.setMirror(8881, '\u22b0');
        Bidi.setMirror(8882, '\u22b3');
        Bidi.setMirror(8883, '\u22b2');
        Bidi.setMirror(8884, '\u22b5');
        Bidi.setMirror(8885, '\u22b4');
        Bidi.setMirror(8886, '\u22b7');
        Bidi.setMirror(8887, '\u22b6');
        Bidi.setMirror(8905, '\u22ca');
        Bidi.setMirror(8906, '\u22c9');
        Bidi.setMirror(8907, '\u22cc');
        Bidi.setMirror(8908, '\u22cb');
        Bidi.setMirror(8909, '\u2243');
        Bidi.setMirror(8912, '\u22d1');
        Bidi.setMirror(8913, '\u22d0');
        Bidi.setMirror(8918, '\u22d7');
        Bidi.setMirror(8919, '\u22d6');
        Bidi.setMirror(8920, '\u22d9');
        Bidi.setMirror(8921, '\u22d8');
        Bidi.setMirror(8922, '\u22db');
        Bidi.setMirror(8923, '\u22da');
        Bidi.setMirror(8924, '\u22dd');
        Bidi.setMirror(8925, '\u22dc');
        Bidi.setMirror(8926, '\u22df');
        Bidi.setMirror(8927, '\u22de');
        Bidi.setMirror(8928, '\u22e1');
        Bidi.setMirror(8929, '\u22e0');
        Bidi.setMirror(8930, '\u22e3');
        Bidi.setMirror(8931, '\u22e2');
        Bidi.setMirror(8932, '\u22e5');
        Bidi.setMirror(8933, '\u22e4');
        Bidi.setMirror(8934, '\u22e7');
        Bidi.setMirror(8935, '\u22e6');
        Bidi.setMirror(8936, '\u22e9');
        Bidi.setMirror(8937, '\u22e8');
        Bidi.setMirror(8938, '\u22eb');
        Bidi.setMirror(8939, '\u22ea');
        Bidi.setMirror(8940, '\u22ed');
        Bidi.setMirror(8941, '\u22ec');
        Bidi.setMirror(8944, '\u22f1');
        Bidi.setMirror(8945, '\u22f0');
        Bidi.setMirror(8946, '\u22fa');
        Bidi.setMirror(8947, '\u22fb');
        Bidi.setMirror(8948, '\u22fc');
        Bidi.setMirror(8950, '\u22fd');
        Bidi.setMirror(8951, '\u22fe');
        Bidi.setMirror(8954, '\u22f2');
        Bidi.setMirror(8955, '\u22f3');
        Bidi.setMirror(8956, '\u22f4');
        Bidi.setMirror(8957, '\u22f6');
        Bidi.setMirror(8958, '\u22f7');
        Bidi.setMirror(8968, '\u2309');
        Bidi.setMirror(8969, '\u2308');
        Bidi.setMirror(8970, '\u230b');
        Bidi.setMirror(8971, '\u230a');
        Bidi.setMirror(9001, '\u232a');
        Bidi.setMirror(9002, '\u2329');
        Bidi.setMirror(10088, '\u2769');
        Bidi.setMirror(10089, '\u2768');
        Bidi.setMirror(10090, '\u276b');
        Bidi.setMirror(10091, '\u276a');
        Bidi.setMirror(10092, '\u276d');
        Bidi.setMirror(10093, '\u276c');
        Bidi.setMirror(10094, '\u276f');
        Bidi.setMirror(10095, '\u276e');
        Bidi.setMirror(10096, '\u2771');
        Bidi.setMirror(10097, '\u2770');
        Bidi.setMirror(10098, '\u2773');
        Bidi.setMirror(10099, '\u2772');
        Bidi.setMirror(10100, '\u2775');
        Bidi.setMirror(10101, '\u2774');
        Bidi.setMirror(10179, '\u27c4');
        Bidi.setMirror(10180, '\u27c3');
        Bidi.setMirror(10181, '\u27c6');
        Bidi.setMirror(10182, '\u27c5');
        Bidi.setMirror(10184, '\u27c9');
        Bidi.setMirror(10185, '\u27c8');
        Bidi.setMirror(10197, '\u27d6');
        Bidi.setMirror(10198, '\u27d5');
        Bidi.setMirror(10205, '\u27de');
        Bidi.setMirror(10206, '\u27dd');
        Bidi.setMirror(10210, '\u27e3');
        Bidi.setMirror(10211, '\u27e2');
        Bidi.setMirror(10212, '\u27e5');
        Bidi.setMirror(10213, '\u27e4');
        Bidi.setMirror(10214, '\u27e7');
        Bidi.setMirror(10215, '\u27e6');
        Bidi.setMirror(10216, '\u27e9');
        Bidi.setMirror(10217, '\u27e8');
        Bidi.setMirror(10218, '\u27eb');
        Bidi.setMirror(10219, '\u27ea');
        Bidi.setMirror(10220, '\u27ed');
        Bidi.setMirror(10221, '\u27ec');
        Bidi.setMirror(10222, '\u27ef');
        Bidi.setMirror(10223, '\u27ee');
        Bidi.setMirror(10627, '\u2984');
        Bidi.setMirror(10628, '\u2983');
        Bidi.setMirror(10629, '\u2986');
        Bidi.setMirror(10630, '\u2985');
        Bidi.setMirror(10631, '\u2988');
        Bidi.setMirror(10632, '\u2987');
        Bidi.setMirror(10633, '\u298a');
        Bidi.setMirror(10634, '\u2989');
        Bidi.setMirror(10635, '\u298c');
        Bidi.setMirror(10636, '\u298b');
        Bidi.setMirror(10637, '\u2990');
        Bidi.setMirror(10638, '\u298f');
        Bidi.setMirror(10639, '\u298e');
        Bidi.setMirror(10640, '\u298d');
        Bidi.setMirror(10641, '\u2992');
        Bidi.setMirror(10642, '\u2991');
        Bidi.setMirror(10643, '\u2994');
        Bidi.setMirror(10644, '\u2993');
        Bidi.setMirror(10645, '\u2996');
        Bidi.setMirror(10646, '\u2995');
        Bidi.setMirror(10647, '\u2998');
        Bidi.setMirror(10648, '\u2997');
        Bidi.setMirror(10680, '\u2298');
        Bidi.setMirror(10688, '\u29c1');
        Bidi.setMirror(10689, '\u29c0');
        Bidi.setMirror(10692, '\u29c5');
        Bidi.setMirror(10693, '\u29c4');
        Bidi.setMirror(10703, '\u29d0');
        Bidi.setMirror(10704, '\u29cf');
        Bidi.setMirror(10705, '\u29d2');
        Bidi.setMirror(10706, '\u29d1');
        Bidi.setMirror(10708, '\u29d5');
        Bidi.setMirror(10709, '\u29d4');
        Bidi.setMirror(10712, '\u29d9');
        Bidi.setMirror(10713, '\u29d8');
        Bidi.setMirror(10714, '\u29db');
        Bidi.setMirror(10715, '\u29da');
        Bidi.setMirror(10741, '\u2215');
        Bidi.setMirror(10744, '\u29f9');
        Bidi.setMirror(10745, '\u29f8');
        Bidi.setMirror(10748, '\u29fd');
        Bidi.setMirror(10749, '\u29fc');
        Bidi.setMirror(10795, '\u2a2c');
        Bidi.setMirror(10796, '\u2a2b');
        Bidi.setMirror(10797, '\u2a2c');
        Bidi.setMirror(10798, '\u2a2d');
        Bidi.setMirror(10804, '\u2a35');
        Bidi.setMirror(10805, '\u2a34');
        Bidi.setMirror(10812, '\u2a3d');
        Bidi.setMirror(10813, '\u2a3c');
        Bidi.setMirror(10852, '\u2a65');
        Bidi.setMirror(10853, '\u2a64');
        Bidi.setMirror(10873, '\u2a7a');
        Bidi.setMirror(10874, '\u2a79');
        Bidi.setMirror(10877, '\u2a7e');
        Bidi.setMirror(10878, '\u2a7d');
        Bidi.setMirror(10879, '\u2a80');
        Bidi.setMirror(10880, '\u2a7f');
        Bidi.setMirror(10881, '\u2a82');
        Bidi.setMirror(10882, '\u2a81');
        Bidi.setMirror(10883, '\u2a84');
        Bidi.setMirror(10884, '\u2a83');
        Bidi.setMirror(10891, '\u2a8c');
        Bidi.setMirror(10892, '\u2a8b');
        Bidi.setMirror(10897, '\u2a92');
        Bidi.setMirror(10898, '\u2a91');
        Bidi.setMirror(10899, '\u2a94');
        Bidi.setMirror(10900, '\u2a93');
        Bidi.setMirror(10901, '\u2a96');
        Bidi.setMirror(10902, '\u2a95');
        Bidi.setMirror(10903, '\u2a98');
        Bidi.setMirror(10904, '\u2a97');
        Bidi.setMirror(10905, '\u2a9a');
        Bidi.setMirror(10906, '\u2a99');
        Bidi.setMirror(10907, '\u2a9c');
        Bidi.setMirror(10908, '\u2a9b');
        Bidi.setMirror(10913, '\u2aa2');
        Bidi.setMirror(10914, '\u2aa1');
        Bidi.setMirror(10918, '\u2aa7');
        Bidi.setMirror(10919, '\u2aa6');
        Bidi.setMirror(10920, '\u2aa9');
        Bidi.setMirror(10921, '\u2aa8');
        Bidi.setMirror(10922, '\u2aab');
        Bidi.setMirror(10923, '\u2aaa');
        Bidi.setMirror(10924, '\u2aad');
        Bidi.setMirror(10925, '\u2aac');
        Bidi.setMirror(10927, '\u2ab0');
        Bidi.setMirror(10928, '\u2aaf');
        Bidi.setMirror(10931, '\u2ab4');
        Bidi.setMirror(10932, '\u2ab3');
        Bidi.setMirror(10939, '\u2abc');
        Bidi.setMirror(10940, '\u2abb');
        Bidi.setMirror(10941, '\u2abe');
        Bidi.setMirror(10942, '\u2abd');
        Bidi.setMirror(10943, '\u2ac0');
        Bidi.setMirror(10944, '\u2abf');
        Bidi.setMirror(10945, '\u2ac2');
        Bidi.setMirror(10946, '\u2ac1');
        Bidi.setMirror(10947, '\u2ac4');
        Bidi.setMirror(10948, '\u2ac3');
        Bidi.setMirror(10949, '\u2ac6');
        Bidi.setMirror(10950, '\u2ac5');
        Bidi.setMirror(10957, '\u2ace');
        Bidi.setMirror(10958, '\u2acd');
        Bidi.setMirror(10959, '\u2ad0');
        Bidi.setMirror(10960, '\u2acf');
        Bidi.setMirror(10961, '\u2ad2');
        Bidi.setMirror(10962, '\u2ad1');
        Bidi.setMirror(10963, '\u2ad4');
        Bidi.setMirror(10964, '\u2ad3');
        Bidi.setMirror(10965, '\u2ad6');
        Bidi.setMirror(10966, '\u2ad5');
        Bidi.setMirror(10974, '\u22a6');
        Bidi.setMirror(10979, '\u22a9');
        Bidi.setMirror(10980, '\u22a8');
        Bidi.setMirror(10981, '\u22ab');
        Bidi.setMirror(10988, '\u2aed');
        Bidi.setMirror(10989, '\u2aec');
        Bidi.setMirror(10999, '\u2af8');
        Bidi.setMirror(11000, '\u2af7');
        Bidi.setMirror(11001, '\u2afa');
        Bidi.setMirror(11002, '\u2af9');
        Bidi.setMirror(11778, '\u2e03');
        Bidi.setMirror(11779, '\u2e02');
        Bidi.setMirror(11780, '\u2e05');
        Bidi.setMirror(11781, '\u2e04');
        Bidi.setMirror(11785, '\u2e0a');
        Bidi.setMirror(11786, '\u2e09');
        Bidi.setMirror(11788, '\u2e0d');
        Bidi.setMirror(11789, '\u2e0c');
        Bidi.setMirror(11804, '\u2e1d');
        Bidi.setMirror(11805, '\u2e1c');
        Bidi.setMirror(11808, '\u2e21');
        Bidi.setMirror(11809, '\u2e20');
        Bidi.setMirror(11810, '\u2e23');
        Bidi.setMirror(11811, '\u2e22');
        Bidi.setMirror(11812, '\u2e25');
        Bidi.setMirror(11813, '\u2e24');
        Bidi.setMirror(11814, '\u2e27');
        Bidi.setMirror(11815, '\u2e26');
        Bidi.setMirror(11816, '\u2e29');
        Bidi.setMirror(11817, '\u2e28');
        Bidi.setMirror(12296, '\u3009');
        Bidi.setMirror(12297, '\u3008');
        Bidi.setMirror(12298, '\u300b');
        Bidi.setMirror(12299, '\u300a');
        Bidi.setMirror(12300, '\u300d');
        Bidi.setMirror(12301, '\u300c');
        Bidi.setMirror(12302, '\u300f');
        Bidi.setMirror(12303, '\u300e');
        Bidi.setMirror(12304, '\u3011');
        Bidi.setMirror(12305, '\u3010');
        Bidi.setMirror(12308, '\u3015');
        Bidi.setMirror(12309, '\u3014');
        Bidi.setMirror(12310, '\u3017');
        Bidi.setMirror(12311, '\u3016');
        Bidi.setMirror(12312, '\u3019');
        Bidi.setMirror(12313, '\u3018');
        Bidi.setMirror(12314, '\u301b');
        Bidi.setMirror(12315, '\u301a');
        Bidi.setMirror(65113, '\ufe5a');
        Bidi.setMirror(65114, '\ufe59');
        Bidi.setMirror(65115, '\ufe5c');
        Bidi.setMirror(65116, '\ufe5b');
        Bidi.setMirror(65117, '\ufe5e');
        Bidi.setMirror(65118, '\ufe5d');
        Bidi.setMirror(65124, '\ufe65');
        Bidi.setMirror(65125, '\ufe64');
        Bidi.setMirror(65288, '\uff09');
        Bidi.setMirror(65289, '\uff08');
        Bidi.setMirror(65308, '\uff1e');
        Bidi.setMirror(65310, '\uff1c');
        Bidi.setMirror(65339, '\uff3d');
        Bidi.setMirror(65341, '\uff3b');
        Bidi.setMirror(65371, '\uff5d');
        Bidi.setMirror(65373, '\uff5b');
        Bidi.setMirror(65375, '\uff60');
        Bidi.setMirror(65376, '\uff5f');
        Bidi.setMirror(65378, '\uff63');
        Bidi.setMirror(65379, '\uff62');
        Bidi.finalShape[1649] = 64337;
        Bidi.finalShape[1659] = 64339;
        Bidi.initialShape[1659] = 64340;
        Bidi.medialShape[1659] = 64341;
        Bidi.finalShape[1662] = 64343;
        Bidi.initialShape[1662] = 64344;
        Bidi.medialShape[1662] = 64345;
        Bidi.finalShape[1664] = 64347;
        Bidi.initialShape[1664] = 64348;
        Bidi.medialShape[1664] = 64349;
        Bidi.finalShape[1658] = 64351;
        Bidi.initialShape[1658] = 64352;
        Bidi.medialShape[1658] = 64353;
        Bidi.finalShape[1663] = 64355;
        Bidi.initialShape[1663] = 64356;
        Bidi.medialShape[1663] = 64357;
        Bidi.finalShape[1657] = 64359;
        Bidi.initialShape[1657] = 64360;
        Bidi.medialShape[1657] = 64361;
        Bidi.finalShape[1700] = 64363;
        Bidi.initialShape[1700] = 64364;
        Bidi.medialShape[1700] = 64365;
        Bidi.finalShape[1702] = 64367;
        Bidi.initialShape[1702] = 64368;
        Bidi.medialShape[1702] = 64369;
        Bidi.finalShape[1668] = 64371;
        Bidi.initialShape[1668] = 64372;
        Bidi.medialShape[1668] = 64373;
        Bidi.finalShape[1667] = 64375;
        Bidi.initialShape[1667] = 64376;
        Bidi.medialShape[1667] = 64377;
        Bidi.finalShape[1670] = 64379;
        Bidi.initialShape[1670] = 64380;
        Bidi.medialShape[1670] = 64381;
        Bidi.finalShape[1671] = 64383;
        Bidi.initialShape[1671] = 64384;
        Bidi.medialShape[1671] = 64385;
        Bidi.finalShape[1677] = 64387;
        Bidi.finalShape[1676] = 64389;
        Bidi.finalShape[1678] = 64391;
        Bidi.finalShape[1672] = 64393;
        Bidi.finalShape[1688] = 64395;
        Bidi.finalShape[1681] = 64397;
        Bidi.finalShape[1705] = 64399;
        Bidi.initialShape[1705] = 64400;
        Bidi.medialShape[1705] = 64401;
        Bidi.finalShape[1711] = 64403;
        Bidi.initialShape[1711] = 64404;
        Bidi.medialShape[1711] = 64405;
        Bidi.finalShape[1715] = 64407;
        Bidi.initialShape[1715] = 64408;
        Bidi.medialShape[1715] = 64409;
        Bidi.finalShape[1713] = 64411;
        Bidi.initialShape[1713] = 64412;
        Bidi.medialShape[1713] = 64413;
        Bidi.finalShape[1722] = 64415;
        Bidi.finalShape[1723] = 64417;
        Bidi.initialShape[1723] = 64418;
        Bidi.medialShape[1723] = 64419;
        Bidi.finalShape[1728] = 64421;
        Bidi.finalShape[1729] = 64423;
        Bidi.initialShape[1729] = 64424;
        Bidi.medialShape[1729] = 64425;
        Bidi.finalShape[1726] = 64427;
        Bidi.initialShape[1726] = 64428;
        Bidi.medialShape[1726] = 64429;
        Bidi.finalShape[1746] = 64431;
        Bidi.finalShape[1747] = 64433;
        Bidi.finalShape[1709] = 64468;
        Bidi.initialShape[1709] = 64469;
        Bidi.medialShape[1709] = 64470;
        Bidi.finalShape[1735] = 64472;
        Bidi.finalShape[1734] = 64474;
        Bidi.finalShape[1736] = 64476;
        Bidi.finalShape[1739] = 64479;
        Bidi.finalShape[1733] = 64481;
        Bidi.finalShape[1737] = 64483;
        Bidi.finalShape[1744] = 64485;
        Bidi.initialShape[1744] = 64486;
        Bidi.medialShape[1744] = 64487;
        Bidi.initialShape[1609] = 64488;
        Bidi.medialShape[1609] = 64489;
        Bidi.finalShape[1740] = 64509;
        Bidi.initialShape[1740] = 64510;
        Bidi.medialShape[1740] = 64511;
        Bidi.finalShape[1570] = 65154;
        Bidi.finalShape[1571] = 65156;
        Bidi.finalShape[1572] = 65158;
        Bidi.finalShape[1573] = 65160;
        Bidi.finalShape[1574] = 65162;
        Bidi.initialShape[1574] = 65163;
        Bidi.medialShape[1574] = 65164;
        Bidi.finalShape[1575] = 65166;
        Bidi.finalShape[1576] = 65168;
        Bidi.initialShape[1576] = 65169;
        Bidi.medialShape[1576] = 65170;
        Bidi.finalShape[1577] = 65172;
        Bidi.finalShape[1578] = 65174;
        Bidi.initialShape[1578] = 65175;
        Bidi.medialShape[1578] = 65176;
        Bidi.finalShape[1579] = 65178;
        Bidi.initialShape[1579] = 65179;
        Bidi.medialShape[1579] = 65180;
        Bidi.finalShape[1580] = 65182;
        Bidi.initialShape[1580] = 65183;
        Bidi.medialShape[1580] = 65184;
        Bidi.finalShape[1581] = 65186;
        Bidi.initialShape[1581] = 65187;
        Bidi.medialShape[1581] = 65188;
        Bidi.finalShape[1582] = 65190;
        Bidi.initialShape[1582] = 65191;
        Bidi.medialShape[1582] = 65192;
        Bidi.finalShape[1583] = 65194;
        Bidi.finalShape[1584] = 65196;
        Bidi.finalShape[1585] = 65198;
        Bidi.finalShape[1586] = 65200;
        Bidi.finalShape[1587] = 65202;
        Bidi.initialShape[1587] = 65203;
        Bidi.medialShape[1587] = 65204;
        Bidi.finalShape[1588] = 65206;
        Bidi.initialShape[1588] = 65207;
        Bidi.medialShape[1588] = 65208;
        Bidi.finalShape[1589] = 65210;
        Bidi.initialShape[1589] = 65211;
        Bidi.medialShape[1589] = 65212;
        Bidi.finalShape[1590] = 65214;
        Bidi.initialShape[1590] = 65215;
        Bidi.medialShape[1590] = 65216;
        Bidi.finalShape[1591] = 65218;
        Bidi.initialShape[1591] = 65219;
        Bidi.medialShape[1591] = 65220;
        Bidi.finalShape[1592] = 65222;
        Bidi.initialShape[1592] = 65223;
        Bidi.medialShape[1592] = 65224;
        Bidi.finalShape[1593] = 65226;
        Bidi.initialShape[1593] = 65227;
        Bidi.medialShape[1593] = 65228;
        Bidi.finalShape[1594] = 65230;
        Bidi.initialShape[1594] = 65231;
        Bidi.medialShape[1594] = 65232;
        Bidi.finalShape[1601] = 65234;
        Bidi.initialShape[1601] = 65235;
        Bidi.medialShape[1601] = 65236;
        Bidi.finalShape[1602] = 65238;
        Bidi.initialShape[1602] = 65239;
        Bidi.medialShape[1602] = 65240;
        Bidi.finalShape[1603] = 65242;
        Bidi.initialShape[1603] = 65243;
        Bidi.medialShape[1603] = 65244;
        Bidi.finalShape[1604] = 65246;
        Bidi.initialShape[1604] = 65247;
        Bidi.medialShape[1604] = 65248;
        Bidi.finalShape[1605] = 65250;
        Bidi.initialShape[1605] = 65251;
        Bidi.medialShape[1605] = 65252;
        Bidi.finalShape[1606] = 65254;
        Bidi.initialShape[1606] = 65255;
        Bidi.medialShape[1606] = 65256;
        Bidi.finalShape[1607] = 65258;
        Bidi.initialShape[1607] = 65259;
        Bidi.medialShape[1607] = 65260;
        Bidi.finalShape[1608] = 65262;
        Bidi.finalShape[1609] = 65264;
        Bidi.finalShape[1610] = 65266;
        Bidi.initialShape[1610] = 65267;
        Bidi.medialShape[1610] = 65268;
        Bidi.finalShape[65269] = 65270;
        Bidi.finalShape[65271] = 65272;
        Bidi.finalShape[65273] = 65274;
        Bidi.finalShape[65275] = 65276;
        Bidi.medialShape[1600] = 1600;
        Bidi.initialShape[1600] = 1600;
        Bidi.finalShape[1600] = 1600;
        Bidi.medialShape[8205] = 8205;
        Bidi.initialShape[8205] = 8205;
        Bidi.finalShape[8205] = 8205;
        Bidi.transparentShape[1611] = true;
        Bidi.transparentShape[1612] = true;
        Bidi.transparentShape[1613] = true;
        Bidi.transparentShape[1614] = true;
        Bidi.transparentShape[1615] = true;
        Bidi.transparentShape[1616] = true;
        Bidi.transparentShape[1617] = true;
        Bidi.transparentShape[1618] = true;
        Bidi.transparentShape[1619] = true;
        Bidi.transparentShape[1620] = true;
        Bidi.transparentShape[1621] = true;
        Bidi.transparentShape[1648] = true;
        Bidi.transparentShape[1750] = true;
        Bidi.transparentShape[1751] = true;
        Bidi.transparentShape[1752] = true;
        Bidi.transparentShape[1753] = true;
        Bidi.transparentShape[1754] = true;
        Bidi.transparentShape[1755] = true;
        Bidi.transparentShape[1756] = true;
        Bidi.transparentShape[1758] = true;
        Bidi.transparentShape[1759] = true;
        Bidi.transparentShape[1760] = true;
        Bidi.transparentShape[1761] = true;
        Bidi.transparentShape[1762] = true;
        Bidi.transparentShape[1763] = true;
        Bidi.transparentShape[1764] = true;
        Bidi.transparentShape[1767] = true;
        Bidi.transparentShape[1768] = true;
        Bidi.transparentShape[1770] = true;
        Bidi.transparentShape[1771] = true;
        Bidi.transparentShape[1772] = true;
        Bidi.transparentShape[1773] = true;
        initialized = true;
    }

    static {
        int n = 0;
        while (n < mirrorChars.length) {
            Bidi.mirrorChars[n] = '\u0000';
            ++n;
        }
        initialShape = new char[65536];
        medialShape = new char[65536];
        finalShape = new char[65536];
        n = 0;
        while (n < initialShape.length) {
            Bidi.finalShape[n] = '\u0000';
            Bidi.medialShape[n] = '\u0000';
            Bidi.initialShape[n] = '\u0000';
            ++n;
        }
        transparentShape = new boolean[65536];
        n = 0;
        while (n < transparentShape.length) {
            Bidi.transparentShape[n] = false;
            ++n;
        }
        initialized = false;
    }

    public static class Test
    extends TestCase {
        protected void setUp() {
            Bidi.init();
        }

        public void testBasic() {
            Assert.assertEquals((String)Bidi.shape("", false), (String)"");
            Assert.assertEquals((String)Bidi.shape(" ", false), (String)" ");
            Assert.assertEquals((String)Bidi.shape("This is a text", false), (String)"This is a text");
        }

        public void testAlef() {
            Assert.assertEquals((String)Bidi.shape("\u0627", false), (String)"\u0627");
        }

        public void testBehAlef() {
            Assert.assertEquals((String)Bidi.shape("\u0628\u0627", false), (String)"\ufe91\ufe8e");
        }

        public void testBehSpaceAlef() {
            Assert.assertEquals((String)Bidi.shape("\u0628 \u0627", false), (String)"\u0628 \u0627");
        }

        public void testAlefBehAlef() {
            Assert.assertEquals((String)Bidi.shape("\u0627\u0628\u0627", false), (String)"\u0627\ufe91\ufe8e");
        }

        public void testJeemBehAlef() {
            Assert.assertEquals((String)Bidi.shape("\u062c\u0628\u0627", false), (String)"\ufe9f\ufe92\ufe8e");
        }

        public void testBehTransparentAlef() {
            Assert.assertEquals((String)Bidi.shape("\u0628\u064b\u064c\u064d\u0627", false), (String)"\ufe91\u064b\u064c\u064d\ufe8e");
        }

        public void testLamAlef() {
            Assert.assertEquals((String)Bidi.shape("\u0644\u0627", false), (String)"\ufefb");
        }

        public void testBehLamAlef() {
            Assert.assertEquals((String)Bidi.shape("\u0628\u0644\u0627", false), (String)"\ufe91\ufefc");
        }

        public void testLamAlefLamAlefMadda() {
            Assert.assertEquals((String)Bidi.shape("\u0644\u0627\u0644\u0622", false), (String)"\ufefb\ufef5");
        }

        public void testMirrorON() {
            Assert.assertEquals((String)Bidi.shape("( [ {", true), (String)") ] }");
        }

        public void testMirrorOFF() {
            Assert.assertEquals((String)Bidi.shape("( [ {", false), (String)"( [ {");
        }
    }
}

