/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep;

import com.renderx.sax.JAXPSourceConverter;
import com.renderx.util.URLSpec;
import com.renderx.xep.ValidationEventHandler;
import com.renderx.xep.ValidatorCore;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Validator {
    private static final String VALIDATOR_STYLESHEET = "resource:/com/renderx/xep/folint.xsl";
    private static final int DEFAULT_STRICTNESS = 1;
    private final ValidatorCore core;

    public Validator() throws SAXException, IOException {
        this(VALIDATOR_STYLESHEET, 1);
    }

    public Validator(String string) throws SAXException, IOException {
        this(string, 1);
    }

    public Validator(int n) throws SAXException, IOException {
        this(VALIDATOR_STYLESHEET, n);
    }

    public Validator(String string, int n) throws SAXException, IOException {
        this.core = new ValidatorCore(new URLSpec(string), n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int validate(Source source) throws SAXException, IOException {
        JAXPSourceConverter jAXPSourceConverter = new JAXPSourceConverter(source);
        try {
            this.core.validate(jAXPSourceConverter.source, jAXPSourceConverter.parser);
            Object var4_3 = null;
            if (jAXPSourceConverter.stream == null) return this.getErrorCount();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (jAXPSourceConverter.stream == null) throw throwable;
            jAXPSourceConverter.stream.close();
            throw throwable;
        }
        jAXPSourceConverter.stream.close();
        return this.getErrorCount();
    }

    public int getErrorCount() {
        return this.core.getErrorCount();
    }

    public int getWarningCount() {
        return this.core.getWarningCount();
    }

    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.core.setValidationEventHandler(validationEventHandler);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: com.renderx.xep.Validator <list of file names>");
            return;
        }
        Validator validator = null;
        try {
            validator = new Validator();
        }
        catch (Exception exception) {
            System.err.println("Cannot create Validator: " + exception.toString());
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            block17: {
                InputSource inputSource = null;
                try {
                    if ("-".equals(stringArray[n])) {
                        inputSource = new InputSource(System.in);
                        inputSource.setSystemId(new URL("stdin").toExternalForm());
                    } else {
                        inputSource = new InputSource(new URLSpec(stringArray[n]).toString());
                    }
                }
                catch (Exception exception) {
                    System.err.println("Cannot create input source for file " + stringArray[n] + ": " + exception.toString());
                    break block17;
                }
                try {
                    validator.validate(new SAXSource(inputSource));
                    int n2 = validator.getErrorCount();
                    int n3 = validator.getWarningCount();
                    System.err.print(("-".equals(stringArray[n]) ? "<stdin>" : stringArray[n]) + ": ");
                    if (n2 == 0) {
                        if (n3 == 0) {
                            System.err.println("validation successful!");
                        } else {
                            System.err.println("" + n3 + " warning" + (n3 == 1 ? "" : "s"));
                        }
                    } else {
                        System.err.print("" + n2 + " error" + (n2 == 1 ? "" : "s"));
                        if (n3 > 0) {
                            System.err.print(", " + n3 + " warning" + (n3 == 1 ? "" : "s"));
                        }
                        System.err.println();
                    }
                }
                catch (SAXException sAXException) {
                    System.err.println(stringArray[n] + " could not be parsed due to structure errors");
                    System.err.println(sAXException.toString());
                }
                catch (IOException iOException) {
                    System.err.println(stringArray[n] + " could not be parsed due to input problems");
                    System.err.println(iOException.toString());
                }
                catch (Exception exception) {
                    System.err.println(stringArray[n] + " could not be parsed");
                    System.err.println(exception.toString());
                }
            }
            ++n;
        }
    }
}

